/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalUtils {
    public static BigDecimal add(BigDecimal a, BigDecimal b) {
        a = BigDecimalUtils.check(a);
        b = BigDecimalUtils.check(b);
        return a.add(b);
    }

    public static BigDecimal subtract(BigDecimal a, BigDecimal b) {
        a = BigDecimalUtils.check(a);
        b = BigDecimalUtils.check(b);
        return a.subtract(b);
    }

    public static BigDecimal multiply(BigDecimal a, BigDecimal b) {
        a = BigDecimalUtils.check(a);
        b = BigDecimalUtils.check(b);
        return a.multiply(b);
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b) {
        a = BigDecimalUtils.check(a);
        if (BigDecimalUtils.eqZero(b = BigDecimalUtils.check(b)).booleanValue()) {
            return BigDecimal.ZERO;
        }
        return a.divide(b, 0, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b, int scale) {
        a = BigDecimalUtils.check(a);
        if (BigDecimalUtils.eqZero(b = BigDecimalUtils.check(b)).booleanValue()) {
            return BigDecimal.ZERO;
        }
        return a.divide(b, scale, RoundingMode.HALF_UP);
    }

    public static Boolean equals(BigDecimal a, BigDecimal b) {
        if ((a = BigDecimalUtils.check(a)).compareTo(b = BigDecimalUtils.check(b)) == 0) {
            return true;
        }
        return false;
    }

    public static Boolean notEquals(BigDecimal a, BigDecimal b) {
        return BigDecimalUtils.equals(a = BigDecimalUtils.check(a), b = BigDecimalUtils.check(b)) == false;
    }

    public static Boolean gt(BigDecimal a, BigDecimal b) {
        if ((a = BigDecimalUtils.check(a)).compareTo(b = BigDecimalUtils.check(b)) > 0) {
            return true;
        }
        return false;
    }

    public static Boolean leZero(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return BigDecimalUtils.le(a, BigDecimal.ZERO);
    }

    public static Boolean ltZero(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return BigDecimalUtils.lt(a, BigDecimal.ZERO);
    }

    public static Boolean eqZero(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return BigDecimalUtils.equals(a, BigDecimal.ZERO);
    }

    public static Boolean geZero(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return BigDecimalUtils.ge(a, BigDecimal.ZERO);
    }

    public static Boolean gtZero(BigDecimal a) {
        a = BigDecimalUtils.check(a);
        return BigDecimalUtils.gt(a, BigDecimal.ZERO);
    }

    public static Boolean lt(BigDecimal a, BigDecimal b) {
        if ((a = BigDecimalUtils.check(a)).compareTo(b = BigDecimalUtils.check(b)) < 0) {
            return true;
        }
        return false;
    }

    public static Boolean ge(BigDecimal a, BigDecimal b) {
        if (!BigDecimalUtils.equals(a, b).booleanValue() && !BigDecimalUtils.gt(a, b).booleanValue()) {
            return false;
        }
        return true;
    }

    public static Boolean le(BigDecimal a, BigDecimal b) {
        if (!BigDecimalUtils.equals(a, b).booleanValue() && !BigDecimalUtils.lt(a, b).booleanValue()) {
            return false;
        }
        return true;
    }

    public static BigDecimal check(BigDecimal a) {
        return a == null ? BigDecimal.ZERO : a;
    }

    public static String convertStr(BigDecimal a) {
        return BigDecimalUtils.check(a).compareTo(BigDecimal.ZERO) == 0 ? "0" : a.toString();
    }

    public static BigDecimal bankersRounding(int newScale, BigDecimal a) {
        return BigDecimalUtils.check(a).setScale(newScale, RoundingMode.HALF_EVEN);
    }
}

