/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import com.wh.commons.utils.ChineseWordsFirstLetterUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CodeUtils {
    public static final Map<String, String> DEFAULT_BRIEF_NAME = new HashMap<String, String>();

    static {
        DEFAULT_BRIEF_NAME.put("\u6e56\u5317\u5e73\u53f0", "UB");
    }

    public static String getPlatformBriefName(String platformName) {
        if (DEFAULT_BRIEF_NAME.containsKey(platformName)) {
            return DEFAULT_BRIEF_NAME.get(platformName);
        }
        return CodeUtils.getFirstLetter(platformName);
    }

    private static String getFirstLetter(String platformName) {
        if (StringUtils.isEmpty((CharSequence)platformName)) {
            return "";
        }
        String firstLetter = ChineseWordsFirstLetterUtil.ChineseToFirstLetter(platformName);
        if (firstLetter.length() > 2) {
            firstLetter = firstLetter.substring(0, 2);
        }
        return firstLetter;
    }

    public static String makeLetterAndNum(int n) {
        char[] arr = new char[n];
        int i = 0;
        while (i < n) {
            char ch = (char)(Math.random() * 124.0);
            if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') && (ch < '0' || ch > '9')) continue;
            arr[i++] = ch;
        }
        return new String(arr);
    }

    public static String makeLetter(int n) {
        char[] arr = new char[n];
        int i = 0;
        while (i < n) {
            char ch = (char)(Math.random() * 124.0);
            if ((ch < 'A' || ch > 'Z') && (ch < 'a' || ch > 'z')) continue;
            arr[i++] = ch;
        }
        return new String(arr);
    }

    public static String makeNum(int n) {
        char[] arr = new char[n];
        int i = 0;
        while (i < n) {
            char ch = (char)(Math.random() * 124.0);
            if (ch < '0' || ch > '9') continue;
            arr[i++] = ch;
        }
        return new String(arr);
    }
}

