/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.wh.commons.utils.AssertUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.http.util.Args;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYMMDDHHMM = "yyMMddHHmm";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_mm = "yyyy-MM-dd HH:mm";
    public static final String YYYY_MM_DD_HH_mm_ss = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHmmssSSS = "yyyyMMddHHmmssSSS";
    public static final String YYYYMMDDHHMM_CH = "yyyy\u5e74MM\u6708dd\u65e5hh:mm";
    public static final String YYYYMMDDHHMM_CH_24 = "yyyy\u5e74MM\u6708dd\u65e5HH:mm";
    public static final String YYMMDD = "yyMMdd";
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);
    public static final FastDateFormat SIMPLE_DATETIME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    public static final FastDateFormat SIMPLE_DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd");

    private DateUtils() {
    }

    public static Date parseDateTime(String dateStr) {
        try {
            return SIMPLE_DATETIME_FORMAT.parse(dateStr);
        }
        catch (ParseException e) {
            throw new BizException(e.getMessage());
        }
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static boolean compare(Date tag) {
        try {
            return simpleDateFormat.parse(simpleDateFormat.format(new Date())).after(simpleDateFormat.parse(simpleDateFormat.format(tag)));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static Calendar getCalendar() {
        return DateUtils.getCalendar(new Date());
    }

    public static Calendar getCalendar(Date time) {
        Calendar c = Calendar.getInstance();
        if (time != null) {
            c.setTime(time);
        }
        return c;
    }

    public static int currentTimeDay() {
        return DateUtils.currentTimeDay(new Date());
    }

    public static int currentTimeDay(Date date) {
        Args.notNull((Object)date, (String)"'date'");
        Calendar c = DateUtils.getCalendar(date);
        int y = c.get(1);
        int m = c.get(2) + 1;
        int d = c.get(5);
        return y * 10000 + m * 100 + d;
    }

    public static Date buildDate(int year, int month, int date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, date, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getCurrTimeMonth(Date date) {
        Args.notNull((Object)date, (String)"'date'");
        Calendar c = DateUtils.getCalendar(date);
        int y = c.get(1);
        int m = c.get(2) + 1;
        return y * 10000 + m * 100;
    }

    public static long currentTimeSeconds() {
        return DateUtils.timeSeconds(null);
    }

    public static long timeSeconds(Date date) {
        long millis = date != null ? date.getTime() : System.currentTimeMillis();
        return millis / 1000L;
    }

    public static int diffByDay(Date time) {
        Date now = new Date();
        return DateUtils.diffByDay(time, now);
    }

    public static int diffByDay(Date var1, Date var2) {
        int day = (int)((var2.getTime() - var1.getTime()) / 86400000L);
        return day;
    }

    public static int diffSecond(Date time) {
        Date now = new Date();
        return DateUtils.diffSecond(time, now);
    }

    public static int diffSecond(Date var1, Date var2) {
        return (int)(var2.getTime() - var1.getTime()) / 1000;
    }

    public static boolean nowInRange(Date begin, Date end) {
        if (begin == null && end == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (begin != null && now < begin.getTime()) {
            return false;
        }
        return end == null || now <= end.getTime();
    }

    public static Date nextDay(Date current) {
        Calendar c = DateUtils.getCalendar(current);
        c.add(5, 1);
        return c.getTime();
    }

    public static Date addYear(Date current, int i) {
        Calendar c = DateUtils.getCalendar(current);
        c.add(1, i);
        return c.getTime();
    }

    public static Date addMonth(Date current, int i) {
        Calendar c = DateUtils.getCalendar(current);
        c.add(2, i);
        return c.getTime();
    }

    public static Date addDate(Date date, int i) {
        Calendar c = DateUtils.getCalendar(date);
        c.add(5, i);
        return c.getTime();
    }

    public static Date addHour(Date date, int i) {
        Calendar c = DateUtils.getCalendar(date);
        c.add(10, i);
        return c.getTime();
    }

    public static Date addMinute(Date date, int i) {
        Calendar c = DateUtils.getCalendar(date);
        c.add(12, i);
        return c.getTime();
    }

    public static Date addSecond(Date date, int i) {
        Calendar c = DateUtils.getCalendar(date);
        c.add(13, i);
        return c.getTime();
    }

    public static Date addMilliSecond(Date date, int i) {
        Calendar c = DateUtils.getCalendar(date);
        c.add(14, i);
        return c.getTime();
    }

    public static Date getMonthStart(Date date) {
        Calendar c = DateUtils.getCalendar(date);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getQuarterStart(Date date) {
        int month = DateUtils.getMonth(date);
        if (month <= 3) {
            return DateUtils.buildDate(DateUtils.getYear(date), 0, 1);
        }
        if (month <= 6) {
            return DateUtils.buildDate(DateUtils.getYear(date), 3, 1);
        }
        if (month <= 9) {
            return DateUtils.buildDate(DateUtils.getYear(date), 6, 1);
        }
        return DateUtils.buildDate(DateUtils.getYear(date), 9, 1);
    }

    public static Date getQuarterEnd(Date date) {
        int month = DateUtils.getMonth(date);
        if (month <= 3) {
            return DateUtils.addMilliSecond(DateUtils.buildDate(DateUtils.getYear(date), 3, 1), -1);
        }
        if (month <= 6) {
            return DateUtils.addMilliSecond(DateUtils.buildDate(DateUtils.getYear(date), 6, 1), -1);
        }
        if (month <= 9) {
            return DateUtils.addMilliSecond(DateUtils.buildDate(DateUtils.getYear(date), 9, 1), -1);
        }
        return DateUtils.addMilliSecond(DateUtils.buildDate(DateUtils.getYear(date) + 1, 0, 1), -1);
    }

    public static Date getYearStart(Date date) {
        Calendar c = DateUtils.getCalendar(date);
        c.set(2, 0);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getMonthEnd(Date date) {
        return DateUtils.addMilliSecond(DateUtils.getMonthStart(DateUtils.addMonth(date, 1)), -1);
    }

    public static Date getYearEnd(Date date) {
        return DateUtils.addMilliSecond(DateUtils.getYearStart(DateUtils.addYear(date, 1)), -1);
    }

    public static Date beforeYear(Date current, int total) {
        Calendar c = DateUtils.getCalendar(current);
        c.add(1, -total);
        return c.getTime();
    }

    public static Date nextDay(Date current, int total) {
        Calendar c = DateUtils.getCalendar(current);
        c.add(5, total);
        return c.getTime();
    }

    public static Date beforeDay(Date current, int total) {
        Calendar c = DateUtils.getCalendar(current);
        c.add(5, -total);
        return c.getTime();
    }

    public static Date beforeMinute(Date current, int minute) {
        Calendar c = DateUtils.getCalendar(current);
        c.add(12, -minute);
        return c.getTime();
    }

    public static Date beforeSecond(Date current, int second) {
        Calendar c = DateUtils.getCalendar(current);
        c.add(13, -second);
        return c.getTime();
    }

    public static int getMonth(Date time) {
        Calendar c = DateUtils.getCalendar(time);
        return c.get(2) + 1;
    }

    public static int getYear(Date time) {
        Calendar c = DateUtils.getCalendar(time);
        return c.get(1);
    }

    public static int getDate(Date time) {
        Calendar c = DateUtils.getCalendar(time);
        return c.get(5);
    }

    public static Date getStartTimeByDay(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static long getEndTimeByDay(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTimeInMillis();
    }

    public static Date afterMinute(Date current, int minute) {
        Calendar c = DateUtils.getCalendar(current);
        c.add(12, minute);
        return c.getTime();
    }

    public static int nextToWeekend(Date date) {
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setFirstDayOfWeek(2);
        cld.setTimeInMillis(date.getTime());
        cld.set(7, 1);
        int total = DateUtils.diffByDay(date, cld.getTime());
        return total;
    }

    public static boolean isWeekend(Date date) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) == 7 || cal.get(7) == 1;
    }

    public static int getSecondFromHHmm(String str, String errorMessage) {
        AssertUtil.assertHHmm(str, errorMessage);
        String[] split = str.split(":");
        return Integer.parseInt(split[0]) * 60 * 60 + Integer.parseInt(split[1]) * 60;
    }

    public static String second2HHmmStr(int second) {
        if (second < 0) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), "\u53c2\u6570\u9519\u8bef\uff0c\u79d2\u6570\u4e0d\u80fd\u5c11\u4e8e0");
        }
        if (second >= 86400) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), "\u53c2\u6570\u9519\u8bef\uff0c\u79d2\u6570\u5927\u4e8e24*60*60");
        }
        int h = second / 60 / 60;
        int m = second / 60 % 60;
        return String.format("%02d:%02d", h, m);
    }

    public static Boolean isDateVail(String date, String format) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format);
        boolean flag = true;
        try {
            LocalDateTime.parse(date, dtf);
        }
        catch (Exception exception) {
            flag = false;
        }
        return flag;
    }

    public static Date getMonthStartTime(String startDateStr, String pattern) {
        Date dateTime;
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        try {
            dateTime = dateFormat.parse(startDateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return DateUtils.getMonthStart(dateTime);
    }

    public static Date getDayStart(Date date) {
        return DateUtils.getMinOrMaxDay(date, LocalTime.MIN);
    }

    private static Date getMinOrMaxDay(Date date, LocalTime localTime) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.of("GMT+8");
        LocalDate localDate = instant.atZone(zoneId).toLocalDate();
        LocalDateTime dateTime = LocalDateTime.of(localDate, localTime);
        Instant dayTimeInstant = dateTime.atZone(zoneId).toInstant();
        return Date.from(dayTimeInstant);
    }

    public static Date getDayEnd(Date date) {
        return DateUtils.getMinOrMaxDay(date, LocalTime.MAX);
    }

    public static Date getMonthEndTime(String startDateStr, String pattern) {
        Date dateTime;
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        try {
            dateTime = dateFormat.parse(startDateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return DateUtils.getMonthEnd(dateTime);
    }

    public static String getPrevMonthDate(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) - n);
        return new SimpleDateFormat("yyyy-MM").format(calendar.getTime());
    }

    public static String getNextMonthDate(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) + n);
        return new SimpleDateFormat("yyyy-MM").format(calendar.getTime());
    }

    public static List<String> getMonthBetween(String minDate, String maxDate) {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74M\u6708");
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        try {
            min.setTime(sdf.parse(minDate));
            min.set(min.get(1), min.get(2), 1);
            max.setTime(sdf.parse(maxDate));
            max.set(max.get(1), max.get(2), 2);
            Calendar curr = min;
            while (curr.before(max)) {
                result.add(sdf.format(curr.getTime()));
                curr.add(2, 1);
            }
            return result;
        }
        catch (ParseException e) {
            throw new RuntimeException("\u8f6c\u6362\u65e5\u671f\u5f02\u5e38" + e);
        }
    }

    public static String formatDateYMDHMSNoBar(Date date) {
        return new DateTime(date.getTime()).toString("yyyyMMddHHmmss");
    }
}

