/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ExportInfoServiceContextUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExportInfoServiceContextUtils.class);

    public static boolean getMark() {
        HttpServletRequest currentHttpServletRequest = ExportInfoServiceContextUtils.getCurrentHttpServletRequest();
        if (currentHttpServletRequest == null) {
            return false;
        }
        currentHttpServletRequest.getHeaderNames();
        String mark = currentHttpServletRequest.getHeader("batch.asyn.export.mark");
        logger.info("daochulanjie-\u8bf7\u6c42{}Mark{}", (Object)currentHttpServletRequest.getRequestURI(), (Object)mark);
        return StrUtil.isNotBlank((CharSequence)mark) && Boolean.parseBoolean(mark);
    }

    public static Integer getPageNum() {
        HttpServletRequest currentHttpServletRequest = ExportInfoServiceContextUtils.getCurrentHttpServletRequest();
        if (currentHttpServletRequest == null) {
            return BigDecimal.ZERO.intValue();
        }
        String pageNum = currentHttpServletRequest.getHeader("batch.asyn.export.pagenum");
        if (StrUtil.isBlank((CharSequence)pageNum)) {
            return BigDecimal.ZERO.intValue();
        }
        return Integer.parseInt(pageNum);
    }

    public static Integer getPageSize() {
        HttpServletRequest currentHttpServletRequest = ExportInfoServiceContextUtils.getCurrentHttpServletRequest();
        if (currentHttpServletRequest == null) {
            return BigDecimal.TEN.intValue();
        }
        String pageSize = currentHttpServletRequest.getHeader("batch.asyn.export.pagesize");
        if (StrUtil.isBlank((CharSequence)pageSize)) {
            return BigDecimal.TEN.intValue();
        }
        return Integer.parseInt(pageSize);
    }

    private static HttpServletRequest getCurrentHttpServletRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return requestAttributes.getRequest();
    }
}

