/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import com.wh.commons.dto.response.DictionaryDataDto;
import com.wh.commons.dto.response.DictionaryDataRespDto;
import com.wh.commons.enums.AllCenterNames;
import com.wh.commons.enums.GlobalCommonEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.TypeFilter;

public class GlobalEnumUtils {
    private static Logger logger = LoggerFactory.getLogger(GlobalEnumUtils.class);
    private static final List<String> centerNames = new ArrayList<String>();

    static {
        AllCenterNames[] allCenterNamesArray = AllCenterNames.values();
        int n = allCenterNamesArray.length;
        int n2 = 0;
        while (n2 < n) {
            AllCenterNames allCenterNames = allCenterNamesArray[n2];
            centerNames.add(allCenterNames.name());
            ++n2;
        }
    }

    public static Map<String, DictionaryDataRespDto> getAllGlobalEnumData() {
        HashMap<String, DictionaryDataRespDto> map = new HashMap<String, DictionaryDataRespDto>();
        centerNames.forEach(centerName -> map.put((String)centerName, GlobalEnumUtils.queryGlobalEnum(centerName)));
        return map;
    }

    private static DictionaryDataRespDto queryGlobalEnum(String centerName) {
        ArrayList<DictionaryDataDto> list = new ArrayList<DictionaryDataDto>();
        StringBuffer errorMsg = new StringBuffer();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        TypeFilter includeFilter = (metadataReader, metadataReaderFactory) -> true;
        provider.addIncludeFilter(includeFilter);
        Set candidateComponents = provider.findCandidateComponents(String.format("com.wh.center.%s.api.enums", centerName));
        candidateComponents.forEach(beanDefinition -> {
            try {
                Class<?> clazz = Class.forName(beanDefinition.getBeanClassName());
                GlobalCommonEnum annotation = (GlobalCommonEnum)AnnotationUtils.getAnnotation(clazz, GlobalCommonEnum.class);
                if (annotation == null) {
                    return;
                }
                LinkedHashMap<String, String> dictionaryMap = new LinkedHashMap<String, String>();
                ?[] objects = clazz.getEnumConstants();
                Method getCode = clazz.getMethod(annotation.getLabelMethod(), new Class[0]);
                Method getName = clazz.getMethod(annotation.getValueMethod(), new Class[0]);
                ?[] objArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objArray[n2];
                    dictionaryMap.put(String.valueOf(getCode.invoke(obj, new Object[0])), String.valueOf(getName.invoke(obj, new Object[0]).toString()));
                    ++n2;
                }
                list.add(new DictionaryDataDto(annotation.name(), clazz.getSimpleName(), dictionaryMap));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.error("\u83b7\u53d6\u5168\u5c40\u8ba2\u5355\u679a\u4e3e\u63a5\u53e3\u5f02\u5e38-{}-{}", (Object)e, (Object)e.getMessage());
                errorMsg.append(String.format("\u8f7d\u5165%s\u51fa\u73b0\u5f02\u5e38%s", beanDefinition.getBeanClassName(), e.getMessage()));
            }
        });
        return new DictionaryDataRespDto(list, errorMsg.toString());
    }
}

