/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class LambdaUtils {
    public static <T> Consumer<T> consumerWithIndex(BiConsumer<T, Integer> consumer) {
        class Obj {
            int i;

            Obj() {
            }
        }
        Obj obj = new Obj();
        return t -> {
            int index = obj.i++;
            consumer.accept(t, index);
        };
    }

    public static <T, K> List<K> list2Fields(List<T> list, Function<T, K> classifier) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList();
        }
        return list.stream().map(classifier).distinct().collect(Collectors.toList());
    }

    public static <T, K> Set<K> Set2Fields(List<T> list, Function<T, K> classifier) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashSet();
        }
        return list.stream().map(classifier).distinct().collect(Collectors.toSet());
    }

    public static <T, K> String joining(List<T> list, Function<T, K> classifier, String characteristics) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return list.stream().map(classifier).map(s -> String.valueOf(s)).collect(Collectors.joining(characteristics));
    }

    public static <T, K> Integer list2FieldsCount(List<T> list, Function<T, K> classifier) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        Long count = list.stream().map(classifier).collect(Collectors.counting());
        return Integer.valueOf("" + count);
    }

    public static <T, K> Map list2FieldsMap(List<T> list, Function<T, K> classifier) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap();
        }
        return list.stream().collect(Collectors.toMap(classifier, Function.identity(), (k1, k2) -> k1));
    }

    public static <T, K> Map<K, List<T>> groupBy(List<T> list, Function<T, K> groupKey) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap();
        }
        return list.stream().collect(Collectors.groupingBy(groupKey));
    }

    public static <T, K> Map<K, T> groupByGetFirst(List<T> list, Function<T, K> groupKey) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap();
        }
        return list.stream().collect(Collectors.groupingBy(groupKey, Collectors.collectingAndThen(Collectors.toList(), value -> value.get(0))));
    }

    public static <T, K, R> Map<K, R> groupByGetFirstVal(List<T> list, Function<T, K> groupKey, Function<T, R> valKey) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap();
        }
        return list.stream().collect(Collectors.groupingBy(groupKey, Collectors.collectingAndThen(Collectors.toList(), value -> valKey.apply(value.get(0)))));
    }

    public static <T, K> List<T> listFilter(List<T> list, Function<T, K> fieldFunc, K status) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().filter(o -> {
            Object k = fieldFunc.apply(o);
            if (status == null) {
                return k == null;
            }
            return k != null && k.equals(status);
        }).collect(Collectors.toList());
    }

    public static <T> List<T> listFilter(List<T> list, Predicate<? super T> predicate) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <T, K> List<T> listReverseFilter(List<T> list, Function<T, K> fieldFunc, K status) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().filter(o -> {
            Object k = fieldFunc.apply(o);
            if (status == null) {
                return k != null;
            }
            return k == null || !k.equals(status);
        }).collect(Collectors.toList());
    }
}

