/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import com.wh.commons.annotations.InsertValid;
import com.wh.commons.annotations.UpdateValid;
import com.wh.commons.dto.request.order.OrderPriceInfo;
import com.wh.commons.utils.AssertUtil;
import com.wh.commons.utils.LambdaUtils;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections.CollectionUtils;

public class OrderPriceUtils {
    public static BigDecimal calculateFreezeAmount(BigDecimal orderAmount, BigDecimal payRatio) {
        return OrderPriceUtils.multiplyBySimple(orderAmount, Objects.isNull(payRatio) ? BigDecimal.ZERO : payRatio);
    }

    public static BigDecimal calculateOrderAmount(List<OrderPriceInfo> orderPriceReqDtos) {
        orderPriceReqDtos.forEach(item -> AssertUtil.validation(orderPriceReqDtos, UpdateValid.class));
        BigDecimal bigDecimal = orderPriceReqDtos.stream().map(item -> item.getItemPrice().multiply(new BigDecimal(item.getNum()))).reduce((a, b) -> a.add((BigDecimal)b)).get().setScale(2, 0);
        return bigDecimal;
    }

    public static BigDecimal calculateOrderAmountByRoundHalfUp(List<OrderPriceInfo> orderPriceReqDtos) {
        orderPriceReqDtos.forEach(item -> AssertUtil.validation(orderPriceReqDtos, UpdateValid.class));
        BigDecimal bigDecimal = orderPriceReqDtos.stream().map(item -> item.getItemPrice().multiply(new BigDecimal(item.getNum()))).reduce((a, b) -> a.add((BigDecimal)b)).get().setScale(2, 4);
        return bigDecimal;
    }

    public static Map<String, BigDecimal> calculateOrderItemAmount(List<OrderPriceInfo> orderPriceReqDtos, BigDecimal orderAmount) {
        orderPriceReqDtos.forEach(item -> AssertUtil.validation(orderPriceReqDtos, UpdateValid.class, InsertValid.class));
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        AssertUtil.isFalse(CollectionUtils.isEmpty(orderPriceReqDtos) || orderAmount == null, "\u8ba1\u7b97\u8ba2\u5355\u660e\u7ec6\u91d1\u989d\u5165\u53c2\u5f02\u5e38");
        orderPriceReqDtos.sort(Comparator.comparing(OrderPriceInfo::getLineId));
        if (orderPriceReqDtos.size() == 1) {
            result.put(((OrderPriceInfo)orderPriceReqDtos.stream().findFirst().get()).getLineId(), orderAmount);
        } else {
            AtomicReference<BigDecimal> finishCalculateAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            orderPriceReqDtos.forEach(LambdaUtils.consumerWithIndex((item, index) -> {
                BigDecimal itemAmount;
                if (index == orderPriceReqDtos.size() - 1) {
                    itemAmount = Objects.requireNonNull(orderAmount).subtract((BigDecimal)finishCalculateAmount.get());
                } else {
                    itemAmount = OrderPriceUtils.multiplyByRoundHalfUp(item.getItemPrice(), new BigDecimal(item.getNum()));
                    finishCalculateAmount.set(((BigDecimal)finishCalculateAmount.get()).add(itemAmount));
                }
                result.put(item.getLineId(), itemAmount);
            }));
        }
        return result;
    }

    public static Map<String, BigDecimal> calculateOrderPackageAmount(List<OrderPriceInfo> orderPriceReqDtos, BigDecimal orderAmount) {
        orderPriceReqDtos.forEach(item -> AssertUtil.validation(orderPriceReqDtos, UpdateValid.class, InsertValid.class));
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        AssertUtil.isFalse(CollectionUtils.isEmpty(orderPriceReqDtos) || orderAmount == null, "\u8ba1\u7b97\u8ba2\u5355\u660e\u7ec6\u91d1\u989d\u5165\u53c2\u5f02\u5e38");
        orderPriceReqDtos.sort(Comparator.comparing(OrderPriceInfo::getLineId));
        BigDecimal priceTotal = BigDecimal.ZERO;
        for (OrderPriceInfo orderPriceReqDto : orderPriceReqDtos) {
            BigDecimal itemPriceTotal = orderPriceReqDto.getItemPrice().multiply(new BigDecimal(orderPriceReqDto.getNum()));
            priceTotal = priceTotal.add(itemPriceTotal);
        }
        BigDecimal orderPriceTotal = priceTotal;
        if (orderPriceReqDtos.size() == 1) {
            result.put(((OrderPriceInfo)orderPriceReqDtos.stream().findFirst().get()).getLineId(), orderAmount);
        } else {
            AtomicReference<BigDecimal> finishCalculateAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            orderPriceReqDtos.forEach(LambdaUtils.consumerWithIndex((item, index) -> {
                BigDecimal itemAmount;
                if (index == orderPriceReqDtos.size() - 1) {
                    itemAmount = Objects.requireNonNull(orderAmount).subtract((BigDecimal)finishCalculateAmount.get());
                } else {
                    BigDecimal itemPrice = item.getItemPrice().multiply(new BigDecimal(item.getNum()));
                    itemAmount = OrderPriceUtils.multiplyByRoundHalfUp(itemPrice.divide(orderPriceTotal, 4), orderAmount);
                    finishCalculateAmount.set(((BigDecimal)finishCalculateAmount.get()).add(itemAmount));
                }
                result.put(item.getLineId(), itemAmount);
            }));
        }
        return result;
    }

    public static BigDecimal multiplyByRoundHalfUp(BigDecimal price, BigDecimal num) {
        return price.multiply(num).setScale(2, 4);
    }

    public static BigDecimal multiplyBySimple(BigDecimal price, BigDecimal num) {
        return price.multiply(num).setScale(4, 4);
    }

    public static void main(String[] args) {
        BigDecimal a1 = new BigDecimal(261079.27);
        BigDecimal a2 = new BigDecimal(0.03);
        BigDecimal a3 = new BigDecimal(0.97);
        System.out.println(a1.multiply(a2));
        System.out.println(OrderPriceUtils.multiplyBySimple(a1, a2));
        System.out.println(OrderPriceUtils.multiplyBySimple(a1, a3));
        System.out.println(OrderPriceUtils.multiplyBySimple(a1, a2).add(OrderPriceUtils.multiplyBySimple(a1, a3)));
    }
}

