/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

public class PwdCheckTool {
    private PwdCheckTool() {
    }

    public static boolean isPasswordAvailable(String password) {
        String str = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{8,20}$";
        if (password.matches(str)) {
            return PwdCheckTool.isPasswordContinuous(password);
        }
        return false;
    }

    public static boolean is6PwdAvailable(String password) {
        String str = "^\\d{6}$";
        return password.matches(str) && PwdCheckTool.isPasswordContinuous(password) && PwdCheckTool.checkPassword(password, 6);
    }

    private static boolean isPasswordContinuous(String password) {
        int count = 0;
        int reverseCount = 0;
        String[] strArr = password.split("");
        int i = 1;
        while (i < strArr.length - 1) {
            count = PwdCheckTool.isPositiveContinuous(strArr[i], strArr[i + 1]) ? ++count : 0;
            reverseCount = PwdCheckTool.isReverseContinuous(strArr[i], strArr[i + 1]) ? ++reverseCount : 0;
            if (count > 2 || reverseCount > 2) break;
            ++i;
        }
        return count <= 2 && reverseCount <= 2;
    }

    private static boolean isPositiveContinuous(String str1, String str2) {
        return str2.hashCode() - str1.hashCode() == 1;
    }

    private static boolean isReverseContinuous(String str1, String str2) {
        return str2.hashCode() - str1.hashCode() == -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkPassword(String password, int lenght) {
        StringBuilder stringBuilder = new StringBuilder(password);
        if (password.length() != lenght) return false;
        try {
            char a1 = stringBuilder.charAt(0);
            char a2 = stringBuilder.charAt(1);
            int d = a2 - a1;
            int n = 1;
            while (true) {
                if (n > stringBuilder.length()) {
                    return false;
                }
                char an = stringBuilder.charAt(n - 1);
                if (a1 + d * (n - 1) != an) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void main(String[] args) {
        String pwd = "999991";
        boolean ret = PwdCheckTool.is6PwdAvailable(pwd);
        System.out.println("is6PwdAvailable:" + ret);
    }
}

