/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.util.SpringBeanUtil;
import com.wh.commons.utils.AssertUtil;
import com.wh.commons.utils.LambdaUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);

    public static void processOaItems(JSONObject data, List<?> items, String mainFieldName, Class<?> c) {
        Field[] fields = c.getDeclaredFields();
        Arrays.stream(fields).forEach(LambdaUtils.consumerWithIndex((field, index) -> {
            String name = field.getName();
            ArrayList filedValList = new ArrayList();
            items.forEach(item -> {
                try {
                    field.setAccessible(true);
                    Object fieldVal = field.get(item);
                    filedValList.add(fieldVal != null ? String.valueOf(fieldVal) : "");
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BizException(e.getMessage());
                }
            });
            data.put(String.format("%s.%s", mainFieldName, name), JSONArray.toJSON(filedValList));
        }));
        data.remove((Object)mainFieldName);
    }

    public static Object invoke(String invokeClassName, String invokeMethodName, String reqArgs, String parameterTypes) {
        ReflectionUtils reflectionUtils = new ReflectionUtils();
        Class<?> invokeClass = reflectionUtils.classForName(invokeClassName);
        Method invokeMethod = reflectionUtils.processMethod(invokeClass, invokeMethodName, parameterTypes);
        return reflectionUtils.invokeMethod(invokeClass, invokeMethod, reqArgs);
    }

    private Object invokeMethod(Class<?> invokeClass, Method invokeMethod, String reqArgs) {
        Object invokeObject = SpringBeanUtil.getBean(invokeClass);
        try {
            if (invokeObject == null) {
                invokeObject = invokeClass.newInstance();
            }
            return invokeMethod.invoke(invokeObject, this.processArgs(reqArgs));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.info(e.getMessage());
            throw new BizException(e.getMessage());
        }
    }

    private Class<?> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.info(e.getMessage());
            throw new BizException(e.getMessage());
        }
    }

    private Method processMethod(Class<?> invokeClass, String invokeMethod, String parameterTypes) {
        try {
            return invokeClass.getDeclaredMethod(invokeMethod, this.processParameterTypes(parameterTypes));
        }
        catch (NoSuchMethodException e) {
            logger.info(e.getMessage());
            throw new BizException(e.getMessage());
        }
    }

    private Object[] processArgs(String reqArgs) {
        return JSONArray.parseArray((String)reqArgs, Object.class).toArray();
    }

    private Class<?>[] processParameterTypes(String parameterTypes) {
        List types = JSONArray.parseArray((String)parameterTypes, String.class);
        ArrayList typesClass = new ArrayList();
        types.forEach(type -> {
            boolean bl = typesClass.add(this.classForName((String)type));
        });
        return typesClass.toArray(new Class[typesClass.size()]);
    }

    private Object[] processParams(String reqArgs, String parameterTypes) {
        return this.processParams(this.processArgs(reqArgs), this.processParameterTypes(parameterTypes));
    }

    private Object[] processParams(Object[] args, Class<?>[] parameterTypes) {
        ArrayList result = new ArrayList();
        Arrays.stream(parameterTypes).forEach(LambdaUtils.consumerWithIndex((type, i) -> {
            if (this.isCommonDataType((Class<?>)type) || this.isWrapClass((Class<?>)type)) {
                result.add(args[i]);
            } else {
                result.add(JSONObject.parseObject((String)String.valueOf(args[i]), (Class)type));
            }
        }));
        return result.toArray();
    }

    public boolean isCommonDataType(Class<?> clazz) {
        return clazz.isPrimitive();
    }

    public boolean isWrapClass(Class<?> clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        if (obj == null || StringUtils.isBlank((CharSequence)fieldName)) {
            logger.info("ReflectionUtil.getFieldValue(Object obj, String fieldName)\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        Field field = ReflectionUtils.getAccessField(obj, fieldName);
        if (field != null) {
            try {
                return field.get(obj);
            }
            catch (IllegalAccessException e) {
                logger.info("\u53cd\u5c04\u83b7\u53d6\u5bf9\u8c61\u6307\u5b9a\u5b57\u6bb5\u7684\u503c\u5f02\u5e38-{}", (Object)e.getMessage());
            }
        }
        return null;
    }

    public static Field getAccessField(Object obj, String fieldName) {
        if (obj == null || StringUtils.isBlank((CharSequence)fieldName)) {
            logger.info("ReflectionUtil.getAccessField(Object obj, String fieldName)\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        Class<?> clazz = obj.getClass();
        while (clazz != Object.class) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                if (field != null) {
                    field.setAccessible(true);
                    return field;
                }
            }
            catch (NoSuchFieldException e) {
                logger.info("\u83b7\u53d6\u6307\u5b9a\u7684\u5b57\u6bb5\u5f02\u5e38-{}", (Object)e.getMessage());
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static void setFieldVal(Field fieldVal, Object obj, Object val) {
        if (fieldVal == null || obj == null) {
            return;
        }
        fieldVal.setAccessible(true);
        try {
            fieldVal.set(obj, val);
        }
        catch (IllegalAccessException e) {
            logger.info(e.getMessage());
        }
    }

    public static Object getFieldValByAnnotation(Object t, Class<?> c, Class a) {
        Field field = ReflectionUtils.getFieldByAnnotation(c, a);
        try {
            field.setAccessible(true);
            return field.get(t);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BizException(String.format("\u4ece\u7c7b:%s\u4e2d\u83b7\u53d6\u4e0d\u5230\u5b57\u6bb5:%s\u7684\u503c", c.getSimpleName(), field.getName()));
        }
    }

    public static Field getFieldByAnnotation(Class<?> c, Class a) {
        Field[] declaredFields = c.getDeclaredFields();
        ArrayList valFields = new ArrayList();
        Arrays.stream(declaredFields).forEach(LambdaUtils.consumerWithIndex((field, index) -> {
            Object annotation = field.getAnnotation(a);
            if (annotation != null) {
                valFields.add(field);
            }
        }));
        if (CollectionUtils.isEmpty(valFields)) {
            return null;
        }
        AssertUtil.isFalse(valFields.size() > 1, String.format("\u6839\u636e\u6ce8\u89e3:%s\u5728\u7c7b:%s\u4e2d\u83b7\u53d6\u5230\u591a\u4e2a\u6dfb\u52a0\u4e86\u6ce8\u89e3\u7684\u5b57\u6bb5", a.getSimpleName(), c.getSimpleName()));
        return (Field)valFields.stream().findFirst().get();
    }
}

