/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.wh.commons.utils.AssertUtil;
import java.util.List;
import java.util.Objects;

public class ResponseDataUtil {
    public static final String SUCCESS_RESULT_CODE = "0";

    public static <T> T checkResponse(RestResponse<T> restResponse) {
        if (restResponse == null) {
            throw new BusinessRuntimeException("\u7cfb\u7edf\u5f02\u5e38\uff1a\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        if (SUCCESS_RESULT_CODE.equalsIgnoreCase(restResponse.getResultCode())) {
            return (T)restResponse.getData();
        }
        throw new BizException(restResponse.getResultMsg());
    }

    public static <T, R> List<R> checkResponseList(RestResponse<T> restResponse) {
        if (restResponse == null) {
            throw new BusinessRuntimeException("\u7cfb\u7edf\u5f02\u5e38\uff1a\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        if (SUCCESS_RESULT_CODE.equalsIgnoreCase(restResponse.getResultCode())) {
            Object data = restResponse.getData();
            AssertUtil.isTrue(data != null, "restResponse.getData()\u83b7\u53d6\u5f02\u5e38");
            if (data instanceof PageInfo) {
                return ((PageInfo)data).getList();
            }
        }
        throw new BizException(restResponse.getResultMsg());
    }

    public static <T> T isSuccess(RestResponse<T> restResponse) {
        Object t = null;
        if (restResponse != null && SUCCESS_RESULT_CODE.equalsIgnoreCase(restResponse.getResultCode())) {
            t = restResponse.getData();
        }
        return (T)t;
    }

    public static boolean isReturnSuccess(RestResponse restResponse) {
        return restResponse != null && SUCCESS_RESULT_CODE.equalsIgnoreCase(restResponse.getResultCode()) && Objects.nonNull(restResponse.getData());
    }
}

