/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.util.SpringBeanUtil;
import com.wh.commons.dto.response.UserInfoExtRespDto;
import com.wh.commons.enums.UserOrgLevelEnum;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServiceContextOrgUtils {
    private static Logger log = LoggerFactory.getLogger(ServiceContextOrgUtils.class);
    private static String JUDGE_PERMISSION_KEY = "wh.offpermission";

    public static UserInfoExtRespDto getUserInfoExt() {
        UserInfoExtRespDto userInfoExt = new UserInfoExtRespDto();
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)ServletRequestAttributes.class.cast(RequestContextHolder.getRequestAttributes());
            String headerUserInfo = requestAttributes.getRequest().getHeader("yes.req.wh.userInfo");
            headerUserInfo = new String(headerUserInfo.getBytes("ISO-8859-1"), "utf-8");
            if (StringUtils.isNotBlank((CharSequence)headerUserInfo)) {
                userInfoExt = (UserInfoExtRespDto)JSONObject.parseObject((String)headerUserInfo, UserInfoExtRespDto.class);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        return userInfoExt;
    }

    public static void judgeOrgLevelAndException(UserOrgLevelEnum userOrgLevelEnum) {
        if (ServiceContextOrgUtils.isOffPermission()) {
            return;
        }
        if (!userOrgLevelEnum.getOrgLevel().equals(ServiceContextOrgUtils.getUserInfoExt().getOrgLevel())) {
            throw new BizException(String.format("\u5f53\u524d\u64cd\u4f5c\u9700\u8981\u7528\u6237\u7ec4\u7ec7\u4e3a:%s\uff1b\u624d\u6709\u64cd\u4f5c\u6743\u9650", userOrgLevelEnum.getOrgLevelName()));
        }
    }

    public static boolean judgeOrgLevel(UserOrgLevelEnum userOrgLevelEnum) {
        if (ServiceContextOrgUtils.isOffPermission()) {
            return true;
        }
        return userOrgLevelEnum.getOrgLevel().equals(ServiceContextOrgUtils.getUserInfoExt().getOrgLevel());
    }

    private static boolean isOffPermission() {
        boolean result = false;
        Environment bean = (Environment)SpringBeanUtil.getBean(Environment.class);
        Integer offPermission = Integer.valueOf(bean.getProperty(JUDGE_PERMISSION_KEY, "0"));
        if (offPermission.equals(1)) {
            result = true;
        }
        return result;
    }
}

