/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import com.alibaba.fastjson.JSON;
import com.wh.commons.utils.AssertUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamExUtils {
    private static Logger log = LoggerFactory.getLogger(AssertUtil.class);

    public static <E> Supplier<Stream<E>> supplier(Collection<E> collection, boolean parallel) {
        return () -> StreamExUtils.support(collection, parallel);
    }

    public static <E> Supplier<Stream<E>> supplier(Collection<E> collection) {
        return StreamExUtils.supplier(collection, false);
    }

    public static <E> Supplier<Stream<E>> supplierFnc(Collection<E> collection, Predicate<E> predicate) {
        return StreamExUtils.supplierFnc(collection, predicate, false);
    }

    public static <E> Supplier<Stream<E>> supplierFnc(Collection<E> collection, Predicate<E> predicate, boolean parallel) {
        return () -> StreamExUtils.supportFnc(collection, predicate, parallel);
    }

    public static <E> Stream<E> support(Collection<E> collection, boolean parallel) {
        return Optional.ofNullable(collection).map(ts -> parallel ? ts.parallelStream() : ts.stream()).orElse(Stream.empty()).filter(Objects::nonNull).peek(print -> {
            if (log.isDebugEnabled()) {
                log.debug("support peek is =>{}", (Object)JSON.toJSONString((Object)print));
            }
        });
    }

    public static <E> Stream<E> support(Collection<E> collection) {
        return StreamExUtils.support(collection, false);
    }

    public static <E, U> Stream<U> supportFnc(E t, Function<E, Collection<U>> mapper, boolean parallel) {
        Objects.requireNonNull(mapper);
        return Optional.ofNullable(t).map(mapper).map(ts -> parallel ? ts.parallelStream() : ts.stream()).orElse(Stream.empty()).filter(Objects::nonNull).peek(print -> {
            if (log.isDebugEnabled()) {
                log.debug("supportFnc peek is =>{}", (Object)JSON.toJSONString((Object)print));
            }
        });
    }

    public static <E> Stream<E> supportFnc(Collection<E> collection, Predicate<E> predicate, boolean parallel) {
        Objects.requireNonNull(predicate);
        return Optional.ofNullable(collection).map(ts -> parallel ? ts.parallelStream() : ts.stream()).orElse(Stream.empty()).filter(Objects::nonNull).filter(predicate).peek(print -> {
            if (log.isDebugEnabled()) {
                log.debug("supportFnc peek is =>{}", (Object)JSON.toJSONString((Object)print));
            }
        });
    }

    public static <E, U> Stream<U> supportFnc(E t, Function<E, Collection<U>> mapper) {
        return StreamExUtils.supportFnc(t, mapper, false);
    }

    public static <E> Stream<E> supportFnc(Collection<E> collection, Predicate<E> predicate) {
        return StreamExUtils.supportFnc(collection, predicate, false);
    }
}

