/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TypeUtils {
    public static boolean isBaseType(Object o) {
        return o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double || o instanceof Character || o instanceof Boolean || o instanceof String || o instanceof Date;
    }

    public static <T> List<T> listRemove(List<T> list, int ... contains) {
        ArrayList<T> listBak = new ArrayList<T>();
        int size = list.size();
        int removeSize = contains.length;
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < removeSize) {
                if (i != contains[j]) {
                    listBak.add(list.get(i));
                }
                ++j;
            }
            ++i;
        }
        return listBak;
    }

    public static String splitString(String string, int index, String split) {
        List list = TypeUtils.strToList(string, split);
        int size = list.size();
        if (index >= size) {
            return null;
        }
        if (index < 0) {
            return (String)list.get(size - 1);
        }
        return (String)list.get(index);
    }

    public static String cutQuotes(String string) {
        if (string.startsWith("\"") || string.startsWith("'")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"") || string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String escapeSql(String string) {
        return string.replaceAll("'", "''");
    }

    public static String filterQuotes(String string) {
        return "'" + string.replaceAll("'", "'") + "'";
    }

    public static String addQuotes(String string) {
        return "'" + string.trim() + "'";
    }

    public static boolean isQuotesInclude(String string) {
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
            return true;
        }
        return string.startsWith("'") && string.endsWith("'");
    }

    public static boolean empty(List list) {
        return list == null || list.size() == 0;
    }

    public static boolean empty(String str) {
        return str == null || str.length() <= 0;
    }

    public static boolean empty(Integer integer) {
        return integer == null || integer == 0;
    }

    public static boolean empty(Long integer) {
        return integer == null || integer == 0L;
    }

    public static boolean empty(Object[] arrays) {
        return arrays == null || arrays.length <= 0;
    }

    public static <T> List<T> arrayToList(T[] ts) {
        if (TypeUtils.empty(ts)) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>();
        T[] TArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            list.add(t);
            ++n2;
        }
        return list;
    }

    public static String arrayToStr(Object[] array) {
        return TypeUtils.arrayToStr(array, ",");
    }

    public static String arrayToStr(Object[] array, String sep) {
        if (TypeUtils.empty(array)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            builder.append(o);
            builder.append(sep);
            ++n2;
        }
        return builder.substring(0, builder.length() - sep.length());
    }

    public static String listToStr(List list, String sep) {
        if (TypeUtils.empty(list)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Object obj : list) {
            builder.append(obj.toString());
            builder.append(sep);
        }
        return builder.substring(0, builder.length() - sep.length());
    }

    public static String[] toStrArray(String str) {
        return TypeUtils.toStrArray(",", str);
    }

    public static String[] toStrArray(String split, String str) {
        return str.split(split);
    }

    public static Long[] toLongArray(String str) {
        return TypeUtils.toLongArray(",", str);
    }

    public static Long[] toLongArray(String split, String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new Long[0];
        }
        String[] arr = str.split(split);
        Long[] longs = new Long[arr.length];
        int i = 0;
        while (i < arr.length) {
            Long v;
            longs[i] = v = TypeUtils.toLong(arr[i], null);
            ++i;
        }
        return longs;
    }

    public static Long toLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        String valueStr = TypeUtils.toStr(value, null);
        if (StringUtils.isEmpty((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr.trim()).longValue();
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static String toStr(Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static Object[] listToObject(List list) {
        if (TypeUtils.empty(list)) {
            return new Object[0];
        }
        Object[] lis = new Object[list.size()];
        int i = 0;
        while (i < list.size()) {
            lis[i] = list.get(i);
            ++i;
        }
        return lis;
    }

    public static String[] listToArray(List<String> list) {
        if (TypeUtils.empty(list)) {
            return new String[0];
        }
        String[] lis = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            lis[i] = list.get(i);
            ++i;
        }
        return lis;
    }

    public static String listToStr(List list) {
        return TypeUtils.listToStr(list, ",");
    }

    public static <T> List<T> strToList(String strs) {
        return TypeUtils.strToList(strs, null);
    }

    public static <T> List<T> strToList(String strs, String separated) {
        if (strs == null || strs.isEmpty()) {
            return new ArrayList();
        }
        if (separated == null) {
            separated = "\\s*,\\s*";
        }
        String[] lis = strs.split(separated);
        ArrayList<String> t = new ArrayList<String>();
        String[] stringArray = lis;
        int n = lis.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            t.add(s);
            ++n2;
        }
        return t;
    }

    public static List<Integer> strToIntegerList(String strs) {
        return TypeUtils.strToIntegerList(strs, null);
    }

    public static List<Integer> strToIntegerList(String strs, String separated) {
        if (strs == null || strs.isEmpty()) {
            return new ArrayList<Integer>();
        }
        if (separated == null) {
            separated = "\\s*,\\s*";
        }
        String[] lis = strs.split(separated);
        ArrayList<Integer> t = new ArrayList<Integer>();
        String[] stringArray = lis;
        int n = lis.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            try {
                t.add(Integer.valueOf(s));
            }
            catch (Exception exception) {
                t.add(0);
            }
            ++n2;
        }
        return t;
    }

    public static List<Long> strToLongList(String strs, String separated) {
        if (strs == null || strs.isEmpty()) {
            return new ArrayList<Long>();
        }
        if (separated == null) {
            separated = "\\s*,\\s*";
        }
        String[] lis = strs.split(separated);
        ArrayList<Long> t = new ArrayList<Long>();
        String[] stringArray = lis;
        int n = lis.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            try {
                t.add(Long.valueOf(s));
            }
            catch (Exception exception) {
                t.add(0L);
            }
            ++n2;
        }
        return t;
    }

    public static <T> List<T> removeRepetition(List<T> list) {
        ArrayList<T> tmpList = new ArrayList<T>();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            T t = it.next();
            if (tmpList.contains(t)) {
                it.remove();
                continue;
            }
            tmpList.add(t);
        }
        return list;
    }

    public static List<Object[]> batchParam(Object[] array) {
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            objects.add(new Object[]{obj});
            ++n2;
        }
        return objects;
    }

    public static String arrayToStr(Serializable[] ids) {
        if (TypeUtils.empty(ids)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Serializable[] serializableArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Serializable obj = serializableArray[n2];
            builder.append(obj.toString());
            builder.append(",");
            ++n2;
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static boolean hasRepeat(Object[] list) {
        int i = 0;
        while (i < list.length - 1) {
            int j = 0;
            while (j < list.length && i != j) {
                if (list[i] == list[j]) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasRepeat(List<String> list) {
        return TypeUtils.hasRepeat(TypeUtils.listToArray(list));
    }
}

