/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import com.dtyunxi.exceptions.BizException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhCollectionUtils {
    private static Logger logger = LoggerFactory.getLogger(WhCollectionUtils.class);

    public static Map<String, Object> obj2Map(Object obj) {
        Map result = new HashMap();
        try {
            result = PropertyUtils.describe((Object)obj);
            result.remove("class");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
            e2.printStackTrace();
        }
        Map<String, Object> collect = result.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
        return collect;
    }

    public static Map<String, String> obj2MapStr(Object obj) {
        Map result = new HashMap();
        try {
            result = PropertyUtils.describe((Object)obj);
            result.remove("class");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
            e2.printStackTrace();
        }
        Map<String, String> collect = result.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue().toString()));
        return collect;
    }

    public static <K, V> Map<K, List<V>> listToMaps(String fieldName, List<V> list) {
        try {
            return WhCollectionUtils.listToMapSafely(fieldName, list);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> Map<K, List<V>> listToMapSafely(String fieldName, List<V> list) throws NoSuchFieldException, IllegalAccessException {
        if (CollectionUtils.isEmpty(list) || StringUtils.isBlank((CharSequence)fieldName)) {
            return Collections.emptyMap();
        }
        HashMap<Object, ArrayList<V>> result = new HashMap<Object, ArrayList<V>>(list.size() * 4 / 3 + 2);
        Field targetField = WhCollectionUtils.getAccessField(fieldName, list.get(0).getClass());
        if (targetField == null) {
            return Collections.emptyMap();
        }
        for (V obj : list) {
            Object key = WhCollectionUtils.getKeyByFieldValue(targetField, obj);
            ArrayList<V> value = (ArrayList<V>)result.get(key);
            if (value == null) {
                value = new ArrayList<V>();
                result.put(key, value);
            }
            value.add(obj);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static Field getAccessField(String fieldName, Class clazz) {
        if (clazz != null && !StringUtils.isBlank((CharSequence)fieldName)) ** GOTO lbl9
        return null;
lbl-1000:
        // 1 sources

        {
            try {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException v0) {
                clazz = clazz.getSuperclass();
            }
lbl9:
            // 2 sources

            ** while (clazz != Object.class)
        }
lbl10:
        // 1 sources

        return null;
    }

    private static Object getKeyByFieldValue(Field field, Object obj) {
        Object key = null;
        if (field == null || obj == null) {
            throw new BizException("\u6570\u636e\u4e0d\u5b58\u5728\u6307\u5b9a\u7684\u5c5e\u6027");
        }
        try {
            key = field.get(obj);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{}", (Object)e.getMessage());
        }
        if (key == null) {
            logger.error("\u6570\u636e\u4e0d\u5b58\u5728\u6307\u5b9a\u7684\u5c5e\u6027 | fieldName: {}", (Object)field.getName());
            throw new BizException("\u6570\u636e\u4e0d\u5b58\u5728\u6307\u5b9a\u7684\u5c5e\u6027");
        }
        return key;
    }

    public static <T, K> List<K> list2Fields(List<T> list, Function<T, K> fieldFunc) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList();
        }
        return list.stream().map(fieldFunc).distinct().collect(Collectors.toList());
    }

    public static <T, K> List<T> listFilter(List<T> list, Function<T, K> fieldFunc, K status) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().filter(o -> {
            Object k = fieldFunc.apply(o);
            if (status == null) {
                return k == null;
            }
            return k != null && k.equals(status);
        }).collect(Collectors.toList());
    }

    public static <T, K> List<T> listReverseFilter(List<T> list, Function<T, K> fieldFunc, K status) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().filter(o -> {
            Object k = fieldFunc.apply(o);
            if (status == null) {
                return k != null;
            }
            return k == null || !k.equals(status);
        }).collect(Collectors.toList());
    }

    public static <T, K> Map<K, List<T>> groupBy(List<T> list, Function<T, K> groupKey) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap();
        }
        return list.stream().collect(Collectors.groupingBy(groupKey));
    }

    public static <T, K> Map<K, T> groupByGetFirst(List<T> list, Function<T, K> groupKey) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap();
        }
        return list.stream().collect(Collectors.groupingBy(groupKey, Collectors.collectingAndThen(Collectors.toList(), value -> value.get(0))));
    }

    public static <T, K, R> Map<K, R> groupByGetFirstVal(List<T> list, Function<T, K> groupKey, Function<T, R> valKey) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap();
        }
        return list.stream().collect(Collectors.groupingBy(groupKey, Collectors.collectingAndThen(Collectors.toList(), value -> valKey.apply(value.get(0)))));
    }
}

