/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import com.wh.commons.utils.AssertUtil;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.NumberUtils;

public class WhNumberUtils
extends NumberUtils {
    public static boolean greaterThanZero(Long value) {
        return value != null && value > 0L;
    }

    public static boolean greaterThanZero(Integer value) {
        return value != null && value > 0;
    }

    public static boolean greaterThanZero(BigDecimal value) {
        return value != null && value.compareTo(BigDecimal.ZERO) > 0;
    }

    public static boolean lessThanZeroOrNull(BigDecimal value) {
        return value == null || value.compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean lessThanZeroOrNull(Long value) {
        return value == null || value.compareTo(0L) < 0;
    }

    public static boolean lessThanZeroOrNull(Integer value) {
        return value == null || value.compareTo(0) < 0;
    }

    public static boolean lessThanZero(BigDecimal value) {
        if (value == null) {
            return false;
        }
        return value.compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean lessThanZero(Long value) {
        if (value == null) {
            return false;
        }
        return value.compareTo(0L) < 0;
    }

    public static boolean lessThanZero(Integer value) {
        if (value == null) {
            return false;
        }
        return value.compareTo(0) < 0;
    }

    public static BigDecimal subtract(BigDecimal main, BigDecimal ... args) {
        BigDecimal result = main;
        BigDecimal[] bigDecimalArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            BigDecimal value = bigDecimalArray[n2];
            if (value != null) {
                result = result.subtract(value);
            }
            ++n2;
        }
        return result.setScale(2, 4);
    }

    public static BigDecimal subtract(int newScale, int roundingMode, BigDecimal main, BigDecimal ... args) {
        BigDecimal result = main;
        BigDecimal[] bigDecimalArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            BigDecimal value = bigDecimalArray[n2];
            if (value != null) {
                result = result.subtract(value);
            }
            ++n2;
        }
        return result.setScale(newScale, roundingMode);
    }

    public static BigDecimal add(BigDecimal ... args) {
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal[] bigDecimalArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            BigDecimal value = bigDecimalArray[n2];
            if (value != null) {
                result = result.add(value);
            }
            ++n2;
        }
        return result;
    }

    public static BigDecimal plus(BigDecimal ... args) {
        return WhNumberUtils.add(args);
    }

    public static boolean isNumeric(String str) {
        if (org.springframework.util.StringUtils.isEmpty((Object)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static BigDecimal mul(BigDecimal bd, double m) {
        AssertUtil.isFalse(Objects.isNull(bd), "parameter is null");
        return bd != null && bd.compareTo(BigDecimal.ZERO) != 0 ? bd.multiply(new BigDecimal(String.valueOf(m))) : BigDecimal.ZERO;
    }

    public static BigDecimal mul(BigDecimal bd, BigDecimal m) {
        AssertUtil.isFalse(Objects.isNull(bd), "parameter is null");
        return bd != null && bd.compareTo(BigDecimal.ZERO) != 0 ? bd.multiply(m) : BigDecimal.ZERO;
    }

    public static BigDecimal emptyAmount(Object amount) {
        return Objects.nonNull(amount) ? new BigDecimal(amount.toString()) : BigDecimal.ZERO;
    }

    public static BigDecimal mul(BigDecimal multiplier, String multiplicand, int decimal, int UPorDown) {
        if (org.springframework.util.StringUtils.isEmpty((Object)multiplicand) || multiplicand.equals("0")) {
            return BigDecimal.ZERO;
        }
        if (Objects.isNull(multiplier) || multiplier.doubleValue() == 0.0) {
            return BigDecimal.ZERO;
        }
        return multiplier.multiply(new BigDecimal(multiplicand)).setScale(decimal, UPorDown);
    }

    public static BigDecimal rounding(BigDecimal params) {
        if (Objects.isNull(params)) {
            return BigDecimal.ZERO;
        }
        if (params.toString().contains("-")) {
            double v = Math.abs(params.doubleValue());
            return new BigDecimal(v);
        }
        return params;
    }

    public static BigDecimal isNullDefaultZero(BigDecimal params) {
        return Optional.ofNullable(params).orElse(BigDecimal.ZERO);
    }

    public static String defaultStr(String params) {
        return StringUtils.isNotEmpty((CharSequence)params) ? params : "";
    }
}

