/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ZipUtils {
    public static String unZip(String compressedStr) {
        if (compressedStr == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = null;
        GZIPInputStream ginzip = null;
        String decompressed = null;
        try {
            try {
                byte[] compressed = new BASE64Decoder().decodeBuffer(compressedStr);
                in = new ByteArrayInputStream(compressed);
                ginzip = new GZIPInputStream(in);
                byte[] buffer = new byte[1024];
                int offset = -1;
                while ((offset = ginzip.read(buffer)) != -1) {
                    out.write(buffer, 0, offset);
                }
                decompressed = out.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (ginzip != null) {
                    try {
                        ginzip.close();
                    }
                    catch (IOException e2) {
                        throw new BizException(e2.getLocalizedMessage());
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        throw new BizException(e3.getLocalizedMessage());
                    }
                }
                try {
                    out.close();
                }
                catch (IOException e4) {
                    throw new BizException(e4.getLocalizedMessage());
                }
            }
        }
        finally {
            if (ginzip != null) {
                try {
                    ginzip.close();
                }
                catch (IOException e) {
                    throw new BizException(e.getLocalizedMessage());
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new BizException(e.getLocalizedMessage());
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                throw new BizException(e.getLocalizedMessage());
            }
        }
        return decompressed;
    }

    public static String zip(String str) {
        ByteArrayOutputStream out;
        block14: {
            if (str == null || str.length() == 0) {
                return str;
            }
            out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = null;
            try {
                try {
                    gzip = new GZIPOutputStream(out);
                    gzip.write(str.getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (gzip == null) break block14;
                    try {
                        gzip.close();
                        break block14;
                    }
                    catch (IOException e2) {
                        throw new BizException(e2.getLocalizedMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                if (gzip != null) {
                    try {
                        gzip.close();
                    }
                    catch (IOException e) {
                        throw new BizException(e.getLocalizedMessage());
                    }
                }
                throw throwable;
            }
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException e) {
                    throw new BizException(e.getLocalizedMessage());
                }
            }
        }
        return new BASE64Encoder().encode(out.toByteArray());
    }
}

