/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.ocs.mgmt.application.dto.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum BillTypeEnum {
    SALE_LIST("SALE_LIST", "\u9500\u552e\u5355"),
    DELIVERY_REFUND_ONLY("DELIVERY_REFUND_ONLY", "\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e"),
    RETURN_BASE("RETURN_BASE", "\u9000\u8d27\u9000\u6b3e"),
    EXCHANGE("EXCHANGE", "\u6362\u8d27\u5355"),
    TRANSFERS("TRANSFERS", "\u8c03\u62e8\u5355"),
    FREIGHT_BOOKKEEPING("FREIGHT_BOOKKEEPING", "\u8fd0\u8d39"),
    PACKAGE_MATERIAL("PACKAGE_MATERIAL", "\u5305\u6750"),
    RECEIVE_ORDER("RECEIVE_ORDER", "\u9886\u7528"),
    RETURN_ORDER("RETURN_ORDER", "\u5f52\u8fd8");

    private String code;
    private String name;
    private static final Map<String, String> ORDER_TYPE_ENUM_MAP;

    private BillTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static List<String> getBillTypeEnumList() {
        ArrayList list = Lists.newArrayList();
        for (BillTypeEnum billTypeEnum : BillTypeEnum.values()) {
            list.add(billTypeEnum.getCode());
        }
        return list;
    }

    public static String getMapName(String code) {
        return ORDER_TYPE_ENUM_MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getDesc(String index) {
        for (BillTypeEnum billTypeEnum : BillTypeEnum.values()) {
            if (!billTypeEnum.getCode().equals(index)) continue;
            return billTypeEnum.getName();
        }
        return null;
    }

    public static List<Map<String, Object>> toList() {
        ArrayList list = Lists.newArrayList();
        for (BillTypeEnum orderTypeEnum : BillTypeEnum.values()) {
            if (!Objects.equals(SALE_LIST.getCode(), orderTypeEnum.getCode()) && !Objects.equals(RETURN_BASE.getCode(), orderTypeEnum.getCode()) && !Objects.equals(EXCHANGE.getCode(), orderTypeEnum.getCode())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", orderTypeEnum.getCode());
            map.put("name", orderTypeEnum.getName());
            list.add(map);
        }
        return list;
    }

    public static Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (BillTypeEnum orderTypeEnum : BillTypeEnum.values()) {
            map.put(orderTypeEnum.getCode(), orderTypeEnum.getName());
        }
        return map;
    }

    static {
        ORDER_TYPE_ENUM_MAP = new HashMap<String, String>();
        for (BillTypeEnum value : BillTypeEnum.values()) {
            ORDER_TYPE_ENUM_MAP.put(value.getCode(), value.getName());
        }
    }
}

