/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dto.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum OmsOrderStatusEnum {
    DELIVERED("DELIVERED", "\u5df2\u53d1\u8d27"),
    COMPLETE("COMPLETE", "\u5df2\u5b8c\u6210"),
    FINISH("FINISH", "\u5df2\u5b8c\u6210"),
    IN_WAREHOUSE("IN_WAREHOUSE", "\u5df2\u5165\u5e93");

    private String code;
    private String name;
    private static final Map<String, String> ORDER_STATUS_ENUM_MAP;
    public static final Map<String, OmsOrderStatusEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private OmsOrderStatusEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getMapName(String code) {
        return ORDER_STATUS_ENUM_MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getDesc(String index) {
        for (OmsOrderStatusEnum omsOrderStatusEnum : OmsOrderStatusEnum.values()) {
            if (!omsOrderStatusEnum.getCode().equals(index)) continue;
            return omsOrderStatusEnum.getName();
        }
        return null;
    }

    public static List<Map<String, Object>> toList() {
        ArrayList list = Lists.newArrayList();
        for (OmsOrderStatusEnum omsOrderStatusEnum : OmsOrderStatusEnum.values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", omsOrderStatusEnum.getCode());
            map.put("name", omsOrderStatusEnum.getName());
            list.add(map);
        }
        return list;
    }

    public static Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (OmsOrderStatusEnum omsOrderStatusEnum : OmsOrderStatusEnum.values()) {
            map.put(omsOrderStatusEnum.getCode(), omsOrderStatusEnum.getName());
        }
        return map;
    }

    public static OmsOrderStatusEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    static {
        ORDER_STATUS_ENUM_MAP = new HashMap<String, String>();
        for (OmsOrderStatusEnum value : OmsOrderStatusEnum.values()) {
            ORDER_STATUS_ENUM_MAP.put(value.getCode(), value.getName());
        }
        CODE_LOOKUP = Arrays.stream(OmsOrderStatusEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(OmsOrderStatusEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.name));
    }
}

