/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.rest.entity;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.api.entity.IReconciliationOrderApi;
import com.yunxi.dg.base.center.finance.dto.entity.BillAuditReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsOrgCustomerRelationDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsOrgCustomerRelationPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.GenerateReconciliationReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationBillDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationBillPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationOrderDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationOrderPageReqDto;
import com.yunxi.dg.base.center.finance.dto.enums.ReconciliationBillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.response.HandlerAuditRespDto;
import com.yunxi.dg.base.center.finance.dto.response.ReconciliationOrderDetailRespDto;
import com.yunxi.dg.base.center.finance.dto.response.ReconciliationOrderRespDto;
import com.yunxi.dg.base.center.finance.service.entity.IReconciliationOrderService;
import com.yunxi.dg.base.center.finance.service.entity.IReconciliationService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u6837\u672c\u4e2d\u5fc3:\u5bf9\u8d26\u5355\u8868\u63a5\u53e3\u670d\u52a1"})
@RequestMapping(value={"/v1/reconciliationOrder"})
public class ReconciliationOrderController
implements IReconciliationOrderApi {
    @Resource
    private IReconciliationOrderService service;
    @Resource
    private IReconciliationService reconciliationService;

    public RestResponse<Long> insert(@RequestBody ReconciliationOrderDto dto) {
        return this.service.insert((BaseDto)dto);
    }

    public RestResponse update(@RequestBody ReconciliationOrderDto dto) {
        return this.service.update((BaseDto)dto);
    }

    public RestResponse<ReconciliationOrderDetailRespDto> detail(Long id) {
        return this.service.detail(id);
    }

    public RestResponse<ReconciliationOrderDetailRespDto> queryBillList(ReconciliationOrderDto dto) {
        return this.service.queryBillList(dto);
    }

    public RestResponse logicDelete(@PathVariable(name="id", required=true) Long id) {
        return this.service.logicDelete(id);
    }

    public RestResponse<PageInfo<ReconciliationOrderRespDto>> queryPage(@RequestBody ReconciliationOrderPageReqDto dto) {
        return this.service.queryPage(dto);
    }

    public RestResponse<Map<String, Integer>> queryCount(@RequestBody(required=false) ReconciliationOrderPageReqDto dto) {
        return this.service.queryCount(dto);
    }

    public RestResponse<PageInfo<ReconciliationBillDto>> queryBillPage(ReconciliationBillPageReqDto reqDto) {
        return this.service.queryBillPage(reqDto);
    }

    public RestResponse<HandlerAuditRespDto> operatorBill(BillAuditReqDto reqDto) {
        return new RestResponse((Object)this.service.operatorBill(reqDto));
    }

    public RestResponse<List<CsOrgCustomerRelationDto>> queryList(CsOrgCustomerRelationPageReqDto reqDto) {
        return this.service.queryList(reqDto);
    }

    public RestResponse<Void> generateTradeRealation(List<String> ruleCodes) {
        CompletableFuture.runAsync(() -> this.reconciliationService.generateRealation(ruleCodes, false));
        return RestResponse.VOID;
    }

    public RestResponse<Void> autoGenerateBill(String ruleStrategy) {
        this.reconciliationService.autoGenerateCustomerBill(ruleStrategy);
        return RestResponse.VOID;
    }

    public RestResponse<Void> autoAuditOrPublishBill(String ruleStrategy) {
        this.reconciliationService.autoAuditOrPublishBill(ruleStrategy);
        return RestResponse.VOID;
    }

    public RestResponse<Void> autoConfirm(String ruleStrategy) {
        this.reconciliationService.autoConfirm(ruleStrategy);
        return RestResponse.VOID;
    }

    public RestResponse<Void> generateReconciliation(List<GenerateReconciliationReqDto> dtos) {
        CompletableFuture.runAsync(() -> this.reconciliationService.manualGenerateRealation(dtos));
        return RestResponse.VOID;
    }

    public RestResponse<List<Map<String, Object>>> getReconciliationBillType() {
        List billTypeList = ReconciliationBillTypeEnum.toList();
        return new RestResponse((Object)billTypeList);
    }

    public RestResponse<Void> autoDealOrderBillTest() {
        this.reconciliationService.autoDealOrderBillTest();
        return RestResponse.VOID;
    }
}

