/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.scheduler.task;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.ISingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.finance.dao.das.IBillApplyDas;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyChangeTypeEnum;
import com.yunxi.dg.base.center.finance.eo.BillApplyEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillApplyService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class BillApplyReconvertTask
implements ISingleTupleScheduleEvent {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IBillApplyService billApplyService;
    @Resource
    private IBillApplyDas billApplyDas;

    public void before(TaskMsg taskMsg) {
        this.logger.info("1\u3001=========\u5f00\u59cb\u6267\u884c\u5f00\u7968\u7533\u8bf7\u5355\u91cd\u65b0\u8f6c\u6362\u4efb\u52a1==========");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskMsg taskMsg) {
        this.resetApplyPerson();
        this.logger.info("2\u3001========>\u5f00\u7968\u7533\u8bf7\u5355\u91cd\u65b0\u8f6c\u6362\u4efb\u52a1\u6267\u884c\u4e2d");
        try {
            List<BillApplyEo> applyEoList;
            ArrayList<String> changeTypeList = new ArrayList<String>();
            changeTypeList.add(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
            changeTypeList.add(BillApplyChangeTypeEnum.HANDLE_FAIL.getCode());
            List waitHandleList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().in((Object)"change_type", changeTypeList)).lt((Object)"reconvert_num", (Object)3)).list();
            if (CollectionUtils.isNotEmpty((Collection)waitHandleList) && CollectionUtils.isNotEmpty(applyEoList = waitHandleList.stream().filter(eo -> eo.getReconvertNum() < 3 && this.judgeTime(eo.getCreateTime())).collect(Collectors.toList()))) {
                List applyNoList = applyEoList.stream().map(BillApplyEo::getApplyNo).collect(Collectors.toList());
                this.logger.info("\u8c03\u5ea6\u4efb\u52a1\u91cd\u65b0\u8f6c\u6362\u5355\u636e\uff1a{}", (Object)JSONObject.toJSONString(applyNoList));
                this.billApplyService.transformBillApply(applyNoList);
                this.updateApplyReconvertNum(applyEoList);
                this.updateApplyChangeType(applyEoList);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.info("\u5f00\u7968\u7533\u8bf7\u5355\u91cd\u65b0\u8f6c\u6362\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            boolean bl = true;
            return bl;
        }
        finally {
            this.logger.info("\u5f00\u7968\u7533\u8bf7\u5355\u91cd\u65b0\u8f6c\u6362\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
            return true;
        }
    }

    private void resetApplyPerson() {
        String oldApplyPerson = ServiceContext.getContext().getRequestUserCode();
        String newApplyPerson = "\u7cfb\u7edf";
        this.logger.info("\u91cd\u8bbe\u53d1\u7968\u7533\u8bf7\u4eba\uff1a{} -> {}", (Object)oldApplyPerson, (Object)newApplyPerson);
        ServiceContext.getContext().setAttachment("yes.req.userCode", newApplyPerson);
    }

    public void after(TaskMsg taskMsg) {
        this.logger.info("3\u3001=========\u7ed3\u675f\u5f00\u7968\u7533\u8bf7\u5355\u91cd\u65b0\u8f6c\u6362\u4efb\u52a1==========");
    }

    public boolean judgeTime(Date createTime) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        instance.add(12, -3);
        Date threeMinutesAge = instance.getTime();
        return !threeMinutesAge.before(createTime);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateApplyReconvertNum(List<BillApplyEo> applyEoList) {
        applyEoList.forEach(info -> {
            BillApplyEo billApplyEo = new BillApplyEo();
            billApplyEo.setId(info.getId());
            billApplyEo.setReconvertNum(Integer.valueOf(info.getReconvertNum() + 1));
            this.billApplyDas.updateSelective((BaseEo)billApplyEo);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateApplyChangeType(List<BillApplyEo> applyEoList) {
        List idList = applyEoList.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(idList)) {
            this.billApplyDas.updateChangeType(idList);
        }
    }
}

