/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.scheduler.task;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepExceptionDetailDomain;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.MamualKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.center.finance.eo.KeepExceptionDetailEo;
import com.yunxi.dg.base.center.finance.service.entity.ISyncKeepAccountingService;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="saleOrderKeepExceptionAccountingTask")
public class SaleOrderKeepExceptionAccountingTask
extends SingleTupleScheduleEvent {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Integer pageSize = 1000;
    private static final Integer endTimes = 10;
    private static final String voucherType = "0";
    @Resource
    private ISyncKeepAccountingService syncKeepAccountingService;
    @Resource
    private IKeepExceptionDetailDomain keepExceptionDetailDomain;
    @Resource
    private IAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;

    public void before(TaskMsg taskMsg) {
        this.logger.info("=========\u5f00\u59cb\u5b9a\u65f6\u6267\u884c\u4ea4\u8d27\u8bb0\u8d26\u5f02\u5e38\u8ba2\u5355\u91cd\u65b0\u8bb0\u8d26\u4efb\u52a1==========");
    }

    public boolean execute(TaskMsg taskMsg) {
        this.logger.info("========>\u5f00\u59cb\u5b9a\u65f6\u6267\u884c\u4ea4\u8d27\u8bb0\u8d26\u5f02\u5e38\u8ba2\u5355\u91cd\u65b0\u8bb0\u8d26\u4efb\u52a1\u6267\u884c\u4e2d");
        return true;
    }

    private void manualGenerateBookAccount(List<KeepExceptionDetailEo> orders, String orderType) {
        List afterSaleOrderEos;
        if (CollectionUtil.isEmpty(orders)) {
            return;
        }
        Map exceptionMap = orders.stream().filter(e -> Objects.nonNull(e.getOrderNo())).collect(Collectors.toMap(KeepExceptionDetailEo::getOrderNo, Function.identity(), (k1, k2) -> k2));
        HashSet existOrderNos = new HashSet();
        if (Objects.equals(BillTypeEnum.SALE_LIST.getCode(), orderType)) {
            List performOrderInfoEos = ((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().in((Object)"sale_order_no", exceptionMap.keySet())).list();
            if (CollectionUtil.isNotEmpty((Collection)performOrderInfoEos)) {
                existOrderNos.addAll(performOrderInfoEos.stream().map(DgPerformOrderInfoEo::getSaleOrderNo).collect(Collectors.toSet()));
            }
        } else if (Objects.equals(BillTypeEnum.RETURN_BASE.getCode(), orderType) && CollectionUtil.isNotEmpty((Collection)(afterSaleOrderEos = ((ExtQueryChainWrapper)this.afterSaleOrderDomain.filter().in((Object)"after_sale_order_no", exceptionMap.keySet())).list()))) {
            existOrderNos.addAll(afterSaleOrderEos.stream().map(AfterSaleOrderEo::getAfterSaleOrderNo).collect(Collectors.toSet()));
        }
        ArrayList<String> innerOrderNos = new ArrayList<String>();
        ArrayList<String> failOrderNos = new ArrayList<String>();
        for (KeepExceptionDetailEo order : orders) {
            if (existOrderNos.contains(order.getOrderNo())) {
                innerOrderNos.add(order.getOrderNo());
                continue;
            }
            failOrderNos.add(order.getOrderNo());
        }
        if (CollectionUtil.isNotEmpty(innerOrderNos)) {
            MamualKeepAccountReqDto keepAccountReqDto = new MamualKeepAccountReqDto();
            keepAccountReqDto.setType(KeepTypeEnum.MAMUAL.getCode());
            keepAccountReqDto.setAccountType(KeepTypeEnum.MAMUAL.getCode());
            keepAccountReqDto.setGeneratePerson("task");
            keepAccountReqDto.setOrderType(orderType);
            keepAccountReqDto.setVoucherType(voucherType);
            keepAccountReqDto.setInnerOrderNos(innerOrderNos);
            this.syncKeepAccountingService.manualGenerateBookAccount(keepAccountReqDto);
            this.keepExceptionDetailDomain.changeStatusByOrderNos(innerOrderNos, 1);
        }
        if (CollectionUtil.isNotEmpty(failOrderNos)) {
            this.keepExceptionDetailDomain.changeStatusByOrderNos(failOrderNos, 2);
        }
    }

    public void after(TaskMsg taskMsg) {
        this.logger.info("=========\u7ed3\u675f\u5b9a\u65f6\u6267\u884c\u4ea4\u8d27\u8bb0\u8d26\u5f02\u5e38\u8ba2\u5355\u91cd\u65b0\u8bb0\u8d26\u4efb\u52a1==========");
    }

    private static /* synthetic */ boolean lambda$execute$0(KeepExceptionDetailEo e) {
        return Objects.nonNull(e.getOrderNo()) && Objects.nonNull(e.getOrderType());
    }
}

