/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.BillAllElectricShopConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBillAllElectricShopDas;
import com.yunxi.dg.base.center.finance.dao.mapper.BillAllElectricShopMapper;
import com.yunxi.dg.base.center.finance.domain.entity.IBillAllElectricShopDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillAllElectricShopDto;
import com.yunxi.dg.base.center.finance.dto.request.AddBillAllElectricShopReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillAllElectricShopQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillAllElectricShopReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillAllElectricShopRespDto;
import com.yunxi.dg.base.center.finance.eo.BillAllElectricShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillAllElectricShopService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillAllElectricShopServiceImpl
extends BaseServiceImpl<BillAllElectricShopDto, BillAllElectricShopEo, IBillAllElectricShopDomain>
implements IBillAllElectricShopService {
    private static final Logger logger = LoggerFactory.getLogger(BillAllElectricShopServiceImpl.class);
    @Resource
    private IBillAllElectricShopDas billAllElectricShopDas;
    @Resource
    private IBillAllElectricShopDomain billAllElectricShopDomain;
    @Resource
    private BillAllElectricShopMapper billAllElectricShopMapper;

    public BillAllElectricShopServiceImpl(IBillAllElectricShopDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillAllElectricShopDto, BillAllElectricShopEo> converter() {
        return BillAllElectricShopConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addUpdateBillAllElectricShop(AddBillAllElectricShopReqDto addReqDtoList) {
        logger.info("\u65b0\u589e\u53d1\u7968\u5168\u7535\u5e97\u94fa\u914d\u7f6e:{}", (Object)JSONObject.toJSONString((Object)addReqDtoList));
        if (addReqDtoList.getUpdate().booleanValue()) {
            this.deleteAllElectricShop();
        }
        ArrayList list = new ArrayList();
        CubeBeanUtils.copyCollection(list, (Collection)addReqDtoList.getReqDtoList(), BillAllElectricShopEo.class);
        if (CollectionUtils.isNotEmpty(list)) {
            this.billAllElectricShopDas.insertBatch(list);
        }
    }

    public void deleteAllElectricShop() {
        logger.info("\u5220\u9664\u53d1\u7968\u5168\u7535\u5e97\u94fa\u914d\u7f6e");
        QueryWrapper deleteWrapper = new QueryWrapper();
        this.billAllElectricShopMapper.delete((Wrapper)deleteWrapper);
    }

    @Override
    public void modifyBillAllElectricShop(BillAllElectricShopReqDto modifyReqDto) {
        BillAllElectricShopEo billAllElectricShopEo = new BillAllElectricShopEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)billAllElectricShopEo);
        this.billAllElectricShopDas.updateSelective((BaseEo)billAllElectricShopEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillAllElectricShop(List<Long> idList) {
        logger.info("\u5220\u9664\u53d1\u7968\u5168\u7535\u5e97\u94fa\u914d\u7f6e\u884c:{}", (Object)JSONObject.toJSONString(idList));
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.in((Object)"id", idList);
        this.billAllElectricShopMapper.delete((Wrapper)deleteWrapper);
    }

    @Override
    public BillAllElectricShopRespDto queryById(Long id) {
        BillAllElectricShopEo billAllElectricShopEo = (BillAllElectricShopEo)this.billAllElectricShopDas.selectByPrimaryKey(id);
        BillAllElectricShopRespDto billAllElectricShopRespDto = new BillAllElectricShopRespDto();
        DtoHelper.eo2Dto((BaseEo)billAllElectricShopEo, (BaseVo)billAllElectricShopRespDto);
        return billAllElectricShopRespDto;
    }

    @Override
    public List<BillAllElectricShopRespDto> queryByList(BillAllElectricShopQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u5f00\u7968\u5168\u7535\u5e97\u94fa\u914d\u7f6e:{}", (Object)JSONObject.toJSONString((Object)queryDto));
        ExtQueryChainWrapper filter = this.billAllElectricShopDas.filter();
        if (null != queryDto) {
            if (StringUtils.isNotBlank((CharSequence)queryDto.getShopCode())) {
                filter.eq((Object)"shop_code", (Object)queryDto.getShopCode());
            }
            if (StringUtils.isNotBlank((CharSequence)queryDto.getShopName())) {
                filter.like((Object)"shop_name", (Object)queryDto.getShopName());
            }
            if (StringUtils.isNotBlank((CharSequence)queryDto.getSiteCode())) {
                filter.eq((Object)"site_code", (Object)queryDto.getSiteCode());
            }
            if (StringUtils.isNotBlank((CharSequence)queryDto.getSiteName())) {
                filter.like((Object)"site_name", (Object)queryDto.getSiteName());
            }
        }
        List list = filter.list();
        ArrayList<BillAllElectricShopRespDto> respDtoList = new ArrayList<BillAllElectricShopRespDto>();
        CubeBeanUtils.copyCollection(respDtoList, (Collection)list, BillAllElectricShopRespDto.class);
        return respDtoList;
    }

    @Override
    public PageInfo<BillAllElectricShopRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        BillAllElectricShopReqDto billAllElectricShopReqDto = (BillAllElectricShopReqDto)JSON.parseObject((String)filter, BillAllElectricShopReqDto.class);
        BillAllElectricShopEo billAllElectricShopEo = new BillAllElectricShopEo();
        DtoHelper.dto2Eo((BaseVo)billAllElectricShopReqDto, (BaseEo)billAllElectricShopEo);
        PageInfo eoPageInfo = this.billAllElectricShopDomain.selectPage((BaseEo)billAllElectricShopEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BillAllElectricShopRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

