/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wh.center.data.api.IAreaExtApi;
import com.wh.center.data.api.dto.request.AreaNameReqDto;
import com.wh.center.data.api.dto.request.MatchByNameOrAliasReqDto;
import com.wh.center.data.api.dto.response.AreaMatchRespDto;
import com.wh.center.data.api.dto.response.AreaNodeDto;
import com.yunxi.dg.base.center.customer.dao.das.IDgEnterpriseDas;
import com.yunxi.dg.base.center.customer.eo.DgEnterpriseEo;
import com.yunxi.dg.base.center.finance.api.entity.BillInvoiceRemarkDto;
import com.yunxi.dg.base.center.finance.convert.entity.BillInvoiceRemarkRuleConverter;
import com.yunxi.dg.base.center.finance.dao.mapper.ShopMapper;
import com.yunxi.dg.base.center.finance.domain.entity.IBillInfoDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IBillInvoiceRemarkRuleDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IBillInvoiceRemarkRuleShopDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillInvoiceRemarkConfigDto;
import com.yunxi.dg.base.center.finance.dto.entity.BillInvoiceRemarkContentDto;
import com.yunxi.dg.base.center.finance.dto.entity.BillInvoiceRemarkRuleDto;
import com.yunxi.dg.base.center.finance.dto.entity.BillInvoiceRemarkRulePageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.BillInvoiceRemarkRuleShopDto;
import com.yunxi.dg.base.center.finance.dto.entity.InvoiceRemarkAreaDto;
import com.yunxi.dg.base.center.finance.dto.entity.InvoiceRemarkConfigDto;
import com.yunxi.dg.base.center.finance.dto.entity.InvoiceRemarkContentReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PlatformOrderIdentityDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillInvoiceRemarkConfigEnum;
import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.eo.BillInvoiceRemarkRuleEo;
import com.yunxi.dg.base.center.finance.eo.BillInvoiceRemarkRuleShopEo;
import com.yunxi.dg.base.center.finance.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoValidateService;
import com.yunxi.dg.base.center.finance.service.entity.IBillInvoiceRemarkConfigService;
import com.yunxi.dg.base.center.finance.service.entity.IBillInvoiceRemarkRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IPlatformOrderIdentityService;
import com.yunxi.dg.base.center.finance.service.generate.GenerateCodeUtils;
import com.yunxi.dg.base.center.finance.service.generate.IGenerateCodeService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.center.item.dao.das.IItemInvoiceDas;
import com.yunxi.dg.base.center.item.dto.entity.ItemInvoiceDto;
import com.yunxi.dg.base.center.item.eo.ItemInvoiceEo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BillInvoiceRemarkRuleServiceImpl
extends BaseServiceImpl<BillInvoiceRemarkRuleDto, BillInvoiceRemarkRuleEo, IBillInvoiceRemarkRuleDomain>
implements IBillInvoiceRemarkRuleService {
    private static final Logger log = LoggerFactory.getLogger(BillInvoiceRemarkRuleServiceImpl.class);
    @Resource
    private IBillInvoiceRemarkRuleShopDomain shopDomain;
    @Resource
    private IAreaExtApi areaExtApi;
    @Resource
    private IPlatformOrderIdentityService platformOrderIdentityService;
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IBillInvoiceRemarkConfigService configService;
    @Resource
    private IBillInfoValidateService billInfoValidateService;
    @Resource
    private IItemInvoiceDas itemInvoiceDas;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private ShopMapper shopMapper;
    @Value(value="${bill.invoice.remark.customer.fields.count:5}")
    private Integer customerFieldsCount;
    @Resource
    private IDgEnterpriseDas enterpriseDas;
    @Resource
    private IBillInfoDomain billInfoDomain;

    public BillInvoiceRemarkRuleServiceImpl(IBillInvoiceRemarkRuleDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillInvoiceRemarkRuleDto, BillInvoiceRemarkRuleEo> converter() {
        return BillInvoiceRemarkRuleConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(BillInvoiceRemarkRuleDto dto) {
        log.info("\u65b0\u589e\u5f00\u7968\u5907\u6ce8\u89c4\u5219\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        this.validate(dto);
        BillInvoiceRemarkRuleEo configEo = new BillInvoiceRemarkRuleEo();
        if (Objects.isNull(dto.getId())) {
            IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.INVOICE_REMARK_RULE.getCode());
            String ruleCode = generateCodeService.getCode("BZGZ");
            BillInvoiceRemarkRulePageReqDto reqDto = new BillInvoiceRemarkRulePageReqDto();
            reqDto.setEnable(Integer.valueOf(0));
            reqDto.setSiteCodes(Arrays.asList(dto.getSiteCode()));
            reqDto.setProvinceCode(dto.getProvinceCode());
            reqDto.setCityCode(StringUtils.isNotBlank((CharSequence)dto.getCityCode()) ? dto.getCityCode() : null);
            reqDto.setCountyCode(StringUtils.isNotBlank((CharSequence)dto.getCountyCode()) ? dto.getCountyCode() : null);
            reqDto.setRelatedEntityNumber(dto.getRelatedEntityNumber());
            List collect = dto.getBillInvoiceRemarkRuleShopDtos().stream().map(BillInvoiceRemarkRuleShopDto::getShopCode).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                reqDto.setShopCodes(collect);
            }
            reqDto.setFlag("add");
            List<BillInvoiceRemarkRuleDto> remarkRuleDtos = this.queryList(reqDto);
            AssertUtils.isFalse((boolean)CollectionUtil.isNotEmpty(remarkRuleDtos), (String)"\u5df2\u5b58\u5728\u540c\u4e00\u533a\u57df\u540c\u4e00\u89c4\u5219\u540c\u4e00\u6e20\u9053\u542f\u7528\u7684\u6570\u636e!");
            Date startTime = DateUtil.parseDate((String)(dto.getEffectBeginTime() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            Date endTime = DateUtil.parseDate((String)(dto.getEffectEndTime() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
            Date now = new Date();
            if (startTime.after(endTime)) {
                throw new BizException("\u89c4\u5219\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f");
            }
            if (endTime.before(now)) {
                throw new BizException("\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
            }
            configEo = new BillInvoiceRemarkRuleEo();
            CubeBeanUtils.copyProperties((Object)configEo, (Object)dto, (String[])new String[0]);
            configEo.setRuleCode(ruleCode);
            configEo.setEnable(Integer.valueOf(0));
            configEo.setCustomFields(dto.getCustomFields());
            if ("\u5168\u56fd".equals(dto.getProvince())) {
                configEo.setProvinceCode("000");
            }
            List billInvoiceRemarkRuleShopEos = dto.getBillInvoiceRemarkRuleShopDtos().stream().map(v -> {
                BillInvoiceRemarkRuleShopEo billInvoiceRemarkRuleShopEo = new BillInvoiceRemarkRuleShopEo();
                CubeBeanUtils.copyProperties((Object)billInvoiceRemarkRuleShopEo, (Object)v, (String[])new String[0]);
                billInvoiceRemarkRuleShopEo.setRuleCode(ruleCode);
                return billInvoiceRemarkRuleShopEo;
            }).collect(Collectors.toList());
            if (Objects.nonNull(configEo)) {
                ((IBillInvoiceRemarkRuleDomain)this.domain).insert((BaseEo)configEo);
                this.shopDomain.insertBatch(billInvoiceRemarkRuleShopEos);
            }
        } else {
            configEo = (BillInvoiceRemarkRuleEo)((IBillInvoiceRemarkRuleDomain)this.domain).selectByPrimaryKey(dto.getId());
            String ruleCode = configEo.getRuleCode();
            dto.setRuleCode(configEo.getRuleCode());
            BillInvoiceRemarkRulePageReqDto reqDto = new BillInvoiceRemarkRulePageReqDto();
            reqDto.setEnable(Integer.valueOf(0));
            reqDto.setSiteCodes(Arrays.asList(dto.getSiteCode()));
            reqDto.setProvinceCode(dto.getProvinceCode());
            reqDto.setCityCode(StringUtils.isNotBlank((CharSequence)dto.getCityCode()) ? dto.getCityCode() : null);
            reqDto.setCountyCode(StringUtils.isNotBlank((CharSequence)dto.getCountyCode()) ? dto.getCountyCode() : null);
            reqDto.setRelatedEntityNumber(dto.getRelatedEntityNumber());
            List collect = dto.getBillInvoiceRemarkRuleShopDtos().stream().map(BillInvoiceRemarkRuleShopDto::getShopCode).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                reqDto.setShopCodes(collect);
            }
            reqDto.setFlag("update");
            reqDto.setNeRuleCode(configEo.getRuleCode());
            List<BillInvoiceRemarkRuleDto> remarkRuleDtos = this.queryList(reqDto);
            AssertUtils.isFalse((boolean)CollectionUtil.isNotEmpty(remarkRuleDtos), (String)"\u5df2\u5b58\u5728\u540c\u4e00\u533a\u57df\u540c\u4e00\u89c4\u5219\u540c\u4e00\u6e20\u9053\u542f\u7528\u7684\u6570\u636e!");
            Date startTime = DateUtil.parseDate((String)(dto.getEffectBeginTime() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            Date endTime = DateUtil.parseDate((String)(dto.getEffectEndTime() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
            Date now = new Date();
            if (startTime.after(endTime)) {
                throw new BizException("\u89c4\u5219\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f");
            }
            if (endTime.before(now)) {
                throw new BizException("\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f");
            }
            CubeBeanUtils.copyProperties((Object)configEo, (Object)dto, (String[])new String[0]);
            configEo.setEnable(Integer.valueOf(0));
            configEo.setCustomFields(dto.getCustomFields());
            if ("\u5168\u56fd".equals(dto.getProvince())) {
                configEo.setProvinceCode("000");
            }
            List billInvoiceRemarkRuleShopEos = dto.getBillInvoiceRemarkRuleShopDtos().stream().map(v -> {
                BillInvoiceRemarkRuleShopEo billInvoiceRemarkRuleShopEo = new BillInvoiceRemarkRuleShopEo();
                CubeBeanUtils.copyProperties((Object)billInvoiceRemarkRuleShopEo, (Object)v, (String[])new String[0]);
                billInvoiceRemarkRuleShopEo.setRuleCode(ruleCode);
                return billInvoiceRemarkRuleShopEo;
            }).collect(Collectors.toList());
            if (Objects.nonNull(configEo)) {
                ((IBillInvoiceRemarkRuleDomain)this.domain).updateSelective((BaseEo)configEo);
                List shopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().eq((Object)"rule_code", (Object)ruleCode)).list();
                if (CollectionUtil.isNotEmpty((Collection)shopEos)) {
                    BillInvoiceRemarkRuleShopEo shopEo = new BillInvoiceRemarkRuleShopEo();
                    shopEo.setRuleCode(ruleCode);
                    this.shopDomain.logicDelete((BaseEo)shopEo);
                }
                this.shopDomain.insertBatch(billInvoiceRemarkRuleShopEos);
            }
        }
        return configEo.getId();
    }

    private void validate(BillInvoiceRemarkRuleDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u65b0\u589e\u5f00\u7968\u5907\u6ce8\u89c4\u5219\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getRuleName(), (String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getSiteName(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getSiteCode(), (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getRelatedEntityName(), (String)"\u9500\u552e\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getRelatedEntityNumber(), (String)"\u9500\u552e\u4e3b\u4f53\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getEffectBeginTime(), (String)"\u89c4\u5219\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getEffectEndTime(), (String)"\u89c4\u5219\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notEmpty((Collection)dto.getBillInvoiceRemarkRuleShopDtos(), (String)"\u9002\u7528\u5e97\u94fa\u4e0d\u80fd\u4e3a\u7a7a!");
        if (dto.getRuleName().length() > 128) {
            throw new BizException("\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7128\u4e2a\u5b57\u7b26!");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCustomFields())) {
            log.info("customerFieldsCount:{}", (Object)this.customerFieldsCount);
            List<String> customerFields = Arrays.asList(dto.getCustomFields().split(","));
            if (customerFields.size() > this.customerFieldsCount) {
                throw new BizException("\u81ea\u5b9a\u4e49\u5b57\u6bb5\u4e0d\u80fd\u8d85\u8fc7" + this.customerFieldsCount + "\u4e2a!");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRelatedEntityNumber())) {
            List enterpriseEos = ((ExtQueryChainWrapper)this.enterpriseDas.filter().eq((Object)"code", (Object)dto.getRelatedEntityNumber())).list();
            if (CollectionUtil.isEmpty((Collection)enterpriseEos)) {
                throw new BizException("\u9500\u552e\u4e3b\u4f53\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            DgEnterpriseEo enterpriseEo = (DgEnterpriseEo)enterpriseEos.get(0);
            if (StringUtils.isBlank((CharSequence)enterpriseEo.getProvinceCode())) {
                throw new BizException("\u9500\u552e\u4e3b\u4f53:" + dto.getRelatedEntityName() + "\u6ca1\u6709\u8bbe\u7f6e\u5bf9\u5e94\u7684\u6ce8\u518c\u5730,\u8bf7\u68c0\u67e5!");
            }
        }
    }

    @Override
    public void deleteRule(Long id) {
        BillInvoiceRemarkRuleEo ruleEo = (BillInvoiceRemarkRuleEo)((IBillInvoiceRemarkRuleDomain)this.domain).selectByPrimaryKey(id);
        AssertUtils.notNull((Object)ruleEo, (String)"\u5f00\u7968\u5907\u6ce8\u89c4\u5219\u7406\u6570\u636e\u4e0d\u5b58\u5728!");
        ((IBillInvoiceRemarkRuleDomain)this.domain).logicDeleteById(id);
        List ruleShopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().eq((Object)"rule_code", (Object)ruleEo.getRuleCode())).list();
        if (CollectionUtil.isNotEmpty((Collection)ruleShopEos)) {
            BillInvoiceRemarkRuleShopEo remarkRuleShopEo = new BillInvoiceRemarkRuleShopEo();
            remarkRuleShopEo.setRuleCode(ruleEo.getRuleCode());
            this.shopDomain.logicDelete((BaseEo)remarkRuleShopEo);
        }
    }

    @Override
    public void enable(BillInvoiceRemarkRuleDto dto) {
        BillInvoiceRemarkRuleEo configEo = (BillInvoiceRemarkRuleEo)((IBillInvoiceRemarkRuleDomain)this.domain).selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)configEo, (String)"\u5f00\u7968\u5907\u6ce8\u89c4\u5219\u7406\u6570\u636e\u4e0d\u5b58\u5728!");
        BillInvoiceRemarkRulePageReqDto reqDto = new BillInvoiceRemarkRulePageReqDto();
        reqDto.setEnable(Integer.valueOf(0));
        reqDto.setSiteCodes(Arrays.asList(configEo.getSiteCode()));
        reqDto.setProvinceCode(configEo.getProvinceCode());
        reqDto.setCityCode(StringUtils.isNotBlank((CharSequence)configEo.getCityCode()) ? configEo.getCityCode() : null);
        reqDto.setCountyCode(StringUtils.isNotBlank((CharSequence)configEo.getCountyCode()) ? configEo.getCountyCode() : null);
        reqDto.setRelatedEntityNumber(configEo.getRelatedEntityNumber());
        List ruleShopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().eq((Object)"rule_code", (Object)configEo.getRuleCode())).list();
        if (CollectionUtil.isNotEmpty((Collection)ruleShopEos)) {
            reqDto.setShopCodes(ruleShopEos.stream().map(BillInvoiceRemarkRuleShopEo::getShopCode).collect(Collectors.toList()));
        }
        reqDto.setFlag("enable");
        reqDto.setNeRuleCode(configEo.getRuleCode());
        List<BillInvoiceRemarkRuleDto> remarkRuleDtos = this.queryList(reqDto);
        AssertUtils.isFalse((boolean)CollectionUtil.isNotEmpty(remarkRuleDtos), (String)"\u5df2\u5b58\u5728\u540c\u4e00\u533a\u57df\u540c\u4e00\u89c4\u5219\u540c\u4e00\u6e20\u9053\u542f\u7528\u7684\u6570\u636e!");
        Date startTime = DateUtil.parseDate((String)(configEo.getEffectBeginTime() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
        Date endTime = DateUtil.parseDate((String)(dto.getEffectEndTime() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
        Date now = new Date();
        if (!now.after(startTime) || !now.before(endTime)) {
            throw new BizException("\u5f53\u524d\u65f6\u95f4\u4e0d\u5728\u6709\u6548\u65f6\u95f4\u8303\u56f4\u5185!");
        }
        BillInvoiceRemarkRuleEo remarkRuleEo = new BillInvoiceRemarkRuleEo();
        remarkRuleEo.setId(dto.getId());
        remarkRuleEo.setEnable(dto.getEnable());
        ((IBillInvoiceRemarkRuleDomain)this.domain).updateSelective((BaseEo)remarkRuleEo);
    }

    @Override
    public BillInvoiceRemarkRuleDto detail(Long id) {
        BillInvoiceRemarkRuleDto configDto = new BillInvoiceRemarkRuleDto();
        BillInvoiceRemarkRuleEo configEo = (BillInvoiceRemarkRuleEo)((ExtQueryChainWrapper)((IBillInvoiceRemarkRuleDomain)this.domain).filter().eq((Object)"id", (Object)id)).one();
        AssertUtils.notNull((Object)configEo, (String)"\u5f00\u7968\u5907\u6ce8\u89c4\u5219\u7406\u6570\u636e\u4e0d\u5b58\u5728!");
        configDto.setId(configEo.getId());
        configDto.setRuleCode(configEo.getRuleCode());
        configDto.setRuleName(configEo.getRuleName());
        configDto.setSiteCode(configEo.getSiteCode());
        configDto.setSiteName(configEo.getSiteName());
        configDto.setEnable(configEo.getEnable());
        configDto.setRemark(configEo.getRemark());
        configDto.setEffectBeginTime(configEo.getEffectBeginTime());
        configDto.setEffectEndTime(configEo.getEffectEndTime());
        configDto.setUpdateTime(configEo.getUpdateTime());
        configDto.setUpdatePerson(configEo.getUpdatePerson());
        configDto.setOptionalField(configEo.getOptionalField());
        configDto.setCustomFields(configEo.getCustomFields());
        configDto.setProvince(configEo.getProvince());
        configDto.setProvinceCode(configEo.getProvinceCode());
        configDto.setCity(configEo.getCity());
        configDto.setCityCode(configEo.getCityCode());
        configDto.setCounty(configEo.getCounty());
        configDto.setCountyCode(configEo.getCountyCode());
        configDto.setFields1(configEo.getFields1());
        configDto.setFields2(configEo.getFields2());
        configDto.setFields3(configEo.getFields3());
        configDto.setFields4(configEo.getFields4());
        configDto.setFields5(configEo.getFields5());
        configDto.setRelatedEntityNumber(configEo.getRelatedEntityNumber());
        configDto.setRelatedEntityName(configEo.getRelatedEntityName());
        List remarkRuleShopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().eq((Object)"rule_code", (Object)configEo.getRuleCode())).list();
        if (CollectionUtil.isNotEmpty((Collection)remarkRuleShopEos)) {
            List remarkRuleShopDtos = remarkRuleShopEos.stream().map(v -> {
                BillInvoiceRemarkRuleShopDto shopDto = new BillInvoiceRemarkRuleShopDto();
                CubeBeanUtils.copyProperties((Object)shopDto, (Object)v, (String[])new String[0]);
                return shopDto;
            }).collect(Collectors.toList());
            configDto.setBillInvoiceRemarkRuleShopDtos(remarkRuleShopDtos);
        }
        return configDto;
    }

    @Override
    public PageInfo<BillInvoiceRemarkRuleDto> queryPage(BillInvoiceRemarkRulePageReqDto dto) {
        log.info("\u5206\u9875\u67e5\u8be2\u5f00\u7968\u5907\u6ce8\u89c4\u5219\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        Integer pageNum = dto.getPageNum();
        Integer pageSize = dto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        PageInfo pageInfo = ((IBillInvoiceRemarkRuleDomain)this.domain).queryPage(dto, pageNum, pageSize);
        if (Objects.nonNull(pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            List ruleCodes = pageInfo.getList().stream().map(BillInvoiceRemarkRuleDto::getRuleCode).collect(Collectors.toList());
            List remarkRuleShopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"rule_code", ruleCodes)).list();
            Map<Object, Object> ruleShopMap = Maps.newHashMap();
            if (CollectionUtil.isNotEmpty((Collection)remarkRuleShopEos)) {
                ruleShopMap = remarkRuleShopEos.stream().collect(Collectors.groupingBy(BillInvoiceRemarkRuleShopEo::getRuleCode));
            }
            HashMap finalRuleShopMap = ruleShopMap;
            pageInfo.getList().forEach(v -> {
                if (finalRuleShopMap.containsKey(v.getRuleCode())) {
                    List shopEos = (List)finalRuleShopMap.get(v.getRuleCode());
                    List shopDtos = shopEos.stream().map(shopEo -> {
                        BillInvoiceRemarkRuleShopDto shopDto = new BillInvoiceRemarkRuleShopDto();
                        CubeBeanUtils.copyProperties((Object)shopDto, (Object)shopEo, (String[])new String[0]);
                        return shopDto;
                    }).collect(Collectors.toList());
                    v.setBillInvoiceRemarkRuleShopDtos(shopDtos);
                    v.setShopCount(Integer.valueOf(shopEos.size()));
                }
                if (StringUtils.isNotBlank((CharSequence)v.getOptionalField())) {
                    List invoiceRemarkConfigDtos = JSONObject.parseArray((String)v.getOptionalField(), InvoiceRemarkConfigDto.class);
                    List collect1 = invoiceRemarkConfigDtos.stream().filter(x -> null != x.getInvoiceRemark()).sorted(Comparator.comparing(InvoiceRemarkConfigDto::getSerialNo, Comparator.comparingInt(Integer::parseInt))).collect(Collectors.toList());
                    List collect = collect1.stream().map(InvoiceRemarkConfigDto::getInvoiceRemark).collect(Collectors.toList());
                    v.setConcatOptionalField(StringUtils.join(collect, (String)","));
                }
                StringBuilder builder = new StringBuilder();
                if (StringUtils.isNotBlank((CharSequence)v.getFields1())) {
                    builder.append(v.getFields1()).append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)v.getFields2())) {
                    builder.append(v.getFields2()).append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)v.getFields3())) {
                    builder.append(v.getFields3()).append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)v.getFields4())) {
                    builder.append(v.getFields4()).append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)v.getFields5())) {
                    builder.append(v.getFields5()).append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)builder.toString()) && builder.length() > 0) {
                    builder.deleteCharAt(builder.length() - 1);
                    v.setConcatCustomFields(builder.toString());
                }
            });
        }
        return pageInfo;
    }

    @Override
    public List<BillInvoiceRemarkRuleDto> queryList(BillInvoiceRemarkRulePageReqDto dto) {
        log.info("\u67e5\u8be2\u89c4\u5219\u914d\u7f6e\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        List ruleDtoList = ((IBillInvoiceRemarkRuleDomain)this.domain).queryList(dto);
        if (CollectionUtil.isNotEmpty((Collection)ruleDtoList)) {
            List ruleCodes = ruleDtoList.stream().map(BillInvoiceRemarkRuleDto::getRuleCode).collect(Collectors.toList());
            List remarkRuleShopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"rule_code", ruleCodes)).list();
            Map<Object, Object> ruleShopMap = Maps.newHashMap();
            if (CollectionUtil.isNotEmpty((Collection)remarkRuleShopEos)) {
                ruleShopMap = remarkRuleShopEos.stream().collect(Collectors.groupingBy(BillInvoiceRemarkRuleShopEo::getRuleCode));
            }
            HashMap finalRuleShopMap = ruleShopMap;
            ruleDtoList.forEach(v -> {
                if (finalRuleShopMap.containsKey(v.getRuleCode())) {
                    List shopEos = (List)finalRuleShopMap.get(v.getRuleCode());
                    List shopDtos = shopEos.stream().map(shopEo -> {
                        BillInvoiceRemarkRuleShopDto shopDto = new BillInvoiceRemarkRuleShopDto();
                        CubeBeanUtils.copyProperties((Object)shopDto, (Object)shopEo, (String[])new String[0]);
                        return shopDto;
                    }).collect(Collectors.toList());
                    v.setBillInvoiceRemarkRuleShopDtos(shopDtos);
                    v.setShopCount(Integer.valueOf(shopEos.size()));
                }
                if (StringUtils.isNotBlank((CharSequence)v.getOptionalField())) {
                    List invoiceRemarkConfigDtos = JSONObject.parseArray((String)v.getOptionalField(), InvoiceRemarkConfigDto.class);
                    List collect1 = invoiceRemarkConfigDtos.stream().filter(x -> null != x.getInvoiceRemark()).sorted(Comparator.comparing(InvoiceRemarkConfigDto::getSerialNo, Comparator.comparingInt(Integer::parseInt))).collect(Collectors.toList());
                    List collect = collect1.stream().map(InvoiceRemarkConfigDto::getInvoiceRemark).collect(Collectors.toList());
                    v.setConcatOptionalField(StringUtils.join(collect, (String)","));
                }
                StringBuilder builder = new StringBuilder();
                if (StringUtils.isNotBlank((CharSequence)v.getFields1())) {
                    builder.append(v.getFields1()).append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)v.getFields2())) {
                    builder.append(v.getFields2()).append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)v.getFields3())) {
                    builder.append(v.getFields3()).append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)v.getFields4())) {
                    builder.append(v.getFields4()).append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)v.getFields5())) {
                    builder.append(v.getFields5()).append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)builder.toString()) && builder.length() > 0) {
                    builder.deleteCharAt(builder.length() - 1);
                    v.setConcatCustomFields(builder.toString());
                }
            });
        }
        return ruleDtoList;
    }

    @Override
    public void autoFreshInvoiceRemarkRule() {
        if (StrUtil.isBlank((CharSequence)ServiceContext.getContext().getRequestId())) {
            String reqId = RequestId.createReqId();
            MDC.put((String)"yes.req.requestId", (String)reqId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
        }
        try {
            boolean hasNextPage;
            int pageNum = 1;
            do {
                PageInfo pageInfo = ((ExtQueryChainWrapper)((IBillInvoiceRemarkRuleDomain)this.domain).filter().eq((Object)"enable", (Object)0)).page(Integer.valueOf(pageNum), Integer.valueOf(500));
                hasNextPage = pageInfo.isHasNextPage();
                log.info("\u6267\u884c\u53d1\u7968\u89c4\u5219\u72b6\u6001\u5237\u65b0\u603b\u6570={}\uff0c\u5f53\u524d\u9875\u7801={}/{}\uff0c\u9875\u5927\u5c0f={}\uff0c\u5f53\u524d\u9875\u6570\u91cf={}", new Object[]{pageInfo.getTotal(), pageInfo.getPageNum(), pageInfo.getPages(), pageInfo.getPageSize(), pageInfo.getList().size()});
                this.autoFreshInvoiceRemarkRuleEnable(pageInfo.getList());
                ++pageNum;
            } while (hasNextPage);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u7b5b\u9009\u5f00\u7968\u5907\u6ce8\u89c4\u5219\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public InvoiceRemarkAreaDto queryArea(String provinceName, String cityName, String areaName) {
        log.info("\u5f00\u59cb\u5339\u914d\u7701\u5e02\u533a\u540d\u79f0\uff1aprovinceName={}, cityName={}, areaName={}", new Object[]{provinceName, cityName, areaName});
        if (StrUtil.isBlank((CharSequence)provinceName)) {
            log.info("\u7701\u4efd\u540d\u79f0\u4e3a\u7a7a\uff0c\u65e0\u9700\u7ee7\u7eed\u5339\u914d");
            return new InvoiceRemarkAreaDto();
        }
        AreaNameReqDto provinceReq = new AreaNameReqDto();
        provinceReq.setLevelId(Integer.valueOf(0));
        provinceReq.setName(provinceName);
        MatchByNameOrAliasReqDto req = new MatchByNameOrAliasReqDto();
        req.setProvinces((List)Lists.newArrayList((Object[])new AreaNameReqDto[]{provinceReq}));
        if (StrUtil.isNotBlank((CharSequence)cityName)) {
            AreaNameReqDto cityReq = new AreaNameReqDto();
            cityReq.setLevelId(Integer.valueOf(1));
            cityReq.setName(cityName);
            provinceReq.setChildren((List)Lists.newArrayList((Object[])new AreaNameReqDto[]{cityReq}));
            if (StrUtil.isNotBlank((CharSequence)areaName)) {
                AreaNameReqDto areaReq = new AreaNameReqDto();
                areaReq.setLevelId(Integer.valueOf(2));
                areaReq.setName(areaName);
                cityReq.setChildren((List)Lists.newArrayList((Object[])new AreaNameReqDto[]{areaReq}));
            }
        }
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JacksonUtil.toJson((Object)req));
        RestResponse resp = this.areaExtApi.matchByNameOrAlias(req);
        log.info("\u54cd\u5e94\u53c2\u6570\uff1a{}", (Object)JacksonUtil.toJson((Object)resp));
        AreaMatchRespDto match = (AreaMatchRespDto)RestResponseHelper.extractData((RestResponse)resp);
        if (match == null || match.getProvinces() == null || match.getProvinces().isEmpty()) {
            return new InvoiceRemarkAreaDto();
        }
        AreaNodeDto province = (AreaNodeDto)match.getProvinces().get(0);
        AreaNodeDto city = CollectionUtils.isEmpty((Collection)province.getChildren()) ? null : (AreaNodeDto)province.getChildren().get(0);
        AreaNodeDto area = city == null || CollectionUtils.isEmpty((Collection)city.getChildren()) ? null : (AreaNodeDto)city.getChildren().get(0);
        String provinceCode = province.getCode();
        String cityCode = city == null ? null : city.getCode();
        String areaCode = area == null ? null : area.getCode();
        log.info("\u7701\u5e02\u533a\u540d\u79f0\u540d\u79f0\u5339\u914d\u7ed3\u679c\uff1a{}-{}, {}-{}, {}-{}", new Object[]{provinceName, provinceCode, cityName, cityCode, areaName, areaCode});
        InvoiceRemarkAreaDto areaDto = new InvoiceRemarkAreaDto();
        areaDto.setProvince(provinceName);
        areaDto.setProvinceCode(provinceCode);
        areaDto.setCity(cityName);
        areaDto.setCityCode(cityCode);
        areaDto.setCounty(areaName);
        areaDto.setCountyCode(areaCode);
        return areaDto;
    }

    private BillInvoiceRemarkContentDto setContentDto(BillInvoiceRemarkContentDto contentDto, Boolean match, String message, String platformOrderNo, String whether) {
        contentDto.setMatch(match);
        contentDto.setPlatformOrderNo(platformOrderNo);
        contentDto.setMessage(message);
        contentDto.setWhether(whether);
        return contentDto;
    }

    private String getSnCodeWithFallback(String platformOrderNo) {
        try {
            return this.billInfoValidateService.getSnCode(platformOrderNo);
        }
        catch (Exception e) {
            log.error("Failed to get SN code for platform order no: {},{}", (Object)platformOrderNo, (Object)e);
            return null;
        }
    }

    private List<BillInvoiceRemarkRuleDto> queryInvoiceRemarkRules(InvoiceRemarkAreaDto areaDto, String shopCode, DgEnterpriseEo enterpriseEo, String relatedEntityNumber) {
        if (areaDto == null || StringUtils.isBlank((CharSequence)shopCode)) {
            log.warn("\u53c2\u6570\u65e0\u6548\uff1aareaDto={} \u6216 shopCode={}", (Object)areaDto, (Object)shopCode);
            return Collections.emptyList();
        }
        String currentDate = DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd");
        BillInvoiceRemarkRulePageReqDto reqDto = this.createBaseRequest(areaDto, shopCode, currentDate, relatedEntityNumber);
        try {
            List<BillInvoiceRemarkRuleDto> countyRuleDtos;
            if (Objects.nonNull(enterpriseEo) && Objects.nonNull(enterpriseEo) && this.isSameArea(areaDto, enterpriseEo)) {
                reqDto.setRelatedEntityNumber(relatedEntityNumber);
            }
            if (CollectionUtil.isNotEmpty(countyRuleDtos = this.queryAndLog(reqDto, "\u5339\u914d\u7684\u533a\u89c4\u5219"))) {
                return countyRuleDtos;
            }
            reqDto = this.createCityRequest(areaDto, shopCode, currentDate, relatedEntityNumber);
            List<BillInvoiceRemarkRuleDto> cityRuleDtos = this.queryAndLog(reqDto, "\u5339\u914d\u7684\u5e02\u89c4\u5219");
            if (CollectionUtil.isNotEmpty(cityRuleDtos)) {
                return cityRuleDtos;
            }
            reqDto = this.createProvinceRequest(areaDto, shopCode, currentDate, relatedEntityNumber);
            List<BillInvoiceRemarkRuleDto> provinceRuleDtos = this.queryAndLog(reqDto, "\u5339\u914d\u7684\u7701\u89c4\u5219");
            if (CollectionUtil.isNotEmpty(provinceRuleDtos)) {
                return provinceRuleDtos;
            }
            reqDto = this.createNationalRequest(shopCode, currentDate, relatedEntityNumber);
            List<BillInvoiceRemarkRuleDto> nationalRuleDtos = this.queryAndLog(reqDto, "\u5339\u914d\u7684\u5168\u56fd\u89c4\u5219");
            return nationalRuleDtos;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u67e5\u8be2\u53d1\u7968\u5907\u6ce8\u89c4\u5219\u5931\u8d25", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private BillInvoiceRemarkRulePageReqDto createBaseRequest(InvoiceRemarkAreaDto areaDto, String shopCode, String currentDate, String relatedEntityNumber) {
        BillInvoiceRemarkRulePageReqDto reqDto = new BillInvoiceRemarkRulePageReqDto();
        reqDto.setProvinceCode(areaDto.getProvinceCode());
        reqDto.setCityCode(areaDto.getCityCode());
        reqDto.setCountyCode(areaDto.getCountyCode());
        reqDto.setShopCodes(Collections.singletonList(shopCode));
        reqDto.setEnable(Integer.valueOf(0));
        reqDto.setEffectDate(currentDate);
        reqDto.setRelatedEntityNumber(relatedEntityNumber);
        return reqDto;
    }

    private BillInvoiceRemarkRulePageReqDto createProvinceRequest(InvoiceRemarkAreaDto areaDto, String shopCode, String currentDate, String relatedEntityNumber) {
        BillInvoiceRemarkRulePageReqDto reqDto = new BillInvoiceRemarkRulePageReqDto();
        reqDto.setProvinceCode(areaDto.getProvinceCode());
        reqDto.setShopCodes(Collections.singletonList(shopCode));
        reqDto.setEnable(Integer.valueOf(0));
        reqDto.setEffectDate(currentDate);
        reqDto.setRelatedEntityNumber(relatedEntityNumber);
        return reqDto;
    }

    private BillInvoiceRemarkRulePageReqDto createCityRequest(InvoiceRemarkAreaDto areaDto, String shopCode, String currentDate, String relatedEntityNumber) {
        BillInvoiceRemarkRulePageReqDto reqDto = new BillInvoiceRemarkRulePageReqDto();
        reqDto.setProvinceCode(areaDto.getProvinceCode());
        reqDto.setCityCode(areaDto.getCityCode());
        reqDto.setShopCodes(Collections.singletonList(shopCode));
        reqDto.setEnable(Integer.valueOf(0));
        reqDto.setEffectDate(currentDate);
        reqDto.setRelatedEntityNumber(relatedEntityNumber);
        return reqDto;
    }

    private BillInvoiceRemarkRulePageReqDto createNationalRequest(String shopCode, String currentDate, String relatedEntityNumber) {
        BillInvoiceRemarkRulePageReqDto reqDto = new BillInvoiceRemarkRulePageReqDto();
        reqDto.setProvinceCode("000");
        reqDto.setShopCodes(Collections.singletonList(shopCode));
        reqDto.setEnable(Integer.valueOf(0));
        reqDto.setEffectDate(currentDate);
        reqDto.setRelatedEntityNumber(relatedEntityNumber);
        return reqDto;
    }

    private boolean isSameArea(InvoiceRemarkAreaDto areaDto, DgEnterpriseEo enterpriseEo) {
        return areaDto.getProvinceCode().equals(enterpriseEo.getProvinceCode()) && areaDto.getCityCode().equals(enterpriseEo.getCityCode()) && areaDto.getCountyCode().equals(enterpriseEo.getCountyCode());
    }

    private List<BillInvoiceRemarkRuleDto> queryAndLog(BillInvoiceRemarkRulePageReqDto reqDto, String logMessage) {
        List result = ((IBillInvoiceRemarkRuleDomain)this.domain).queryList(reqDto);
        log.info("{}\uff1a{}", (Object)logMessage, (Object)result);
        return result;
    }

    private void appendIfPresent(StringBuilder buffer, Map<String, String> map, String key) {
        if (map != null && map.containsKey(key) && StringUtils.isNotBlank((CharSequence)map.get(key))) {
            buffer.append(map.get(key)).append(",");
        }
    }

    private void appendIfPresent(StringBuilder buffer, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            buffer.append(value).append(",");
        }
    }

    private boolean isBrandOrItemName(String code) {
        return BillInvoiceRemarkConfigEnum.SUBSIDY_CATEGORIES.getCode().equals(code) || BillInvoiceRemarkConfigEnum.BRAND.getCode().equals(code) || BillInvoiceRemarkConfigEnum.ENERGY_EFFICIENCY_SPEC_MODEL.getCode().equals(code);
    }

    private List<BillInvoiceRemarkConfigDto> filterAndSortConfigs(List<BillInvoiceRemarkConfigDto> configs) {
        return configs.stream().filter(x -> !this.isBrandOrItemName(x.getInvoiceRemarkCode())).sorted(Comparator.comparing(BillInvoiceRemarkConfigDto::getSerialNo, Comparator.comparingInt(Integer::parseInt))).collect(Collectors.toList());
    }

    private BillInvoiceRemarkContentDto getBillInvoiceRemarkContentDto(BillInvoiceRemarkRuleDto ruleDto, String platformOrderNo, String snCode, ItemInvoiceDto itemInvoiceDto, DgPerformOrderInfoEo performOrderInfoEo, PlatformOrderIdentityDto orderIdentityDto, BillInfoEo billInfoEo) {
        log.info("\u53d1\u7968\u5907\u6ce8\u89c4\u5219\uff1a{},{},{}", new Object[]{platformOrderNo, JSONObject.toJSONString((Object)ruleDto), JSONObject.toJSONString((Object)billInfoEo)});
        BillInvoiceRemarkContentDto contentDto = new BillInvoiceRemarkContentDto();
        contentDto.setMatch(Boolean.TRUE);
        contentDto.setPlatformOrderNo(platformOrderNo);
        contentDto.setRuleCode(ruleDto.getRuleCode());
        contentDto.setRuleName(ruleDto.getRuleName());
        List configDtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)ruleDto.getOptionalField())) {
            configDtos = JSONObject.parseArray((String)ruleDto.getOptionalField(), BillInvoiceRemarkConfigDto.class);
        }
        log.info("\u53ef\u9009\u5b57\u6bb5\u4fe1\u606f\uff1a{},{},{}", new Object[]{platformOrderNo, JSONObject.toJSONString((Object)configDtos), JSONObject.toJSONString((Object)billInfoEo)});
        HashMap itemProjectNameMap = Maps.newHashMap();
        List<BillInvoiceRemarkConfigDto> configDtoList = this.getInvoiceRemarkConfig(platformOrderNo, configDtos, snCode, itemInvoiceDto, performOrderInfoEo, orderIdentityDto, billInfoEo);
        List<BillInvoiceRemarkConfigDto> failRemarkConfigDtos = configDtoList.stream().filter(x -> "0".equals(x.getHit())).collect(Collectors.toList());
        StringBuilder builder = new StringBuilder();
        if (CollectionUtil.isNotEmpty(failRemarkConfigDtos)) {
            builder.append("\u89c4\u5219\u7f16\u53f7\uff1a").append(ruleDto.getRuleCode()).append(",\u5907\u6ce8\u5b57\u6bb5 ");
            failRemarkConfigDtos.forEach(v -> builder.append(v.getMessage()).append(","));
            builder.append("\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u4fee\u6539");
        }
        configDtoList.forEach(v -> {
            if (StringUtils.isNotBlank((CharSequence)v.getInvoiceRemarkCode()) && this.isBrandOrItemName(v.getInvoiceRemarkCode())) {
                itemProjectNameMap.put(v.getInvoiceRemarkCode(), v.getInvoiceRemarkValue());
            }
        });
        if (CollectionUtil.isNotEmpty(failRemarkConfigDtos)) {
            contentDto.setMatch(Boolean.FALSE);
            contentDto.setPlatformOrderNo(platformOrderNo);
            List collect = failRemarkConfigDtos.stream().map(BillInvoiceRemarkConfigDto::getMessage).collect(Collectors.toList());
            contentDto.setMessage(String.join((CharSequence)",", collect));
            contentDto.setWhether("1");
        }
        StringBuilder itemProjectBuffer = new StringBuilder();
        this.appendIfPresent(itemProjectBuffer, itemProjectNameMap, BillInvoiceRemarkConfigEnum.SUBSIDY_CATEGORIES.getCode());
        this.appendIfPresent(itemProjectBuffer, itemProjectNameMap, BillInvoiceRemarkConfigEnum.BRAND.getCode());
        this.appendIfPresent(itemProjectBuffer, itemProjectNameMap, BillInvoiceRemarkConfigEnum.ENERGY_EFFICIENCY_SPEC_MODEL.getCode());
        if (StringUtils.isNotBlank((CharSequence)itemProjectBuffer.toString())) {
            contentDto.setItemProjectName(itemProjectBuffer.deleteCharAt(itemProjectBuffer.length() - 1).toString());
        }
        log.info("itemProjectName:{},{},{}", new Object[]{platformOrderNo, billInfoEo.getBillFlowNo(), itemProjectBuffer.toString()});
        StringBuilder result = new StringBuilder();
        List<BillInvoiceRemarkConfigDto> filteredConfigs = this.filterAndSortConfigs(configDtoList);
        log.info("\u8fc7\u6ee4\u540e\u7684\u53ef\u9009\u5b57\u6bb5\u4fe1\u606f\uff1a{},{}", (Object)platformOrderNo, (Object)JSONObject.toJSONString(filteredConfigs));
        filteredConfigs.forEach(v -> {
            if (StringUtils.isNotBlank((CharSequence)v.getInvoiceRemarkValue())) {
                result.append(v.getInvoiceRemark() + ": " + v.getInvoiceRemarkValue() + "").append(",");
            }
        });
        if (StringUtils.isNotBlank((CharSequence)ruleDto.getCustomFields())) {
            String specialInvoiceRemark;
            ArrayList<String> customerFields = new ArrayList<String>(Arrays.asList(ruleDto.getCustomFields().split(",")));
            log.info("\u5339\u914d\u540e\u81ea\u5b9a\u4e49\u5b57\u6bb5\u5185\u5bb9\uff1a{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString(customerFields));
            if (CollectionUtil.isNotEmpty(customerFields) && !customerFields.contains(specialInvoiceRemark = itemInvoiceDto.getSpecialInvoiceRemark())) {
                if (StringUtils.isNotBlank((CharSequence)specialInvoiceRemark)) {
                    customerFields.add(specialInvoiceRemark);
                }
                customerFields.forEach(v -> this.appendIfPresent(result, (String)v));
            }
        }
        contentDto.setResult(StringUtils.isNotBlank((CharSequence)result.toString()) ? result.deleteCharAt(result.length() - 1).toString() : null);
        this.setContentDto(contentDto, CollectionUtil.isNotEmpty(failRemarkConfigDtos) ? Boolean.FALSE : Boolean.TRUE, CollectionUtil.isNotEmpty(failRemarkConfigDtos) ? builder.toString() : "\u5339\u914d\u6210\u529f", platformOrderNo, "1");
        log.info("\u5339\u914d\u6210\u529f\u7ed3\u679c\uff1a{},{}", (Object)platformOrderNo, (Object)JSONObject.toJSONString((Object)contentDto));
        return contentDto;
    }

    @Override
    public BillInvoiceRemarkContentDto matchInvoiceRemark(InvoiceRemarkContentReqDto dto, BillInfoEo billInfoEo) {
        BillInvoiceRemarkRuleDto ruleDto;
        Map<String, ShopEo> shopEoMap;
        log.info("\u5339\u914d\u5f00\u7968\u5907\u6ce8\u89c4\u5219\u5165\u53c2\uff1a{},{},{}", new Object[]{dto.getPlatformOrderNo(), dto.getShopCode(), JSONObject.toJSONString((Object)dto), JSONObject.toJSONString((Object)billInfoEo)});
        BillInvoiceRemarkContentDto contentDto = new BillInvoiceRemarkContentDto();
        InvoiceRemarkAreaDto areaDto = new InvoiceRemarkAreaDto();
        if (StringUtils.isBlank((CharSequence)dto.getProvinceCode()) && StringUtils.isBlank((CharSequence)dto.getCityCode()) && StringUtils.isBlank((CharSequence)dto.getCountyCode())) {
            areaDto = this.queryArea(dto.getProvince(), dto.getCity(), dto.getCounty());
        } else {
            areaDto.setProvince(dto.getProvince());
            areaDto.setProvinceCode(dto.getProvinceCode());
            areaDto.setCity(dto.getCity());
            areaDto.setCityCode(dto.getCityCode());
            areaDto.setCounty(dto.getCounty());
            areaDto.setCountyCode(dto.getCountyCode());
        }
        if (Objects.isNull(areaDto)) {
            return this.setContentDto(contentDto, Boolean.FALSE, "\u5339\u914d\u4e0d\u5230\u7701\u5e02\u533a\u7f16\u7801", dto.getPlatformOrderNo(), "0");
        }
        PlatformOrderIdentityDto orderIdentityDto = this.platformOrderIdentityService.getByPlatformOrderNo(dto.getPlatformOrderNo());
        Map orderIdentityDtoMap = BeanUtil.beanToMap((Object)orderIdentityDto);
        log.info("\u5e73\u53f0\u5355\u53f7\u5bf9\u5e94\u5355\u7684\u5b9e\u540d\u5236\u4fe1\u606f\uff1a{},{}", new Object[]{dto.getPlatformOrderNo(), JSONObject.toJSONString((Object)orderIdentityDto), JSONObject.toJSONString((Object)orderIdentityDtoMap)});
        ItemInvoiceDto itemInvoiceDto = this.getItemInvoiceDto(dto.getSkuCode());
        log.info("\u67e5\u8be2\u5546\u54c1\u5f00\u7968\u4fe1\u606f\uff1a{},{}", (Object)dto.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)itemInvoiceDto));
        String snCode = this.getSnCodeWithFallback(dto.getPlatformOrderNo());
        log.info("\u8ba2\u5355\uff1a{}\u5bf9\u5e94SN\u7801\u4fe1\u606f\uff1a{}", (Object)dto.getPlatformOrderNo(), (Object)snCode);
        DgPerformOrderInfoEo performOrderInfoEo = this.getDgPerformOrderInfoEo(dto.getPlatformOrderNo());
        log.info("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f:{},{}", (Object)dto.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)performOrderInfoEo));
        DgEnterpriseEo enterpriseEo = new DgEnterpriseEo();
        if (StringUtils.isNotBlank((CharSequence)performOrderInfoEo.getRelatedEntityNumber())) {
            enterpriseEo = this.getDgEnterpriseEo(performOrderInfoEo.getRelatedEntityNumber());
        }
        log.info("\u9500\u552e\u8ba2\u5355\u5bf9\u5e94\u7684\u9500\u552e\u516c\u53f8\u4fe1\u606f:{},{}", (Object)dto.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)enterpriseEo));
        String relatedEntityNumber = performOrderInfoEo.getRelatedEntityNumber();
        if (StringUtils.isBlank((CharSequence)relatedEntityNumber) && null != (shopEoMap = this.getShop(Arrays.asList(dto.getShopCode())))) {
            ShopEo shopEo = shopEoMap.get(dto.getShopCode());
            relatedEntityNumber = shopEo.getCompanyCode();
        }
        List<BillInvoiceRemarkRuleDto> invoiceRemarkRuleDtos = this.queryInvoiceRemarkRules(areaDto, dto.getShopCode(), enterpriseEo, relatedEntityNumber);
        log.info("\u5e73\u53f0\u8ba2\u5355\uff1a{}\uff0c\u5e97\u94fa\uff1a{}\u5f00\u7968\u5907\u6ce8\u89c4\u5219\u5185\u5bb9\uff1a{}", new Object[]{dto.getPlatformOrderNo(), dto.getShopCode(), JSONObject.toJSONString(invoiceRemarkRuleDtos)});
        if (CollectionUtils.isEmpty(invoiceRemarkRuleDtos)) {
            return this.setContentDto(contentDto, Boolean.FALSE, "\u5339\u914d\u4e0d\u5230\u5f00\u7968\u5907\u6ce8\u89c4\u5219", dto.getPlatformOrderNo(), "0");
        }
        if (invoiceRemarkRuleDtos.size() > 1) {
            ruleDto = new BillInvoiceRemarkRuleDto();
            Iterator<BillInvoiceRemarkRuleDto> iterator = invoiceRemarkRuleDtos.iterator();
            if (iterator.hasNext()) {
                BillInvoiceRemarkRuleDto v = iterator.next();
                ruleDto = StringUtils.isNotBlank((CharSequence)v.getCountyCode()) ? v : (StringUtils.isNotBlank((CharSequence)v.getCityCode()) ? v : invoiceRemarkRuleDtos.get(0));
            }
            log.info("\u4f18\u5148\u7ea7\u6309\u533a\u300b\u5e02\u300b\u7701\u5904\u7406\uff1a{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)ruleDto));
            contentDto = this.getBillInvoiceRemarkContentDto(ruleDto, dto.getPlatformOrderNo(), snCode, itemInvoiceDto, performOrderInfoEo, orderIdentityDto, billInfoEo);
        } else {
            ruleDto = invoiceRemarkRuleDtos.get(0);
            log.info("\u5339\u914d\u5230\u4e00\u6761\u5f00\u7968\u5907\u6ce8\u89c4\u5219\uff1a{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)ruleDto));
            contentDto = this.getBillInvoiceRemarkContentDto(ruleDto, dto.getPlatformOrderNo(), snCode, itemInvoiceDto, performOrderInfoEo, orderIdentityDto, billInfoEo);
        }
        return contentDto;
    }

    private List<BillInvoiceRemarkConfigDto> getInvoiceRemarkConfig(String platformOrderNo, List<BillInvoiceRemarkConfigDto> configDtos, String snCode, ItemInvoiceDto itemInvoiceDto, DgPerformOrderInfoEo performOrderInfoEo, PlatformOrderIdentityDto orderIdentityDto, BillInfoEo billInfoEo) {
        configDtos.forEach(v -> {
            if (StringUtils.isBlank((CharSequence)v.getInvoiceRemarkCode())) {
                log.warn("InvoiceRemarkCode is blank for item: {}", (Object)JSONObject.toJSONString((Object)v));
                return;
            }
            BillInvoiceRemarkConfigEnum configEnum = BillInvoiceRemarkConfigEnum.forCode((String)v.getInvoiceRemarkCode());
            log.info("BillInvoiceRemarkConfigEnum:{}", (Object)JSONObject.toJSONString((Object)configEnum));
            if (configEnum == null) {
                log.warn("Unknown InvoiceRemarkCode: {}", (Object)v.getInvoiceRemarkCode());
                return;
            }
            try {
                this.handleConfigEnum(configEnum, (BillInvoiceRemarkConfigDto)v, itemInvoiceDto, platformOrderNo, snCode, billInfoEo, performOrderInfoEo, orderIdentityDto);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("Error processing configEnum: {}, item: {}", new Object[]{configEnum, JSONObject.toJSONString((Object)v), e});
            }
        });
        return configDtos;
    }

    private void handleConfigEnum(BillInvoiceRemarkConfigEnum configEnum, BillInvoiceRemarkConfigDto v, ItemInvoiceDto itemInvoiceDto, String platformOrderNo, String snCode, BillInfoEo billInfoEo, DgPerformOrderInfoEo performOrderInfoEo, PlatformOrderIdentityDto orderIdentityDto) {
        switch (configEnum) {
            case BRAND: 
            case ITEM_NAME: 
            case ENERGY_EFFICIENCY_SPEC_MODEL: 
            case THIRD_CODE: 
            case ENERGY_EFFICIENCY_RATING: 
            case SUBSIDY_CATEGORIES: 
            case PAY_TYPE_NAME: 
            case PAYMENT_ORDER_NO: 
            case ALIPAY_TRANSACTION_NO: 
            case TMALL_OID: 
            case PHONE: 
            case ID_CARD: 
            case NAME: 
            case ADDRESS_INFO: 
            case INSTALLATION_ADDRESS: {
                String value = this.getValueFromItemInvoiceDto(itemInvoiceDto, orderIdentityDto, configEnum);
                this.setValueAndCheckEmpty(v, value, configEnum);
                break;
            }
            case PLATFORM_ORDER_NO: {
                v.setInvoiceRemarkValue(platformOrderNo);
                v.setHit("1");
                if (!StringUtils.isBlank((CharSequence)platformOrderNo)) break;
                v.setInvoiceRemarkValue(" ");
                v.setHit("0");
                v.setMessage(" " + v.getInvoiceRemark() + " ");
                break;
            }
            case SN_CODE: {
                v.setInvoiceRemarkValue(snCode);
                v.setHit("1");
                if (!StringUtils.isBlank((CharSequence)snCode)) break;
                v.setInvoiceRemarkValue(" ");
                v.setHit("0");
                v.setMessage(" " + v.getInvoiceRemark() + " ");
                break;
            }
            case ITEM_PRICE: {
                log.info("ITEM_PRICE:{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)billInfoEo.getInvoiceAmount());
                v.setInvoiceRemarkValue(Convert.toStr((Object)billInfoEo.getInvoiceAmount()));
                v.setHit("1");
                break;
            }
            case STATE_SUBSIDIES_AMOUNT: {
                if (Objects.nonNull(performOrderInfoEo)) {
                    v.setHit("1");
                    v.setInvoiceRemarkValue(Convert.toStr((Object)(null != performOrderInfoEo.getStateSubsidiesAmount() ? performOrderInfoEo.getStateSubsidiesAmount().setScale(2, RoundingMode.HALF_UP) : Integer.valueOf(0))));
                    break;
                }
                log.warn("performOrderInfoEo is null, cannot set STATE_SUBSIDIES_AMOUNT");
                v.setInvoiceRemarkValue(" ");
                v.setHit("0");
                v.setMessage(" " + v.getInvoiceRemark() + " ");
                break;
            }
            case PURCHASE_TIME: {
                String purchaseTimeValue = DateUtil.getDateFormat((Date)orderIdentityDto.getPurchaseTime(), (String)"yyyy-MM-dd");
                v.setInvoiceRemarkValue(purchaseTimeValue);
                v.setHit("1");
                if (!Objects.isNull(orderIdentityDto.getPurchaseTime())) break;
                v.setInvoiceRemarkValue(" ");
                v.setHit("0");
                v.setMessage(" " + v.getInvoiceRemark() + " ");
                break;
            }
            default: {
                log.warn("Unhandled configEnum: {}, context: {}", (Object)configEnum, (Object)JSONObject.toJSONString((Object)v));
            }
        }
    }

    private String getValueFromItemInvoiceDto(ItemInvoiceDto itemInvoiceDto, PlatformOrderIdentityDto orderIdentityDto, BillInvoiceRemarkConfigEnum configEnum) {
        switch (configEnum) {
            case BRAND: {
                return itemInvoiceDto.getBrand();
            }
            case ITEM_NAME: {
                return itemInvoiceDto.getItemName();
            }
            case ENERGY_EFFICIENCY_SPEC_MODEL: {
                return itemInvoiceDto.getEnergyEfficiencySpecModel();
            }
            case THIRD_CODE: {
                return itemInvoiceDto.getThirdCode();
            }
            case ENERGY_EFFICIENCY_RATING: {
                return itemInvoiceDto.getEnergyEfficiencyRating();
            }
            case SUBSIDY_CATEGORIES: {
                return itemInvoiceDto.getSubsidyCategories();
            }
            case PAY_TYPE_NAME: {
                return orderIdentityDto.getPayTypeName();
            }
            case PAYMENT_ORDER_NO: {
                return orderIdentityDto.getPaymentOrderNo();
            }
            case ALIPAY_TRANSACTION_NO: {
                return orderIdentityDto.getAlipayTransactionNo();
            }
            case TMALL_OID: {
                return orderIdentityDto.getTmallOid();
            }
            case PHONE: {
                return orderIdentityDto.getPhone();
            }
            case ID_CARD: {
                return orderIdentityDto.getIdCard();
            }
            case NAME: {
                return orderIdentityDto.getName();
            }
            case ADDRESS_INFO: {
                return orderIdentityDto.getInstallationAddress();
            }
            case INSTALLATION_ADDRESS: {
                return orderIdentityDto.getAddressInfo();
            }
        }
        return null;
    }

    private void setValueAndCheckEmpty(BillInvoiceRemarkConfigDto v, String value, BillInvoiceRemarkConfigEnum configEnum) {
        v.setInvoiceRemarkValue(value);
        v.setHit("1");
        if (StringUtils.isBlank((CharSequence)value)) {
            v.setInvoiceRemarkValue(" ");
            v.setHit("0");
            v.setMessage(" " + v.getInvoiceRemark() + " ");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void autoFreshInvoiceRemarkRuleEnable(List<BillInvoiceRemarkRuleEo> remarkRuleEos) {
        remarkRuleEos.forEach(v -> {
            Date startTime = DateUtil.parseDate((String)(v.getEffectBeginTime() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            Date endTime = DateUtil.parseDate((String)(v.getEffectEndTime() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
            Date nowTime = new Date();
            if (nowTime.before(startTime) || nowTime.after(endTime)) {
                BillInvoiceRemarkRuleEo remarkRuleEo = new BillInvoiceRemarkRuleEo();
                remarkRuleEo.setId(v.getId());
                remarkRuleEo.setEnable(Integer.valueOf(1));
                ((IBillInvoiceRemarkRuleDomain)this.domain).updateSelective((BaseEo)remarkRuleEo);
            }
        });
    }

    private BigDecimal getStateSubsidiesAmount(String platformOrderNo) {
        BigDecimal stateSubsidiesAmount = BigDecimal.ZERO;
        List performOrderInfoEos = ((ExtQueryChainWrapper)this.performOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).list();
        if (CollectionUtil.isNotEmpty((Collection)performOrderInfoEos)) {
            stateSubsidiesAmount = ((DgPerformOrderInfoEo)performOrderInfoEos.get(0)).getStateSubsidiesAmount();
        }
        return stateSubsidiesAmount;
    }

    private ItemInvoiceDto getItemInvoiceDto(String skuCode) {
        List itemInvoiceEos = ((ExtQueryChainWrapper)this.itemInvoiceDas.filter().eq((Object)"item_code", (Object)skuCode)).list();
        if (CollectionUtil.isNotEmpty((Collection)itemInvoiceEos)) {
            ItemInvoiceEo itemInvoiceEo = (ItemInvoiceEo)itemInvoiceEos.get(0);
            ItemInvoiceDto itemInvoiceDto = new ItemInvoiceDto();
            CubeBeanUtils.copyProperties((Object)itemInvoiceDto, (Object)itemInvoiceEo, (String[])new String[0]);
            return itemInvoiceDto;
        }
        return new ItemInvoiceDto();
    }

    private DgPerformOrderInfoEo getDgPerformOrderInfoEo(String platformOrderNo) {
        List performOrderInfoEos = ((ExtQueryChainWrapper)this.performOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).list();
        if (CollectionUtil.isNotEmpty((Collection)performOrderInfoEos)) {
            return (DgPerformOrderInfoEo)performOrderInfoEos.get(0);
        }
        return new DgPerformOrderInfoEo();
    }

    private DgPerformOrderAddrEo getDgPerformOrderAddrEo(Long orderId) {
        List performOrderAddrEos = ((ExtQueryChainWrapper)this.performOrderAddrDomain.filter().eq((Object)"order_id", (Object)orderId)).list();
        if (CollectionUtil.isNotEmpty((Collection)performOrderAddrEos)) {
            return (DgPerformOrderAddrEo)performOrderAddrEos.get(0);
        }
        return new DgPerformOrderAddrEo();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<BillInvoiceRemarkRuleDto> invoiceRemarkRuleDtos) {
        log.info("BillInvoiceRemarkRuleServiceImpl.batchSave start, param: {}", (Object)JSONObject.toJSONString(invoiceRemarkRuleDtos));
        AssertUtils.notEmpty(invoiceRemarkRuleDtos, (String)"\u6279\u91cf\u63d2\u5165\u5f00\u7968\u5907\u6ce8\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList shopCodes = Lists.newArrayList();
        invoiceRemarkRuleDtos.forEach(i -> {
            List remarkRuleShopDtos = i.getBillInvoiceRemarkRuleShopDtos();
            shopCodes.addAll(remarkRuleShopDtos.stream().map(BillInvoiceRemarkRuleShopDto::getShopCode).distinct().collect(Collectors.toList()));
        });
        Map<Object, Object> shopEoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)shopCodes)) {
            shopEoMap = this.getShop(shopCodes);
        }
        ArrayList remarkRuleEoList = Lists.newArrayList();
        ArrayList billInvoiceRemarkRuleShopEos = Lists.newArrayList();
        Map<Object, Object> finalShopEoMap = shopEoMap;
        invoiceRemarkRuleDtos.forEach(v -> {
            BillInvoiceRemarkRuleEo billInvoiceRemarkRuleEo = new BillInvoiceRemarkRuleEo();
            CubeBeanUtils.copyProperties((Object)billInvoiceRemarkRuleEo, (Object)v, (String[])new String[0]);
            billInvoiceRemarkRuleEo.setEnable(Integer.valueOf(0));
            billInvoiceRemarkRuleEo.setProvince(v.getProvince());
            billInvoiceRemarkRuleEo.setProvinceCode(v.getProvinceCode());
            billInvoiceRemarkRuleEo.setCity(v.getCity());
            billInvoiceRemarkRuleEo.setCityCode(v.getCityCode());
            billInvoiceRemarkRuleEo.setCounty(v.getCounty());
            billInvoiceRemarkRuleEo.setCountyCode(v.getCountyCode());
            billInvoiceRemarkRuleEo.setCustomFields(v.getCustomFields());
            IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.INVOICE_REMARK_RULE.getCode());
            String ruleCode = generateCodeService.getCode("BZGZ");
            billInvoiceRemarkRuleEo.setRuleCode(ruleCode);
            v.getBillInvoiceRemarkRuleShopDtos().forEach(i -> {
                BillInvoiceRemarkRuleShopEo remarkRuleShopEo = new BillInvoiceRemarkRuleShopEo();
                CubeBeanUtils.copyProperties((Object)remarkRuleShopEo, (Object)i, (String[])new String[0]);
                remarkRuleShopEo.setRuleCode(ruleCode);
                if (finalShopEoMap.containsKey(i.getShopCode())) {
                    ShopEo shopEo = (ShopEo)finalShopEoMap.get(i.getShopCode());
                    remarkRuleShopEo.setShopName(shopEo.getName());
                }
                billInvoiceRemarkRuleShopEos.add(remarkRuleShopEo);
            });
            remarkRuleEoList.add(billInvoiceRemarkRuleEo);
        });
        if (CollectionUtil.isNotEmpty((Collection)remarkRuleEoList)) {
            ((IBillInvoiceRemarkRuleDomain)this.domain).insertBatch((List)remarkRuleEoList);
            this.shopDomain.insertBatch((List)billInvoiceRemarkRuleShopEos);
        }
    }

    private Map<String, ShopEo> getShop(List<String> shopCodes) {
        if (shopCodes == null || shopCodes.isEmpty()) {
            return Maps.newHashMap();
        }
        List collect = Lists.partition(new ArrayList<String>(shopCodes), (int)500).stream().flatMap(v -> {
            List list = this.shopMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ShopEo.class).in(ShopEo::getCode, (Collection)v)).eq(BaseEo::getDr, (Object)0));
            return list.stream();
        }).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(collect)) {
            return Maps.newHashMap();
        }
        return collect.stream().collect(Collectors.toMap(ShopEo::getCode, Function.identity(), (v1, v2) -> v1));
    }

    private DgEnterpriseEo getDgEnterpriseEo(String relatedEntityNumber) {
        List dgEnterpriseEos;
        if (StringUtils.isNotBlank((CharSequence)relatedEntityNumber) && CollectionUtil.isNotEmpty((Collection)(dgEnterpriseEos = ((ExtQueryChainWrapper)this.enterpriseDas.filter().eq((Object)"code", (Object)relatedEntityNumber)).list()))) {
            return (DgEnterpriseEo)dgEnterpriseEos.get(0);
        }
        return new DgEnterpriseEo();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateInvoiceRemark(List<BillInvoiceRemarkDto> billInvoiceRemarkDtos, String remarkImportPerson) {
        log.info("BillInvoiceRemarkRuleServiceImpl.batchUpdateInvoiceRemark start, param: {},{}", (Object)billInvoiceRemarkDtos.size(), (Object)remarkImportPerson);
        if (CollectionUtil.isEmpty(billInvoiceRemarkDtos)) {
            log.info("\u66f4\u65b0\u53d1\u7968\u5907\u6ce8\u96c6\u5408\u4e3a\u7a7a");
            return;
        }
        List billFlowNos = billInvoiceRemarkDtos.stream().map(BillInvoiceRemarkDto::getBillFlowNo).distinct().collect(Collectors.toList());
        List billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDomain.filter().in((Object)"bill_flow_no", billFlowNos)).list();
        Map billInfoEoMap = billInfoEoList.stream().collect(Collectors.toMap(BillInfoEo::getBillFlowNo, Function.identity(), (v1, v2) -> v1));
        ArrayList list = Lists.newArrayList();
        billInvoiceRemarkDtos.forEach(v -> {
            if (billInfoEoMap.containsKey(v.getBillFlowNo())) {
                BillInfoEo billInfoEo = (BillInfoEo)billInfoEoMap.get(v.getBillFlowNo());
                BillInfoEo infoEo = new BillInfoEo();
                infoEo.setId(billInfoEo.getId());
                infoEo.setInvoiceRemarks(v.getInvoiceRemarks());
                infoEo.setRemarkImportPerson(remarkImportPerson);
                list.add(infoEo);
            }
        });
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            ((IBillInvoiceRemarkRuleDomain)this.domain).batchUpdateInvoiceRemark((List)list);
        }
    }
}

