/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.convert.entity.ChargeAccountInfoConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBusinessTypeDas;
import com.yunxi.dg.base.center.finance.dao.das.IChargeAccountInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.IChargeAccountTypeDas;
import com.yunxi.dg.base.center.finance.dao.vo.ChargeAccountInfoVo;
import com.yunxi.dg.base.center.finance.dao.vo.ChargeAccountReqVo;
import com.yunxi.dg.base.center.finance.domain.entity.IChargeAccountInfoDomain;
import com.yunxi.dg.base.center.finance.dto.entity.ChargeAccountInfoDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.FinanceExceptionCode;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepOrderInterfaceEnum;
import com.yunxi.dg.base.center.finance.dto.enums.NodeTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.ChargeAccountInfoReqDto;
import com.yunxi.dg.base.center.finance.dto.request.ChargeAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepAccountReqDto;
import com.yunxi.dg.base.center.finance.dto.response.AccountingTypeRespDto;
import com.yunxi.dg.base.center.finance.dto.response.ChargeAccountInfoRespDto;
import com.yunxi.dg.base.center.finance.eo.BusinessTypeEo;
import com.yunxi.dg.base.center.finance.eo.ChargeAccountInfoEo;
import com.yunxi.dg.base.center.finance.eo.ChargeAccountTypeEo;
import com.yunxi.dg.base.center.finance.service.entity.IAccountingTypeService;
import com.yunxi.dg.base.center.finance.service.entity.IChargeAccountInfoService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ChargeAccountInfoServiceImpl
extends BaseServiceImpl<ChargeAccountInfoDto, ChargeAccountInfoEo, IChargeAccountInfoDomain>
implements IChargeAccountInfoService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IChargeAccountInfoDas chargeAccountInfoDas;
    @Resource
    private IChargeAccountInfoDomain chargeAccountInfoDomain;
    @Resource
    private IChargeAccountTypeDas chargeAccountTypeDas;
    @Resource
    private IBusinessTypeDas businessTypeDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IAccountingTypeService accountingTypeService;

    public ChargeAccountInfoServiceImpl(IChargeAccountInfoDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ChargeAccountInfoDto, ChargeAccountInfoEo> converter() {
        return ChargeAccountInfoConverter.INSTANCE;
    }

    @Override
    public Long addChargeAccountInfo(ChargeAccountInfoReqDto addReqDto) {
        ChargeAccountInfoEo chargeAccountInfoEo = new ChargeAccountInfoEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)chargeAccountInfoEo);
        this.chargeAccountInfoDas.insert((BaseEo)chargeAccountInfoEo);
        this.cacheService.delCache(this.getChargeAccountNameKey());
        return chargeAccountInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyChargeAccountInfo(ChargeAccountReqDto chargeAccountReqDto) {
        if (Objects.isNull(chargeAccountReqDto.getId())) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List ids = Arrays.asList(chargeAccountReqDto.getId().split(",")).stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
        List chargeAccountInfoEos = ((ExtQueryChainWrapper)this.chargeAccountInfoDas.filter().in((Object)"id", ids)).list();
        if (CollectionUtils.isEmpty((Collection)chargeAccountInfoEos)) {
            throw new BizException("\u8bb0\u8d26\u7c7b\u578b\u8bbe\u7f6e\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        chargeAccountInfoEos.forEach(v -> this.chargeAccountInfoDas.delete((BaseEo)v));
        this.cacheService.delCache(this.getChargeAccountNameKey());
        this.addChargeAccount(chargeAccountReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeChargeAccountInfo(String ids) {
        List chargeIds = Arrays.asList(ids.split(",")).stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
        List accountInfoEos = ((ExtQueryChainWrapper)this.chargeAccountInfoDas.filter().in((Object)"id", chargeIds)).list();
        if (CollectionUtils.isEmpty((Collection)accountInfoEos)) {
            throw new BizException("\u9700\u8981\u5220\u9664\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728!");
        }
        this.cacheService.delCache(this.getChargeAccountNameKey());
        List<Long> list = Arrays.asList(ids.split(",")).stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
        list.forEach(v -> this.chargeAccountInfoDas.logicDeleteById(v));
    }

    @Override
    public ChargeAccountInfoRespDto queryById(Long id) {
        ChargeAccountInfoEo chargeAccountInfoEo = (ChargeAccountInfoEo)this.chargeAccountInfoDas.selectByPrimaryKey(id);
        ChargeAccountInfoRespDto chargeAccountInfoRespDto = new ChargeAccountInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)chargeAccountInfoEo, (BaseVo)chargeAccountInfoRespDto);
        return chargeAccountInfoRespDto;
    }

    @Override
    public PageInfo<ChargeAccountInfoRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ChargeAccountInfoReqDto chargeAccountInfoReqDto = (ChargeAccountInfoReqDto)JSON.parseObject((String)filter, ChargeAccountInfoReqDto.class);
        ChargeAccountInfoEo chargeAccountInfoEo = new ChargeAccountInfoEo();
        DtoHelper.dto2Eo((BaseVo)chargeAccountInfoReqDto, (BaseEo)chargeAccountInfoEo);
        PageInfo eoPageInfo = this.chargeAccountInfoDomain.selectPage((BaseEo)chargeAccountInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ChargeAccountInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ChargeAccountInfoRespDto> queryPage(ChargeAccountReqDto chargeAccountReqDto, Integer pageNum, Integer pageSize) {
        ChargeAccountReqVo reqVo = new ChargeAccountReqVo();
        CubeBeanUtils.copyProperties((Object)reqVo, (Object)chargeAccountReqDto, (String[])new String[0]);
        PageInfo accountInfoVoPageInfo = this.chargeAccountInfoDas.queryPage(reqVo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)accountInfoVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (!CollectionUtils.isEmpty((Collection)accountInfoVoPageInfo.getList())) {
            List businessTypes = accountInfoVoPageInfo.getList().stream().filter(s -> Objects.nonNull(s.getBusinessType())).map(ChargeAccountInfoVo::getBusinessType).collect(Collectors.toList());
            List businessTypeEos = Lists.newArrayList();
            Map businessTypeEoMap = null;
            if (!CollectionUtils.isEmpty(businessTypes)) {
                businessTypeEos = ((ExtQueryChainWrapper)this.businessTypeDas.filter().in((Object)"business_type", businessTypes)).list();
                businessTypeEoMap = businessTypeEos.stream().collect(Collectors.toMap(BusinessTypeEo::getBusinessType, Function.identity(), (k1, k2) -> k1));
            }
            Map finalBusinessTypeEoMap = businessTypeEoMap;
            List accountInfoRespDtos = accountInfoVoPageInfo.getList().stream().map(v -> {
                ChargeAccountInfoRespDto respDto = new ChargeAccountInfoRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)v, (String[])new String[0]);
                if (!Objects.equals(BillTypeEnum.TRANSFERS.getCode(), v.getOrderType())) {
                    List<String> codes = Arrays.asList(v.getSiteCodes().split(","));
                    ArrayList siteRespDtos = Lists.newArrayList();
                    respDto.setSiteCodes(codes);
                    respDto.setSiteRespDtos((List)siteRespDtos);
                }
                if (Objects.nonNull(v.getBusinessType()) && null != finalBusinessTypeEoMap && null != finalBusinessTypeEoMap.get(v.getBusinessType())) {
                    respDto.setBusinessTypeName(((BusinessTypeEo)finalBusinessTypeEoMap.get(v.getBusinessType())).getBusinessName());
                }
                return respDto;
            }).collect(Collectors.toList());
            dtoPageInfo.setList(accountInfoRespDtos);
        }
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ChargeAccountInfoRespDto> page(KeepAccountReqDto keepAccountReqDto, Integer pageNum, Integer pageSize) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.chargeAccountInfoDas.filter().orderByDesc((Object)"update_time");
        if (Objects.nonNull(keepAccountReqDto) && Objects.nonNull(keepAccountReqDto.getBusinessName())) {
            sqlFilters.like((Object)"business_name", (Object)keepAccountReqDto.getBusinessName());
        }
        if (Objects.nonNull(keepAccountReqDto) && Objects.nonNull(keepAccountReqDto.getBusinessType())) {
            sqlFilters.like((Object)"business_type", (Object)keepAccountReqDto.getBusinessType());
        }
        if (Objects.nonNull(keepAccountReqDto) && Objects.nonNull(keepAccountReqDto.getChargeAccountName())) {
            sqlFilters.like((Object)"charge_account_name", (Object)keepAccountReqDto.getChargeAccountName());
        }
        if (Objects.nonNull(keepAccountReqDto) && Objects.nonNull(keepAccountReqDto.getBillAccountName())) {
            sqlFilters.like((Object)"bill_account_name", (Object)keepAccountReqDto.getBillAccountName());
        }
        if (Objects.nonNull(keepAccountReqDto) && Objects.nonNull(keepAccountReqDto.getSlaveBillAccountName())) {
            sqlFilters.like((Object)"slave_bill_account_name", (Object)keepAccountReqDto.getSlaveBillAccountName());
        }
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ChargeAccountInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addChargeAccount(ChargeAccountReqDto chargeAccountReqDto) {
        List chargeAccountInfoEos;
        ChargeAccountTypeEo chargeAccountTypeEo;
        this.logger.info("\u65b0\u589e\u8bb0\u8d26\u7c7b\u578b\u8bbe\u7f6e\u8868\u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)chargeAccountReqDto));
        this.validate(chargeAccountReqDto);
        List<Object> siteCodes = new ArrayList();
        if (!Objects.equals(BillTypeEnum.TRANSFERS.getCode(), chargeAccountReqDto.getOrderType())) {
            siteCodes = Arrays.asList(chargeAccountReqDto.getSiteCodes().split(","));
        }
        if (Objects.isNull(chargeAccountTypeEo = (ChargeAccountTypeEo)((ExtQueryChainWrapper)this.chargeAccountTypeDas.filter().eq((Object)"charge_account_code", (Object)chargeAccountReqDto.getChargeAccountCode())).one())) {
            throw new BizException("\u8bb0\u8d26\u7c7b\u578b\u4e0d\u5b58\u5728!");
        }
        if (Objects.equals(BillTypeEnum.SALE_LIST.getCode(), chargeAccountReqDto.getOrderType()) || Objects.equals(BillTypeEnum.RETURN_BASE.getCode(), chargeAccountReqDto.getOrderType()) || Objects.equals(BillTypeEnum.EXCHANGE.getCode(), chargeAccountReqDto.getOrderType()) ? !CollectionUtils.isEmpty((Collection)(chargeAccountInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.chargeAccountInfoDas.filter().in(!siteCodes.isEmpty(), (Object)"site_code", siteCodes)).eq((Object)"order_type", (Object)chargeAccountReqDto.getOrderType())).eq((Object)"business_type", (Object)chargeAccountReqDto.getBusinessType())).eq((Object)"charge_account_code", (Object)chargeAccountReqDto.getChargeAccountCode())).list())) : (Objects.equals(BillTypeEnum.DELIVERY_REFUND_ONLY.getCode(), chargeAccountReqDto.getOrderType()) || Objects.equals(BillTypeEnum.FREIGHT_BOOKKEEPING.getCode(), chargeAccountReqDto.getOrderType()) ? !CollectionUtils.isEmpty((Collection)(chargeAccountInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.chargeAccountInfoDas.filter().in(!siteCodes.isEmpty(), (Object)"site_code", siteCodes)).eq((Object)"order_type", (Object)chargeAccountReqDto.getOrderType())).eq((Object)"charge_account_code", (Object)chargeAccountReqDto.getChargeAccountCode())).list())) : Objects.equals(BillTypeEnum.TRANSFERS.getCode(), chargeAccountReqDto.getOrderType()) && !CollectionUtils.isEmpty((Collection)(chargeAccountInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.chargeAccountInfoDas.filter().eq((Object)"order_type", (Object)chargeAccountReqDto.getOrderType())).eq((Object)"business_type", (Object)chargeAccountReqDto.getBusinessType())).eq((Object)"category_storage", (Object)chargeAccountReqDto.getCategoryStorage())).eq((Object)"charge_account_code", (Object)chargeAccountReqDto.getChargeAccountCode())).list())))) {
            throw new BizException("\u8be5" + BillTypeEnum.getDesc((String)chargeAccountReqDto.getOrderType()) + "\u8bb0\u8d26\u7c7b\u578b\u5df2\u88ab\u8bbe\u7f6e\u8fc7\uff0c\u65e0\u6cd5\u518d\u8fdb\u884c\u8bbe\u7f6e");
        }
        if (Objects.equals(BillTypeEnum.TRANSFERS.getCode(), chargeAccountReqDto.getOrderType())) {
            ChargeAccountInfoEo accountTypeEo = new ChargeAccountInfoEo();
            accountTypeEo.setOrderType(chargeAccountReqDto.getOrderType());
            accountTypeEo.setOrderName(BillTypeEnum.getDesc((String)chargeAccountReqDto.getOrderType()));
            accountTypeEo.setBusinessType(chargeAccountReqDto.getBusinessType());
            accountTypeEo.setChargeAccountCode(chargeAccountReqDto.getChargeAccountCode());
            accountTypeEo.setChargeAccountName(chargeAccountTypeEo.getChargeAccountName());
            accountTypeEo.setCategoryStorage(chargeAccountReqDto.getCategoryStorage());
            this.chargeAccountInfoDas.insert((BaseEo)accountTypeEo);
        } else {
            chargeAccountInfoEos = Lists.newArrayListWithCapacity((int)siteCodes.size());
            siteCodes.forEach(v -> {
                ChargeAccountInfoEo accountTypeEo = new ChargeAccountInfoEo();
                accountTypeEo.setOrderType(chargeAccountReqDto.getOrderType());
                accountTypeEo.setOrderName(BillTypeEnum.getDesc((String)chargeAccountReqDto.getOrderType()));
                accountTypeEo.setSiteCode(v);
                accountTypeEo.setBusinessType(chargeAccountReqDto.getBusinessType());
                accountTypeEo.setChargeAccountCode(chargeAccountReqDto.getChargeAccountCode());
                accountTypeEo.setChargeAccountName(chargeAccountTypeEo.getChargeAccountName());
                accountTypeEo.setInvoice(Integer.valueOf(Objects.nonNull(chargeAccountTypeEo.getInvoice()) ? chargeAccountTypeEo.getInvoice() : Integer.parseInt(InvoiceTypeEnum.NO.getCode())));
                accountTypeEo.setCategoryStorage(chargeAccountReqDto.getCategoryStorage());
                accountTypeEo.setOrderInterface(KeepOrderInterfaceEnum.getDesc((String)chargeAccountTypeEo.getChargeAccountName()));
                accountTypeEo.setBillingInterface(chargeAccountTypeEo.getInvoice() == 1 ? "Z_YX_BILLING" : null);
                chargeAccountInfoEos.add(accountTypeEo);
            });
            this.chargeAccountInfoDas.insertBatch(chargeAccountInfoEos);
        }
        this.cacheService.delCache(this.getChargeAccountNameKey());
    }

    private void validate(ChargeAccountReqDto chargeAccountReqDto) {
        if (Objects.isNull(chargeAccountReqDto.getOrderType())) {
            throw new BizException("\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!Objects.equals(chargeAccountReqDto.getOrderType(), BillTypeEnum.TRANSFERS.getCode()) && Objects.isNull(chargeAccountReqDto.getSiteCodes())) {
            throw new BizException("\u7ad9\u70b9\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!Objects.equals(chargeAccountReqDto.getOrderType(), BillTypeEnum.DELIVERY_REFUND_ONLY.getCode()) && !Objects.equals(chargeAccountReqDto.getOrderType(), BillTypeEnum.FREIGHT_BOOKKEEPING.getCode()) && Objects.isNull(chargeAccountReqDto.getBusinessType())) {
            throw new BizException("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(chargeAccountReqDto.getChargeAccountCode())) {
            throw new BizException("\u8bb0\u8d26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    @Override
    public ChargeAccountInfoRespDto detail(ChargeAccountReqDto chargeAccountReqDto) {
        ChargeAccountInfoRespDto chargeAccountInfoRespDto = new ChargeAccountInfoRespDto();
        if (Objects.isNull(chargeAccountReqDto.getId())) {
            throw new BizException("\u8bf7\u6c42\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List ids = Arrays.asList(chargeAccountReqDto.getId().split(",")).stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
        List chargeAccountInfoEos = ((ExtQueryChainWrapper)this.chargeAccountInfoDas.filter().in((Object)"id", ids)).list();
        if (CollectionUtils.isEmpty((Collection)chargeAccountInfoEos)) {
            throw new BizException("\u8bb0\u8d26\u7c7b\u578b\u8bbe\u7f6e\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (!Objects.isNull(((ChargeAccountInfoEo)chargeAccountInfoEos.get(0)).getBusinessType())) {
            BusinessTypeEo businessTypeEo = (BusinessTypeEo)((ExtQueryChainWrapper)this.businessTypeDas.filter().eq((Object)"business_type", (Object)((ChargeAccountInfoEo)chargeAccountInfoEos.get(0)).getBusinessType())).one();
            chargeAccountInfoRespDto.setBusinessType(((ChargeAccountInfoEo)chargeAccountInfoEos.get(0)).getBusinessType());
            chargeAccountInfoRespDto.setBusinessTypeName(businessTypeEo.getBusinessName());
        }
        if (!Objects.equals(BillTypeEnum.TRANSFERS.getCode(), ((ChargeAccountInfoEo)chargeAccountInfoEos.get(0)).getOrderType())) {
            List codes = chargeAccountInfoEos.stream().map(v -> v.getSiteCode()).collect(Collectors.toList());
            ArrayList siteRespDtos = Lists.newArrayList();
            chargeAccountInfoRespDto.setSiteCodes(codes);
            chargeAccountInfoRespDto.setSiteRespDtos((List)siteRespDtos);
        }
        chargeAccountInfoRespDto.setOrderType(((ChargeAccountInfoEo)chargeAccountInfoEos.get(0)).getOrderType());
        chargeAccountInfoRespDto.setOrderName(BillTypeEnum.getDesc((String)((ChargeAccountInfoEo)chargeAccountInfoEos.get(0)).getOrderType()));
        chargeAccountInfoRespDto.setInvoice(((ChargeAccountInfoEo)chargeAccountInfoEos.get(0)).getInvoice());
        chargeAccountInfoRespDto.setCategoryStorage(((ChargeAccountInfoEo)chargeAccountInfoEos.get(0)).getCategoryStorage());
        chargeAccountInfoRespDto.setOrderInterface(((ChargeAccountInfoEo)chargeAccountInfoEos.get(0)).getOrderInterface());
        chargeAccountInfoRespDto.setBillingInterface(((ChargeAccountInfoEo)chargeAccountInfoEos.get(0)).getBillingInterface());
        return chargeAccountInfoRespDto;
    }

    @Override
    public List<ChargeAccountInfoRespDto> queryChargeAccountInfoList(ChargeAccountInfoReqDto accountInfoReqDto) {
        ArrayList<ChargeAccountInfoRespDto> dtoList = new ArrayList<ChargeAccountInfoRespDto>();
        ChargeAccountInfoEo chargeAccountInfoEo = new ChargeAccountInfoEo();
        DtoHelper.dto2Eo((BaseVo)accountInfoReqDto, (BaseEo)chargeAccountInfoEo);
        List chargeAccountInfoEos = this.chargeAccountInfoDomain.selectList((BaseEo)chargeAccountInfoEo);
        CubeBeanUtils.copyCollection(dtoList, (Collection)chargeAccountInfoEos, ChargeAccountInfoRespDto.class);
        return dtoList;
    }

    @Override
    public List<String> queryChargeAccountNameList() {
        List cacheVal = (List)this.cacheService.getCache(this.getChargeAccountNameKey(), (TypeReference)new TypeReference<List<String>>(){});
        if (CollectionUtil.isNotEmpty((Collection)cacheVal)) {
            return cacheVal;
        }
        ChargeAccountInfoEo chargeAccountInfoEo = new ChargeAccountInfoEo();
        List chargeAccountInfoEos = this.chargeAccountInfoDomain.selectList((BaseEo)chargeAccountInfoEo);
        if (CollectionUtil.isNotEmpty((Collection)chargeAccountInfoEos)) {
            List<String> businessTypeList = chargeAccountInfoEos.stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getChargeAccountName())).map(ChargeAccountInfoEo::getChargeAccountName).collect(Collectors.toList());
            this.cacheService.setCache(this.getChargeAccountNameKey(), businessTypeList);
            return businessTypeList;
        }
        this.cacheService.setCache(this.getChargeAccountNameKey(), (Object)Lists.newArrayList(), 60);
        return Lists.newArrayList();
    }

    private String getChargeAccountNameKey() {
        return "chargeAccountNameKey";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addKeepAccount(KeepAccountReqDto keepAccountReqDto) {
        Optional.ofNullable(keepAccountReqDto).orElseThrow(() -> {
            throw new BizException("\u53c2\u6570\u6709\u8bef");
        });
        this.validateKeep(keepAccountReqDto);
        ChargeAccountInfoEo chargeAccountEo = new ChargeAccountInfoEo();
        chargeAccountEo.setBusinessName(keepAccountReqDto.getBusinessName());
        chargeAccountEo.setBusinessType(keepAccountReqDto.getBusinessType());
        chargeAccountEo.setChargeAccountName(keepAccountReqDto.getChargeAccountName());
        chargeAccountEo.setBillAccountName(keepAccountReqDto.getBillAccountName());
        chargeAccountEo.setSlaveBillAccountName(keepAccountReqDto.getSlaveBillAccountName());
        AccountingTypeRespDto accountingTypeRespDto = this.accountingTypeService.getAccountingInterface(keepAccountReqDto.getChargeAccountName(), VoucherTypeEnum.DELIVERY.getCode());
        AccountingTypeRespDto invoiceAccountingTypeRespDto = this.accountingTypeService.getAccountingInterface(keepAccountReqDto.getBillAccountName(), VoucherTypeEnum.INVOICE.getCode());
        chargeAccountEo.setOrderInterface(null != accountingTypeRespDto ? accountingTypeRespDto.getOrderInterface() : null);
        chargeAccountEo.setPostDelivery(null != accountingTypeRespDto ? accountingTypeRespDto.getPostDelivery() : null);
        chargeAccountEo.setBillingInterface(null != invoiceAccountingTypeRespDto ? invoiceAccountingTypeRespDto.getBillingInterface() : null);
        if (Objects.nonNull(keepAccountReqDto.getId())) {
            ChargeAccountInfoEo chargeAccountInfoEo = (ChargeAccountInfoEo)((ExtQueryChainWrapper)this.chargeAccountInfoDas.filter().eq((Object)"id", (Object)keepAccountReqDto.getId())).one();
            if (Objects.isNull(chargeAccountInfoEo)) {
                throw new BizException("\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            chargeAccountEo.setId(chargeAccountInfoEo.getId());
            this.chargeAccountInfoDas.updateSelective((BaseEo)chargeAccountEo);
        } else {
            ChargeAccountInfoEo chargeAccountInfoEo = (ChargeAccountInfoEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.chargeAccountInfoDas.filter().eq((Object)"business_name", (Object)keepAccountReqDto.getBusinessName())).eq((Object)"business_type", (Object)keepAccountReqDto.getBusinessType())).one();
            if (Objects.nonNull(chargeAccountInfoEo)) {
                throw new BizException("\u8bb0\u8d26\u7c7b\u578b\u8bbe\u7f6e\u5df2\u5b58\u5728\uff01");
            }
            this.chargeAccountInfoDas.insert((BaseEo)chargeAccountEo);
        }
        return chargeAccountEo.getId();
    }

    private void validateKeep(KeepAccountReqDto keepAccountReqDto) {
        Assert.notNull((Object)keepAccountReqDto.getBusinessName(), (String)"\u4e1a\u52a1\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((keepAccountReqDto.getBusinessName().length() < 51 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7c7b\u578b\u540d\u79f0\u9650\u52361-50\u5b57\u7b26");
        Assert.notNull((Object)keepAccountReqDto.getBusinessType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((keepAccountReqDto.getBusinessType().length() < 51 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7c7b\u578b\u7f16\u7801\u9650\u52361-50\u5b57\u7b26");
        Assert.notNull((Object)keepAccountReqDto.getChargeAccountName(), (String)"\u8ba2\u5355\u8bb0\u8d26\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((keepAccountReqDto.getChargeAccountName().length() < 51 ? 1 : 0) != 0, (String)"\u8ba2\u5355\u8bb0\u8d26\u7f16\u7801\u9650\u52361-50\u5b57\u7b26");
        Assert.notNull((Object)keepAccountReqDto.getBillAccountName(), (String)"\u5f00\u7968\u8bb0\u8d26\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isTrue((keepAccountReqDto.getBillAccountName().length() < 51 ? 1 : 0) != 0, (String)"\u5f00\u7968\u8bb0\u8d26\u7f16\u7801\u9650\u52361-50\u5b57\u7b26");
    }

    @Override
    public Map<String, ChargeAccountInfoEo> getChargeAccountInfo(String nodeType, String orderType) {
        if (Objects.equals(NodeTypeEnum.NO.getCode(), nodeType)) {
            List accountInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.chargeAccountInfoDas.filter().eq((Object)"order_type", (Object)orderType)).isNotNull((Object)"order_interface")).list();
            if (CollectionUtils.isEmpty((Collection)accountInfoEos)) {
                this.logger.error(FinanceExceptionCode.SALE_CHARGE_ACCOUNT_NOT_SET.getMsg());
                throw new BizException(FinanceExceptionCode.SALE_CHARGE_ACCOUNT_NOT_SET.getCode(), FinanceExceptionCode.SALE_CHARGE_ACCOUNT_NOT_SET.getMsg());
            }
            Map<Object, Object> chargeAccountInfoEoMap = Maps.newHashMap();
            chargeAccountInfoEoMap = Objects.equals(BillTypeEnum.DELIVERY_REFUND_ONLY.getCode(), orderType) ? accountInfoEos.stream().collect(Collectors.toMap(k -> k.getOrderType() + "_" + k.getSiteCode(), Function.identity(), (k1, k2) -> k1)) : accountInfoEos.stream().collect(Collectors.toMap(k -> k.getOrderType() + "_" + k.getBusinessType() + "_" + k.getSiteCode(), Function.identity(), (k1, k2) -> k1));
            return chargeAccountInfoEoMap;
        }
        List accountInfoEos = this.chargeAccountInfoDas.filter().select(new String[]{"business_name", "business_type", "charge_account_name", "bill_account_name", "order_interface", "billing_interface", "post_delivery"}).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)accountInfoEos)) {
            this.logger.error(FinanceExceptionCode.SALE_CHARGE_ACCOUNT_NOT_SET.getMsg());
            throw new BizException(FinanceExceptionCode.SALE_CHARGE_ACCOUNT_NOT_SET.getCode(), FinanceExceptionCode.SALE_CHARGE_ACCOUNT_NOT_SET.getMsg());
        }
        Map<String, ChargeAccountInfoEo> chargeAccountInfoEoMap = accountInfoEos.stream().collect(Collectors.toMap(k -> k.getBusinessType(), Function.identity(), (k1, k2) -> k1));
        return chargeAccountInfoEoMap;
    }

    @Override
    public Map<String, ChargeAccountInfoEo> queryAllChargeAccountList() {
        List accountInfoEos = this.chargeAccountInfoDas.filter().select(new String[]{"business_name", "business_type", "charge_account_name", "bill_account_name", "order_interface", "billing_interface", "post_delivery", "slave_bill_account_name"}).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)accountInfoEos)) {
            this.logger.error(FinanceExceptionCode.CHARGE_ACCOUNT_NOT_SET.getMsg());
            throw new BizException(FinanceExceptionCode.CHARGE_ACCOUNT_NOT_SET.getCode(), FinanceExceptionCode.CHARGE_ACCOUNT_NOT_SET.getMsg());
        }
        Map<String, ChargeAccountInfoEo> chargeAccountInfoEoMap = accountInfoEos.stream().collect(Collectors.toMap(k -> k.getBusinessType(), Function.identity(), (k1, k2) -> k1));
        return chargeAccountInfoEoMap;
    }
}

