/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.ChargeAccountTypeConverter;
import com.yunxi.dg.base.center.finance.dao.das.IChargeAccountInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.IChargeAccountTypeDas;
import com.yunxi.dg.base.center.finance.domain.entity.IChargeAccountTypeDomain;
import com.yunxi.dg.base.center.finance.dto.entity.ChargeAccountTypeDto;
import com.yunxi.dg.base.center.finance.dto.request.ChargeAccountTypeReqDto;
import com.yunxi.dg.base.center.finance.dto.response.ChargeAccountTypeRespDto;
import com.yunxi.dg.base.center.finance.eo.ChargeAccountInfoEo;
import com.yunxi.dg.base.center.finance.eo.ChargeAccountTypeEo;
import com.yunxi.dg.base.center.finance.service.entity.IChargeAccountTypeService;
import com.yunxi.dg.base.center.finance.service.utils.GenerateUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChargeAccountTypeServiceImpl
extends BaseServiceImpl<ChargeAccountTypeDto, ChargeAccountTypeEo, IChargeAccountTypeDomain>
implements IChargeAccountTypeService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IChargeAccountTypeDas chargeAccountTypeDas;
    @Resource
    private IChargeAccountTypeDomain chargeAccountTypeDomain;
    @Resource
    private IChargeAccountInfoDas chargeAccountInfoDas;

    public ChargeAccountTypeServiceImpl(IChargeAccountTypeDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ChargeAccountTypeDto, ChargeAccountTypeEo> converter() {
        return ChargeAccountTypeConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addChargeAccountType(ChargeAccountTypeReqDto addReqDto) {
        this.logger.info("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        Integer chargeAccountCode = this.chargeAccountTypeDas.chargeAccountCode();
        ChargeAccountTypeEo chargeAccountTypeEo = null;
        if (Objects.nonNull(addReqDto.getId())) {
            chargeAccountTypeEo = (ChargeAccountTypeEo)((ExtQueryChainWrapper)this.chargeAccountTypeDas.filter().eq((Object)"id", (Object)addReqDto.getId())).one();
            if (Objects.nonNull(chargeAccountTypeEo)) {
                CubeBeanUtils.copyProperties((Object)chargeAccountTypeEo, (Object)addReqDto, (String[])new String[0]);
                this.chargeAccountTypeDas.updateSelective((BaseEo)chargeAccountTypeEo);
                List chargeAccountInfoEos = ((ExtQueryChainWrapper)this.chargeAccountInfoDas.filter().eq((Object)"charge_account_code", (Object)chargeAccountTypeEo.getChargeAccountCode())).list();
                if (CollectionUtils.isNotEmpty((Collection)chargeAccountInfoEos)) {
                    chargeAccountInfoEos.forEach(v -> {
                        ChargeAccountInfoEo chargeAccountInfoEo = new ChargeAccountInfoEo();
                        chargeAccountInfoEo.setId(v.getId());
                        chargeAccountInfoEo.setChargeAccountName(addReqDto.getChargeAccountName());
                        chargeAccountInfoEo.setInvoice(addReqDto.getInvoice());
                        this.chargeAccountInfoDas.updateSelective((BaseEo)chargeAccountInfoEo);
                    });
                }
            } else {
                List accountTypeEos = ((ExtQueryChainWrapper)this.chargeAccountTypeDas.filter().eq((Object)"charge_account_name", (Object)addReqDto.getChargeAccountName())).list();
                if (CollectionUtils.isNotEmpty((Collection)accountTypeEos)) {
                    throw new BizException("\u8be5\u8bb0\u8d26\u7c7b\u578b\u5df2\u5b58\u5728!");
                }
                chargeAccountTypeEo = new ChargeAccountTypeEo();
                CubeBeanUtils.copyProperties((Object)chargeAccountTypeEo, (Object)addReqDto, (String[])new String[0]);
                chargeAccountTypeEo.setChargeAccountCode(Objects.nonNull(chargeAccountCode) ? GenerateUtils.getLocalTrmSeqNum(chargeAccountCode) : GenerateUtils.getLocalTrmSeqNum(0));
                this.chargeAccountTypeDas.insert((BaseEo)chargeAccountTypeEo);
            }
        } else {
            List accountTypeEos = ((ExtQueryChainWrapper)this.chargeAccountTypeDas.filter().eq((Object)"charge_account_name", (Object)addReqDto.getChargeAccountName())).list();
            if (CollectionUtils.isNotEmpty((Collection)accountTypeEos)) {
                throw new BizException("\u8be5\u8bb0\u8d26\u7c7b\u578b\u5df2\u5b58\u5728!");
            }
            chargeAccountTypeEo = new ChargeAccountTypeEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)chargeAccountTypeEo);
            chargeAccountTypeEo.setChargeAccountCode(Objects.nonNull(chargeAccountCode) ? GenerateUtils.getLocalTrmSeqNum(chargeAccountCode) : GenerateUtils.getLocalTrmSeqNum(0));
            this.chargeAccountTypeDas.insert((BaseEo)chargeAccountTypeEo);
        }
        return chargeAccountTypeEo.getId();
    }

    @Override
    public void modifyChargeAccountType(ChargeAccountTypeReqDto modifyReqDto) {
        ChargeAccountTypeEo chargeAccountTypeEo = new ChargeAccountTypeEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)chargeAccountTypeEo);
        this.chargeAccountTypeDas.updateSelective((BaseEo)chargeAccountTypeEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeChargeAccountType(Long id) {
        ChargeAccountTypeEo chargeAccountTypeEo = (ChargeAccountTypeEo)((ExtQueryChainWrapper)this.chargeAccountTypeDas.filter().eq((Object)"id", (Object)id)).one();
        if (Objects.isNull(chargeAccountTypeEo)) {
            throw new BizException("\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        List chargeAccountInfoEos = ((ExtQueryChainWrapper)this.chargeAccountInfoDas.filter().eq((Object)"charge_account_name", (Object)chargeAccountTypeEo.getChargeAccountName())).list();
        if (CollectionUtils.isNotEmpty((Collection)chargeAccountInfoEos)) {
            throw new BizException("\u8bb0\u8d26\u7c7b\u578b\uff1a" + chargeAccountTypeEo.getChargeAccountName() + "\u5df2\u8fdb\u884c\u8bb0\u8d26\u7c7b\u578b\u8bbe\u7f6e,\u65e0\u6cd5\u5220\u9664!");
        }
        this.chargeAccountTypeDas.logicDeleteById(id);
    }

    @Override
    public ChargeAccountTypeRespDto queryById(Long id) {
        ChargeAccountTypeEo chargeAccountTypeEo = (ChargeAccountTypeEo)this.chargeAccountTypeDas.selectByPrimaryKey(id);
        ChargeAccountTypeRespDto chargeAccountTypeRespDto = new ChargeAccountTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)chargeAccountTypeEo, (BaseVo)chargeAccountTypeRespDto);
        return chargeAccountTypeRespDto;
    }

    @Override
    public PageInfo<ChargeAccountTypeRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ChargeAccountTypeReqDto chargeAccountTypeReqDto = (ChargeAccountTypeReqDto)JSON.parseObject((String)filter, ChargeAccountTypeReqDto.class);
        ChargeAccountTypeEo chargeAccountTypeEo = new ChargeAccountTypeEo();
        DtoHelper.dto2Eo((BaseVo)chargeAccountTypeReqDto, (BaseEo)chargeAccountTypeEo);
        PageInfo eoPageInfo = this.chargeAccountTypeDomain.selectPage((BaseEo)chargeAccountTypeEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ChargeAccountTypeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ChargeAccountTypeRespDto> queryPage(ChargeAccountTypeReqDto chargeAccountTypeReqDto, Integer pageNum, Integer pageSize) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.chargeAccountTypeDas.filter().orderByDesc((Object)"create_time");
        if (Objects.nonNull(chargeAccountTypeReqDto.getChargeAccountName())) {
            sqlFilters.like((Object)"charge_account_name", (Object)("%" + chargeAccountTypeReqDto.getChargeAccountName() + "%"));
        }
        if (Objects.nonNull(chargeAccountTypeReqDto.getChargeAccountDesc())) {
            sqlFilters.like((Object)"charge_account_desc", (Object)("%" + chargeAccountTypeReqDto.getChargeAccountDesc() + "%"));
        }
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ChargeAccountTypeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

