/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl.rule;

import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.ConditionTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.HckExchangeDeliveryNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.HckPushErpDeliveryNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.HckRefundsBaseDeliveryNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.HckSaleBillingKeepingNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.HckSaleDeliveryKeepingNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRule;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class KeepAccountRuleFactory {
    private static final Logger log = LoggerFactory.getLogger(KeepAccountRuleFactory.class);
    @Value(value="${keep.base.mode:AJR}")
    private String mode;

    public static List<KeepNodeRule> getSaleKeepNodeRuleList(String node, String orderType, String keepSystem) {
        log.info("=====sale.node: {}, keepSystem: {}, orderType: {}", new Object[]{node, keepSystem, orderType});
        LinkedList<KeepNodeRule> SALE_KEEP_NODE_RULE_LIST = new LinkedList<KeepNodeRule>();
        if (keepSystem.equals("AJR")) {
            if (Objects.equals(node, "2") || Objects.equals(node, "3")) {
                SALE_KEEP_NODE_RULE_LIST.add(new HckSaleDeliveryKeepingNodeRule(keepSystem));
                SALE_KEEP_NODE_RULE_LIST.add(new HckPushErpDeliveryNodeRule(ConditionTypeEnum.SALE_CREATE_DELIVERY.getCode()));
                SALE_KEEP_NODE_RULE_LIST.add(new HckSaleBillingKeepingNodeRule(keepSystem));
                SALE_KEEP_NODE_RULE_LIST.add(new HckPushErpDeliveryNodeRule(ConditionTypeEnum.SALE_CREATE_BILLING.getCode()));
            } else if (Objects.equals(node, "0")) {
                SALE_KEEP_NODE_RULE_LIST.add(new HckSaleDeliveryKeepingNodeRule(keepSystem));
                SALE_KEEP_NODE_RULE_LIST.add(new HckPushErpDeliveryNodeRule(ConditionTypeEnum.SALE_CREATE_DELIVERY.getCode()));
            } else if (Objects.equals(node, "1")) {
                SALE_KEEP_NODE_RULE_LIST.add(new HckSaleBillingKeepingNodeRule(keepSystem));
                SALE_KEEP_NODE_RULE_LIST.add(new HckPushErpDeliveryNodeRule(ConditionTypeEnum.SALE_CREATE_BILLING.getCode()));
            }
        } else if (keepSystem.equals("AF") || keepSystem.equals("HR")) {
            if (Objects.equals(node, "2") || Objects.equals(node, "3")) {
                SALE_KEEP_NODE_RULE_LIST.add(new HckSaleDeliveryKeepingNodeRule(keepSystem));
                SALE_KEEP_NODE_RULE_LIST.add(new HckSaleBillingKeepingNodeRule(keepSystem));
            } else if (Objects.equals(node, "0")) {
                SALE_KEEP_NODE_RULE_LIST.add(new HckSaleDeliveryKeepingNodeRule(keepSystem));
                SALE_KEEP_NODE_RULE_LIST.add(new HckSaleBillingKeepingNodeRule(keepSystem));
            } else if (Objects.equals(node, "1")) {
                SALE_KEEP_NODE_RULE_LIST.add(new HckSaleBillingKeepingNodeRule(keepSystem));
            }
        }
        return SALE_KEEP_NODE_RULE_LIST.stream().collect(Collectors.toList());
    }

    public static List<KeepNodeRule> getRefundsBaseNodeList(String node, String orderType, String keepSystem) {
        log.info("=====refund.node: {}, keepSystem: {}, orderType: {}", new Object[]{node, keepSystem, orderType});
        LinkedList<KeepNodeRule> RETURN_BASE_NODE_LIST = new LinkedList<KeepNodeRule>();
        if (Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), node) && Objects.equals(orderType, BillTypeEnum.DELIVERY_REFUND_ONLY.getCode())) {
            log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u4e0d\u9700\u8981\u4ea4\u8d27\u8bb0\u8d26");
        } else {
            RETURN_BASE_NODE_LIST.add(new HckRefundsBaseDeliveryNodeRule(node, keepSystem));
        }
        if (keepSystem.equals("AJR")) {
            if (orderType.equals(BillTypeEnum.EXCHANGE.getCode())) {
                RETURN_BASE_NODE_LIST.add(new HckPushErpDeliveryNodeRule(ConditionTypeEnum.EXCHANGE_DELIVERY.getCode()));
            } else if (orderType.equals(BillTypeEnum.RETURN_BASE.getCode())) {
                RETURN_BASE_NODE_LIST.add(new HckPushErpDeliveryNodeRule(ConditionTypeEnum.RETURN_BASE_DELIVERY.getCode()));
            } else if (orderType.equals(BillTypeEnum.DELIVERY_REFUND_ONLY.getCode())) {
                RETURN_BASE_NODE_LIST.add(new HckPushErpDeliveryNodeRule(ConditionTypeEnum.DELIVERY_REFUND_ONLY_BILLING.getCode()));
            }
        }
        return RETURN_BASE_NODE_LIST.stream().collect(Collectors.toList());
    }

    public static List<KeepNodeRule> getRefundsBaseNodeList(String node, String orderType, String keepSystem, Boolean ifOriginal) {
        log.info("\u552e\u540e\u5355\u8bb0\u8d26getRefundsBaseNodeList\uff0cnode\uff1a{}, keepSystem: {}, orderType: {}\uff0cifOriginal\uff1a{}", new Object[]{node, keepSystem, orderType, ifOriginal});
        LinkedList<KeepNodeRule> RETURN_BASE_NODE_LIST = new LinkedList<KeepNodeRule>();
        if (Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), node) && Objects.equals(orderType, BillTypeEnum.DELIVERY_REFUND_ONLY.getCode())) {
            log.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u4e0d\u9700\u8981\u4ea4\u8d27\u8bb0\u8d26");
        } else if (keepSystem.equals("HR")) {
            if (orderType.equals(BillTypeEnum.RETURN_BASE.getCode()) && !ifOriginal.booleanValue()) {
                log.info("\u65e0\u539f\u5355\u9000\u8d27\u9000\u6b3e\u5355\uff0c\u4e0d\u751f\u6210\u4ea4\u8d27\u548c\u5f00\u7968\u8bb0\u8d26\u5355");
            } else if (Objects.equals(VoucherTypeEnum.INVOICE.getCode(), node) && orderType.equals(BillTypeEnum.DELIVERY_REFUND_ONLY.getCode()) && !ifOriginal.booleanValue()) {
                log.info("\u65e0\u539f\u5355\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\uff0c\u4e0d\u751f\u6210\u5f00\u7968\u8bb0\u8d26");
            } else {
                RETURN_BASE_NODE_LIST.add(new HckRefundsBaseDeliveryNodeRule(node, keepSystem));
            }
        } else {
            RETURN_BASE_NODE_LIST.add(new HckRefundsBaseDeliveryNodeRule(node, keepSystem));
        }
        if (keepSystem.equals("AJR")) {
            if (orderType.equals(BillTypeEnum.EXCHANGE.getCode())) {
                RETURN_BASE_NODE_LIST.add(new HckPushErpDeliveryNodeRule(ConditionTypeEnum.EXCHANGE_DELIVERY.getCode()));
            } else if (orderType.equals(BillTypeEnum.RETURN_BASE.getCode())) {
                RETURN_BASE_NODE_LIST.add(new HckPushErpDeliveryNodeRule(ConditionTypeEnum.RETURN_BASE_DELIVERY.getCode()));
            } else if (orderType.equals(BillTypeEnum.DELIVERY_REFUND_ONLY.getCode())) {
                RETURN_BASE_NODE_LIST.add(new HckPushErpDeliveryNodeRule(ConditionTypeEnum.DELIVERY_REFUND_ONLY_BILLING.getCode()));
            }
        }
        return RETURN_BASE_NODE_LIST.stream().collect(Collectors.toList());
    }

    public static List<KeepNodeRule> getExchangeIssuedNodeList(String node, String orderType, String keepSystem) {
        LinkedList<KeepNodeRule> EXCHANGE_NODE_LIST = new LinkedList<KeepNodeRule>();
        EXCHANGE_NODE_LIST.add(new HckExchangeDeliveryNodeRule());
        EXCHANGE_NODE_LIST.add(new HckPushErpDeliveryNodeRule(ConditionTypeEnum.EXCHANGE_DELIVERY.getCode()));
        return EXCHANGE_NODE_LIST.stream().collect(Collectors.toList());
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeepAccountRuleFactory)) {
            return false;
        }
        KeepAccountRuleFactory other = (KeepAccountRuleFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeepAccountRuleFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        return result;
    }

    public String toString() {
        return "KeepAccountRuleFactory(mode=" + this.getMode() + ")";
    }
}

