/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.mq;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dao.das.IBillAllElectricShopDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillApplyDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillBusinessRelPlatformDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillEntityDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillOrderItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillStrategyNoInvoiceItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IItemRateDgDas;
import com.yunxi.dg.base.center.finance.dao.das.INoKeepBillDas;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPerformOrderInfoDomain;
import com.yunxi.dg.base.center.finance.dto.common.MqConstants;
import com.yunxi.dg.base.center.finance.dto.entity.BillInvoiceRemarkContentDto;
import com.yunxi.dg.base.center.finance.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.finance.dto.entity.InvoiceRemarkContentReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.ItemRateDgDto;
import com.yunxi.dg.base.center.finance.dto.entity.ItemSkuDgDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderItemDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderSnapshotDto;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AllRedFlagEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyAuditTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyChangeTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillAuditTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillCreateTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoColourTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillStrategyRemarkType;
import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.NoKeepBillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.enums.PlatFormOrderSelectTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.RelBusinessTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleItemStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.StrategyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SubsidiesTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.UseBlackListEnum;
import com.yunxi.dg.base.center.finance.dto.enums.WhetherMergeBillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.dto.response.RedOrderInvoiceAgainBillRespDto;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderItemEo;
import com.yunxi.dg.base.center.finance.eo.BillApplyEo;
import com.yunxi.dg.base.center.finance.eo.BillBusinessRelPlatformEo;
import com.yunxi.dg.base.center.finance.eo.BillEntityEo;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.eo.BillItemEo;
import com.yunxi.dg.base.center.finance.eo.BillOrderItemEo;
import com.yunxi.dg.base.center.finance.eo.BillStrategyNoInvoiceItemEo;
import com.yunxi.dg.base.center.finance.eo.NoKeepBillEo;
import com.yunxi.dg.base.center.finance.eo.PerformOrderInfoEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillBusinessRelPlatformService;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoValidateService;
import com.yunxi.dg.base.center.finance.service.entity.IBillInvoiceRemarkRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyService;
import com.yunxi.dg.base.center.finance.service.entity.IHhOrderGenerateBillInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IItemDgService;
import com.yunxi.dg.base.center.finance.service.entity.IPerformOrderInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepAccountsService;
import com.yunxi.dg.base.center.finance.service.entity.IShopService;
import com.yunxi.dg.base.center.finance.service.generate.GenerateCodeUtils;
import com.yunxi.dg.base.center.finance.service.generate.IGenerateCodeService;
import com.yunxi.dg.base.center.finance.service.mq.BaseGenerateInvoiceInfoOrderConsumer;
import com.yunxi.dg.base.center.finance.service.mq.IWhDgMessageProcessor;
import com.yunxi.dg.base.center.finance.service.mq.keep.RealTimeAccountingConsumer;
import com.yunxi.dg.base.center.finance.service.utils.GenerateCodeDataUtils;
import com.yunxi.dg.base.center.finance.service.utils.LogUtils;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(tag="CIS_AFTER_SALE_ORDER_STATUS_CHANGE_TAG", msgType="publish")
public class GenerateInvoiceInfoByAfterOrderConsumer
extends BaseGenerateInvoiceInfoOrderConsumer<MessageVo>
implements IWhDgMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(GenerateInvoiceInfoByAfterOrderConsumer.class);
    @Resource
    private IHhOrderGenerateBillInfoService hhOrderGenerateBillInfoService;
    @Resource
    private IBillInfoService billInfoService;
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IBillItemDas billItemDas;
    @Resource
    private IBillApplyDas billApplyDas;
    @Resource
    private GenerateCodeDataUtils generateCodeDataUtils;
    @Resource
    private OssRegistryVo ossRegistryVo;
    private String operateCode = "S";
    @Value(value="${huieryun.ossregistryvo.bucketName: oms-sit}")
    private String bucketName;
    private static final int EXPORT_FAIL_EXPIRES_IN = 1200;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private ILockService lockService;
    private static final String TABLENAME = "mq_after_sale_order_status_change#";
    @Resource
    private IBillBusinessRelPlatformDas billBusinessRelPlatformDas;
    @Resource
    private IBillBusinessRelPlatformService billBusinessRelPlatformService;
    @Resource
    private IPushKeepAccountsService pushKeepAccountsService;
    @Resource
    private IBillOrderItemDas billOrderItemDas;
    @Resource
    private IBillStrategyService billStrategyService;
    @Resource
    private IContext context;
    @Value(value="${bill.mode:HCK-KINGDEE}")
    private String billMode;
    @Resource
    private IBillStrategyNoInvoiceItemDas billStrategyNoInvoiceItemDas;
    @Resource
    private INoKeepBillDas noKeepBillDas;
    @Resource
    private IBillAllElectricShopDas billAllElectricShopDas;
    @Resource
    private IBillEntityDas billEntityDas;
    @Resource
    private IDgPerformOrderItemLineDomain iDgPerformOrderItemLineDomain;
    @Resource
    private IPerformOrderInfoService performOrderInfoService;
    @Resource
    private IShopService shopService;
    @Resource
    private IItemDgService itemDgService;
    @Resource
    private IItemRateDgDas itemRateDgDas;
    @Resource
    private RealTimeAccountingConsumer realTimeAccountingConsumer;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IAfterSaleOrderDomain iAfterSaleOrderDomain;
    @Resource
    private IAfterSaleOrderItemDomain iAfterSaleOrderItemDomain;
    @Resource
    private IPerformOrderInfoDomain iPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IBillInfoValidateService billInfoValidateService;
    @Resource
    private IBillInvoiceRemarkRuleService remarkRuleService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MessageResponse processBiz(MessageVo message) {
        Mutex mutexBill;
        Mutex mutex;
        block23: {
            block24: {
                MessageResponse messageResponse;
                block21: {
                    block22: {
                        this.resetApplyPerson();
                        ServiceContext.getContext().remove("yx.dg.opt.chain.context");
                        ServiceContext.getContext().remove("yx.dg.opt.chain.header");
                        logger.info("\u63a5\u6536\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5f02\u6b65\u7ea2\u51b2\u751f\u6210\u5f00 \u7968\u4fe1\u606fmessage: {}", (Object)JSONObject.toJSONString((Object)message));
                        mutex = null;
                        mutexBill = null;
                        Object platformOrderKeyMutex = null;
                        try {
                            Map dataMap = JacksonUtil.toMap((String)JacksonUtil.toJson((Object)message.getData()));
                            logger.info("dataMap.get(ifInvoice)={}", dataMap.get("ifInvoice"));
                            if (Objects.nonNull(dataMap.get("ifInvoice")) && (dataMap.get("ifInvoice").equals(0) || dataMap.get("ifInvoice").equals("0"))) {
                                logger.info("\u4e0d\u9700\u8981\u7ea2\u51b2\uff0cifInvoice\u4e3a\u7a7a\u6216\u8005={}", dataMap.get("ifInvoice"));
                                MessageResponse messageResponse2 = MessageResponse.SUCCESS;
                                return messageResponse2;
                            }
                            String saleOrderNo = dataMap.get("saleOrderNo").toString();
                            String platformOrderNo = dataMap.get("platformOrderNo").toString();
                            String orderStatus = dataMap.get("afterStatus").toString();
                            if (!OmsSaleOrderStatus.FINISH.getCode().equals(orderStatus)) {
                                logger.info("\u552e\u540e\u5355\u975e\u5df2\u5b8c\u6210\u72b6\u6001\uff0c\u4e0d\u8fdb\u884c\u5f00\u7968:{},{},{}", new Object[]{saleOrderNo, platformOrderNo, orderStatus});
                                MessageResponse messageResponse3 = MessageResponse.SUCCESS;
                                return messageResponse3;
                            }
                            String afterSaleOrderNo = dataMap.get("afterSaleOrderNo").toString();
                            String afterSaleOrderType = dataMap.get("afterSaleOrderType").toString();
                            String primaryKey = platformOrderNo + " " + saleOrderNo + " " + orderStatus;
                            Thread.sleep(RandomUtil.randomLong((long)100L, (long)200L));
                            String platformOrderKey = MqConstants.getInvoiceKey((String)platformOrderNo);
                            mutex = this.lockService.lock(TABLENAME, primaryKey, 60, 120, TimeUnit.SECONDS);
                            logger.info("\u63a5\u6536\u552e\u540e\u5355\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u8ba2\u5355\u72b6\u6001\uff1a{}", (Object)orderStatus);
                            if (!this.billInfoValidateService.canBillForGiftAfterSaleOrder(afterSaleOrderNo)) {
                                logger.info("\u5f00\u7968\u7b56\u7565\u4e2d\u914d\u7f6e\u4e86\u8d60\u54c1\u4e0d\u5f00\u53d1\u7968\uff0c\u5e76\u4e14\u5f53\u524d\u8ba2\u5355\u4e5f\u662f\u8d60\u54c1\u8ba2\u5355\uff0c\u65e0\u9700\u89e6\u53d1\u53d1\u7968\u91cd\u5f00:{}", (Object)afterSaleOrderNo);
                                messageResponse = MessageResponse.SUCCESS;
                                if (mutex == null) break block21;
                                break block22;
                            }
                            PerformOrderInfoDto performOrderInfoDto = this.performOrderInfoService.queryInfoByOrderNo(saleOrderNo);
                            if (this.orderTypeFilter(performOrderInfoDto.getOrderType()).booleanValue() && this.costProjectFilter(afterSaleOrderNo).booleanValue()) {
                                if (AfterSaleOrderStatusEnum.FINISH.getCode().equals(orderStatus) && this.billInfoService.exchangeOrderFilter(platformOrderNo).booleanValue()) {
                                    mutexBill = this.lockService.lock("bill_info_key", platformOrderNo, 20, 30, TimeUnit.SECONDS);
                                    if (null == mutexBill) {
                                        throw new BizException(String.format("\u6b63\u5411\u9006\u5411\u751f\u6210\u53d1\u7968\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,platformOrderNo:\u3010%s\u3011", platformOrderNo));
                                    }
                                    this.operationBillInfo(dataMap);
                                }
                            } else {
                                logger.info("\u552e\u540e\u8865\u53d1\u7c7b\u578b\u8ba2\u5355\u4e0d\u8fdb\u884c\u5f00\u7968");
                            }
                            if (mutex == null) break block23;
                            break block24;
                        }
                        catch (BusinessRuntimeException er) {
                            er.printStackTrace();
                            logger.error("\u53ef\u80fd\u662f\u6216\u8005\u5206\u5e03\u5f0f\u5931\u8d25\u4e86", (Throwable)er);
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            MessageResponse messageResponse4 = MessageResponse.ERROR;
                            return messageResponse4;
                        }
                        catch (Exception e) {
                            logger.error("\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5f02\u6b65\u7ea2\u51b2\u751f\u6210\u5f00\u7968\u4fe1\u606f\u5904\u7406\u5f02\u5e38", (Throwable)e);
                            throw new BizException(String.format("\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5f02\u6b65\u7ea2\u51b2\u751f\u6210\u5f00\u7968\u4fe1\u606f\u5904\u7406\u5f02\u5e38:\u3010%s\u3011\uff0c\u3010%s\u3011", e.getMessage(), e));
                        }
                    }
                    this.lockService.unlock(mutex);
                }
                if (mutexBill == null) return messageResponse;
                this.lockService.unlock(mutexBill);
                return messageResponse;
            }
            this.lockService.unlock(mutex);
        }
        if (mutexBill == null) return MessageResponse.SUCCESS;
        this.lockService.unlock(mutexBill);
        return MessageResponse.SUCCESS;
        finally {
            if (mutex != null) {
                this.lockService.unlock(mutex);
            }
            if (mutexBill != null) {
                this.lockService.unlock(mutexBill);
            }
        }
    }

    private void resetApplyPerson() {
        String newApplyPerson = "\u7cfb\u7edf";
        String oldApplyPerson = ServiceContext.getContext().getRequestUserCode();
        logger.info("\u91cd\u8bbe\u53d1\u7968\u7533\u8bf7\u4eba\uff1a{} -> {}", (Object)oldApplyPerson, (Object)newApplyPerson);
        ServiceContext.getContext().setAttachment("yes.req.userCode", newApplyPerson);
    }

    @Transactional(rollbackFor={Exception.class})
    public void operationBillInfo(Map<String, Object> dataMap) {
        logger.info("operationBillInfo:{}", (Object)JSONObject.toJSONString(dataMap));
        String saleOrderNo = dataMap.get("saleOrderNo") == null ? null : dataMap.get("saleOrderNo").toString();
        String platformOrderNo = dataMap.get("platformOrderNo") == null ? null : dataMap.get("platformOrderNo").toString();
        String afterSaleOrderType = dataMap.get("afterSaleOrderType") == null ? null : dataMap.get("afterSaleOrderType").toString();
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).list();
        logger.info("\u6839\u636e\u5e73\u53f0\u8ba2\u5355\u53f7\u67e5\u8be2\u5f00\u7968\u8bb0\u5f55operationBillInfo:{}", (Object)JSONObject.toJSONString((Object)list));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List billFlowNoList = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
            List billInfoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).eq((Object)"whether_merge_bill", (Object)WhetherMergeBillTypeEnum.NO_MERGE.getCode())).list();
            if (CollectionUtils.isNotEmpty((Collection)billInfoList)) {
                AtomicBoolean flag = new AtomicBoolean(true);
                List<BillInfoEo> billInfoEoList = billInfoList.stream().sorted(Comparator.comparing(BaseEo::getId).reversed()).collect(Collectors.toList());
                BillInfoEo bill = (BillInfoEo)billInfoEoList.get(0);
                logger.info("\u552e\u540e\u83b7\u53d6\u5f53\u524d\u6700\u65b0\u7684\u5f00\u7968\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)bill));
                if (bill.getPlatformOrderNo().equals(bill.getSaleOrderNo()) || StringUtils.isEmpty((CharSequence)bill.getSaleOrderNo())) {
                    flag.set(false);
                }
                this.platformOrderInvoice(billInfoEoList, platformOrderNo, afterSaleOrderType);
            } else {
                logger.info("\u672a\u5f00\u7968\u4e0d\u9700\u8981\u5904\u7406\uff0c\u5e73\u53f0\u8ba2\u5355\u53f7\uff1a{},\u914d\u8d27\u8ba2\u5355\u53f7\uff1a{}", (Object)platformOrderNo, (Object)saleOrderNo);
            }
        }
    }

    public void noKeepAfterUpdate(List<String> afterSaleOrderNo) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.noKeepBillDas.filter().eq((Object)"business_type", (Object)NoKeepBillTypeEnum.AFTER.getCode())).in((Object)"business_order_no", afterSaleOrderNo)).list();
        Map noKeepBillEoMap = ((List)Optional.ofNullable(list).orElse(new ArrayList())).stream().collect(Collectors.toMap(NoKeepBillEo::getBusinessOrderNo, Function.identity(), (v1, v2) -> v1));
        ArrayList addList = new ArrayList();
        afterSaleOrderNo.forEach(after -> {
            if (!noKeepBillEoMap.containsKey(after)) {
                NoKeepBillEo noKeepBillEo = new NoKeepBillEo();
                noKeepBillEo.setBusinessOrderNo(after);
                noKeepBillEo.setBusinessType(NoKeepBillTypeEnum.AFTER.getCode());
                noKeepBillEo.setStatus(Integer.valueOf(0));
                addList.add(noKeepBillEo);
            }
        });
        if (CollectionUtils.isNotEmpty(addList)) {
            this.noKeepBillDas.insertBatch(addList);
        }
    }

    public void saleOrderInvoice(List<BillInfoEo> billInfoList, String saleOrderNo, String afterSaleOrderType, String platformOrderNo) {
        BillInfoEo billInfoEo = new BillInfoEo();
        List billInfos = billInfoList.stream().filter(x -> InvoiceStateEnum.BILLED.getCode().equals(x.getInvoiceState())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(billInfos)) {
            billInfoEo = (BillInfoEo)billInfos.get(0);
        } else {
            List billInfoEos = billInfoList.stream().sorted(Comparator.comparing(BaseEo::getId).reversed()).collect(Collectors.toList());
            billInfoEo = (BillInfoEo)billInfoEos.get(0);
        }
        logger.info("\u83b7\u53d6\u6700\u65b0\u7684\u5f00\u7968\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)billInfoEo));
        PerformOrderInfoDto performOrderInfoDto = this.performOrderInfoService.queryByOrderNo(saleOrderNo);
        this.billInfoService.resetAmountAndNumForBill(performOrderInfoDto);
        BillApplyEo billApplyEo = this.addBillApplyInfo(billInfoEo, performOrderInfoDto, afterSaleOrderType, new Object());
        ArrayList<String> changeTypeList = new ArrayList<String>();
        changeTypeList.add(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
        changeTypeList.add(BillApplyChangeTypeEnum.HANDLE_FAIL.getCode());
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).in((Object)"change_type", changeTypeList)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            if (billInfoList.stream().anyMatch(bill -> InvoiceStateEnum.INVOICING.getCode().equals(bill.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(bill.getInvoiceState()))) {
                logger.info("\u5b58\u5728\u5f00\u7968\u4e2d/\u5f00\u7968\u5931\u8d25\u5355\u636e\u4e0d\u7ee7\u7eed\u64cd\u4f5c");
                billApplyEo.setChangeType(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
                this.billApplyDas.insert((BaseEo)billApplyEo);
                this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(billApplyEo.getPlatformOrderNo().split(",")), billApplyEo.getApplyNo(), RelBusinessTypeEnum.APPLY.getCode());
                return;
            }
            billApplyEo.setChangeType(BillApplyChangeTypeEnum.HANDLED.getCode());
            logger.info("\u552e\u540e\u7ea2\u51b2\u6210\u529f\u91cd\u65b0\u751f\u6210\u6700\u65b0\u7684\u5f00\u7968\u4fe1\u606f");
            this.orderGenerateInvoicing(performOrderInfoDto, billInfoEo, billApplyEo);
            this.billApplyDas.insert((BaseEo)billApplyEo);
            this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(billApplyEo.getPlatformOrderNo().split(",")), billApplyEo.getApplyNo(), RelBusinessTypeEnum.APPLY.getCode());
        } else {
            billApplyEo.setChangeType(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
            this.billApplyDas.insert((BaseEo)billApplyEo);
            this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(billApplyEo.getPlatformOrderNo().split(",")), billApplyEo.getApplyNo(), RelBusinessTypeEnum.APPLY.getCode());
        }
    }

    public void platformOrderInvoice(List<BillInfoEo> billInfoList, String platformOrderNo, String afterSaleOrderType) {
        BillInfoEo billInfoEo = new BillInfoEo();
        List billInfos = billInfoList.stream().filter(x -> InvoiceStateEnum.BILLED.getCode().equals(x.getInvoiceState())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(billInfos)) {
            billInfoEo = (BillInfoEo)billInfos.get(0);
        } else {
            List billInfoEos = billInfoList.stream().sorted(Comparator.comparing(BaseEo::getId).reversed()).collect(Collectors.toList());
            billInfoEo = (BillInfoEo)billInfoEos.get(0);
        }
        logger.info("\u83b7\u53d6\u8ba2\u5355\u7684\u5f00\u7968\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)billInfoEo));
        BillApplyEo billApplyEo = new BillApplyEo();
        List<Object> performOrderInfoDtoList = new ArrayList();
        if (WhetherMergeBillTypeEnum.NO_MERGE.getCode().equals(billInfoEo.getWhetherMergeBill()) || null == billInfoEo.getWhetherMergeBill()) {
            PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
            performOrderInfoPageReqDto.setPlatformOrderNo(platformOrderNo);
            performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
            performOrderInfoDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
            billApplyEo = this.addBillApplyInfo(billInfoEo, (PerformOrderInfoDto)performOrderInfoDtoList.get(0), afterSaleOrderType, new Object());
        } else {
            logger.info("\u552e\u540e\u5408\u5e76\u5f00\u7968\u5904\u7406");
            String[] platformOrderNoList = billInfoEo.getPlatformOrderNo().split(",");
            PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
            performOrderInfoPageReqDto.setPlatformOrderNoList(new ArrayList<String>(Arrays.asList(platformOrderNoList)));
            performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
            performOrderInfoDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
            billApplyEo = this.addBillApplyInfo(billInfoEo, (PerformOrderInfoDto)performOrderInfoDtoList.get(0), afterSaleOrderType, new Object());
        }
        this.billInfoService.resetAmountAndNumForBill(performOrderInfoDtoList);
        List list = new ArrayList();
        List relPlatformEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().in((Object)"platform_order_no", Arrays.asList(billInfoEo.getPlatformOrderNo().split(",")))).eq((Object)"business_type", (Object)RelBusinessTypeEnum.APPLY.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)relPlatformEoList)) {
            List applyNoList = relPlatformEoList.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
            ArrayList<String> changeTypeList = new ArrayList<String>();
            changeTypeList.add(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
            changeTypeList.add(BillApplyChangeTypeEnum.HANDLE_FAIL.getCode());
            list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().in((Object)"apply_no", applyNoList)).in((Object)"change_type", changeTypeList)).list();
            logger.info("\u83b7\u53d6\u5173\u8054\u7684\u7533\u8bf7\u5355\u662f\u5426\u5b58\u5728\u4e3a\u8f6c\u6362:{},{}", (Object)platformOrderNo, (Object)JSONObject.toJSONString(list));
        }
        if (CollectionUtils.isEmpty(list)) {
            boolean blueTicketIsInvoicing = billInfoList.stream().filter(bill -> BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(bill.getBillType())).anyMatch(bill -> InvoiceStateEnum.INVOICING.getCode().equals(bill.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(bill.getInvoiceState()));
            if (blueTicketIsInvoicing) {
                logger.info("\u5b58\u5728\u5f00\u7968\u4e2d/\u5f00\u7968\u5931\u8d25\u5355\u636e\u4e0d\u7ee7\u7eed\u64cd\u4f5c");
                billApplyEo.setChangeType(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
                this.billApplyDas.insert((BaseEo)billApplyEo);
                this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(billApplyEo.getPlatformOrderNo().split(",")), billApplyEo.getApplyNo(), RelBusinessTypeEnum.APPLY.getCode());
                return;
            }
            billApplyEo.setChangeType(BillApplyChangeTypeEnum.HANDLED.getCode());
            logger.info("\u552e\u540e\u7ea2\u51b2\u6210\u529f\u91cd\u65b0\u751f\u6210\u6700\u65b0\u7684\u5f00\u7968\u4fe1\u606f==\u300bperformOrderInfoDtoList={}", (Object)JSON.toJSONString(performOrderInfoDtoList));
            boolean consistency = false;
            this.platformGenerateInvoicing(performOrderInfoDtoList, billInfoEo, billApplyEo, consistency);
            logger.info("\u53d1\u7968\u4fe1\u606f\u4e00\u81f4:{},{}", (Object)consistency, (Object)billInfoEo.getPlatformOrderNo());
            if (!consistency) {
                this.billApplyDas.insert((BaseEo)billApplyEo);
                this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(billApplyEo.getPlatformOrderNo().split(",")), billApplyEo.getApplyNo(), RelBusinessTypeEnum.APPLY.getCode());
            }
        } else {
            billApplyEo.setChangeType(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
            this.billApplyDas.insert((BaseEo)billApplyEo);
            this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(billApplyEo.getPlatformOrderNo().split(",")), billApplyEo.getApplyNo(), RelBusinessTypeEnum.APPLY.getCode());
        }
    }

    private BillApplyEo addBillApplyInfo(BillInfoEo billInfoEo, PerformOrderInfoDto performOrderInfoDto, String afterSaleOrderType, Object tfOrderRespDto) {
        IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.BILL_APPLY.getCode());
        String applyNo = generateCodeService.getCode("BA");
        BillApplyEo billApplyEo = new BillApplyEo();
        billApplyEo.setApplyNo(applyNo);
        billApplyEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
        billApplyEo.setSite(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getChannelCode());
        billApplyEo.setShopId(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopId());
        billApplyEo.setShopCode(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode());
        billApplyEo.setShopName(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopName());
        billApplyEo.setPlatformOrderStatus(performOrderInfoDto.getPlatformOrderStatus());
        billApplyEo.setApplyChannel(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getChannelCode());
        switch (afterSaleOrderType.toUpperCase()) {
            case "JTK": 
            case "jtk": 
            case "FHHTK": 
            case "fhhtk": {
                billApplyEo.setApplyType("refund");
                break;
            }
            case "thtk": 
            case "THTK": {
                billApplyEo.setApplyType("returns_and_refunds");
                break;
            }
            case "HH": 
            case "hh": {
                billApplyEo.setApplyType("exchange");
                break;
            }
            default: {
                billApplyEo.setApplyType("apply_bill");
            }
        }
        if (!BillApplyTypeEnum.APPLY_BILL.getCode().equals(billApplyEo.getApplyType())) {
            billApplyEo.setBusinessOrderNo(performOrderInfoDto.getSaleOrderNo());
        }
        billApplyEo.setBillType(billInfoEo.getInvoiceType());
        billApplyEo.setBillTitle(billInfoEo.getBillTitle());
        billApplyEo.setChangeType(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
        billApplyEo.setApplyTime(new Date());
        billApplyEo.setEnterprise(billInfoEo.getBillTitle());
        billApplyEo.setTaxesCode(billInfoEo.getTaxesCode());
        billApplyEo.setRegisteredAddress(billInfoEo.getRegisteredAddress());
        billApplyEo.setRegisteredPhone(billInfoEo.getRegisteredPhone());
        billApplyEo.setBankAccount(billInfoEo.getBankAccount());
        billApplyEo.setBank(billInfoEo.getBank());
        billApplyEo.setMailbox(billInfoEo.getMailbox());
        billApplyEo.setPhone(billInfoEo.getPhone());
        billApplyEo.setTitleType(billInfoEo.getTitleType());
        billApplyEo.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
        billApplyEo.setBillAddress(billInfoEo.getBillAddress());
        billApplyEo.setBillPersonPhone(billInfoEo.getBillPersonPhone());
        billApplyEo.setBillPersonName(billInfoEo.getBillPersonName());
        return billApplyEo;
    }

    private void orderGenerateInvoicing(PerformOrderInfoDto performOrderInfoDto, BillInfoEo billInfo, BillApplyEo billApplyEo) {
        String billFlowNo = this.generateCodeDataUtils.generateNo("KP");
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setBillFlowNo(billFlowNo);
        this.getBillItem(billInfo, billApplyEo, billInfoEo, performOrderInfoDto);
        logger.info("\u552e\u540e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4orderGenerateInvoicing==>billInfoEo:{}", (Object)LogUtils.buildLogContent(billInfoEo));
        this.saveBillDetailInfo(performOrderInfoDto, billInfoEo, billInfo.getBillFlowNo());
    }

    private void saveBillDetailInfo(PerformOrderInfoDto performOrderInfoDto, BillInfoEo billInfoEo, String oldBillFlowNo) {
        ArrayList<PerformOrderItemDto> itemList = new ArrayList<PerformOrderItemDto>();
        ArrayList<PerformOrderItemDto> zeroNumItemList = new ArrayList<PerformOrderItemDto>();
        ArrayList<BillItemEo> billItemEoList = new ArrayList<BillItemEo>();
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(billInfoEo.getShopCode(), StrategyTypeEnum.ORDINARY_BILL.getCode());
        if (Objects.isNull(billStrategyRespDto) || null == billStrategyRespDto.getId()) {
            logger.info("\u672a\u83b7\u53d6\u5230\u5e97\u94fa\u5f00\u7968\u7b56\u7565:{}", (Object)billInfoEo.getShopCode());
            return;
        }
        logger.info("\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderInfoDto.getItemDtoList()));
        billInfoEo.setInvoiceSaleOrderNo(performOrderInfoDto.getSaleOrderNo());
        if (this.orderTypeFilter(performOrderInfoDto.getOrderType()).booleanValue()) {
            if (!OmsSaleOrderStatus.CANCEL.getCode().equals(performOrderInfoDto.getOrderStatus())) {
                List noInvoiceItemEoList = ((ExtQueryChainWrapper)this.billStrategyNoInvoiceItemDas.filter().eq((Object)"strategy_id", (Object)billStrategyRespDto.getId())).list();
                Map itemEoMap = ((List)Optional.ofNullable(noInvoiceItemEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(BillStrategyNoInvoiceItemEo::getItemCode, Function.identity(), (v1, v2) -> v2));
                performOrderInfoDto.getItemDtoList().forEach(item -> this.filterItem((PerformOrderItemDto)item, itemEoMap, billStrategyRespDto, (List<PerformOrderItemDto>)itemList, (List<PerformOrderItemDto>)zeroNumItemList));
            }
        } else {
            logger.info("\u8865\u53d1\u8ba2\u5355\u5546\u54c1\u884c\u4e0d\u8fdb\u884c\u5f00\u7968");
        }
        if (CollectionUtils.isNotEmpty(zeroNumItemList) && StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getFreightCostItemCode())) {
            this.assembleFreightCostItem(billStrategyRespDto, itemList, zeroNumItemList);
        }
        if (CollectionUtils.isEmpty(itemList)) {
            logger.info("\u552e\u540e\u5f00\u7968\u5546\u54c1\u660e\u7ec6\u6ca1\u6709\u53ef\u4ee5\u6b63\u5e38\u5f00\u7968\u6570\u636e\u76f4\u63a5\u8c03\u7528\u53d1\u7968\u4f5c\u5e9f\u63a5\u53e3");
            List billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).list();
            this.billInfoService.redInvoice(billInfoEoList);
            return;
        }
        BigDecimal mergeItemAmount = BigDecimal.ZERO;
        ArrayList noWhetherMergeItem = new ArrayList();
        ArrayList<PerformOrderItemDto> whetherMergeItem = new ArrayList<PerformOrderItemDto>();
        if (1 == billStrategyRespDto.getWhetherMergeItem()) {
            logger.info("\u6839\u636e\u7b56\u7565\u7ec4\u5408\u5546\u54c1\u9700\u8981\u5408\u5e76\u5f00\u7968");
            itemList.forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getGroupSkuCode())) {
                    whetherMergeItem.add((PerformOrderItemDto)item);
                } else {
                    noWhetherMergeItem.add(item);
                }
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(whetherMergeItem)) {
                mergeItemAmount = this.whetherMergeItem(whetherMergeItem, billInfoEo, billItemEoList, billStrategyRespDto);
            }
        } else {
            CubeBeanUtils.copyCollection(noWhetherMergeItem, itemList, PerformOrderItemDto.class);
        }
        AtomicReference<BigDecimal> number = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (CollectionUtils.isNotEmpty(noWhetherMergeItem)) {
            Map<String, List<PerformOrderItemDto>> orderItemMap = noWhetherMergeItem.stream().collect(Collectors.groupingBy(PerformOrderItemDto::getSkuCode));
            List<String> skuCodeList = noWhetherMergeItem.stream().map(PerformOrderItemDto::getSkuCode).distinct().collect(Collectors.toList());
            List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCodeList);
            Map<String, ItemSkuDgDto> skuCodeMap = ((List)Optional.ofNullable(itemSkuDgDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
            List billItemList = ((ExtQueryChainWrapper)this.billItemDas.filter().eq((Object)"bill_flow_no", (Object)oldBillFlowNo)).list();
            List<BillItemEo> freightItem = billItemList.stream().filter(item -> 1 == item.getFreightCost()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(freightItem)) {
                freightItem.forEach(item -> {
                    item.setId(null);
                    item.setBillFlowNo(billInfoEo.getBillFlowNo());
                    billItemEoList.add((BillItemEo)item);
                });
            }
            Map itemBillMap = billItemList.stream().collect(Collectors.toMap(BillItemEo::getItemCode, Function.identity(), (v1, v2) -> v2));
            orderItemMap.forEach((k, v) -> {
                BillItemEo billItemEo = new BillItemEo();
                PerformOrderItemDto saleOrderItemExtRespDto = (PerformOrderItemDto)v.get(0);
                billItemEo.setItemId(saleOrderItemExtRespDto.getItemId());
                billItemEo.setItemCode(saleOrderItemExtRespDto.getItemCode());
                billItemEo.setItemName(saleOrderItemExtRespDto.getItemName());
                ItemRateDgDto itemRateDgDto = new ItemRateDgDto();
                if (skuCodeMap.containsKey(saleOrderItemExtRespDto.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(saleOrderItemExtRespDto.getSkuCode());
                    billItemEo.setItemName(itemSkuDgDto.getName());
                    billItemEo.setSpecification(itemSkuDgDto.getSpecModel());
                    itemRateDgDto = itemSkuDgDto.getItemRateDgDto();
                }
                billItemEo.setQuantity(v.stream().map(PerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
                billItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
                BigDecimal payAmount = v.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundedPayAmount = v.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundedPayAmount = refundedPayAmount.abs();
                BigDecimal amount = payAmount.subtract(refundedPayAmount);
                billItemEo.setAmount(amount);
                billItemEo.setClinchDealAmount(amount);
                number.set(((BigDecimal)number.get()).add(amount));
                billItemEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
                billItemEo.setUnitPrice(saleOrderItemExtRespDto.getSalePrice());
                if (itemBillMap.containsKey(k)) {
                    BillItemEo oldBillItem = (BillItemEo)itemBillMap.get(k);
                    billItemEo.setItemShortName(oldBillItem.getItemShortName());
                    billItemEo.setPatentName(oldBillItem.getPatentName());
                    billItemEo.setTaxRate(oldBillItem.getTaxRate());
                    billItemEo.setTaxClassificationCode(oldBillItem.getTaxClassificationCode());
                    billItemEo.setTaxAmount(billItemEo.getAmount().divide(oldBillItem.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(oldBillItem.getTaxRate()).setScale(2, 4));
                    billItemEo.setBillLineItemName(oldBillItem.getBillLineItemName());
                    billItemEo.setUnit(oldBillItem.getUnit());
                }
                this.getOrderItemInvoice(skuCodeMap, itemRateDgDto, saleOrderItemExtRespDto, billItemEo, billStrategyRespDto);
                billItemEoList.add(billItemEo);
                if (BigDecimalUtils.gtZero((BigDecimal)billItemEo.getAmount()).booleanValue() && BigDecimalUtils.gtZero((BigDecimal)billItemEo.getQuantity()).booleanValue()) {
                    billItemEo.setUnitPrice(billItemEo.getAmount().divide(billItemEo.getQuantity(), 2, RoundingMode.HALF_UP));
                }
            });
            this.addBillOrderItem(itemList, billInfoEo, skuCodeMap, billStrategyRespDto);
        }
        billInfoEo.setInvoiceAmount(number.get().add(mergeItemAmount));
        if (CollectionUtils.isEmpty(billItemEoList)) {
            logger.info("\u552e\u540e\u5f00\u7968\u5546\u54c1\u660e\u7ec6\u6ca1\u6709\u53ef\u4ee5\u6b63\u5e38\u5f00\u7968\u6570\u636e\u76f4\u63a5\u8c03\u7528\u53d1\u7968\u4f5c\u5e9f\u63a5\u53e3");
            List billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).list();
            this.billInfoService.redInvoice(billInfoEoList);
            return;
        }
        BillInvoiceRemarkContentDto contentDto = new BillInvoiceRemarkContentDto();
        this.getBillRemark(billStrategyRespDto, billInfoEo, performOrderInfoDto, billItemEoList);
        if (null != billInfoEo.getSubsidiesType() && 1 == billInfoEo.getSubsidiesType()) {
            String skuCode = ((BillItemEo)billItemEoList.get(0)).getItemCode();
            logger.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u83b7\u53d6\u53d1\u7968SKU:{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)skuCode);
            contentDto = this.getInvoiceRemarkContentDto(billInfoEo, performOrderInfoDto, skuCode);
            logger.info("\u6839\u636e\u7b56\u7565\u83b7\u53d6\u5907\u6ce8====>{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)contentDto));
            if (null != contentDto && "1".equals(contentDto.getWhether())) {
                billInfoEo.setInvoiceRemarks(null != contentDto ? contentDto.getResult() : null);
                BillInvoiceRemarkContentDto finalContentDto = contentDto;
                billInfoEo.setRuleCode(finalContentDto.getRuleCode());
                billInfoEo.setRuleName(finalContentDto.getRuleName());
                billInfoEo.setInvoiceRemarkFlag(Integer.valueOf(1));
                if (StringUtils.isNotBlank((CharSequence)finalContentDto.getMessage())) {
                    billInfoEo.setAuditFailReason(finalContentDto.getMessage());
                }
                billItemEoList.forEach(v -> {
                    logger.info("\u53d1\u7968\u884c\u9879\u76ee\u540d\u79f0====>{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)finalContentDto.getItemProjectName());
                    if (StringUtils.isNotBlank((CharSequence)finalContentDto.getItemProjectName())) {
                        String projectName = finalContentDto.getItemProjectName() + v.getBillLineItemName();
                        v.setBillLineItemName(projectName);
                    }
                });
            }
        }
        billItemEoList.forEach(a -> this.billInfoService.setSpecialRate(billInfoEo, (BillItemEo)a));
        this.billItemDas.insertBatch(billItemEoList);
        this.getShopAllElectricInfo(billInfoEo);
        this.billInfoService.checkAndSetBlacklist(billInfoEo);
        RedOrderInvoiceAgainBillRespDto respDto = this.billInfoService.redInvoiceIsReopen(billInfoEo);
        this.billInfoDas.insert((BaseEo)billInfoEo);
        if (BillAuditTypeEnum.AUTO_AUDIT.getCode().equals(billStrategyRespDto.getBillAudit()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getBillApplyType())) {
            boolean isAuto = CollectionUtil.isEmpty((Collection)billStrategyRespDto.getCreateTypeList()) || (StrUtil.isNotBlank((CharSequence)billInfoEo.getCreatePerson()) ? billStrategyRespDto.getCreateTypeList().contains("manual") : billStrategyRespDto.getCreateTypeList().contains("sys"));
            logger.info("\u9002\u7528\u56fd\u8865\u8ba2\u5355\u914d\u7f6e\uff1a{},{}", (Object)JSONObject.toJSONString((Object)billStrategyRespDto), (Object)JSONObject.toJSONString((Object)billInfoEo));
            if (null != BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType())) {
                String code = BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType()).getCode();
                if (billStrategyRespDto.getBillApplyType().contains(code) && isAuto) {
                    if (1 == (null != billInfoEo.getSubsidiesType() ? billInfoEo.getSubsidiesType() : 0) && CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("national_supplement")) {
                        this.autoAuditCheck(billInfoEo, billItemEoList, billStrategyRespDto, contentDto);
                    } else if (0 == (null != billInfoEo.getSubsidiesType() ? billInfoEo.getSubsidiesType() : 0) && CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("non_national_supplement")) {
                        this.autoAuditCheck(billInfoEo, billItemEoList, billStrategyRespDto, contentDto);
                    }
                }
            }
        }
        billInfoEo.setAgainBillRedBillFlowNo(respDto.getRedBillFlowNo());
        this.billInfoDas.updateSelective((BaseEo)billInfoEo);
        this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(billInfoEo.getPlatformOrderNo().split(",")), billInfoEo.getBillFlowNo(), RelBusinessTypeEnum.INVOICE.getCode());
        this.billInfoService.syncAddKingdeeInvoice(billInfoEo, billItemEoList, respDto.getReopenIsBill());
    }

    private BillInvoiceRemarkContentDto getInvoiceRemarkContentDto(BillInfoEo billInfoEo, PerformOrderInfoDto performOrderInfoDto, String skuCode) {
        BillInvoiceRemarkContentDto contentDto = new BillInvoiceRemarkContentDto();
        if (null != billInfoEo.getSubsidiesType() && 1 == billInfoEo.getSubsidiesType()) {
            InvoiceRemarkContentReqDto reqDto = new InvoiceRemarkContentReqDto();
            reqDto.setPlatformOrderNo(performOrderInfoDto.getPlatformOrderNo());
            reqDto.setShopCode(billInfoEo.getShopCode());
            reqDto.setSkuCode(skuCode);
            List orderAddrDtoList = performOrderInfoDto.getPerformOrderAddrDtoList();
            reqDto.setProvince(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderAddrDtoList) ? ((DgPerformOrderAddrDto)orderAddrDtoList.get(0)).getProvince() : null);
            reqDto.setProvinceCode(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderAddrDtoList) ? ((DgPerformOrderAddrDto)orderAddrDtoList.get(0)).getProvinceCode() : null);
            reqDto.setCity(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderAddrDtoList) ? ((DgPerformOrderAddrDto)orderAddrDtoList.get(0)).getCity() : null);
            reqDto.setCityCode(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderAddrDtoList) ? ((DgPerformOrderAddrDto)orderAddrDtoList.get(0)).getCityCode() : null);
            reqDto.setCounty(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderAddrDtoList) ? ((DgPerformOrderAddrDto)orderAddrDtoList.get(0)).getCounty() : null);
            reqDto.setCountyCode(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderAddrDtoList) ? ((DgPerformOrderAddrDto)orderAddrDtoList.get(0)).getCountyCode() : null);
            contentDto = this.remarkRuleService.matchInvoiceRemark(reqDto, billInfoEo);
            logger.info("\u5339\u914d\u5230\u7684\u53d1\u7968\u5907\u6ce8\u4fe1\u606f\uff1a{}\uff0c{}", (Object)performOrderInfoDto.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)contentDto));
        }
        return contentDto;
    }

    public void assembleFreightCostItem(BillStrategyRespDto billStrategyRespDto, List<PerformOrderItemDto> itemList, List<PerformOrderItemDto> zeroNumItemList) {
        ArrayList<String> skuCode = new ArrayList<String>();
        skuCode.add(billStrategyRespDto.getFreightCostItemCode());
        List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCode);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemSkuDgDtoList)) {
            ItemSkuDgDto itemSkuDgDto = itemSkuDgDtoList.get(0);
            PerformOrderItemDto performOrderItemDto = new PerformOrderItemDto();
            performOrderItemDto.setGift(Integer.valueOf(0));
            performOrderItemDto.setItemId(itemSkuDgDto.getItemDgDto().getId());
            performOrderItemDto.setItemCode(itemSkuDgDto.getItemDgDto().getCode());
            performOrderItemDto.setItemName(itemSkuDgDto.getItemDgDto().getName());
            performOrderItemDto.setSkuCode(itemSkuDgDto.getCode());
            performOrderItemDto.setSkuId(itemSkuDgDto.getId());
            performOrderItemDto.setSkuName(itemSkuDgDto.getName());
            performOrderItemDto.setItemNum(BigDecimal.ONE);
            BigDecimal realPayAmount = zeroNumItemList.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal refundedPayAmount = zeroNumItemList.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundedPayAmount = refundedPayAmount.abs();
            BigDecimal amount = realPayAmount.subtract(refundedPayAmount);
            performOrderItemDto.setRefundedPayAmount(BigDecimal.ZERO);
            performOrderItemDto.setSurplusCanRefundPayAmount(amount);
            performOrderItemDto.setSalePrice(amount);
            performOrderItemDto.setRealPayAmount(amount);
            performOrderItemDto.setPayAmount(amount);
            itemList.add(performOrderItemDto);
            logger.info("\u552e\u540e\u91cd\u65b0\u751f\u6210\u8ba2\u5355\u6570\u91cf\u9000\u8d27\u5b8c\u6210\u91d1\u989d\u4e0d\u4e3a\u96f6\u5f00\u7968\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderItemDto));
        }
    }

    public void autoAuditCheck(BillInfoEo billInfoEo, List<BillItemEo> billItemEoList, BillStrategyRespDto billStrategyRespDto, BillInvoiceRemarkContentDto contentDto) {
        List collect;
        logger.info("\u81ea\u52a8\u5ba1\u6838\u5f00\u59cbautoAuditCheck:{}", (Object)JSONObject.toJSONString((Object)billInfoEo));
        BillEntityEo billEntityEo = new BillEntityEo();
        if (null != billInfoEo.getEntityId()) {
            billEntityEo = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)billInfoEo.getEntityId())).one();
        }
        ArrayList<String> errorList = new ArrayList<String>();
        AtomicBoolean flag = new AtomicBoolean(true);
        ArrayList<String> billType = new ArrayList<String>();
        billType.add(BillInfoColourTypeEnum.RED_TICKET.getCode());
        billType.add(BillInfoColourTypeEnum.CANCEL_TICKET.getCode());
        List billInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).in((Object)"bill_type", billType)).eq((Object)"all_red_flag", (Object)AllRedFlagEnum.YES_ALL_RED_FLAG.getCode())).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEos) && org.apache.commons.collections.CollectionUtils.isNotEmpty(collect = billInfoEos.stream().filter(x -> x.getInvoiceState().equals(InvoiceStateEnum.WAIT_AUDIT.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.WAIT_BILL.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.INVOICING.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.FAILED.getCode())).collect(Collectors.toList()))) {
            errorList.add("\u5b58\u5728\u7ea2\u7968\u672a\u5f00\u7968\u6210\u529f\uff0c\u84dd\u7968\u65e0\u6cd5\u5ba1\u6838\u901a\u8fc7");
            flag.set(false);
        }
        logger.info("\u547d\u4e2d\u56fd\u8865\u62ac\u5934\u9ed1\u540d\u5355\u6821\u9a8cnational_supplement:{}", (Object)JSONObject.toJSONString((Object)billStrategyRespDto));
        if (SubsidiesTypeEnum.COUNTRY_SUBSIDIES.getCode().equals(billInfoEo.getSubsidiesType())) {
            logger.info("\u62ac\u5934\u9ed1\u540d\u5355\u6821\u9a8cgetUseBlackList,getBlackListContent:{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)billStrategyRespDto));
            logger.info("\u62ac\u5934billTitle,blackListContent:{},{}", (Object)billInfoEo.getBillTitle(), (Object)billStrategyRespDto.getBlackListContent());
            if (BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(billInfoEo.getBillType()) && StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getUseBlackList()) && UseBlackListEnum.YES.getCode().equals(billStrategyRespDto.getUseBlackList()) && StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getBlackListContent()) && (billInfoEo.getBillTitle().contains(billStrategyRespDto.getBlackListContent()) || billStrategyRespDto.getBlackListContent().contains(billInfoEo.getBillTitle()))) {
                errorList.add("\u547d\u4e2d\u56fd\u8865\u62ac\u5934\u9ed1\u540d\u5355");
                flag.set(false);
            }
            logger.info("\u53d1\u7968\u5907\u6ce8\u5339\u914d\u6821\u9a8c:{}", (Object)JSONObject.toJSONString((Object)contentDto));
            if (null != contentDto && !contentDto.getMatch().booleanValue() && "1".equals(contentDto.getWhether())) {
                errorList.add(contentDto.getMessage());
                flag.set(false);
            }
        }
        if (BillInfoTypeEnum.ELECTRONIC_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getEleComInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getEleComInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.PAPER_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getPapComInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getPapComInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getPapSpeInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getPapSpeInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ALL_ELECTRONIC_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getAllEleComInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getAllEleComInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getAllEleSpeInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getAllEleSpeInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getEleSpeInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getEleSpeInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoEo.getBillPersonPhone()) && !billInfoEo.getBillPersonPhone().matches("1[0-9]\\d{9}")) {
            errorList.add("\u6536\u7968\u4eba\u7535\u8bdd\u53f7\u586b\u5199\u9519\u8bef");
            flag.set(false);
        }
        if (BigDecimal.ZERO.compareTo(billInfoEo.getInvoiceAmount()) >= 0) {
            errorList.add("\u53d1\u7968\u603b\u91d1\u989d\u4e3a\u96f6");
            flag.set(false);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billItemEoList)) {
            billItemEoList.forEach(item -> {
                if (StringUtils.isEmpty((CharSequence)item.getTaxClassificationCode())) {
                    errorList.add(String.format("\u5546\u54c1%s\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a", item.getItemCode()));
                    flag.set(false);
                }
                if (null == item.getTaxRate() || BigDecimal.ZERO.compareTo(item.getTaxRate()) == 0) {
                    errorList.add(String.format("\u5546\u54c1%s\u7a0e\u7387\u4e3a\u7a7a", item.getItemCode()));
                    flag.set(false);
                }
                if (StringUtils.isBlank((CharSequence)item.getBillLineItemName())) {
                    errorList.add(String.format("\u5546\u54c1%s\u53d1\u7968\u884c\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a", item.getItemCode()));
                    flag.set(false);
                }
            });
        } else {
            errorList.add("\u5546\u54c1\u660e\u7ec6\u4e3a\u7a7a");
            flag.set(false);
        }
        if (flag.get()) {
            billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_BILL.getCode());
            billInfoEo.setAuditTime(new Date());
            billInfoEo.setAuditPerson(this.context.userName());
        } else {
            billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
            billInfoEo.setAuditTime(new Date());
            billInfoEo.setAuditPerson(this.context.userName());
            billInfoEo.setAuditFailReason(String.join((CharSequence)";", errorList));
        }
    }

    public void getShopAllElectricInfo(BillInfoEo billInfoEo) {
        logger.info("\u67e5\u8be2\u662f\u5426\u4e3a\u5168\u7535\u5e97\u94fa:{}", (Object)billInfoEo.getShopCode());
        if (StringUtils.isNotBlank((CharSequence)billInfoEo.getShopCode())) {
            List list = ((ExtQueryChainWrapper)this.billAllElectricShopDas.filter().eq((Object)"shop_code", (Object)billInfoEo.getShopCode())).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                logger.info("\u5168\u7535\u5e97\u94fa\u66f4\u65b0\u53d1\u7968\u7c7b\u578b");
                switch (billInfoEo.getInvoiceType()) {
                    case "electronic_general_invoice": 
                    case "paper_general_invoice": 
                    case "all_electronic_general_invoice": {
                        billInfoEo.setInvoiceType(BillInfoTypeEnum.ALL_ELECTRONIC_GENERAL_INVOICE.getCode());
                        break;
                    }
                    case "special_paper_invoice": 
                    case "all_electronic_special_invoice": 
                    case "electronic_special_invoice": {
                        billInfoEo.setInvoiceType(BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode());
                        break;
                    }
                }
            }
        } else {
            logger.info("\u53d1\u7968\u5e97\u94fa\u4e3a\u7a7a");
        }
    }

    public void getOrderItemInvoice(Map<String, ItemSkuDgDto> itemCodeMap, ItemRateDgDto itemRateDgDto, PerformOrderItemDto performOrderItemDto, BillItemEo billItemEo, BillStrategyRespDto billStrategyRespDto) {
        String itemDisplayName;
        ItemSkuDgDto itemSkuDgDto;
        if (itemCodeMap.containsKey(performOrderItemDto.getSkuCode())) {
            itemSkuDgDto = itemCodeMap.get(performOrderItemDto.getSkuCode());
            billItemEo.setItemShortName(itemSkuDgDto.getName());
            billItemEo.setPatentName(itemSkuDgDto.getName());
            billItemEo.setSpecification(itemSkuDgDto.getSpecModel());
        }
        if (null != itemRateDgDto && null != itemRateDgDto.getId()) {
            billItemEo.setTaxRate(itemRateDgDto.getRate());
            billItemEo.setTaxClassificationCode(itemRateDgDto.getCode());
            billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
            if ("type_commodity".equals(billStrategyRespDto.getBillRowName())) {
                itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                billItemEo.setBillLineItemName(itemDisplayName);
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                if (itemCodeMap.containsKey(performOrderItemDto.getSkuCode())) {
                    itemSkuDgDto = itemCodeMap.get(performOrderItemDto.getSkuCode());
                    billItemEo.setBillLineItemName(itemSkuDgDto.getName());
                }
            } else {
                billItemEo.setBillLineItemName(performOrderItemDto.getSkuName());
            }
        } else {
            if (null != billStrategyRespDto.getTaxRate()) {
                billItemEo.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
            }
            if ("commodity".equals(billStrategyRespDto.getBillRowName())) {
                billItemEo.setBillLineItemName(performOrderItemDto.getSkuName());
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                if (itemCodeMap.containsKey(performOrderItemDto.getSkuCode())) {
                    itemSkuDgDto = itemCodeMap.get(performOrderItemDto.getSkuCode());
                    billItemEo.setBillLineItemName(itemSkuDgDto.getName());
                }
            } else {
                itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                billItemEo.setBillLineItemName(itemDisplayName);
            }
            billItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
        }
    }

    public BigDecimal whetherMergeItem(List<PerformOrderItemDto> whetherMergeItem, BillInfoEo billInfoEo, List<BillItemEo> billItemEoList, BillStrategyRespDto billStrategyRespDto) {
        logger.info("\u7ec4\u5408\u5546\u54c1\u5408\u5e76:{}", (Object)JSON.toJSONString(whetherMergeItem));
        Map<String, List<PerformOrderItemDto>> listMap = whetherMergeItem.stream().collect(Collectors.groupingBy(PerformOrderItemDto::getGroupSkuCode));
        List<String> skuCodeList = whetherMergeItem.stream().map(PerformOrderItemDto::getSkuCode).distinct().collect(Collectors.toList());
        List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCodeList);
        Map<String, ItemSkuDgDto> skuCodeMap = ((List)Optional.ofNullable(itemSkuDgDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
        AtomicReference<BigDecimal> number = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        listMap.forEach((k, v) -> {
            BillItemEo billItemEo = new BillItemEo();
            PerformOrderItemDto saleOrderItemExtRespDto = (PerformOrderItemDto)v.get(0);
            billItemEo.setGift(saleOrderItemExtRespDto.getGift());
            billItemEo.setItemId(saleOrderItemExtRespDto.getGroupItemId());
            billItemEo.setItemCode(saleOrderItemExtRespDto.getGroupSkuCode());
            billItemEo.setQuantity(v.stream().map(PerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            billItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
            BigDecimal payAmount = v.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal refundedPayAmount = v.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundedPayAmount = refundedPayAmount.abs();
            BigDecimal amount = payAmount.subtract(refundedPayAmount);
            billItemEo.setAmount(amount);
            billItemEo.setClinchDealAmount(amount);
            number.set(((BigDecimal)number.get()).add(amount));
            billItemEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
            ArrayList patentNameList = new ArrayList();
            ArrayList itemNameList = new ArrayList();
            AtomicReference<ItemRateDgDto> itemRateDgDto = new AtomicReference<ItemRateDgDto>(new ItemRateDgDto());
            v.forEach(item -> {
                if (skuCodeMap.containsKey(item.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(item.getSkuCode());
                    patentNameList.add(itemSkuDgDto.getName());
                    itemNameList.add(itemSkuDgDto.getName());
                    if (null != itemSkuDgDto.getItemRateDgDto() && null != itemSkuDgDto.getItemRateDgDto().getId()) {
                        itemRateDgDto.set(itemSkuDgDto.getItemRateDgDto());
                    }
                }
            });
            String patentName = patentNameList.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining(";"));
            String itemName = itemNameList.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining("+"));
            billItemEo.setItemName(itemName);
            billItemEo.setItemShortName(saleOrderItemExtRespDto.getGroupItemName());
            billItemEo.setPatentName(patentName);
            if (null != itemRateDgDto.get() && null != itemRateDgDto.get().getId()) {
                ItemRateDgDto itemRateDgEo = itemRateDgDto.get();
                billItemEo.setTaxRate(itemRateDgEo.getRate());
                billItemEo.setTaxClassificationCode(itemRateDgEo.getCode());
                billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
                if ("type_commodity".equals(billStrategyRespDto.getBillRowName())) {
                    String itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                    billItemEo.setBillLineItemName(itemDisplayName);
                } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                    if (skuCodeMap.containsKey(saleOrderItemExtRespDto.getSkuCode())) {
                        ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(saleOrderItemExtRespDto.getSkuCode());
                        billItemEo.setBillLineItemName(itemSkuDgDto.getName());
                    } else {
                        billItemEo.setBillLineItemName(String.join((CharSequence)"+", itemNameList));
                    }
                } else {
                    if (null != billStrategyRespDto.getTaxRate()) {
                        billItemEo.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                        billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
                    }
                    if ("commodity".equals(billStrategyRespDto.getBillRowName())) {
                        billItemEo.setBillLineItemName(String.join((CharSequence)"+", itemNameList));
                    } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                        if (skuCodeMap.containsKey(saleOrderItemExtRespDto.getSkuCode())) {
                            ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(saleOrderItemExtRespDto.getSkuCode());
                            billItemEo.setBillLineItemName(itemSkuDgDto.getName());
                        }
                    } else {
                        String itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                        billItemEo.setBillLineItemName(itemDisplayName);
                    }
                    billItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
                }
                billItemEo.setUnitPrice(billItemEo.getAmount().divide(billItemEo.getQuantity(), 2, RoundingMode.HALF_UP));
                billItemEo.setUnit(saleOrderItemExtRespDto.getCalcUnitDesc());
                billItemEoList.add(billItemEo);
            }
        });
        this.addBillOrderItem(whetherMergeItem, billInfoEo, skuCodeMap, billStrategyRespDto);
        return number.get();
    }

    public void addBillOrderItem(List<PerformOrderItemDto> saleOrderItemExtRespDtoList, BillInfoEo billInfoEo, Map<String, ItemSkuDgDto> skuCodeMap, BillStrategyRespDto billStrategyRespDto) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleOrderItemExtRespDtoList)) {
            List platformOrderInfos = ((ExtQueryChainWrapper)this.iPerformOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).list();
            ArrayList billOrderItemEoList = new ArrayList();
            saleOrderItemExtRespDtoList.forEach(itemDto -> {
                BillOrderItemEo billOrderItemEo = new BillOrderItemEo();
                billOrderItemEo.setGift(itemDto.getGift());
                if (3 == itemDto.getGift()) {
                    billOrderItemEo.setGift(Integer.valueOf(0));
                    billOrderItemEo.setFreightCost(Integer.valueOf(1));
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)platformOrderInfos)) {
                    PerformOrderInfoEo platformOrderInfo = (PerformOrderInfoEo)platformOrderInfos.get(0);
                    billOrderItemEo.setOrderType(platformOrderInfo.getOrderType());
                }
                billOrderItemEo.setItemId(itemDto.getSkuId());
                billOrderItemEo.setItemCode(itemDto.getSkuCode());
                billOrderItemEo.setItemName(itemDto.getSkuName());
                billOrderItemEo.setQuantity(itemDto.getItemNum());
                billOrderItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
                BigDecimal payAmount = itemDto.getRealPayAmount();
                BigDecimal refundedPayAmount = itemDto.getRefundedPayAmount();
                refundedPayAmount = refundedPayAmount.abs();
                BigDecimal amount = payAmount.subtract(refundedPayAmount);
                billOrderItemEo.setAmount(amount);
                billOrderItemEo.setClinchDealAmount(amount);
                billOrderItemEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
                if (skuCodeMap.containsKey(itemDto.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(itemDto.getSkuCode());
                    billOrderItemEo.setSpecification(itemSkuDgDto.getSpecModel());
                    billOrderItemEo.setThirdCode(itemSkuDgDto.getThirdCode());
                    billOrderItemEo.setEnergyEfficiencyRating(itemSkuDgDto.getEnergyEfficiencyRating());
                    billOrderItemEo.setSpecialInvoiceRemark(itemSkuDgDto.getSpecialInvoiceRemark());
                    billOrderItemEo.setEnergyEfficiencySpecModel(itemSkuDgDto.getEnergyEfficiencySpecModel());
                    this.assembleBillOrderItemInfo((PerformOrderItemDto)itemDto, itemSkuDgDto.getItemRateDgDto(), itemSkuDgDto, billStrategyRespDto, billOrderItemEo);
                }
                billOrderItemEo.setUnitPrice(itemDto.getSalePrice());
                billOrderItemEo.setUnit("\u53f0");
                billOrderItemEo.setOrderItemId(itemDto.getId());
                billOrderItemEo.setGroupItemName(itemDto.getGroupItemName());
                billOrderItemEo.setGroupSkuCode(itemDto.getGroupSkuCode());
                billOrderItemEo.setPlatformItemCode(itemDto.getPlatformItemCode());
                billOrderItemEo.setPlatformItemName(itemDto.getPlatformItemName());
                billOrderItemEo.setRefundedItemNum(itemDto.getRefundedItemNum());
                billOrderItemEo.setRefundedPayAmount(itemDto.getRefundedPayAmount());
                billOrderItemEo.setSurplusCanRefundPayAmount(itemDto.getSurplusCanRefundPayAmount());
                billOrderItemEoList.add(billOrderItemEo);
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billOrderItemEoList)) {
                this.billOrderItemDas.insertBatch(billOrderItemEoList);
            }
        }
    }

    public void assembleBillOrderItemInfo(PerformOrderItemDto performOrderItemDto, ItemRateDgDto itemRateDgDto, ItemSkuDgDto itemSkuDgDto, BillStrategyRespDto billStrategyRespDto, BillOrderItemEo billOrderItemEo) {
        if (null != itemRateDgDto && null != itemRateDgDto.getId()) {
            billOrderItemEo.setTaxRate(itemRateDgDto.getRate());
            billOrderItemEo.setTaxClassificationCode(itemRateDgDto.getCode());
            billOrderItemEo.setTaxAmount(billOrderItemEo.getAmount().divide(billOrderItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billOrderItemEo.getTaxRate()).setScale(2, 4));
            if ("type_commodity".equals(billStrategyRespDto.getBillRowName())) {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billOrderItemEo.getItemName()) ? "" : billOrderItemEo.getItemName();
                billOrderItemEo.setBillLineItemName(itemDisplayName);
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                billOrderItemEo.setBillLineItemName(itemSkuDgDto.getName());
            } else {
                billOrderItemEo.setBillLineItemName(performOrderItemDto.getSkuName());
            }
        } else {
            if (null != billStrategyRespDto.getTaxRate()) {
                billOrderItemEo.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                billOrderItemEo.setTaxAmount(billOrderItemEo.getAmount().divide(billOrderItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billOrderItemEo.getTaxRate()).setScale(2, 4));
            }
            if ("commodity".equals(billStrategyRespDto.getBillRowName())) {
                billOrderItemEo.setBillLineItemName(performOrderItemDto.getSkuName());
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                billOrderItemEo.setBillLineItemName(itemSkuDgDto.getName());
            } else {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billOrderItemEo.getItemName()) ? "" : billOrderItemEo.getItemName();
                billOrderItemEo.setBillLineItemName(itemDisplayName);
            }
            billOrderItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
        }
    }

    private void platformGenerateInvoicing(List<PerformOrderInfoDto> performOrderInfoDtoList, BillInfoEo billInfo, BillApplyEo billApplyEo, boolean consistency) {
        PerformOrderInfoDto performOrderInfoDto = performOrderInfoDtoList.get(0);
        List collect = performOrderInfoDtoList.stream().filter(x -> null != x.getSubsidiesType() && 1 == x.getSubsidiesType()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            performOrderInfoDto.setSubsidiesType(Integer.valueOf(1));
        }
        String billFlowNo = this.generateCodeDataUtils.generateNo("KP");
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setBillFlowNo(billFlowNo);
        this.getBillItem(billInfo, billApplyEo, billInfoEo, performOrderInfoDto);
        ArrayList<PerformOrderItemDto> itemList = new ArrayList<PerformOrderItemDto>();
        ArrayList<PerformOrderItemDto> zeroNumItemList = new ArrayList<PerformOrderItemDto>();
        ArrayList<BillItemEo> billItemEoList = new ArrayList<BillItemEo>();
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(billInfoEo.getShopCode(), StrategyTypeEnum.ORDINARY_BILL.getCode());
        if (Objects.isNull(billStrategyRespDto) || null == billStrategyRespDto.getId()) {
            logger.info("\u672a\u83b7\u53d6\u5230\u5e97\u94fa\u5f00\u7968\u7b56\u7565:{}", (Object)billInfoEo.getShopCode());
            return;
        }
        List noInvoiceItemEoList = ((ExtQueryChainWrapper)this.billStrategyNoInvoiceItemDas.filter().eq((Object)"strategy_id", (Object)billStrategyRespDto.getId())).list();
        Map itemEoMap = ((List)Optional.ofNullable(noInvoiceItemEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(BillStrategyNoInvoiceItemEo::getItemCode, Function.identity(), (v1, v2) -> v2));
        String invoiceSaleOrderNo = performOrderInfoDtoList.stream().map(PerformOrderInfoDto::getSaleOrderNo).distinct().collect(Collectors.joining(","));
        billInfoEo.setInvoiceSaleOrderNo(invoiceSaleOrderNo);
        ArrayList billSkuCodeList = new ArrayList();
        performOrderInfoDtoList.forEach(bizSaleOrderRespDto -> {
            logger.info("\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)bizSaleOrderRespDto.getItemDtoList()));
            billSkuCodeList.addAll(bizSaleOrderRespDto.getItemDtoList().stream().map(PerformOrderItemDto::getSkuCode).collect(Collectors.toList()));
            if (this.orderTypeFilter(bizSaleOrderRespDto.getOrderType()).booleanValue()) {
                if (OmsSaleOrderStatus.COMPLETE.getCode().equals(bizSaleOrderRespDto.getOrderStatus()) || OmsSaleOrderStatus.DELIVERED.getCode().equals(bizSaleOrderRespDto.getOrderStatus())) {
                    bizSaleOrderRespDto.getItemDtoList().forEach(item -> this.filterItem((PerformOrderItemDto)item, itemEoMap, billStrategyRespDto, itemList, zeroNumItemList));
                }
            } else {
                logger.info("\u8865\u53d1\u8ba2\u5355\u5546\u54c1\u884c\u4e0d\u8fdb\u884c\u5f00\u7968");
            }
        });
        if (CollectionUtils.isNotEmpty(zeroNumItemList) && StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getFreightCostItemCode())) {
            this.assembleFreightCostItem(billStrategyRespDto, itemList, zeroNumItemList);
        }
        if (CollectionUtils.isEmpty(itemList)) {
            logger.info("\u552e\u540e\u5f00\u7968\u5546\u54c1\u660e\u7ec6\u6ca1\u6709\u53ef\u4ee5\u6b63\u5e38\u5f00\u7968\u6570\u636e\u76f4\u63a5\u8c03\u7528\u53d1\u7968\u4f5c\u5e9f\u63a5\u53e3");
            List billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).list();
            this.billInfoService.redInvoice(billInfoEoList);
            return;
        }
        BigDecimal mergeItemAmount = BigDecimal.ZERO;
        ArrayList<PerformOrderItemDto> noWhetherMergeItem = new ArrayList<PerformOrderItemDto>();
        ArrayList<PerformOrderItemDto> whetherMergeItem = new ArrayList<PerformOrderItemDto>();
        if (1 == billStrategyRespDto.getWhetherMergeItem()) {
            logger.info("\u6839\u636e\u7b56\u7565\u7ec4\u5408\u5546\u54c1\u9700\u8981\u5408\u5e76\u5f00\u7968");
            itemList.forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getGroupSkuCode())) {
                    whetherMergeItem.add((PerformOrderItemDto)item);
                } else {
                    noWhetherMergeItem.add((PerformOrderItemDto)item);
                }
            });
            if (CollectionUtils.isNotEmpty(whetherMergeItem)) {
                mergeItemAmount = this.whetherMergeItem(whetherMergeItem, billInfoEo, billItemEoList, billStrategyRespDto);
            }
        } else {
            CubeBeanUtils.copyCollection(noWhetherMergeItem, itemList, PerformOrderItemDto.class);
        }
        AtomicReference<BigDecimal> number = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        Map<String, List<PerformOrderItemDto>> exchangeItemMap = this.extractExchangeGoods(performOrderInfoDto);
        if (CollectionUtils.isNotEmpty(noWhetherMergeItem)) {
            Map<String, List<PerformOrderItemDto>> orderItemMap = noWhetherMergeItem.stream().collect(Collectors.groupingBy(PerformOrderItemDto::getSkuCode));
            List<String> skuCodeList = noWhetherMergeItem.stream().map(PerformOrderItemDto::getSkuCode).distinct().collect(Collectors.toList());
            if (CollUtil.isNotEmpty(exchangeItemMap)) {
                List skuCodes = exchangeItemMap.values().stream().flatMap(Collection::stream).map(PerformOrderItemDto::getSkuCode).collect(Collectors.toList());
                skuCodeList.addAll(skuCodes);
            }
            List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCodeList);
            Map<String, ItemSkuDgDto> skuCodeMap = ((List)Optional.ofNullable(itemSkuDgDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
            List billItemList = ((ExtQueryChainWrapper)this.billItemDas.filter().eq((Object)"bill_flow_no", (Object)billInfo.getBillFlowNo())).list();
            List<BillItemEo> freightItem = billItemList.stream().filter(item -> Objects.nonNull(item.getFreightCost()) && 1 == item.getFreightCost()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(freightItem)) {
                freightItem.forEach(item -> {
                    item.setId(null);
                    item.setBillFlowNo(billInfoEo.getBillFlowNo());
                    number.set(((BigDecimal)number.get()).add(item.getAmount()));
                    billItemEoList.add((BillItemEo)item);
                });
            }
            Map itemBillMap = billItemList.stream().collect(Collectors.toMap(BillItemEo::getItemCode, Function.identity(), (v1, v2) -> v2));
            orderItemMap.forEach((k, v) -> {
                BillItemEo billItemEo = new BillItemEo();
                PerformOrderItemDto saleOrderItemExtRespDto = (PerformOrderItemDto)v.get(0);
                billItemEo.setItemId(saleOrderItemExtRespDto.getItemId());
                billItemEo.setItemCode(saleOrderItemExtRespDto.getItemCode());
                billItemEo.setItemName(saleOrderItemExtRespDto.getItemName());
                ItemRateDgDto itemRateDgDto = new ItemRateDgDto();
                if (skuCodeMap.containsKey(saleOrderItemExtRespDto.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(saleOrderItemExtRespDto.getSkuCode());
                    billItemEo.setItemName(itemSkuDgDto.getName());
                    billItemEo.setSpecification(itemSkuDgDto.getSpecModel());
                    billItemEo.setThirdCode(itemSkuDgDto.getThirdCode());
                    billItemEo.setEnergyEfficiencyRating(itemSkuDgDto.getEnergyEfficiencyRating());
                    billItemEo.setSpecialInvoiceRemark(itemSkuDgDto.getSpecialInvoiceRemark());
                    billItemEo.setEnergyEfficiencySpecModel(itemSkuDgDto.getEnergyEfficiencySpecModel());
                    billItemEo.setUnit(itemSkuDgDto.getSaleUnitName());
                    itemRateDgDto = itemSkuDgDto.getItemRateDgDto();
                }
                billItemEo.setGift(saleOrderItemExtRespDto.getGift());
                billItemEo.setQuantity(v.stream().map(PerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
                billItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
                BigDecimal payAmount = v.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundedPayAmount = v.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundedPayAmount = refundedPayAmount.abs();
                BigDecimal amount = payAmount.subtract(refundedPayAmount);
                billItemEo.setAmount(amount);
                billItemEo.setClinchDealAmount(amount);
                number.set(((BigDecimal)number.get()).add(billItemEo.getAmount()));
                billItemEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
                billItemEo.setUnitPrice(billItemEo.getAmount().divide(billItemEo.getQuantity(), 2, RoundingMode.HALF_UP));
                if (itemBillMap.containsKey(k)) {
                    BillItemEo oldBillItem = (BillItemEo)itemBillMap.get(k);
                    billItemEo.setItemShortName(oldBillItem.getItemShortName());
                    billItemEo.setPatentName(oldBillItem.getPatentName());
                    billItemEo.setTaxRate(oldBillItem.getTaxRate());
                    billItemEo.setTaxClassificationCode(oldBillItem.getTaxClassificationCode());
                    billItemEo.setTaxAmount(billItemEo.getAmount().divide(oldBillItem.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(oldBillItem.getTaxRate()).setScale(2, 4));
                    billItemEo.setBillLineItemName(oldBillItem.getBillLineItemName());
                    billItemEo.setUnit(oldBillItem.getUnit());
                }
                this.getOrderItemInvoice(skuCodeMap, itemRateDgDto, saleOrderItemExtRespDto, billItemEo, billStrategyRespDto);
                billItemEoList.add(billItemEo);
            });
            this.addBillOrderItem(noWhetherMergeItem, billInfoEo, skuCodeMap, billStrategyRespDto);
        }
        billInfoEo.setInvoiceAmount(number.get().add(mergeItemAmount));
        logger.info("\u552e\u540e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4dplatformGenerateInvoicing==>billInfoEo:{}", (Object)LogUtils.buildLogContent(billInfoEo));
        BillInvoiceRemarkContentDto contentDto = new BillInvoiceRemarkContentDto();
        this.getBillRemark(billStrategyRespDto, billInfoEo, performOrderInfoDto, billItemEoList);
        if (null != billInfoEo.getSubsidiesType() && 1 == billInfoEo.getSubsidiesType() && CollectionUtils.isNotEmpty(billSkuCodeList)) {
            String skuCode = (String)billSkuCodeList.get(0);
            logger.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u83b7\u53d6\u53d1\u7968SKU:{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)skuCode);
            contentDto = this.getInvoiceRemarkContentDto(billInfoEo, performOrderInfoDto, skuCode);
            logger.info("\u6839\u636e\u7b56\u7565\u83b7\u53d6\u5907\u6ce8====>{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)contentDto));
            if (null != contentDto && "1".equals(contentDto.getWhether())) {
                billInfoEo.setInvoiceRemarks(null != contentDto ? contentDto.getResult() : null);
                BillInvoiceRemarkContentDto finalContentDto = contentDto;
                billInfoEo.setRuleCode(finalContentDto.getRuleCode());
                billInfoEo.setRuleName(finalContentDto.getRuleName());
                billInfoEo.setInvoiceRemarkFlag(Integer.valueOf(1));
                if (StringUtils.isNotBlank((CharSequence)finalContentDto.getMessage())) {
                    billInfoEo.setAuditFailReason(finalContentDto.getMessage());
                }
                billItemEoList.forEach(v -> {
                    logger.info("\u53d1\u7968\u884c\u9879\u76ee\u540d\u79f0====>{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)finalContentDto.getItemProjectName());
                    if (StringUtils.isNotBlank((CharSequence)finalContentDto.getItemProjectName())) {
                        String projectName = finalContentDto.getItemProjectName() + v.getBillLineItemName();
                        v.setBillLineItemName(projectName);
                    }
                });
            }
        }
        boolean isConsistency = this.billInfoValidateService.validateBillInfo(billInfoEo.getPlatformOrderNo(), billInfoEo);
        logger.info("\u53d1\u7968\u4fe1\u606f\u4e00\u81f4:{},{}", (Object)isConsistency, (Object)billInfoEo.getPlatformOrderNo());
        if (isConsistency) {
            consistency = true;
            logger.info("\u53d1\u7968\u4fe1\u606f\u4e00\u81f4\uff0c\u4e0d\u751f\u6210\u53d1\u7968\u6570\u636e\uff1a{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)isConsistency);
            logger.info("\u5e73\u53f0\u5355\uff1a\uff1a{},\u53d1\u7968\u4fe1\u606f\uff1a\u5f00\u7968\u91d1\u989d\u3001\u53d1\u7968\u7c7b\u578b\u3001\u62ac\u5934\u3001\u7a0e\u53f7\u3001\u53d1\u7968\u5907\u6ce8\u4e00\u81f4\uff0c\u4e0d\u751f\u6210\u5f00\u7968\u6570\u636e", (Object)billInfoEo.getPlatformOrderNo(), (Object)"\u53d1\u7968\u4fe1\u606f\uff1a\u5f00\u7968\u91d1\u989d\u3001\u53d1\u7968\u7c7b\u578b\u3001\u62ac\u5934\u3001\u7a0e\u53f7\u3001\u53d1\u7968\u5907\u6ce8\u4e00\u81f4\uff0c\u4e0d\u751f\u6210\u5f00\u7968\u6570\u636e");
            return;
        }
        if (CollectionUtils.isEmpty(billItemEoList) || BigDecimalUtils.leZero((BigDecimal)billInfoEo.getInvoiceAmount()).booleanValue()) {
            logger.info("\u552e\u540e\u5f00\u7968\u5546\u54c1\u660e\u7ec6\u6ca1\u6709\u53ef\u4ee5\u6b63\u5e38\u5f00\u7968\u6570\u636e\u76f4\u63a5\u8c03\u7528\u53d1\u7968\u4f5c\u5e9f\u63a5\u53e3\u6216\u8005 \u5f00\u7968\u91d1\u989d\u4e3a0");
            List billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).list();
            this.billInfoService.redInvoice(billInfoEoList);
            return;
        }
        this.getShopAllElectricInfo(billInfoEo);
        this.billInfoService.checkAndSetBlacklist(billInfoEo);
        RedOrderInvoiceAgainBillRespDto respDto = this.billInfoService.redInvoiceIsReopen(billInfoEo);
        this.billInfoDas.insert((BaseEo)billInfoEo);
        if (BillAuditTypeEnum.AUTO_AUDIT.getCode().equals(billStrategyRespDto.getBillAudit()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getBillApplyType())) {
            boolean isAuto = CollectionUtil.isEmpty((Collection)billStrategyRespDto.getCreateTypeList()) || (StrUtil.isNotBlank((CharSequence)billInfoEo.getCreatePerson()) ? billStrategyRespDto.getCreateTypeList().contains("manual") : billStrategyRespDto.getCreateTypeList().contains("sys"));
            logger.info("\u9002\u7528\u56fd\u8865\u8ba2\u5355\u914d\u7f6e\uff1a{},{}", (Object)JSONObject.toJSONString((Object)billStrategyRespDto), (Object)JSONObject.toJSONString((Object)billInfoEo));
            if (null != BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType())) {
                String code = BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType()).getCode();
                if (billStrategyRespDto.getBillApplyType().contains(code) && isAuto) {
                    if (1 == (null != billInfoEo.getSubsidiesType() ? billInfoEo.getSubsidiesType() : 0) && CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("national_supplement")) {
                        this.autoAuditCheck(billInfoEo, billItemEoList, billStrategyRespDto, contentDto);
                    } else if (0 == (null != billInfoEo.getSubsidiesType() ? billInfoEo.getSubsidiesType() : 0) && CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("non_national_supplement")) {
                        this.autoAuditCheck(billInfoEo, billItemEoList, billStrategyRespDto, contentDto);
                    }
                }
            }
        }
        billInfoEo.setAgainBillRedBillFlowNo(respDto.getRedBillFlowNo());
        this.billInfoDas.updateSelective((BaseEo)billInfoEo);
        this.itemGiftGenerateEo(billItemEoList);
        this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(billInfoEo.getPlatformOrderNo().split(",")), billFlowNo, RelBusinessTypeEnum.INVOICE.getCode());
        if (CollectionUtils.isNotEmpty(billItemEoList)) {
            billItemEoList.forEach(a -> {
                a.setId(null);
                this.billInfoService.setSpecialRate(billInfoEo, (BillItemEo)a);
            });
            logger.info("\u552e\u540e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4platformGenerateInvoicing==>billItemEoList:{}", (Object)LogUtils.buildLogContent(billItemEoList));
            this.billItemDas.insertBatch(billItemEoList);
        }
        this.billInfoService.syncAddKingdeeInvoice(billInfoEo, billItemEoList, respDto.getReopenIsBill());
    }

    public void getBillRemark(BillStrategyRespDto billStrategyRespDto, BillInfoEo billInfoEo, PerformOrderInfoDto performOrderInfoDto, List<BillItemEo> billItemEoList) {
        List list;
        if (BillStrategyRemarkType.PLATFORM.containsCode(billStrategyRespDto.getRemark())) {
            billInfoEo.setInvoiceRemarks(performOrderInfoDto.getPlatformOrderNo());
        } else if (BillStrategyRemarkType.PATENT.containsCode(billStrategyRespDto.getRemark())) {
            list = billItemEoList.stream().map(BillItemEo::getPatentName).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            billInfoEo.setInvoiceRemarks(String.join((CharSequence)";", list));
        }
        list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).orderByDesc((Object)"create_time")).list(Integer.valueOf(2));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            String joinRemarks;
            String remarks = StrUtil.isNotBlank((CharSequence)billInfoEo.getInvoiceRemarks()) ? billInfoEo.getInvoiceRemarks() + "," : billInfoEo.getInvoiceRemarks();
            String string = joinRemarks = list.size() > 1 && StrUtil.isBlank((CharSequence)((BillApplyEo)list.get(0)).getRemark()) ? ((BillApplyEo)list.get(1)).getRemark() : ((BillApplyEo)list.get(0)).getRemark();
            if (StrUtil.isNotBlank((CharSequence)joinRemarks)) {
                billInfoEo.setInvoiceRemarks(String.format("%s%s", remarks, joinRemarks));
            }
            billInfoEo.setFileUrl(((BillApplyEo)list.get(0)).getFileUrl());
        }
    }

    public void getBillItem(BillInfoEo billInfo, BillApplyEo billApplyEo, BillInfoEo billInfoEo, PerformOrderInfoDto performOrderInfoDto) {
        billInfoEo.setPlatformOrderNo(billInfo.getPlatformOrderNo());
        billInfoEo.setApplyNo(billApplyEo.getApplyNo());
        billInfoEo.setShopId(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopId());
        billInfoEo.setShopCode(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode());
        ShopEo shopOrganizationCode = this.shopService.selectShopByCode(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode());
        billInfoEo.setOrganizationCode(shopOrganizationCode.getOrganizationCode());
        billInfoEo.setShopName(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopName());
        billInfoEo.setSite(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getSiteName());
        billInfoEo.setSiteCode(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getSiteCode());
        billInfoEo.setCustomerCode(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getHsCustomerCode());
        billInfoEo.setCustomerName(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getHsCustomerName());
        billInfoEo.setBillTitle(billInfo.getBillTitle());
        billInfoEo.setInvoiceType(billInfo.getInvoiceType());
        billInfoEo.setTitleType(billInfo.getTitleType());
        billInfoEo.setTaxesCode(billInfo.getTaxesCode());
        billInfoEo.setRegisteredAddress(billInfo.getRegisteredAddress());
        billInfoEo.setRegisteredPhone(billInfo.getRegisteredPhone());
        billInfoEo.setBankAccount(billInfo.getBankAccount());
        billInfoEo.setBank(billInfo.getBank());
        billInfoEo.setBillPersonPhone(billInfo.getBillPersonPhone());
        billInfoEo.setBillPersonName(billInfo.getBillPersonName());
        billInfoEo.setBillAddress(billInfo.getBillAddress());
        billInfoEo.setDistributorRegisteredAddress(billInfo.getDistributorRegisteredAddress());
        billInfoEo.setDistributorRegisteredPhone(billInfo.getDistributorRegisteredPhone());
        billInfoEo.setDistributorTaxesCode(billInfo.getDistributorTaxesCode());
        billInfoEo.setDistributorBank(billInfo.getDistributorBank());
        billInfoEo.setDistributorBankAccount(billInfo.getDistributorBankAccount());
        billInfoEo.setCollectPerson(billInfo.getCollectPerson());
        billInfoEo.setBillPerson(billInfo.getBillPerson());
        billInfoEo.setReviewPerson(billInfo.getReviewPerson());
        billInfoEo.setCreateType(BillCreateTypeEnum.SYSTEM.getCode());
        billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
        billInfoEo.setEntityId(billInfo.getEntityId());
        billInfoEo.setEntityCode(billInfo.getEntityCode());
        billInfoEo.setEntityName(billInfo.getEntityName());
        billInfoEo.setEnterprise(billInfo.getEnterprise());
        if (BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(billInfo.getInvoiceType())) {
            billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
        }
        billInfoEo.setMailbox(billInfo.getMailbox());
        billInfoEo.setPhone(billInfo.getPhone());
        billInfoEo.setBillChannel(billInfo.getBillChannel());
        billInfoEo.setWhetherMergeBill(billInfo.getWhetherMergeBill());
        billInfoEo.setBillType(BillInfoColourTypeEnum.BLUE_TICKET.getCode());
        billInfoEo.setSubsidiesType(Integer.valueOf(null != performOrderInfoDto.getSubsidiesType() ? performOrderInfoDto.getSubsidiesType() : 0));
        if (StringUtils.isNotBlank((CharSequence)performOrderInfoDto.getPlatformOrderNo())) {
            Integer subsidiesType = this.getSubsidiesType(performOrderInfoDto.getPlatformOrderNo());
            billInfoEo.setSubsidiesType(subsidiesType);
        }
    }

    public void filterItem(PerformOrderItemDto item, Map<String, BillStrategyNoInvoiceItemEo> itemEoMap, BillStrategyRespDto billStrategyRespDto, List<PerformOrderItemDto> itemList, List<PerformOrderItemDto> zeroNumItemList) {
        if (SaleItemStatusEnum.CANCEL.getCode().equals(item.getStatus())) {
            return;
        }
        if (itemEoMap.containsKey(item.getSkuCode())) {
            logger.info("\u6839\u636e\u7b56\u7565\u8be5\u5546\u54c1\u662f\u4e0d\u5f00\u7968\u5546\u54c1:{}", (Object)item.getSkuCode());
            return;
        }
        if (BigDecimal.ZERO.compareTo(item.getRealPayAmount()) == 0 && BigDecimal.ZERO.compareTo(item.getSalePrice()) == 0) {
            logger.info("\u9500\u552e\u5355\u4ef7\u4e3a\u96f6\u8fc7\u6ee4\u4e0d\u5f00\u7968");
            return;
        }
        if (BigDecimal.ZERO.compareTo(item.getRealPayAmount()) == 0 && BigDecimal.ZERO.compareTo(item.getSalePrice()) < 0) {
            item.setGift(Integer.valueOf(1));
        }
        if (BigDecimal.ZERO.compareTo(item.getRealPayAmount()) < 0) {
            item.setGift(Integer.valueOf(0));
        }
        if (Objects.isNull(item.getRefundedItemNum()) || BigDecimal.ZERO.compareTo(item.getRefundedItemNum()) == 0) {
            if (item.getRealPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                if (item.getRealPayAmount().subtract(item.getRefundedPayAmount().abs()).compareTo(BigDecimal.ZERO) > 0) {
                    if ("1".equals(billStrategyRespDto.getBillGift())) {
                        itemList.add(item);
                    } else if (0 == item.getGift()) {
                        itemList.add(item);
                    }
                }
            } else if ("1".equals(billStrategyRespDto.getBillGift())) {
                itemList.add(item);
            } else if (0 == item.getGift()) {
                itemList.add(item);
            }
        } else {
            BigDecimal num = item.getItemNum().subtract(item.getRefundedItemNum().abs());
            if (num.compareTo(BigDecimal.ZERO) > 0) {
                if (item.getRealPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                    if (item.getRealPayAmount().subtract(item.getRefundedPayAmount().abs()).compareTo(BigDecimal.ZERO) > 0) {
                        if ("1".equals(billStrategyRespDto.getBillGift())) {
                            item.setItemNum(num);
                            itemList.add(item);
                        } else if (0 == item.getGift()) {
                            item.setItemNum(num);
                            itemList.add(item);
                        }
                    }
                } else if ("1".equals(billStrategyRespDto.getBillGift())) {
                    item.setItemNum(num);
                    itemList.add(item);
                } else if (0 == item.getGift()) {
                    item.setItemNum(num);
                    itemList.add(item);
                }
            } else if (item.getRealPayAmount().subtract(item.getRefundedPayAmount().abs()).compareTo(BigDecimal.ZERO) > 0) {
                item.setItemNum(num);
                zeroNumItemList.add(item);
            }
        }
    }

    public void addInvoice(BillInfoEo billInfoEo, List<BillItemEo> billItemEoList) {
        logger.info("\u552e\u540e\u5355\u5b8c\u6210\u8ba2\u5355\u91cd\u65b0\u5f00\u7968:{}\uff0c{}", (Object)JSONObject.toJSONString((Object)billInfoEo), (Object)JSONObject.toJSONString(billItemEoList));
    }

    public String uploadPdfUrl(String billFlowNo, String pdfUrl) {
        if (StrUtil.isBlank((CharSequence)pdfUrl)) {
            return null;
        }
        String fileName = String.format("billInfo-billFlowNo-%s.pdf", billFlowNo);
        String dateForm = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        String path = MessageFormat.format(String.format("{0}/{1}/%s", fileName), "invoice", dateForm);
        String url = null;
        try {
            InputStream pdfInputStream = this.getPdfInputStream(pdfUrl);
            this.objectStorageService.put(this.bucketName, path, pdfInputStream);
            url = this.objectStorageService.getFileUrlWithQureyParamter(path, 1200);
            return url.substring(0, url.indexOf("?")).replace("invoice", this.ossRegistryVo.getDir() + "invoice");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private InputStream getPdfInputStream(String pdfUrl) {
        URL source = null;
        try {
            source = new URL(pdfUrl);
            URLConnection connection = source.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            InputStream input = connection.getInputStream();
            return input;
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public Boolean orderTypeFilter(String orderType) {
        if (SaleOrderTypeEnum.CONSIGNMENT_NOT_BACK.getType().equals(orderType) || SaleOrderTypeEnum.CONSIGNMENT_BACK.getType().equals(orderType) || SaleOrderTypeEnum.PROXY_SALE.getType().equals(orderType) || SaleOrderTypeEnum.GIFT_ORDER.getType().equals(orderType) || SaleOrderTypeEnum.SHIPMENT_CLAIM_ORDER.getType().equals(orderType)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void itemGiftGenerateEo(List<BillItemEo> itemList) {
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        ArrayList itemGiftList = Lists.newArrayList();
        for (BillItemEo orderItem : itemList) {
            BigDecimal salePrice;
            if (!Objects.equals(1, orderItem.getGift()) || BigDecimalUtils.gtZero((BigDecimal)orderItem.getAmount()).booleanValue() || BigDecimalUtils.leZero((BigDecimal)(salePrice = orderItem.getUnitPrice())).booleanValue()) continue;
            orderItem.setAmount(salePrice.multiply(orderItem.getQuantity()));
            BillItemEo itemGiftSalePrice = (BillItemEo)BeanUtil.copyProperties((Object)orderItem, BillItemEo.class, (String[])new String[0]);
            itemGiftSalePrice.setAmount(orderItem.getAmount().negate());
            itemGiftList.add(itemGiftSalePrice);
        }
        if (CollUtil.isNotEmpty((Collection)itemGiftList)) {
            logger.info("\u751f\u6210\u8d60\u54c1\u8d1f\u6570\u884c\uff1a{}", (Object)JSON.toJSONString((Object)itemGiftList));
            itemList.addAll(itemGiftList);
        }
    }

    public Boolean costProjectFilter(String afterSaleOrderNo) {
        return true;
    }

    private BillItemEo handlerExchangeGoods(Map<String, ItemSkuDgDto> skuCodeMap, BillItemEo billItemEo, List<PerformOrderItemDto> performOrderItemDtos) {
        if (CollectionUtils.isEmpty(performOrderItemDtos)) {
            return null;
        }
        PerformOrderItemDto orderItemDto = performOrderItemDtos.get(0);
        billItemEo.setAmount(billItemEo.getAmount().subtract(orderItemDto.getRefundedPayAmount()));
        billItemEo.setQuantity(billItemEo.getQuantity().subtract(orderItemDto.getRefundedItemNum()));
        BillItemEo exchangeItemEo = new BillItemEo();
        PerformOrderItemDto saleOrderItemExtRespDto = performOrderItemDtos.get(1);
        exchangeItemEo.setItemId(saleOrderItemExtRespDto.getItemId());
        exchangeItemEo.setItemCode(saleOrderItemExtRespDto.getItemCode());
        exchangeItemEo.setItemName(saleOrderItemExtRespDto.getItemName());
        exchangeItemEo.setUnitPrice(saleOrderItemExtRespDto.getSalePrice());
        exchangeItemEo.setGift(saleOrderItemExtRespDto.getGift());
        exchangeItemEo.setQuantity(saleOrderItemExtRespDto.getItemNum());
        exchangeItemEo.setBillFlowNo(billItemEo.getBillFlowNo());
        exchangeItemEo.setAmount(saleOrderItemExtRespDto.getRealPayAmount());
        exchangeItemEo.setClinchDealAmount(exchangeItemEo.getAmount());
        if (skuCodeMap.containsKey(saleOrderItemExtRespDto.getSkuCode())) {
            ItemSkuDgDto itemSkuDgDto = skuCodeMap.get(saleOrderItemExtRespDto.getSkuCode());
            exchangeItemEo.setItemName(itemSkuDgDto.getName());
            exchangeItemEo.setSpecification(itemSkuDgDto.getSpecModel());
            exchangeItemEo.setUnit(itemSkuDgDto.getSaleUnitName());
            ItemRateDgDto itemRateDgDto = itemSkuDgDto.getItemRateDgDto();
            exchangeItemEo.setItemShortName(itemRateDgDto.getName());
            exchangeItemEo.setPatentName(itemSkuDgDto.getPatentCode());
            exchangeItemEo.setTaxRate(itemRateDgDto.getRate());
            exchangeItemEo.setTaxClassificationCode(itemRateDgDto.getCode());
            exchangeItemEo.setTaxAmount(billItemEo.getAmount().divide(itemRateDgDto.getRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(itemRateDgDto.getRate()).setScale(2, 4));
            exchangeItemEo.setBillLineItemName(itemRateDgDto.getName());
        }
        if (BigDecimalUtils.gtZero((BigDecimal)exchangeItemEo.getAmount()).booleanValue() && BigDecimalUtils.gtZero((BigDecimal)exchangeItemEo.getQuantity()).booleanValue()) {
            exchangeItemEo.setUnitPrice(exchangeItemEo.getAmount().divide(exchangeItemEo.getQuantity(), 2, RoundingMode.HALF_UP));
        }
        return exchangeItemEo;
    }

    private Map<String, List<PerformOrderItemDto>> extractExchangeGoods(PerformOrderInfoDto performOrderInfoDto) {
        AfterSaleOrderEo orderEo = (AfterSaleOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iAfterSaleOrderDomain.filter().eq((Object)"after_sale_order_type", (Object)"HH")).in((Object)"status", new Object[]{"COMPLETE", "FINISH"})).eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).one();
        if (Objects.isNull(orderEo)) {
            return Collections.emptyMap();
        }
        List list = ((ExtQueryChainWrapper)this.iAfterSaleOrderItemDomain.filter().eq((Object)"after_sale_order_id", (Object)orderEo.getId())).list();
        HashMap<String, List<PerformOrderItemDto>> orderItemMap = new HashMap<String, List<PerformOrderItemDto>>();
        ArrayList<PerformOrderItemDto> orderList = new ArrayList<PerformOrderItemDto>();
        Map exchangeItemMap = list.stream().collect(Collectors.toMap(AfterSaleOrderItemEo::getAfterSaleOrderItemType, Function.identity()));
        AfterSaleOrderItemEo origAfterSaleOrderItemEo = (AfterSaleOrderItemEo)exchangeItemMap.get(0);
        AfterSaleOrderItemEo exChangeItemEo = (AfterSaleOrderItemEo)exchangeItemMap.get(1);
        PerformOrderItemDto orderItemDto = (PerformOrderItemDto)BeanUtil.toBean((Object)origAfterSaleOrderItemEo, PerformOrderItemDto.class);
        orderItemDto.setItemId(origAfterSaleOrderItemEo.getItemId());
        orderItemDto.setItemNum(new BigDecimal(origAfterSaleOrderItemEo.getItemNum()));
        orderItemDto.setSalePrice(origAfterSaleOrderItemEo.getItemPrice());
        orderItemDto.setPayAmount(origAfterSaleOrderItemEo.getPayAmount());
        orderItemDto.setRefundedPayAmount(exChangeItemEo.getRefundAmount());
        orderItemDto.setRefundedItemNum(BigDecimal.valueOf(exChangeItemEo.getDeliverNum().intValue()));
        orderList.add(orderItemDto);
        PerformOrderItemDto exChangeItemDto = (PerformOrderItemDto)BeanUtil.toBean((Object)exChangeItemEo, PerformOrderItemDto.class);
        exChangeItemDto.setItemId(exChangeItemEo.getItemId());
        exChangeItemDto.setItemNum(new BigDecimal(exChangeItemEo.getItemNum()));
        exChangeItemDto.setSalePrice(exChangeItemEo.getItemPrice());
        exChangeItemDto.setPayAmount(exChangeItemEo.getPayAmount());
        exChangeItemDto.setRefundedPayAmount(exChangeItemEo.getRefundAmount());
        exChangeItemDto.setRefundedItemNum(BigDecimal.valueOf(exChangeItemEo.getDeliverNum().intValue()));
        orderList.add(exChangeItemDto);
        orderItemMap.put(orderItemDto.getSkuCode(), orderList);
        return orderItemMap;
    }

    private Integer getSubsidiesType(String platformOrderNo) {
        List collect;
        Integer subsidiesType = 0;
        List performOrderInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).notIn((Object)"order_status", Arrays.asList(OmsSaleOrderStatus.SPLIT.getCode(), OmsSaleOrderStatus.WAIT_CUSTOMER_AUDIT.getCode(), OmsSaleOrderStatus.WAIT_BUSINESS_AUDIT.getCode(), OmsSaleOrderStatus.WAIT_PICK.getCode(), OmsSaleOrderStatus.PICKED.getCode(), OmsSaleOrderStatus.WAIT_DELIVERY.getCode(), OmsSaleOrderStatus.WAIT_ASSIGN.getCode(), OmsSaleOrderStatus.CANCEL.getCode(), OmsSaleOrderStatus.OBSOLETE.getCode(), OmsSaleOrderStatus.LACK.getCode()))).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)performOrderInfoEos) && CollectionUtils.isNotEmpty(collect = performOrderInfoEos.stream().filter(x -> null != x.getSubsidiesType() && 1 == x.getSubsidiesType()).collect(Collectors.toList()))) {
            subsidiesType = 1;
        }
        return subsidiesType;
    }
}

