/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.mq;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillOrderItemDas;
import com.yunxi.dg.base.center.finance.dto.enums.BillTitleTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.PushPlatformStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderInvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.WhetherMergeBillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.IinvoiceItemsReqDto;
import com.yunxi.dg.base.center.finance.dto.request.IinvoiceUploadReqDto;
import com.yunxi.dg.base.center.finance.dto.request.InvoiceTradeNotiflyDto;
import com.yunxi.dg.base.center.finance.dto.request.PlatformFinanceInfo;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.eo.BillOrderItemEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoService;
import com.yunxi.dg.base.center.finance.service.mq.IWhDgMessageProcessor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="INVOICE_CALLBACK_TAG")
public class KingdeeInvoiceCallbackSyncConsumer
implements IWhDgMessageProcessor<String> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private ILockService iLockService;
    @Resource
    private IBillInfoService billInfoService;
    @Resource
    private IBillItemDas billItemDas;
    @Resource
    private IBillOrderItemDas billOrderItemDas;
    private static final String TABLENAME = "kingdee_invoice_callback_sync";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(String message) {
        BillInfoEo billInfoEo;
        Mutex mutex;
        InvoiceTradeNotiflyDto invoiceTradeNotiflyDto;
        block9: {
            String billFlowNo;
            block8: {
                ServiceContext.getContext().remove("yx.dg.opt.chain.context");
                ServiceContext.getContext().remove("yx.dg.opt.chain.header");
                this.logger.info("[\u5f00\u7968\u7ed3\u679c\u5f02\u6b65\u56de\u8c03]>>>\u5f00\u59cb\u76d1\u542c\u5f00\u7968\u56de\u8c03mq\u6d88\u606f,\u5f00\u59cb\u6267\u884c\u56de\u8c03\u6d41\u7a0b{}", (Object)message);
                invoiceTradeNotiflyDto = (InvoiceTradeNotiflyDto)JSON.parseObject((String)message, InvoiceTradeNotiflyDto.class);
                if (ObjectUtil.isEmpty((Object)invoiceTradeNotiflyDto)) {
                    this.logger.info("[\u5f00\u7968\u7ed3\u679c\u5f02\u6b65\u56de\u8c03\u6570\u636e\u4e3a\u7a7a]>>>\u65f6\u95f4{}", (Object)new Date());
                    return MessageResponse.SUCCESS;
                }
                mutex = null;
                billFlowNo = invoiceTradeNotiflyDto.getTradeId();
                this.logger.info("\u56de\u4f20\u53d1\u7968\u6d41\u6c34\u53f7{}", (Object)billFlowNo);
                if (StringUtils.isBlank((CharSequence)billFlowNo)) {
                    this.logger.info("[\u5f00\u7968\u7ed3\u679c\u5f02\u6b65\u56de\u8c03\u56de\u4f20\u53d1\u7968\u6d41\u6c34\u53f7\u4e3a\u7a7a]>>>\u65f6\u95f4{}", (Object)new Date());
                    return MessageResponse.SUCCESS;
                }
                String key = "kingdee_invoice_callback_sync_" + billFlowNo;
                mutex = this.iLockService.lock(TABLENAME, key, 10, 20, TimeUnit.SECONDS);
                billInfoEo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)billFlowNo)).one();
                if (null != billInfoEo) break block8;
                this.logger.info("[\u5f00\u7968\u7ed3\u679c\u5f02\u6b65\u56de\u8c03]\u8be5\u53d1\u7968\u6570\u636e\u4e0d\u5b58\u5728,\u4e0d\u5141\u8bb8\u7ee7\u7eed\u901a\u77e5:{}", (Object)billFlowNo);
                MessageResponse messageResponse = MessageResponse.SUCCESS;
                this.iLockService.unlock(mutex);
                return messageResponse;
            }
            if (!InvoiceStateEnum.BILLED.getCode().equals(billInfoEo.getInvoiceState())) break block9;
            this.logger.info("[\u5f00\u7968\u7ed3\u679c\u5f02\u6b65\u56de\u8c03]\u8be5\u53d1\u7968\u72b6\u6001\u662f[\u5df2\u5b8c\u6210]\u4e0d\u5141\u8bb8\u91cd\u590d\u901a\u77e5:{}", (Object)billFlowNo);
            MessageResponse messageResponse = MessageResponse.SUCCESS;
            this.iLockService.unlock(mutex);
            return messageResponse;
        }
        try {
            this.updateCallNum(billInfoEo);
            this.callbackInvoice(invoiceTradeNotiflyDto, billInfoEo);
        }
        catch (Exception e) {
            MessageResponse messageResponse;
            try {
                this.logger.info("[\u53d1\u7968\u6d41\u6c34\u53f7]:{}\u5f00\u7968\u5f02\u6b65\u56de\u8c03\u76d1\u542cmq\u901a\u77e5\u540e\u7eed\u6d41\u7a0b\u7ed3\u679c\u5931\u8d25[\u5f02\u5e38\u662f]:{}", (Object)invoiceTradeNotiflyDto.getTradeId(), (Object)JSON.toJSONString((Object)e.getMessage()));
                messageResponse = MessageResponse.ERROR;
            }
            catch (Throwable throwable) {
                this.iLockService.unlock(mutex);
                throw throwable;
            }
            this.iLockService.unlock(mutex);
            return messageResponse;
        }
        this.iLockService.unlock(mutex);
        return MessageResponse.SUCCESS;
    }

    public void updateCallNum(BillInfoEo billInfoEo) {
        BillInfoEo infoEo = new BillInfoEo();
        infoEo.setId(billInfoEo.getId());
        infoEo.setCallbackNum(Integer.valueOf(billInfoEo.getCallbackNum() + 1));
        this.billInfoDas.updateSelective((BaseEo)infoEo);
    }

    @Transactional(rollbackFor={Exception.class})
    public void callbackInvoice(InvoiceTradeNotiflyDto invoiceTradeNotiflyDto, BillInfoEo billInfoEo) {
        if ("2".equals(invoiceTradeNotiflyDto.getInvoiceStatus())) {
            BillInfoEo redBillInfoEo;
            this.billInfoService.updateOrderBillInfo(billInfoEo, SaleOrderInvoiceStateEnum.INVOICED.getCode());
            BillInfoEo infoEo = new BillInfoEo();
            infoEo.setId(billInfoEo.getId());
            infoEo.setInvoiceState(InvoiceStateEnum.BILLED.getCode());
            infoEo.setExtension("");
            infoEo.setInvoiceUrl(invoiceTradeNotiflyDto.getInvoiceUrl());
            infoEo.setExternalInvoiceTime(invoiceTradeNotiflyDto.getFinishTime());
            infoEo.setExternalInvoiceCode(invoiceTradeNotiflyDto.getInvoiceCode());
            infoEo.setExternalInvoiceNo(invoiceTradeNotiflyDto.getInvoiceSerial());
            infoEo.setInvoiceConnectUrl(invoiceTradeNotiflyDto.getDownloadUrl());
            infoEo.setInvoiceContent(invoiceTradeNotiflyDto.getInvoiceContent());
            if (CollectionUtils.isNotEmpty((Collection)invoiceTradeNotiflyDto.getPlatformFinanceInfo())) {
                if (WhetherMergeBillTypeEnum.YES_MERGE.getCode().equals(billInfoEo.getWhetherMergeBill())) {
                    this.updateBillOrderItemInfo(invoiceTradeNotiflyDto, billInfoEo);
                } else {
                    infoEo.setFinanceReceivableNo(((PlatformFinanceInfo)invoiceTradeNotiflyDto.getPlatformFinanceInfo().get(0)).getFinanceReceivableNo());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)billInfoEo.getAgainBillRedBillFlowNo()) && null != (redBillInfoEo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)billInfoEo.getAgainBillRedBillFlowNo())).one())) {
                BillInfoEo redUpdateBillEo = new BillInfoEo();
                redUpdateBillEo.setId(redBillInfoEo.getId());
                redUpdateBillEo.setExtension("");
                redUpdateBillEo.setExternalInvoiceTime(invoiceTradeNotiflyDto.getFinishTime());
                redUpdateBillEo.setInvoiceState(InvoiceStateEnum.BILLED.getCode());
                this.billInfoDas.updateSelective((BaseEo)redUpdateBillEo);
                BillInfoEo ticketBillInfo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)redBillInfoEo.getBlueTicketFlowNo())).one();
                if (null != ticketBillInfo) {
                    BillInfoEo ticketBillInfoEo = new BillInfoEo();
                    ticketBillInfoEo.setId(ticketBillInfo.getId());
                    ticketBillInfoEo.setInvoiceState(InvoiceStateEnum.RED_FLUSH.getCode());
                    this.billInfoDas.updateSelective((BaseEo)ticketBillInfoEo);
                }
            }
            billInfoEo.setInvoiceUrl(invoiceTradeNotiflyDto.getInvoiceUrl());
            billInfoEo.setExternalInvoiceTime(invoiceTradeNotiflyDto.getFinishTime());
            billInfoEo.setExternalInvoiceCode(invoiceTradeNotiflyDto.getInvoiceCode());
            billInfoEo.setExternalInvoiceNo(invoiceTradeNotiflyDto.getInvoiceSerial());
            billInfoEo.setInvoiceConnectUrl(invoiceTradeNotiflyDto.getDownloadUrl());
            billInfoEo.setInvoiceContent(invoiceTradeNotiflyDto.getInvoiceContent());
            this.backPassPlatformInvoice(billInfoEo, infoEo);
            this.billInfoDas.updateSelective((BaseEo)infoEo);
        } else {
            this.logger.info("\u91d1\u8776\u56de\u8c03\u72b6\u6001\u672a\u5904\u7406");
        }
    }

    public void updateBillOrderItemInfo(InvoiceTradeNotiflyDto invoiceTradeNotiflyDto, BillInfoEo billInfoEo) {
        List billOrderItemList = ((ExtQueryChainWrapper)this.billOrderItemDas.filter().eq((Object)"bill_flow_no", (Object)billInfoEo.getBillFlowNo())).select(new String[]{"id,bill_flow_no,platform_order_no"}).list();
        if (CollectionUtils.isNotEmpty((Collection)billOrderItemList)) {
            Map platformFinanceInfoMap = ((List)Optional.ofNullable(invoiceTradeNotiflyDto.getPlatformFinanceInfo()).orElse(new ArrayList())).stream().collect(Collectors.toMap(PlatformFinanceInfo::getPlatformOrderNo, Function.identity(), (v1, v2) -> v1));
            billOrderItemList.forEach(item -> {
                if (platformFinanceInfoMap.containsKey(item.getPlatformOrderNo())) {
                    PlatformFinanceInfo platformFinanceInfo = (PlatformFinanceInfo)platformFinanceInfoMap.get(item.getPlatformOrderNo());
                    BillOrderItemEo billOrderItemEo = new BillOrderItemEo();
                    billOrderItemEo.setId(item.getId());
                    billOrderItemEo.setFinanceReceivableNo(platformFinanceInfo.getFinanceReceivableNo());
                    this.billOrderItemDas.updateSelective((BaseEo)billOrderItemEo);
                }
            });
        }
    }

    public void backPassPlatformInvoice(BillInfoEo billInfoEo, BillInfoEo updateInfoEo) {
        IinvoiceUploadReqDto invoiceInfo = new IinvoiceUploadReqDto();
        this.convertInvoiceInfo(billInfoEo, invoiceInfo);
        this.logger.info("\u53d1\u7968\u56de\u4f20\u5e73\u53f0\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)invoiceInfo));
        try {
            RestResponse restResp = new RestResponse();
            String code = restResp.getResultCode();
            if ("0".equals(code)) {
                updateInfoEo.setPushPlatformState(PushPlatformStateEnum.SUCCESS.getCode());
                updateInfoEo.setPushPlatformError("");
            } else {
                updateInfoEo.setPushPlatformState(PushPlatformStateEnum.FAIL.getCode());
                updateInfoEo.setPushPlatformError(restResp.getResultMsg());
            }
        }
        catch (Exception e) {
            this.logger.info("\u56de\u4f20\u5e73\u53f0\u53d1\u7968\u4fe1\u606f\u5931\u8d25:{}", (Object)e.getMessage());
            updateInfoEo.setPushPlatformState(PushPlatformStateEnum.FAIL.getCode());
            updateInfoEo.setPushPlatformError(e.getMessage());
        }
    }

    public void convertInvoiceInfo(BillInfoEo billInfoEo, IinvoiceUploadReqDto invoiceInfo) {
        this.logger.info("\u8f6c\u6362\u53d1\u7968\u521d\u59cb\u5bf9\u8c61:{}", (Object)JSON.toJSONString((Object)billInfoEo));
        invoiceInfo.setChannelCode(billInfoEo.getSiteCode());
        invoiceInfo.setShopCode(billInfoEo.getShopCode());
        invoiceInfo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
        invoiceInfo.setReceiverTaxNo(billInfoEo.getDistributorTaxesCode());
        invoiceInfo.setReceiverName(billInfoEo.getEnterprise());
        invoiceInfo.setInvoiceCode(billInfoEo.getExternalInvoiceCode());
        invoiceInfo.setInvoiceNo(billInfoEo.getExternalInvoiceNo());
        invoiceInfo.setIvcTitle(billInfoEo.getBillTitle());
        invoiceInfo.setTotalPrice(billInfoEo.getInvoiceAmount());
        invoiceInfo.setInvoiceTime(null != billInfoEo.getExternalInvoiceTime() ? DateUtil.format((Date)billInfoEo.getExternalInvoiceTime(), (String)"yyyy-MM-dd HH:mm:ss") : DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        invoiceInfo.setPdfUrl(billInfoEo.getInvoiceUrl());
        invoiceInfo.setPayerRegisterNo(billInfoEo.getTaxesCode());
        switch (billInfoEo.getInvoiceType()) {
            case "electronic_general_invoice": {
                invoiceInfo.setInvoiceKind(Integer.valueOf(0));
                break;
            }
            case "electronic_special_invoice": {
                invoiceInfo.setInvoiceKind(Integer.valueOf(3));
                break;
            }
            case "paper_general_invoice": {
                invoiceInfo.setInvoiceKind(Integer.valueOf(1));
                break;
            }
            case "special_paper_invoice": {
                invoiceInfo.setInvoiceKind(Integer.valueOf(2));
                break;
            }
            case "all_electronic_general_invoice": {
                invoiceInfo.setInvoiceKind(Integer.valueOf(4));
                break;
            }
            case "all_electronic_special_invoice": {
                invoiceInfo.setInvoiceKind(Integer.valueOf(5));
                break;
            }
        }
        invoiceInfo.setBusinessType(Integer.valueOf(BillTitleTypeEnum.PERSON.getCode().equals(billInfoEo.getTitleType()) ? 0 : 1));
        List itemList = ((ExtQueryChainWrapper)this.billItemDas.filter().eq((Object)"bill_flow_no", (Object)billInfoEo.getBillFlowNo())).list();
        ArrayList invoiceItems = new ArrayList();
        AtomicReference<BigDecimal> sumTax = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        itemList.forEach(item -> {
            IinvoiceItemsReqDto reqDto = new IinvoiceItemsReqDto();
            reqDto.setTaxRate(item.getTaxRate());
            reqDto.setTax(item.getTaxAmount());
            reqDto.setAmount(item.getAmount());
            reqDto.setSumPrice(item.getAmount().subtract(item.getTaxAmount()));
            reqDto.setItemNo(item.getTaxClassificationCode());
            reqDto.setItemName(item.getBillLineItemName());
            reqDto.setPrice(item.getAmount().divide(item.getQuantity(), 6, 1));
            reqDto.setQuantity(null != item.getQuantity() ? Integer.valueOf(item.getQuantity().stripTrailingZeros().toPlainString()) : null);
            sumTax.set(((BigDecimal)sumTax.get()).add(item.getTaxAmount()));
            invoiceItems.add(reqDto);
        });
        invoiceInfo.setSumTax(sumTax.get());
        invoiceInfo.setSumPrice(billInfoEo.getInvoiceAmount().subtract(sumTax.get()));
        invoiceInfo.setInvoiceItems(invoiceItems);
    }
}

