/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.aliyun.openservices.shade.com.google.common.base.Throwables;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemExtExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.dto.ItemInvoiceExportDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.item.dao.das.ItemInvoiceDas;
import com.yunxi.dg.base.center.item.dao.das.ItemSkuDgDas;
import com.yunxi.dg.base.center.item.dto.request.ImportDto;
import com.yunxi.dg.base.center.item.dto.request.ItemInvoiceConditionReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemInvoiceDto;
import com.yunxi.dg.base.center.item.eo.ItemInvoiceEo;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.service.entity.ItemInvoiceService;
import com.yunxi.dg.base.center.item.service.util.EasyPoiExportUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ItemInvoiceServiceImpl
implements ItemInvoiceService {
    private static Logger logger = LoggerFactory.getLogger(ItemInvoiceServiceImpl.class);
    @Resource
    private ItemInvoiceDas itemInvoiceDas;
    @Resource
    private ItemSkuDgDas itemSkuDgDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addItemInvoice(ItemInvoiceDto addReqDto) {
        Assert.notNull((Object)addReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)addReqDto.getSkuCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)((ExtQueryChainWrapper)this.itemSkuDgDas.filter().eq((Object)"code", (Object)addReqDto.getSkuCode())).one();
        ItemInvoiceEo itemInvoiceEo = new ItemInvoiceEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemInvoiceEo);
        itemInvoiceEo.setItemCode(addReqDto.getSkuCode());
        itemInvoiceEo.setItemName(addReqDto.getSkuName());
        itemInvoiceEo.setItemDisplayName(addReqDto.getSkuDisplayName());
        itemInvoiceEo.setSpecification(itemSkuDgEo.getSpecModel());
        itemInvoiceEo.setThirdCode(itemSkuDgEo.getThirdCode());
        itemInvoiceEo.setEnergyEfficiencyRating(itemSkuDgEo.getEnergyEfficiencyRating());
        itemInvoiceEo.setSpecialInvoiceRemark(addReqDto.getSpecialInvoiceRemark());
        this.checkAddItemInvoiceParam(itemInvoiceEo, itemSkuDgEo);
        ItemInvoiceEo oldItemInvoiceEo = (ItemInvoiceEo)((ExtQueryChainWrapper)this.itemInvoiceDas.filter().eq((Object)"item_code", (Object)itemInvoiceEo.getItemCode())).one();
        if (Objects.nonNull(oldItemInvoiceEo)) {
            itemInvoiceEo.setId(oldItemInvoiceEo.getId());
            this.itemInvoiceDas.updateSelective((BaseEo)itemInvoiceEo);
        } else {
            itemInvoiceEo.setId(null);
            this.itemInvoiceDas.insert((BaseEo)itemInvoiceEo);
        }
        return itemInvoiceEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddItemInvoice(List<ItemInvoiceDto> addReqDtos) {
        Assert.notEmpty(addReqDtos, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        ArrayList<ItemInvoiceEo> itemInvoiceEos = new ArrayList<ItemInvoiceEo>();
        for (ItemInvoiceDto itemInvoiceDto : addReqDtos) {
            ItemInvoiceEo itemInvoiceEo = (ItemInvoiceEo)BeanUtil.toBean((Object)itemInvoiceDto, ItemInvoiceEo.class);
            itemInvoiceEo.setItemCode(itemInvoiceDto.getSkuCode());
            itemInvoiceEo.setItemDisplayName(itemInvoiceDto.getSkuDisplayName());
            itemInvoiceEo.setItemName(itemInvoiceDto.getSkuName());
            itemInvoiceEo.setSpecialInvoiceRemark(itemInvoiceDto.getSpecialInvoiceRemark());
            itemInvoiceEos.add(itemInvoiceEo);
        }
        ArrayList<ItemInvoiceEo> updateItemInvoices = new ArrayList<ItemInvoiceEo>();
        this.checkItemCode(itemInvoiceEos, updateItemInvoices);
        logger.info("================>\u65b0\u589e{}\u6761\u8bb0\u5f55", (Object)itemInvoiceEos.size());
        this.itemInvoiceDas.insertBatch(itemInvoiceEos);
        logger.info("================>\u66f4\u65b0{}\u6761\u8bb0\u5f55", (Object)updateItemInvoices.size());
        if (CollectionUtils.isNotEmpty(updateItemInvoices)) {
            for (ItemInvoiceEo updateItemInvoice : updateItemInvoices) {
                this.itemInvoiceDas.updateSelective((BaseEo)updateItemInvoice);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyItemInvoice(ItemInvoiceDto modifyReqDto) {
        Assert.notNull((Object)modifyReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)modifyReqDto.getId(), (String)"id\u4e0d\u53ef\u4e3a\u7a7a");
        ItemInvoiceEo itemInvoiceEo = new ItemInvoiceEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemInvoiceEo);
        itemInvoiceEo.setItemCode(modifyReqDto.getSkuCode());
        itemInvoiceEo.setItemName(modifyReqDto.getSkuName());
        itemInvoiceEo.setItemDisplayName(modifyReqDto.getSkuDisplayName());
        if (Objects.nonNull(modifyReqDto.getSkuCode())) {
            ItemInvoiceEo oldItemInvoiceEo = (ItemInvoiceEo)((ExtQueryChainWrapper)this.itemInvoiceDas.filter().eq((Object)"item_code", (Object)modifyReqDto.getSkuCode())).one();
            if (Objects.nonNull(oldItemInvoiceEo) && !oldItemInvoiceEo.getId().equals(modifyReqDto.getId())) {
                throw new BizException(String.format("\u5546\u54c1\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff1a%s", modifyReqDto.getSkuCode()));
            }
            ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)((ExtQueryChainWrapper)this.itemSkuDgDas.filter().eq((Object)"code", (Object)modifyReqDto.getSkuCode())).one();
            Assert.notNull((Object)itemSkuDgEo, (String)(modifyReqDto.getSkuCode() + "\u8be5\u5546\u54c1\u7f16\u7801\u7684\u5546\u54c1\u4e0d\u5b58\u5728"));
            itemInvoiceEo.setItemName(itemSkuDgEo.getName());
            itemInvoiceEo.setSpecification(itemSkuDgEo.getSpecModel());
            itemInvoiceEo.setThirdCode(itemSkuDgEo.getThirdCode());
            itemInvoiceEo.setEnergyEfficiencyRating(itemSkuDgEo.getEnergyEfficiencyRating());
            itemInvoiceEo.setSpecialInvoiceRemark(modifyReqDto.getSpecialInvoiceRemark());
        }
        this.itemInvoiceDas.updateSelective((BaseEo)itemInvoiceEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByIds(List<Long> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        this.itemInvoiceDas.logicDeleteByIds(ids);
    }

    @Override
    public List<ItemInvoiceDto> queryByIds(List<Long> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        List invoiceEos = ((ExtQueryChainWrapper)this.itemInvoiceDas.filter().in((Object)"id", ids)).list();
        ArrayList<ItemInvoiceDto> itemInvoiceDtos = new ArrayList<ItemInvoiceDto>();
        for (ItemInvoiceEo itemInvoiceEo : invoiceEos) {
            ItemInvoiceDto itemInvoiceDto = (ItemInvoiceDto)BeanUtil.toBean((Object)itemInvoiceEo, ItemInvoiceDto.class);
            itemInvoiceDto.setSkuCode(itemInvoiceEo.getItemCode());
            itemInvoiceDto.setSkuDisplayName(itemInvoiceEo.getItemDisplayName());
            itemInvoiceDto.setSkuName(itemInvoiceEo.getItemName());
            itemInvoiceDtos.add(itemInvoiceDto);
        }
        return itemInvoiceDtos;
    }

    @Override
    public List<ItemInvoiceDto> queryByItemCodes(List<String> itemCodes) {
        Assert.notEmpty(itemCodes, (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        List invoiceEos = ((ExtQueryChainWrapper)this.itemInvoiceDas.filter().in((Object)"item_code", itemCodes)).list();
        ArrayList<ItemInvoiceDto> itemInvoiceDtos = new ArrayList<ItemInvoiceDto>();
        for (ItemInvoiceEo itemInvoiceEo : invoiceEos) {
            ItemInvoiceDto itemInvoiceDto = (ItemInvoiceDto)BeanUtil.toBean((Object)itemInvoiceEo, ItemInvoiceDto.class);
            itemInvoiceDto.setSkuCode(itemInvoiceEo.getItemCode());
            itemInvoiceDto.setSkuDisplayName(itemInvoiceEo.getItemDisplayName());
            itemInvoiceDto.setSkuName(itemInvoiceEo.getItemName());
            itemInvoiceDtos.add(itemInvoiceDto);
        }
        return itemInvoiceDtos;
    }

    @Override
    public PageInfo<ItemInvoiceDto> queryByPages(ItemInvoiceConditionReqDto reqDto) {
        Assert.notNull((Object)reqDto, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u53ef\u4e3a\u7a7a");
        PageInfo dtoPageInfo = new PageInfo();
        PageInfo<ItemInvoiceEo> eoPageInfo = this.queryDataByPages(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            ArrayList<ItemInvoiceDto> itemInvoiceDtos = new ArrayList<ItemInvoiceDto>();
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            for (ItemInvoiceEo itemInvoiceEo : eoPageInfo.getList()) {
                ItemInvoiceDto itemInvoiceDto = (ItemInvoiceDto)BeanUtil.toBean((Object)itemInvoiceEo, ItemInvoiceDto.class);
                itemInvoiceDto.setSkuCode(itemInvoiceEo.getItemCode());
                itemInvoiceDto.setSkuDisplayName(itemInvoiceEo.getItemDisplayName());
                itemInvoiceDto.setSkuName(itemInvoiceEo.getItemName());
                itemInvoiceDtos.add(itemInvoiceDto);
            }
            dtoPageInfo.setList(itemInvoiceDtos);
        }
        return dtoPageInfo;
    }

    @Override
    public String export(ItemInvoiceConditionReqDto reqDto) {
        String url;
        Integer pageNum = 1;
        reqDto.setPageNum(pageNum);
        reqDto.setPageSize(Integer.valueOf(1000));
        String fileName = "/\u5546\u54c1\u5f00\u7968\u4fe1\u606f\u6570\u636e_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        OssRegistryVo ossRegistryVo = (OssRegistryVo)SpringBeanUtil.getBean(OssRegistryVo.class);
        ArrayList<ItemInvoiceExportDto> excelRespDtoList = new ArrayList<ItemInvoiceExportDto>();
        try {
            PageInfo<ItemInvoiceEo> eoPageInfo;
            do {
                if (CollectionUtils.isNotEmpty((Collection)(eoPageInfo = this.queryDataByPages(reqDto)).getList())) {
                    for (ItemInvoiceEo itemInvoiceEo : eoPageInfo.getList()) {
                        ItemInvoiceExportDto exportDto = new ItemInvoiceExportDto();
                        BeanUtils.copyProperties((Object)itemInvoiceEo, (Object)exportDto);
                        excelRespDtoList.add(exportDto);
                    }
                }
                Integer n = pageNum;
                Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
            } while (pageNum <= eoPageInfo.getPages());
            url = EasyPoiExportUtil.getExportUrl(excelRespDtoList, ItemInvoiceExportDto.class, null, fileName, "xls");
        }
        catch (Exception e) {
            logger.error("fileName: {}\u5bfc\u51fa\u5546\u54c1\u5f00\u7968\u4fe1\u606f\u5f02\u5e38: {}", (Object)fileName, (Object)e);
            throw new BizException("\u5bfc\u51fa\u5546\u54c1\u5f00\u7968\u4fe1\u606f\u5f02\u5e38:", e.getMessage());
        }
        return url;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String importItemInvoice(ImportDto importDto) {
        List<ItemInvoiceExportDto> excelReqDtoList = null;
        try {
            excelReqDtoList = EasyPoiExportUtil.parseImportFile(importDto.getUrl(), ItemInvoiceExportDto.class);
        }
        catch (Exception e) {
            logger.error(ItemExtExceptionCode.ITEM_BUNDLES_IMPORT_PARSING_ERROR.getMsg(), (Object)Throwables.getStackTraceAsString((Throwable)e));
            throw new BizException(ItemExtExceptionCode.ITEM_BUNDLES_IMPORT_PARSING_ERROR.getMsg(), e.getMessage());
        }
        return "0";
    }

    @Override
    public ItemInvoiceDto queryById(Long id) {
        ItemInvoiceDto itemInvoiceDto = new ItemInvoiceDto();
        ItemInvoiceEo itemInvoiceEo = (ItemInvoiceEo)this.itemInvoiceDas.selectByPrimaryKey(id);
        DtoHelper.eo2Dto((BaseEo)itemInvoiceEo, (BaseVo)itemInvoiceDto);
        return itemInvoiceDto;
    }

    public void checkItemCode(List<ItemInvoiceEo> itemInvoiceEos, List<ItemInvoiceEo> updateItemInvoices) {
        List<String> itemCodes = itemInvoiceEos.stream().map(ItemInvoiceEo::getItemCode).collect(Collectors.toList());
        List<List<String>> collectList = this.getIterate(itemCodes);
        ArrayList itemSkuEos = new ArrayList();
        ArrayList oldItemInvoiceEoList = new ArrayList();
        for (List<String> codes : collectList) {
            List itemInvoices;
            if (CollectionUtils.isEmpty(codes) || codes.size() < 1) break;
            List itemSkuDgEos = ((ExtQueryChainWrapper)this.itemSkuDgDas.filter().in((Object)"code", codes)).list();
            if (CollectionUtils.isNotEmpty((Collection)itemSkuDgEos)) {
                itemSkuEos.addAll(itemSkuDgEos);
            }
            if (!CollectionUtils.isNotEmpty((Collection)(itemInvoices = ((ExtQueryChainWrapper)this.itemInvoiceDas.filter().in((Object)"item_code", codes)).list()))) continue;
            oldItemInvoiceEoList.addAll(itemInvoices);
        }
        Assert.notEmpty(itemSkuEos, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        Map itemEoMap = itemSkuEos.stream().collect(Collectors.toMap(ItemSkuDgEo::getCode, Function.identity(), (key1, key2) -> key2));
        Map<Object, Object> itemInvoiceEoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(oldItemInvoiceEoList)) {
            itemInvoiceEoMap = oldItemInvoiceEoList.stream().collect(Collectors.toMap(ItemInvoiceEo::getItemCode, Function.identity(), (key1, key2) -> key2));
        }
        Iterator<ItemInvoiceEo> iterator = itemInvoiceEos.iterator();
        while (iterator.hasNext()) {
            ItemInvoiceEo invoiceEo = iterator.next();
            Assert.notNull((Object)invoiceEo.getItemCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            ItemSkuDgEo itemSkuEo = (ItemSkuDgEo)itemEoMap.get(invoiceEo.getItemCode());
            Assert.notNull((Object)invoiceEo, (String)"\u5546\u54c1\u5f00\u7968\u4fe1\u606f\u4e0d\u5b58\u5728");
            invoiceEo.setSpecification(itemSkuEo.getSpecModel());
            invoiceEo.setThirdCode(itemSkuEo.getThirdCode());
            invoiceEo.setEnergyEfficiencyRating(itemSkuEo.getEnergyEfficiencyRating());
            this.checkAddItemInvoiceParam(invoiceEo, itemSkuEo);
            ItemInvoiceEo itemInvoiceEo = (ItemInvoiceEo)itemInvoiceEoMap.get(invoiceEo.getItemCode());
            if (!Objects.nonNull(itemInvoiceEo)) continue;
            invoiceEo.setId(itemInvoiceEo.getId());
            updateItemInvoices.add(invoiceEo);
            iterator.remove();
        }
    }

    public void checkAddItemInvoiceParam(ItemInvoiceEo itemInvoiceEo, ItemSkuDgEo itemSkuEo) {
        Assert.notNull((Object)itemInvoiceEo.getTaxRate(), (String)"\u5f00\u7968\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)itemInvoiceEo.getTaxCategoryCode(), (String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)itemSkuEo, (String)(itemInvoiceEo.getItemCode() + "\u8be5\u5546\u54c1\u7f16\u7801\u7684\u5546\u54c1\u4e0d\u5b58\u5728"));
        itemInvoiceEo.setItemName(itemSkuEo.getName());
        itemInvoiceEo.setCalcuUnit(itemSkuEo.getPriceUnit());
    }

    private void queryCondition(ExtQueryChainWrapper<ItemInvoiceEo> sqlFilters, ItemInvoiceConditionReqDto reqDto) {
        if (StringUtils.isNotBlank((CharSequence)reqDto.getItemCode())) {
            sqlFilters.eq((Object)"item_code", (Object)reqDto.getItemCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getItemName())) {
            sqlFilters.like((Object)"item_name", (Object)reqDto.getItemName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getItemDisplayName())) {
            sqlFilters.eq((Object)"item_display_name", (Object)reqDto.getItemDisplayName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPatentNo())) {
            sqlFilters.eq((Object)"patent_No", (Object)reqDto.getPatentNo());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getTaxCategoryCode())) {
            sqlFilters.like((Object)"tax_category_code", (Object)("%" + reqDto.getTaxCategoryCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getItemType())) {
            sqlFilters.like((Object)"item_type", (Object)("%" + reqDto.getItemType() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPatentName())) {
            sqlFilters.like((Object)"patent_name", (Object)("%" + reqDto.getPatentName() + "%"));
        }
        if (Objects.nonNull(reqDto.getUpdateBeginTime())) {
            sqlFilters.ge((Object)"update_time", (Object)reqDto.getUpdateBeginTime());
        }
        if (Objects.nonNull(reqDto.getUpdateEndTime())) {
            sqlFilters.lt((Object)"update_time", (Object)reqDto.getUpdateEndTime());
        }
        if (Objects.nonNull(reqDto.getCreateBeginTime())) {
            sqlFilters.ge((Object)"create_time", (Object)reqDto.getCreateBeginTime());
        }
        if (Objects.nonNull(reqDto.getCreateEndTime())) {
            sqlFilters.lt((Object)"create_time", (Object)reqDto.getCreateEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSpecModel())) {
            sqlFilters.like((Object)"specification", (Object)reqDto.getSpecModel());
        }
        if (Objects.nonNull(reqDto.getThirdCode())) {
            sqlFilters.like((Object)"third_code", (Object)reqDto.getThirdCode());
        }
        if (Objects.nonNull(reqDto.getEnergyEfficiencyRating())) {
            sqlFilters.like((Object)"energy_efficiency_rating", (Object)reqDto.getEnergyEfficiencyRating());
        }
        if (Objects.nonNull(reqDto.getSpecialInvoiceRemark())) {
            sqlFilters.like((Object)"special_invoice_remark", (Object)reqDto.getSpecialInvoiceRemark());
        }
    }

    public PageInfo<ItemInvoiceEo> queryDataByPages(ItemInvoiceConditionReqDto reqDto) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.itemInvoiceDas.filter().orderByDesc((Object)"update_time");
        this.queryCondition((ExtQueryChainWrapper<ItemInvoiceEo>)sqlFilters, reqDto);
        PageInfo eoPageInfo = sqlFilters.page(reqDto.getPageNum(), reqDto.getPageSize());
        return eoPageInfo;
    }

    public List<List<String>> getIterate(List<String> itemCodes) {
        int length;
        ArrayList<List<String>> collectList = new ArrayList<List<String>>();
        int i = 0;
        for (length = itemCodes.size(); length > 1000; length -= 1000) {
            collectList.add(itemCodes.subList(i, i + 1000));
            i += 1000;
        }
        if (length > 0) {
            collectList.add(itemCodes.subList(i, i + length));
        }
        return collectList;
    }
}

