/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.constants.ItemDgStatus;
import com.yunxi.dg.base.center.item.constants.ItemTypeDgEnum;
import com.yunxi.dg.base.center.item.constants.StorageChangeLogStatusDgEnum;
import com.yunxi.dg.base.center.item.constants.StorageChangeLogTypeDgEnum;
import com.yunxi.dg.base.center.item.dao.vo.StorageChangeLogMessageDgVo;
import com.yunxi.dg.base.center.item.domain.entity.IItemBundleRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemStorageDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IShelfDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IStorageChangeLogDgDomain;
import com.yunxi.dg.base.center.item.dto.request.BaseReqDto;
import com.yunxi.dg.base.center.item.dto.request.BatchItemStorageDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageBranchQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageDetailQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageInfoDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageReturnDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemStorageSubDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ShelfDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.BatchItemStorageDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.BundleItemStorageDgDto;
import com.yunxi.dg.base.center.item.dto.response.ItemShelfDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemStorageDetailQueryDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemStorageDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemStorageQueryDgRespDto;
import com.yunxi.dg.base.center.item.eo.ItemBundleRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.eo.ItemStorageDgEo;
import com.yunxi.dg.base.center.item.eo.ShelfDgEo;
import com.yunxi.dg.base.center.item.eo.StorageChangeLogDgEo;
import com.yunxi.dg.base.center.item.exception.ItemBusinessRuntimeException;
import com.yunxi.dg.base.center.item.exception.ItemExceptionCode;
import com.yunxi.dg.base.center.item.service.entity.IItemDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemStorageDgService;
import com.yunxi.dg.base.center.item.service.entity.IShelfDgService;
import com.yunxi.dg.base.center.item.service.util.ItemStorageDgUtils;
import com.yunxi.dg.base.center.item.service.util.QueryParamDgUtils;
import com.yunxi.dg.base.center.item.service.util.RedisLockDgUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemStorageDgServiceImpl
implements IItemStorageDgService {
    private Logger logger = LoggerFactory.getLogger(ItemStorageDgServiceImpl.class);
    @Resource
    private IShelfDgDomain shelfDgDomain;
    @Resource
    private IItemStorageDgDomain itemStorageDgDomain;
    @Resource
    private ItemStorageDgUtils itemStorageDgUtils;
    @Resource
    private IStorageChangeLogDgDomain storageChangeLogDgDomain;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IItemDgDomain itemDgDomain;
    @Resource
    private IContext context;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private RedisLockDgUtils redisLockDgUtils;
    @Resource
    private IShelfDgService shelfDgService;
    @Resource
    private IItemDgService itemDgService;
    @Resource
    private IItemBundleRelationDgDomain itemBundleRelationDgDomain;
    private String todo = "todo";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long operatingItemStorage(ItemStorageDgReqDto itemStorageDgReqDto) {
        return this.operatingItemStorageNoValidSelf(itemStorageDgReqDto);
    }

    public void dealBundleItem(BatchItemStorageDgReqDto batchItemStorageDgReqDto) {
        ArrayList<ItemStorageDgReqDto> newItemStorageList = new ArrayList<ItemStorageDgReqDto>();
        for (ItemStorageDgReqDto itemStorageDgReqDto : batchItemStorageDgReqDto.getItemStorageDgReqDtoList()) {
            if (ItemTypeDgEnum.BUNDLE.getType().equals(itemStorageDgReqDto.getItemType())) {
                List<ItemBundleRelationDgEo> bundleItemRespDtos = this.itemDgService.queryBundleItemList(itemStorageDgReqDto.getShopId(), itemStorageDgReqDto.getSkuId());
                this.logger.info("\u6263\u51cf\u7ec4\u5408\u5e93\u5b58{}", (Object)JSON.toJSONString(bundleItemRespDtos));
                for (ItemBundleRelationDgEo itemBundleRelationDgEo : bundleItemRespDtos) {
                    ItemStorageDgReqDto itemStorageSubDto = new ItemStorageDgReqDto();
                    itemStorageSubDto.setShopId(itemStorageDgReqDto.getShopId());
                    itemStorageSubDto.setSkuId(itemBundleRelationDgEo.getSubSkuId());
                    itemStorageSubDto.setBalance(Long.valueOf(itemStorageDgReqDto.getBalance() * (long)itemBundleRelationDgEo.getNum().intValue()));
                    itemStorageSubDto.setOrderNo(itemStorageDgReqDto.getOrderNo());
                    newItemStorageList.add(itemStorageSubDto);
                }
                continue;
            }
            newItemStorageList.add(itemStorageDgReqDto);
        }
        batchItemStorageDgReqDto.setItemStorageDgReqDtoList(newItemStorageList);
    }

    @Override
    public BatchItemStorageDgRespDto batchOperatingItemStorage(BatchItemStorageDgReqDto batchItemStorageDgReqDto) {
        if (CollectionUtils.isEmpty((Collection)batchItemStorageDgReqDto.getItemStorageDgReqDtoList())) {
            throw new BizException("\u5546\u54c1\u64cd\u4f5c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BatchItemStorageDgReqDto.SUB.equals(batchItemStorageDgReqDto.getOpt())) {
            for (ItemStorageDgReqDto itemStorageDgReqDto : batchItemStorageDgReqDto.getItemStorageDgReqDtoList()) {
                if (itemStorageDgReqDto.getBalance() != null && itemStorageDgReqDto.getBalance() < 0L) continue;
                throw new BizException("\u4f20\u53c2\u6709\u8bef\uff0c\u6263\u51cf\u64cd\u4f5c\u4e0d\u80fd\u5927\u4e8e0\u6216\u8005\u4e3a\u7a7a");
            }
        } else if (BatchItemStorageDgReqDto.ADD.equals(batchItemStorageDgReqDto.getOpt())) {
            for (ItemStorageDgReqDto itemStorageDgReqDto : batchItemStorageDgReqDto.getItemStorageDgReqDtoList()) {
                if (itemStorageDgReqDto.getBalance() != null && itemStorageDgReqDto.getBalance() > 0L) continue;
                throw new BizException("\u4f20\u53c2\u6709\u8bef\uff0c\u589e\u52a0\u64cd\u4f5c\u4e0d\u80fd\u5c0f\u4e8e0");
            }
        } else {
            throw new BizException("\u53ea\u652f\u6301\u65b0\u589e\u548c\u6263\u51cf\u4e24\u79cd\u64cd\u4f5c");
        }
        this.dealBundleItem(batchItemStorageDgReqDto);
        BatchItemStorageDgRespDto batchItemStorageDgRespDto = new BatchItemStorageDgRespDto();
        for (ItemStorageDgReqDto itemStorageDgReqDto : batchItemStorageDgReqDto.getItemStorageDgReqDtoList()) {
            try {
                this.operatingItemStorage(itemStorageDgReqDto);
                ItemStorageDgRespDto itemStorageDgRespDto = new ItemStorageDgRespDto();
                BeanUtils.copyProperties((Object)itemStorageDgReqDto, (Object)itemStorageDgRespDto);
                batchItemStorageDgRespDto.getSuccessList().add(itemStorageDgRespDto);
            }
            catch (Exception e) {
                if (BatchItemStorageDgReqDto.SUB.equals(batchItemStorageDgReqDto.getOpt())) {
                    this.logger.info("\u8ba2\u5355\u53f7{}\u64cd\u4f5c\u5e93\u5b58\u5931\u8d25{}", (Object)itemStorageDgReqDto.getOrderNo(), (Object)e);
                    if (CollectionUtils.isNotEmpty((Collection)batchItemStorageDgRespDto.getSuccessList())) {
                        for (ItemStorageDgRespDto itemStorageDgRespDto : batchItemStorageDgRespDto.getSuccessList()) {
                            try {
                                ItemStorageDgReqDto rollBack = new ItemStorageDgReqDto();
                                BeanUtils.copyProperties((Object)itemStorageDgRespDto, (Object)rollBack);
                                rollBack.setBalance(Long.valueOf(-rollBack.getBalance().longValue()));
                                this.operatingItemStorage(rollBack);
                            }
                            catch (Exception rollBackEx) {
                                this.logger.error("\u3010\u865a\u62df\u5e93\u5b58\u56de\u6eda\u5931\u8d25:shopId={},skuId={},storage={}\u3011", new Object[]{itemStorageDgRespDto.getShopId(), itemStorageDgRespDto.getSkuId(), itemStorageDgRespDto.getBalance(), rollBackEx});
                            }
                        }
                    }
                    throw new BizException("\u5e93\u5b58\u4e0d\u8db3");
                }
                batchItemStorageDgRespDto.setIfAllSuccess(Boolean.valueOf(false));
                this.logger.error("\u8ba2\u5355\u53f7{}\u64cd\u4f5c\u589e\u52a0\u5e93\u5b58\u5931\u8d25{}\uff0c\u7ee7\u7eed\u589e\u52a0\u5e93\u5b58", (Object)itemStorageDgReqDto.getOrderNo(), (Object)e);
            }
        }
        if (batchItemStorageDgRespDto.getIfAllSuccess().booleanValue()) {
            batchItemStorageDgRespDto.setSuccessList(null);
        }
        return batchItemStorageDgRespDto;
    }

    Long operatingItemStorageNoValidSelf(ItemStorageDgReqDto itemStorageDgReqDto) {
        boolean redisResult;
        this.logger.info("\u5e93\u5b58\u53c2\u6570: {}", JSON.toJSON((Object)itemStorageDgReqDto));
        if (itemStorageDgReqDto == null || itemStorageDgReqDto.getSkuId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        if (itemStorageDgReqDto.getBalance() == null || itemStorageDgReqDto.getBalance().equals(0L)) {
            return null;
        }
        ItemStorageDgEo itemInsertEo = ItemStorageDgEo.newInstance((Map)itemStorageDgReqDto.getExtFields());
        ItemStorageDgEo itemStorageDgEo = ItemStorageDgEo.newInstance((Map)itemStorageDgReqDto.getExtFields());
        ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)this.itemSkuDgDomain.selectByPrimaryKey(itemStorageDgReqDto.getSkuId());
        itemStorageDgEo.setItemId(itemSkuDgEo.getItemId());
        itemStorageDgEo.setShelfId(Long.valueOf(0L));
        itemStorageDgEo.setShopId(itemStorageDgReqDto.getShopId());
        itemStorageDgEo.setChannelId(itemStorageDgReqDto.getChannelId());
        itemStorageDgEo.setSkuId(itemStorageDgReqDto.getSkuId());
        BeanUtils.copyProperties((Object)itemStorageDgEo, (Object)itemInsertEo);
        ItemStorageDgEo result = (ItemStorageDgEo)this.itemStorageDgDomain.selectOne((BaseEo)itemStorageDgEo);
        if (result == null) {
            if (itemStorageDgReqDto.getBalance() < 0L) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
            itemInsertEo.setAppending(Long.valueOf(0L));
            itemInsertEo.setAllocated(Long.valueOf(0L));
            itemInsertEo.setBalance(Long.valueOf(0L));
            itemInsertEo.setInstanceId(this.context.instanceId());
            itemInsertEo.setTenantId(this.context.tenantId());
            this.itemStorageDgDomain.insert((BaseEo)itemInsertEo);
            result = (ItemStorageDgEo)this.itemStorageDgDomain.selectOne((BaseEo)itemStorageDgEo);
            redisResult = this.itemStorageDgUtils.addItemStorage(itemStorageDgReqDto.getShopId(), itemStorageDgReqDto.getSkuId(), itemStorageDgReqDto.getBalance());
        } else {
            Long balance = itemStorageDgReqDto.getBalance();
            if (balance < 0L) {
                redisResult = this.itemStorageDgUtils.subItemStorage(result.getShopId(), result.getSkuId(), balance);
                if (!redisResult) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_NOT_ENOUGH);
                }
            } else {
                redisResult = this.itemStorageDgUtils.addItemStorage(result.getShopId(), result.getSkuId(), balance);
            }
        }
        if (!redisResult) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_OPERATING_ERROR);
        }
        StorageChangeLogDgEo changeLogEo = new StorageChangeLogDgEo();
        changeLogEo.setShelfId(Long.valueOf(0L));
        changeLogEo.setShopId(itemStorageDgReqDto.getShopId());
        changeLogEo.setItemId(itemSkuDgEo.getItemId());
        changeLogEo.setSkuId(itemSkuDgEo.getId());
        changeLogEo.setOrderNo(itemStorageDgReqDto.getOrderNo());
        if (StringUtils.isEmpty((CharSequence)changeLogEo.getOrderNo())) {
            changeLogEo.setOrderNo("ST" + IdGenrator.nextId((long)0L, (long)0L));
        }
        changeLogEo.setStatus(StorageChangeLogStatusDgEnum.CHANGE_BALANCE.getStatus());
        changeLogEo.setPreemptionTime(new Date());
        changeLogEo.setActivity(itemStorageDgReqDto.getActivity());
        itemStorageDgEo.setPresell(itemStorageDgReqDto.getPresell());
        changeLogEo.setInstanceId(this.context.instanceId());
        changeLogEo.setTenantId(this.context.tenantId());
        HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
        if (itemStorageDgReqDto.getInventoryEffectiveDate() != null) {
            map.put("inventory_effective_date", itemStorageDgReqDto.getInventoryEffectiveDate());
        }
        map.put("balance", itemStorageDgReqDto.getBalance());
        changeLogEo.setExtension(JSON.toJSONString(map));
        this.storageChangeLogDgDomain.insert((BaseEo)changeLogEo);
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<Long, String> params = new HashMap<Long, String>();
        params.put(changeLogEo.getId(), "");
        if (itemStorageDgReqDto.getInventoryEffectiveDate() != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            params.put(changeLogEo.getId(), simpleDateFormat.format(itemStorageDgReqDto.getInventoryEffectiveDate()));
        }
        ids.add(changeLogEo.getId());
        StorageChangeLogMessageDgVo storageChangeLogMessageDgVo = new StorageChangeLogMessageDgVo();
        storageChangeLogMessageDgVo.setChangeLogIdList(ids);
        storageChangeLogMessageDgVo.setChangType(StorageChangeLogTypeDgEnum.PREEMPTION_STORAGE.getStatus());
        storageChangeLogMessageDgVo.setParams(params);
        String messageStr = JSON.toJSONString((Object)storageChangeLogMessageDgVo);
        this.logger.info("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55mq\u53d1\u9001:{}", (Object)messageStr);
        this.commonsMqService.sendDelaySingleMessage("ITEM_STORAGE_CHANGE_LOG_DG", (Object)messageStr, Long.valueOf(1L));
        return result.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subItemStorage(ItemStorageSubDgReqDto itemStorageSubDgReqDto) {
        this.checkInstanceIdAndTenantId((BaseReqDto)itemStorageSubDgReqDto);
        if (itemStorageSubDgReqDto == null || StringUtils.isBlank((CharSequence)itemStorageSubDgReqDto.getOrderNo()) || CollectionUtils.isEmpty((Collection)itemStorageSubDgReqDto.getItemList())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        for (ItemStorageInfoDgReqDto itemStorageInfoDgReqDto : itemStorageSubDgReqDto.getItemList()) {
            if (itemStorageInfoDgReqDto != null && itemStorageInfoDgReqDto.getSkuId() != null && itemStorageInfoDgReqDto.getNum() != null && itemStorageInfoDgReqDto.getNum() >= 0L) continue;
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        StorageChangeLogDgEo storageChangeLogDgEo = new StorageChangeLogDgEo();
        storageChangeLogDgEo.setOrderNo(itemStorageSubDgReqDto.getOrderNo());
        storageChangeLogDgEo.setInstanceId(itemStorageSubDgReqDto.getInstanceId());
        storageChangeLogDgEo.setTenantId(itemStorageSubDgReqDto.getTenantId());
        storageChangeLogDgEo.setDr(0);
        if (this.storageChangeLogDgDomain.count((BaseEo)storageChangeLogDgEo) > 0) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.ORDER_EXISTS);
        }
        ArrayList<Long> changeLogIdList = new ArrayList<Long>();
        HashMap<Long, String> params = new HashMap<Long, String>();
        for (ItemStorageInfoDgReqDto itemStorageInfoDgReqDto : itemStorageSubDgReqDto.getItemList()) {
            boolean subResult;
            ShelfDgEo shelfDgEo = new ShelfDgEo();
            shelfDgEo.setShopId(itemStorageInfoDgReqDto.getShopId());
            shelfDgEo.setSkuId(itemStorageInfoDgReqDto.getSkuId());
            shelfDgEo.setInstanceId(itemStorageSubDgReqDto.getInstanceId());
            shelfDgEo.setTenantId(itemStorageSubDgReqDto.getTenantId());
            shelfDgEo = (ShelfDgEo)this.shelfDgDomain.selectOne((BaseEo)shelfDgEo);
            if (shelfDgEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.ITEM_OFF_SHELF);
            }
            ItemStorageDgEo itemStorageDgEo = new ItemStorageDgEo();
            itemStorageDgEo.setShelfId(shelfDgEo.getId());
            this.validDateFormat(itemStorageInfoDgReqDto, itemStorageDgEo);
            itemStorageDgEo.setInstanceId(shelfDgEo.getInstanceId());
            itemStorageDgEo.setTenantId(shelfDgEo.getTenantId());
            itemStorageDgEo = (ItemStorageDgEo)this.itemStorageDgDomain.selectOne((BaseEo)itemStorageDgEo);
            if (itemStorageDgEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_NOT_ENOUGH);
            }
            if (StringUtils.isEmpty((CharSequence)itemStorageInfoDgReqDto.getInventoryEffectiveDate())) {
                subResult = this.itemStorageDgUtils.subItemStorage(shelfDgEo.getShopId(), shelfDgEo.getSkuId(), -itemStorageInfoDgReqDto.getNum().longValue());
            } else {
                ItemStorageDgServiceImpl.isValidDate(itemStorageInfoDgReqDto.getInventoryEffectiveDate());
                subResult = this.itemStorageDgUtils.subItemStorage(itemStorageInfoDgReqDto.getInventoryEffectiveDate(), shelfDgEo.getShopId(), shelfDgEo.getSkuId(), -itemStorageInfoDgReqDto.getNum().longValue());
            }
            if (!subResult) {
                this.rollbackItemStorage(itemStorageSubDgReqDto.getOrderNo(), itemStorageSubDgReqDto.getInstanceId(), itemStorageSubDgReqDto.getTenantId());
                throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_NOT_ENOUGH);
            }
            StorageChangeLogDgEo changeLogEo = new StorageChangeLogDgEo();
            changeLogEo.setShelfId(shelfDgEo.getId());
            changeLogEo.setShopId(itemStorageInfoDgReqDto.getShopId());
            changeLogEo.setChannelId(shelfDgEo.getChannelId());
            changeLogEo.setItemId(shelfDgEo.getItemId());
            changeLogEo.setSkuId(itemStorageInfoDgReqDto.getSkuId());
            changeLogEo.setOrderNo(itemStorageSubDgReqDto.getOrderNo());
            changeLogEo.setAppending(itemStorageInfoDgReqDto.getNum());
            changeLogEo.setStatus(StorageChangeLogStatusDgEnum.PREEMPTION.getStatus());
            changeLogEo.setPreemptionTime(new Date());
            changeLogEo.setInstanceId(itemStorageSubDgReqDto.getInstanceId());
            changeLogEo.setTenantId(itemStorageSubDgReqDto.getTenantId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("inventory_effective_date", itemStorageInfoDgReqDto.getInventoryEffectiveDate());
            changeLogEo.setExtension(JSON.toJSONString(map));
            this.storageChangeLogDgDomain.insert((BaseEo)changeLogEo);
            changeLogIdList.add(changeLogEo.getId());
            params.put(changeLogEo.getId(), itemStorageInfoDgReqDto.getInventoryEffectiveDate());
        }
        if (CollectionUtils.isNotEmpty(changeLogIdList)) {
            StorageChangeLogMessageDgVo storageChangeLogMessageDgVo = new StorageChangeLogMessageDgVo();
            storageChangeLogMessageDgVo.setChangeLogIdList(changeLogIdList);
            storageChangeLogMessageDgVo.setChangType(StorageChangeLogTypeDgEnum.PREEMPTION_STORAGE.getStatus());
            storageChangeLogMessageDgVo.setParams(params);
            String messageStr = JSON.toJSONString((Object)storageChangeLogMessageDgVo);
            this.logger.info("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55mq\u53d1\u9001:{}", (Object)messageStr);
            this.commonsMqService.sendDelaySingleMessage("ITEM_STORAGE_CHANGE_LOG_DG", (Object)messageStr, Long.valueOf(1L));
        }
    }

    private void validDateFormat(ItemStorageInfoDgReqDto itemStorageInfoDgReqDto, ItemStorageDgEo itemStorageDgEo) {
        if (StringUtils.isNotEmpty((CharSequence)itemStorageInfoDgReqDto.getInventoryEffectiveDate())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                itemStorageDgEo.setInventoryEffectiveDate(sdf.parse(itemStorageInfoDgReqDto.getInventoryEffectiveDate()));
            }
            catch (ParseException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new ItemBusinessRuntimeException(e.getMessage(), e.getMessage());
            }
        } else {
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.isNull((String)"inventory_effective_date"));
            itemStorageDgEo.setSqlFilters(sqlFilterList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void returnItemStorage(ItemStorageReturnDgReqDto itemStorageReturnDgReqDto) {
        this.checkInstanceIdAndTenantId((BaseReqDto)itemStorageReturnDgReqDto);
        if (itemStorageReturnDgReqDto == null || StringUtils.isBlank((CharSequence)itemStorageReturnDgReqDto.getOrderNo()) || CollectionUtils.isEmpty((Collection)itemStorageReturnDgReqDto.getItemList())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        for (ItemStorageInfoDgReqDto itemStorageInfoDgReqDto : itemStorageReturnDgReqDto.getItemList()) {
            if (itemStorageInfoDgReqDto == null || itemStorageInfoDgReqDto.getSkuId() == null || itemStorageInfoDgReqDto.getNum() == null || itemStorageInfoDgReqDto.getNum() < 0L) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
            if (!StringUtils.isNotEmpty((CharSequence)itemStorageInfoDgReqDto.getInventoryEffectiveDate())) continue;
            ItemStorageDgServiceImpl.isValidDate(itemStorageInfoDgReqDto.getInventoryEffectiveDate());
        }
        StorageChangeLogDgEo storageChangeLogDgEo = new StorageChangeLogDgEo();
        storageChangeLogDgEo.setOrderNo(itemStorageReturnDgReqDto.getOrderNo());
        storageChangeLogDgEo.setInstanceId(itemStorageReturnDgReqDto.getInstanceId());
        storageChangeLogDgEo.setTenantId(itemStorageReturnDgReqDto.getTenantId());
        storageChangeLogDgEo.setDr(0);
        if (this.storageChangeLogDgDomain.count((BaseEo)storageChangeLogDgEo) == 0) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.ORDER_NOT_EXISTS);
        }
        ArrayList<Long> changeLogIdList = new ArrayList<Long>();
        HashMap<Long, String> params = new HashMap<Long, String>();
        for (ItemStorageInfoDgReqDto itemStorageInfoDgReqDto : itemStorageReturnDgReqDto.getItemList()) {
            ShelfDgEo shelfDgEo = new ShelfDgEo();
            shelfDgEo.setShopId(itemStorageInfoDgReqDto.getShopId());
            shelfDgEo.setSkuId(itemStorageInfoDgReqDto.getSkuId());
            shelfDgEo.setInstanceId(itemStorageReturnDgReqDto.getInstanceId());
            shelfDgEo.setTenantId(itemStorageReturnDgReqDto.getTenantId());
            shelfDgEo = (ShelfDgEo)this.shelfDgDomain.selectOne((BaseEo)shelfDgEo);
            if (shelfDgEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.ITEM_OFF_SHELF);
            }
            ItemStorageDgEo itemStorageDgEo = new ItemStorageDgEo();
            itemStorageDgEo.setShelfId(shelfDgEo.getId());
            this.validDateFormat(itemStorageInfoDgReqDto, itemStorageDgEo);
            itemStorageDgEo.setInstanceId(shelfDgEo.getInstanceId());
            itemStorageDgEo.setTenantId(shelfDgEo.getTenantId());
            itemStorageDgEo = (ItemStorageDgEo)this.itemStorageDgDomain.selectOne((BaseEo)itemStorageDgEo);
            if (itemStorageDgEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_NOT_ENOUGH);
            }
            StorageChangeLogDgEo queryEo = new StorageChangeLogDgEo();
            queryEo.setOrderNo(itemStorageReturnDgReqDto.getOrderNo());
            queryEo.setInstanceId(itemStorageReturnDgReqDto.getInstanceId());
            queryEo.setTenantId(itemStorageReturnDgReqDto.getTenantId());
            try {
                Object map;
                StorageChangeLogDgEo changeLogEo = (StorageChangeLogDgEo)this.storageChangeLogDgDomain.selectOne((BaseEo)queryEo);
                if (changeLogEo == null) {
                    throw new BizException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg());
                }
                changeLogEo.setAppending(Long.valueOf(-itemStorageInfoDgReqDto.getNum().longValue()));
                changeLogEo.setStatus(StorageChangeLogStatusDgEnum.CANCEL.getStatus());
                changeLogEo.setPreemptionTime(new Date());
                if (StringUtils.isNotEmpty((CharSequence)changeLogEo.getExtension())) {
                    map = JSON.parseObject((String)changeLogEo.getExtension());
                    map.put("stage", this.todo);
                    changeLogEo.setExtension(JSON.toJSONString((Object)map));
                } else {
                    map = new HashMap();
                    map.put("stage", this.todo);
                    changeLogEo.setExtension(JSON.toJSONString((Object)map));
                }
                this.storageChangeLogDgDomain.updateSelective((BaseEo)changeLogEo);
                changeLogIdList.add(changeLogEo.getId());
                params.put(changeLogEo.getId(), itemStorageInfoDgReqDto.getInventoryEffectiveDate());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        if (CollectionUtils.isNotEmpty(changeLogIdList)) {
            StorageChangeLogMessageDgVo storageChangeLogMessageDgVo = new StorageChangeLogMessageDgVo();
            storageChangeLogMessageDgVo.setChangeLogIdList(changeLogIdList);
            storageChangeLogMessageDgVo.setChangType(StorageChangeLogTypeDgEnum.RETURN_STORAGE.getStatus());
            storageChangeLogMessageDgVo.setParams(params);
            String messageStr = JSON.toJSONString((Object)storageChangeLogMessageDgVo);
            this.logger.info("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55mq\u53d1\u9001:{}", (Object)messageStr);
            this.commonsMqService.sendDelaySingleMessage("ITEM_STORAGE_CHANGE_LOG_DG", (Object)messageStr, Long.valueOf(1L));
        }
        for (ItemStorageInfoDgReqDto itemStorageInfoDgReqDto : itemStorageReturnDgReqDto.getItemList()) {
            this.itemStorageDgUtils.addItemStorage(itemStorageInfoDgReqDto.getInventoryEffectiveDate(), itemStorageInfoDgReqDto.getShopId(), itemStorageInfoDgReqDto.getSkuId(), itemStorageInfoDgReqDto.getNum());
        }
    }

    @Override
    public List<ItemStorageQueryDgRespDto> queryBranchItemStorage(ItemStorageBranchQueryDgReqDto itemStorageBranchQueryDgReqDto) {
        if (CollectionUtils.isEmpty((Collection)itemStorageBranchQueryDgReqDto.getShelfList())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ArrayList<ItemStorageQueryDgRespDto> itemStorageQueryDgRespDtoList = new ArrayList<ItemStorageQueryDgRespDto>();
        for (ShelfDgReqDto shelfDgReqDto : itemStorageBranchQueryDgReqDto.getShelfList()) {
            ItemStorageQueryDgRespDto itemStorageQueryDgRespDto = new ItemStorageQueryDgRespDto();
            itemStorageQueryDgRespDto.setShopId(shelfDgReqDto.getShopId());
            itemStorageQueryDgRespDto.setSkuId(shelfDgReqDto.getSkuId());
            ItemShelfDgRespDto itemShelfSkuRespDto = this.shelfDgService.queryItemShelf(shelfDgReqDto);
            if (itemShelfSkuRespDto != null) {
                itemStorageQueryDgRespDto.setItemShelfDgRespDto(itemShelfSkuRespDto);
                Long avaNum = 0L;
                avaNum = ItemTypeDgEnum.BUNDLE.getType().intValue() == itemShelfSkuRespDto.getItemType().intValue() ? this.getBundleItemSkuStorage(shelfDgReqDto.getShopId(), shelfDgReqDto.getSkuId()) : this.itemStorageDgUtils.queryItemStorage(shelfDgReqDto.getShopId(), shelfDgReqDto.getSkuId());
                itemStorageQueryDgRespDto.setAvaNum(avaNum);
                itemStorageQueryDgRespDto.setItemShelfDgRespDto(itemShelfSkuRespDto);
            } else {
                itemShelfSkuRespDto = new ItemShelfDgRespDto();
                itemShelfSkuRespDto.setShopId(shelfDgReqDto.getShopId());
                itemShelfSkuRespDto.setSkuId(shelfDgReqDto.getSkuId());
                itemShelfSkuRespDto.setItemId(shelfDgReqDto.getItemId());
                itemShelfSkuRespDto.setBusType(shelfDgReqDto.getBusType());
                itemShelfSkuRespDto.setStatus(ItemDgStatus.ITEM_OFFSHELF.getStatus());
                itemStorageQueryDgRespDto.setAvaNum(Long.valueOf(0L));
                itemStorageQueryDgRespDto.setItemShelfDgRespDto(itemShelfSkuRespDto);
            }
            itemStorageQueryDgRespDtoList.add(itemStorageQueryDgRespDto);
        }
        return itemStorageQueryDgRespDtoList;
    }

    @Override
    public List<ItemStorageQueryDgRespDto> queryItemStorage(List<ItemStorageQueryDgReqDto> itemStorageQueryDgReqDtoList, Long instanceId, Long tenantId) {
        if (CollectionUtils.isEmpty(itemStorageQueryDgReqDtoList)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ArrayList<ItemStorageQueryDgRespDto> itemStorageQueryDgRespDtoList = new ArrayList<ItemStorageQueryDgRespDto>();
        Integer advanceSale = 1;
        for (ItemStorageQueryDgReqDto itemStorageQueryDgReqDto : itemStorageQueryDgReqDtoList) {
            if (CollectionUtils.isEmpty((Collection)itemStorageQueryDgReqDto.getSkuIds())) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_QUERY_SKU);
            }
            if (StringUtils.isNotEmpty((CharSequence)itemStorageQueryDgReqDto.getInventoryEffectiveDate())) {
                ItemStorageDgServiceImpl.isValidDate(itemStorageQueryDgReqDto.getInventoryEffectiveDate());
            }
            Long shopId = itemStorageQueryDgReqDto.getShopId();
            for (Long skuId : itemStorageQueryDgReqDto.getSkuIds()) {
                ItemStorageQueryDgRespDto itemStorageQueryDgRespDto = new ItemStorageQueryDgRespDto();
                itemStorageQueryDgRespDto.setShopId(shopId);
                itemStorageQueryDgRespDto.setSkuId(skuId);
                itemStorageQueryDgRespDto.setChannelId(itemStorageQueryDgReqDto.getChannelId());
                List shelfDgEoList = this.shelfDgDomain.selectByParam(shopId, itemStorageQueryDgReqDto.getChannelId(), null, skuId, null);
                Integer itemType = null;
                if (CollectionUtils.isNotEmpty((Collection)shelfDgEoList)) {
                    itemType = ((ShelfDgEo)shelfDgEoList.get(0)).getItemType();
                }
                if (itemType != null && ItemTypeDgEnum.BUNDLE.getType().intValue() == itemType.intValue()) {
                    Long minBalance = this.getBundleItemSkuStorage(shopId, skuId);
                    itemStorageQueryDgRespDto.setAvaNum(minBalance);
                } else {
                    Long avaNum = this.itemStorageDgUtils.queryItemStorage(itemStorageQueryDgReqDto.getInventoryEffectiveDate(), shopId, skuId);
                    if (avaNum == null) {
                        boolean lock = this.redisLockDgUtils.lock(shopId + "_" + skuId);
                        int cycle = 0;
                        while (!lock) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                this.logger.error(e.getMessage(), (Throwable)e);
                            }
                            lock = this.redisLockDgUtils.lock(shopId + "_" + skuId);
                            if (cycle++ != 5) continue;
                        }
                        if (lock) {
                            ItemDgEo itemDgEo;
                            ItemSkuDgEo itemSkuDgEo;
                            avaNum = this.itemStorageDgUtils.queryItemStorage(itemStorageQueryDgReqDto.getInventoryEffectiveDate(), shopId, skuId);
                            if (avaNum == null && (itemSkuDgEo = (ItemSkuDgEo)this.itemSkuDgDomain.selectByPrimaryKey(skuId)) != null && advanceSale.equals(itemSkuDgEo.getAdvanceSale()) && (StringUtils.isEmpty((CharSequence)itemSkuDgEo.getDiscontinuationDate()) || !itemSkuDgEo.getDiscontinuationDate().contains(itemStorageQueryDgReqDto.getInventoryEffectiveDate())) && (itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemSkuDgEo.getItemId())) != null && ItemDgStatus.ITEM_ONSHELF.getStatus().equals(itemDgEo.getStatus()) && itemSkuDgEo.getInventoryQuantity() > 0L) {
                                avaNum = itemSkuDgEo.getInventoryQuantity();
                                ItemStorageDgEo itemStorageDgEo = new ItemStorageDgEo();
                                itemStorageDgEo.setShopId(shopId);
                                itemStorageDgEo.setSkuId(skuId);
                                List itemStorageDgEoList = this.itemStorageDgDomain.selectPage((BaseEo)itemStorageDgEo, Integer.valueOf(1), Integer.valueOf(1)).getList();
                                if (CollectionUtils.isNotEmpty((Collection)itemStorageDgEoList)) {
                                    itemStorageDgEo = (ItemStorageDgEo)itemStorageDgEoList.get(0);
                                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                                    try {
                                        itemStorageDgEo.setInventoryEffectiveDate(sdf.parse(itemStorageQueryDgReqDto.getInventoryEffectiveDate()));
                                    }
                                    catch (ParseException e) {
                                        throw new ItemBusinessRuntimeException("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef(yyyy-MM-dd)");
                                    }
                                    itemStorageDgEo.setBalance(itemSkuDgEo.getInventoryQuantity());
                                    itemStorageDgEo.setId(null);
                                    this.itemStorageDgDomain.insert((BaseEo)itemStorageDgEo);
                                    this.itemStorageDgUtils.addItemStorage(itemStorageDgEo.getInventoryEffectiveDate(), shopId, skuId, itemSkuDgEo.getInventoryQuantity());
                                }
                            }
                            this.redisLockDgUtils.releaseLock(shopId + "_" + skuId);
                        }
                    }
                    itemStorageQueryDgRespDto.setAvaNum(Long.valueOf(avaNum == null ? 0L : avaNum));
                }
                itemStorageQueryDgRespDtoList.add(itemStorageQueryDgRespDto);
                itemStorageQueryDgRespDto.setInventoryEffectiveDate(itemStorageQueryDgReqDto.getInventoryEffectiveDate());
            }
        }
        return itemStorageQueryDgRespDtoList;
    }

    @Override
    public Long getBundleItemSkuStorage(Long shopId, Long skuId) {
        this.logger.info("\u67e5\u8be2\u7ec4\u5408\u5546\u54c1\u5e93\u5b58\uff1ashopId={}, skuId={}", (Object)shopId, (Object)skuId);
        List itemBundleRelationDgEoList = this.itemBundleRelationDgDomain.getListBySkuId((List)Lists.newArrayList((Object[])new Long[]{skuId}));
        Long minBalance = null;
        if (CollectionUtils.isNotEmpty((Collection)itemBundleRelationDgEoList)) {
            Map<Long, Integer> subSkuMap = itemBundleRelationDgEoList.stream().collect(Collectors.toMap(ItemBundleRelationDgEo::getSubSkuId, ItemBundleRelationDgEo::getNum));
            List itemStorageDgEoList = this.itemStorageDgDomain.selectByParam((List)Lists.newArrayList((Object[])new Long[]{shopId}), null, (List)Lists.newArrayList(subSkuMap.keySet()));
            if (CollectionUtils.isNotEmpty((Collection)itemStorageDgEoList)) {
                minBalance = itemStorageDgEoList.stream().filter(itemStorageEo -> itemStorageEo.getBalance() != null).mapToLong(itemStorageEo -> {
                    long balance = 0L;
                    Integer num = (Integer)subSkuMap.get(itemStorageEo.getSkuId());
                    if (num != null && num != 0) {
                        balance = itemStorageEo.getBalance() / (long)num.intValue();
                    }
                    return balance;
                }).min().orElse(0L);
            }
        }
        return minBalance;
    }

    @Override
    public PageInfo<ItemStorageDetailQueryDgRespDto> queryItemStorageDetail(ItemStorageDetailQueryDgReqDto itemStorageDetailQueryDgReqDto, Integer pageNum, Integer pageSize) {
        if (itemStorageDetailQueryDgReqDto == null || itemStorageDetailQueryDgReqDto.getInstanceId() == null || itemStorageDetailQueryDgReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ItemStorageDgEo itemStorageDgEo = ItemStorageDgEo.newInstance((Map)itemStorageDetailQueryDgReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)itemStorageDetailQueryDgReqDto, (BaseEo)itemStorageDgEo);
        QueryParamDgUtils.fillQueryCreateStartTime(itemStorageDetailQueryDgReqDto.getCreateBeginTime(), (BaseEo)itemStorageDgEo);
        QueryParamDgUtils.fillQueryCreateEndTime(itemStorageDetailQueryDgReqDto.getCreateEndTime(), (BaseEo)itemStorageDgEo);
        QueryParamDgUtils.fillQueryUpdateStartTime(itemStorageDetailQueryDgReqDto.getUpdateBeginTime(), (BaseEo)itemStorageDgEo);
        QueryParamDgUtils.fillQueryUpdateEndTime(itemStorageDetailQueryDgReqDto.getUpdateEndTime(), (BaseEo)itemStorageDgEo);
        PageInfo eoPageInfo = this.itemStorageDgDomain.selectPage((BaseEo)itemStorageDgEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList itemStorageDetailQueryDgRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), itemStorageDetailQueryDgRespDtoList, ItemStorageDetailQueryDgRespDto.class);
        for (ItemStorageDetailQueryDgRespDto detailDto : itemStorageDetailQueryDgRespDtoList) {
            detailDto.setAvaNum(this.itemStorageDgUtils.queryItemStorage(detailDto.getShopId(), detailDto.getSkuId()));
        }
        dtoPageInfo.setList(itemStorageDetailQueryDgRespDtoList);
        return dtoPageInfo;
    }

    @Override
    public ItemStorageDetailQueryDgRespDto queryItemStorageDetail(Long id, Long instanceId, Long tenantId) {
        if (instanceId == null || tenantId == null || id == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ItemStorageDgEo itemStorageDgEo = (ItemStorageDgEo)this.itemStorageDgDomain.selectByPrimaryKey(id);
        ItemStorageDetailQueryDgRespDto itemStorageDetailQueryDgRespDto = new ItemStorageDetailQueryDgRespDto();
        if (itemStorageDgEo == null || !instanceId.equals(itemStorageDgEo.getInstanceId()) || !tenantId.equals(itemStorageDgEo.getTenantId())) {
            return itemStorageDetailQueryDgRespDto;
        }
        DtoHelper.eo2Dto((BaseEo)itemStorageDgEo, (BaseVo)itemStorageDetailQueryDgRespDto);
        itemStorageDetailQueryDgRespDto.setAvaNum(this.itemStorageDgUtils.queryItemStorage(itemStorageDgEo.getShopId(), itemStorageDgEo.getSkuId()));
        return itemStorageDetailQueryDgRespDto;
    }

    private void rollbackItemStorage(String orderNo, Long instanceId, Long tenantId) {
        StorageChangeLogDgEo storageChangeLogDgEo = new StorageChangeLogDgEo();
        storageChangeLogDgEo.setOrderNo(orderNo);
        storageChangeLogDgEo.setInstanceId(instanceId);
        storageChangeLogDgEo.setTenantId(tenantId);
        List storageChangeLogDgEoList = this.storageChangeLogDgDomain.selectList((BaseEo)storageChangeLogDgEo);
        if (CollectionUtils.isEmpty((Collection)storageChangeLogDgEoList)) {
            return;
        }
        this.logger.info("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\u56de\u6eda\u64cd\u4f5c\u5f00\u59cb");
        for (StorageChangeLogDgEo changeLogEo : storageChangeLogDgEoList) {
            this.itemStorageDgUtils.addItemStorage(changeLogEo.getShopId(), changeLogEo.getSkuId(), changeLogEo.getAppending());
        }
        this.logger.info("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\u56de\u6eda\u64cd\u4f5c\u7ed3\u675f");
    }

    private void checkInstanceIdAndTenantId(BaseReqDto baseReqDto) {
        if (baseReqDto.getInstanceId() == null || baseReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
    }

    private static void isValidDate(String dateStr) {
        if (StringUtils.isEmpty((CharSequence)dateStr) || dateStr.length() > "yyyy-MM-dd".length()) {
            throw new ItemBusinessRuntimeException("\u9519\u8bef\u7684\u65e5\u671f\u683c\u5f0f(yyyy-MM-dd)");
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            simpleDateFormat.setLenient(false);
            simpleDateFormat.parse(dateStr);
        }
        catch (Exception e) {
            throw new ItemBusinessRuntimeException("\u9519\u8bef\u7684\u65e5\u671f\u683c\u5f0f(yyyy-MM-dd)");
        }
    }

    @Override
    public List<BundleItemStorageDgDto> queryBundleItemStorage(Long itemId, Long shopId) {
        List itemSkuDgEoList;
        ArrayList bundleItemStorageDgDtoList = Lists.newArrayList();
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemId);
        if (itemDgEo != null && itemDgEo.getType() != null && ItemTypeDgEnum.BUNDLE.getType().intValue() == itemDgEo.getType().intValue() && CollectionUtils.isNotEmpty((Collection)(itemSkuDgEoList = this.itemSkuDgDomain.selectByItemId(itemId)))) {
            itemSkuDgEoList.forEach(itemSkuEo -> {
                BundleItemStorageDgDto bundleItemStorageDgDto = new BundleItemStorageDgDto();
                bundleItemStorageDgDto.setShopId(shopId);
                bundleItemStorageDgDto.setItemId(itemId);
                bundleItemStorageDgDto.setSkuId(itemSkuEo.getId());
                Long shelfAmount = this.getBundleItemSkuStorage(shopId, itemSkuEo.getId());
                bundleItemStorageDgDto.setShelfAmount(shelfAmount);
                bundleItemStorageDgDtoList.add(bundleItemStorageDgDto);
            });
        }
        return bundleItemStorageDgDtoList;
    }
}

