/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.data.dto.dto.DictDto;
import com.yunxi.dg.base.center.data.proxy.query.IDictQueryApiProxy;
import com.yunxi.dg.base.center.item.constants.ItemDgItemAttributeEnum;
import com.yunxi.dg.base.center.item.constants.ItemVersionOaAuditStatusEnum;
import com.yunxi.dg.base.center.item.constants.ItemVersionStatusEnum;
import com.yunxi.dg.base.center.item.domain.entity.IItemBundleRelationDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.item.domain.entity.IItemVersionDgDomain;
import com.yunxi.dg.base.center.item.dto.entity.ItemVersionDgDto;
import com.yunxi.dg.base.center.item.dto.request.BundleItemBomDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.BundleItemDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemVersionDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.UnitDgRespDto;
import com.yunxi.dg.base.center.item.eo.ItemBundleRelationDgEo;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.item.eo.ItemVersionDgEo;
import com.yunxi.dg.base.center.item.event.localEvent.ItemVersionMqEvent;
import com.yunxi.dg.base.center.item.service.entity.IItemPushOaAssistService;
import com.yunxi.dg.base.center.item.service.entity.IItemSkuDgService;
import com.yunxi.dg.base.center.item.service.entity.IItemVersionDgService;
import com.yunxi.dg.base.center.item.service.entity.IUnitDgService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemVersionDgServiceImpl
implements IItemVersionDgService {
    private static final Logger log = LoggerFactory.getLogger(ItemVersionDgServiceImpl.class);
    @Resource
    private IItemDgDomain itemDgDomain;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IItemVersionDgDomain itemVersionDgDomain;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private IItemPushOaAssistService itemPushOaAssistService;
    @Resource
    private IItemBundleRelationDgDomain itemBundleRelationDgDomain;
    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private IItemSkuDgService itemSkuDgService;
    @Resource
    private IUnitDgService unitDgService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addItemVersion(ItemVersionDgDto dto) {
        AssertUtils.notEmpty((Collection)dto.getBundleItemBomDgReqDtoList(), (String)"bom\u6e05\u5355\u660e\u7ec6\u4e0d\u53ef\u4e3a\u7a7a!");
        ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)this.itemSkuDgDomain.selectById((Serializable)dto.getSkuId());
        AssertUtils.notNull((Object)itemSkuDgEo, (String)"sku\u4fe1\u606f\u4e0d\u5b58\u5728!");
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemSkuDgEo.getItemId());
        AssertUtils.notNull((Object)itemDgEo, (String)"spu\u4fe1\u606f\u4e0d\u5b58\u5728!");
        if (Objects.isNull(dto.getId())) {
            return this.addProcess(dto, itemSkuDgEo, itemDgEo);
        }
        return this.updateProcess(dto, itemSkuDgEo, itemDgEo);
    }

    private Long updateProcess(ItemVersionDgDto dto, ItemSkuDgEo itemSkuDgEo, ItemDgEo itemDgEo) {
        ItemVersionDgEo itemVersionDgEo = this.checkVersion(dto);
        boolean isPushOa = true;
        List itemVersionDgEoList = this.itemVersionDgDomain.queryEnableStatusAndSkuId(dto.getSkuId());
        itemVersionDgEo.setVersion(dto.getVersion());
        itemVersionDgEo.setBomAssemblyCoefficient(dto.getBomAssemblyCoefficient());
        if (!ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_PRODUCT.getType().equals(itemDgEo.getItemAttribute())) {
            AssertUtils.notNull((Object)dto.getStatus(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3anull");
            itemVersionDgEo.setStatus(dto.getStatus());
            isPushOa = false;
            if (CollectionUtil.isNotEmpty((Collection)itemVersionDgEoList)) {
                for (ItemVersionDgEo versionDgEo : itemVersionDgEoList) {
                    if (versionDgEo.getId().equals(itemVersionDgEo.getId())) continue;
                    versionDgEo.setStatus(ItemVersionStatusEnum.STOP_STATUS.getType());
                    this.itemVersionDgDomain.update((BaseEo)versionDgEo);
                }
            }
        } else {
            AssertUtils.isFalse((!ItemVersionStatusEnum.STOP_STATUS.getType().equals(itemVersionDgEo.getStatus()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u72b6\u6001\u4e3a\u7981\u7528\u7684version\u624d\u80fd\u7f16\u8f91");
            itemVersionDgEo.setPeriodStartTime(null);
            itemVersionDgEo.setPeriodEndTime(null);
            itemVersionDgEo.setStatus(ItemVersionStatusEnum.AWAIT_STATUS.getType());
            itemVersionDgEo.setOaAuditStatus(ItemVersionOaAuditStatusEnum.AWAIT_STATUS.getType());
        }
        this.itemVersionDgDomain.update((BaseEo)itemVersionDgEo);
        List itemBundleRelationDgEos = this.itemBundleRelationDgDomain.queryBySkuIdAndVersion(itemVersionDgEo.getSkuId(), dto.getVersion());
        if (CollectionUtil.isNotEmpty((Collection)itemBundleRelationDgEos)) {
            Set itemBundleIds = itemBundleRelationDgEos.stream().map(BaseEo::getId).collect(Collectors.toSet());
            this.itemBundleRelationDgDomain.logicDeleteByIds((List)Lists.newArrayList(itemBundleIds));
        }
        List<ItemBundleRelationDgEo> itemBundleRelationDgEoList = this.fillItemBundleRelationDgEo(dto.getBundleItemBomDgReqDtoList(), itemVersionDgEo, itemSkuDgEo, itemDgEo);
        this.itemBundleRelationDgDomain.insertBatch(itemBundleRelationDgEoList);
        if (isPushOa) {
            this.pushOa(itemVersionDgEo, itemBundleRelationDgEoList);
        }
        return itemVersionDgEo.getId();
    }

    private ItemVersionDgEo checkVersion(ItemVersionDgDto dto) {
        AssertUtils.notNull((Object)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ItemVersionDgEo itemVersionDgEo = this.checkId(dto.getId());
        List itemVersionDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemVersionDgDomain.filter().eq((Object)"sku_id", (Object)dto.getSkuId())).eq((Object)"version", (Object)dto.getVersion())).list();
        boolean checkVersion = CollectionUtil.isNotEmpty((Collection)itemVersionDgEos) && !((ItemVersionDgEo)itemVersionDgEos.get(0)).getId().equals(itemVersionDgEo.getId());
        AssertUtils.isFalse((boolean)checkVersion, (String)(dto.getVersion() + "\u7248\u672c\u53f7\u4e0d\u53ef\u91cd\u590d!"));
        return itemVersionDgEo;
    }

    private Long addProcess(ItemVersionDgDto dto, ItemSkuDgEo itemSkuDgEo, ItemDgEo itemDgEo) {
        List itemVersionDgEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemVersionDgDomain.filter().eq((Object)"sku_id", (Object)dto.getSkuId())).eq((Object)"version", (Object)dto.getVersion())).list();
        AssertUtils.isFalse((boolean)CollectionUtil.isNotEmpty((Collection)itemVersionDgEos), (String)(dto.getVersion() + "\u7248\u672c\u53f7\u4e0d\u53ef\u91cd\u590d!"));
        ItemVersionDgEo versionDgEo = new ItemVersionDgEo();
        BeanUtil.copyProperties((Object)dto, (Object)versionDgEo, (String[])new String[0]);
        boolean isPushOa = true;
        List itemVersionDgEoList = this.itemVersionDgDomain.queryEnableStatusAndSkuId(dto.getSkuId());
        if (!ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_PRODUCT.getType().equals(itemDgEo.getItemAttribute())) {
            versionDgEo.setOaAuditStatus(ItemVersionOaAuditStatusEnum.PASS_STATUS.getType());
            versionDgEo.setStatus(ItemVersionStatusEnum.ENABLE_STATUS.getType());
            for (ItemVersionDgEo itemVersionDgEo : itemVersionDgEoList) {
                itemVersionDgEo.setStatus(ItemVersionStatusEnum.STOP_STATUS.getType());
                this.itemVersionDgDomain.update((BaseEo)itemVersionDgEo);
            }
            isPushOa = false;
        } else {
            versionDgEo.setOaAuditStatus(ItemVersionOaAuditStatusEnum.AWAIT_STATUS.getType());
            versionDgEo.setStatus(ItemVersionStatusEnum.AWAIT_STATUS.getType());
        }
        versionDgEo.setId(null);
        versionDgEo.setSkuId(itemSkuDgEo.getId());
        versionDgEo.setSkuCode(itemSkuDgEo.getCode());
        versionDgEo.setItemId(itemSkuDgEo.getItemId());
        versionDgEo.setItemCode(itemDgEo.getCode());
        List<ItemBundleRelationDgEo> itemBundleRelationDgEos = this.fillItemBundleRelationDgEo(dto.getBundleItemBomDgReqDtoList(), versionDgEo, itemSkuDgEo, itemDgEo);
        this.itemVersionDgDomain.insert((BaseEo)versionDgEo);
        this.itemBundleRelationDgDomain.insertBatch(itemBundleRelationDgEos);
        if (isPushOa) {
            this.pushOa(versionDgEo, itemBundleRelationDgEos);
        }
        return versionDgEo.getId();
    }

    private List<ItemBundleRelationDgEo> fillItemBundleRelationDgEo(List<BundleItemBomDgReqDto> bundleItemBomDgReqDtoList, ItemVersionDgEo versionDgEo, ItemSkuDgEo itemSkuDgEo, ItemDgEo itemDgEo) {
        ArrayList bundleRelationDgEos = Lists.newArrayList();
        for (BundleItemBomDgReqDto bundleItemBomDgReqDto : bundleItemBomDgReqDtoList) {
            ItemBundleRelationDgEo bundleRelationDgEo = new ItemBundleRelationDgEo();
            BeanUtil.copyProperties((Object)bundleItemBomDgReqDto, (Object)bundleRelationDgEo, (String[])new String[0]);
            bundleRelationDgEo.setVersion(versionDgEo.getVersion());
            bundleRelationDgEo.setSkuId(itemSkuDgEo.getId());
            bundleRelationDgEo.setItemId(itemDgEo.getId());
            bundleRelationDgEo.setSubType(itemDgEo.getSubType());
            bundleRelationDgEo.setItemAttribute(bundleItemBomDgReqDto.getItemAttribute());
            bundleRelationDgEo.setId(null);
            bundleRelationDgEos.add(bundleRelationDgEo);
        }
        return bundleRelationDgEos;
    }

    private void pushOa(ItemVersionDgEo versionDgEo, List<ItemBundleRelationDgEo> bundleRelationDgEos) {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("isPushOa", "yunxi-dg-base-center-item"));
        if (Objects.nonNull(dictDto) && YesNoEnum.YES.getValue().equals(dictDto.getStatus())) {
            DgItemSkuDetailRespDto itemSkuDetailRespDto = this.itemSkuDgService.getItemSkuDetailById(versionDgEo.getSkuId());
            if (ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_PRODUCT.getType().equals(itemSkuDetailRespDto.getItemAttribute())) {
                ArrayList skuIds = Lists.newArrayList();
                for (ItemBundleRelationDgEo itemBundleRelationDgEo : bundleRelationDgEos) {
                    skuIds.add(itemBundleRelationDgEo.getSubSkuId());
                }
                List itemSkuDgEoList = this.itemSkuDgDomain.selectByIds((List)skuIds);
                Map itemSkuDgEoMap = itemSkuDgEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
                Set unitCodeList = itemSkuDgEoList.stream().map(ItemSkuDgEo::getUnit).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toSet());
                Map<Object, Object> unitDgRespDtoMap = Maps.newHashMap();
                if (CollectionUtil.isNotEmpty(unitCodeList)) {
                    List<UnitDgRespDto> unitDgRespDtoList = this.unitDgService.queryByCodes(Lists.newArrayList(unitCodeList));
                    unitDgRespDtoMap = unitDgRespDtoList.stream().collect(Collectors.toMap(UnitDgRespDto::getCode, Function.identity(), (v1, v2) -> v1));
                }
                ItemVersionDgRespDto itemVersionDgRespDto = (ItemVersionDgRespDto)BeanUtil.copyProperties((Object)versionDgEo, ItemVersionDgRespDto.class, (String[])new String[0]);
                List bundleItemDgReqDtoList = BeanUtil.copyToList(bundleRelationDgEos, BundleItemDgReqDto.class);
                for (BundleItemDgReqDto bundleItemDgReqDto : bundleItemDgReqDtoList) {
                    if (!itemSkuDgEoMap.containsKey(bundleItemDgReqDto.getSubSkuId())) continue;
                    ItemSkuDgEo skuDgEo = (ItemSkuDgEo)itemSkuDgEoMap.get(bundleItemDgReqDto.getSubSkuId());
                    bundleItemDgReqDto.setSubSkuName(skuDgEo.getName());
                    bundleItemDgReqDto.setSubSkuCode(skuDgEo.getCode());
                    bundleItemDgReqDto.setManageDepartmentName(skuDgEo.getManageDepartmentName());
                    if (!unitDgRespDtoMap.containsKey(skuDgEo.getUnit())) continue;
                    bundleItemDgReqDto.setUnitName(((UnitDgRespDto)unitDgRespDtoMap.get(skuDgEo.getUnit())).getName());
                }
                itemVersionDgRespDto.setBundleItemBomDgReqDtoList(bundleItemDgReqDtoList);
                itemSkuDetailRespDto.setVersionDgReqDtos(null);
                itemSkuDetailRespDto.setVersionDgReqDtos((List)Lists.newArrayList((Object[])new ItemVersionDgRespDto[]{itemVersionDgRespDto}));
                Boolean pushBomToOa = this.itemPushOaAssistService.pushBomToOa(itemSkuDetailRespDto);
                AssertUtils.isFalse((pushBomToOa == false ? 1 : 0) != 0, (String)"\u65b0\u589ebom\u6e05\u5355\uff0c\u63a8OA\u5ba1\u6838\u5931\u8d25");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveItemVersion(ItemVersionDgDto dto) {
        ItemVersionDgEo itemVersionDgEo = this.checkVersion(dto);
        AssertUtils.notEmpty((Collection)dto.getBundleItemBomDgReqDtoList(), (String)"bom\u6e05\u5355\u660e\u7ec6\u4e0d\u53ef\u4e3a\u7a7a!");
        ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)this.itemSkuDgDomain.selectById((Serializable)dto.getSkuId());
        AssertUtils.notNull((Object)itemSkuDgEo, (String)"sku\u4fe1\u606f\u4e0d\u5b58\u5728!");
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemSkuDgEo.getItemId());
        AssertUtils.notNull((Object)itemDgEo, (String)"spu\u4fe1\u606f\u4e0d\u5b58\u5728!");
        boolean isPushErp = true;
        String version = itemVersionDgEo.getVersion();
        itemVersionDgEo.setVersion(dto.getVersion());
        itemVersionDgEo.setBomAssemblyCoefficient(dto.getBomAssemblyCoefficient());
        List itemVersionDgEoList = this.itemVersionDgDomain.queryEnableStatusAndSkuId(itemVersionDgEo.getSkuId());
        if (!ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_PRODUCT.getType().equals(itemDgEo.getItemAttribute())) {
            itemVersionDgEo.setStatus(dto.getStatus());
            if (ItemVersionStatusEnum.ENABLE_STATUS.getType().equals(dto.getStatus())) {
                for (Object versionDgEo : itemVersionDgEoList) {
                    versionDgEo.setStatus(ItemVersionStatusEnum.STOP_STATUS.getType());
                    this.itemVersionDgDomain.update((BaseEo)versionDgEo);
                }
            }
            isPushErp = false;
        } else {
            log.info("\u72b6\u6001 -> {}", (Object)dto.getStatus());
            if (ItemVersionStatusEnum.STOP_STATUS.getType().equals(dto.getStatus())) {
                log.info("OA\u6d41\u7a0b \u72b6\u6001 -> {}", (Object)dto.getStatus());
                itemVersionDgEo.setStatus(ItemVersionStatusEnum.STOP_STATUS.getType());
                itemVersionDgEo.setPeriodEndTime(new Date());
            } else {
                isPushErp = false;
            }
        }
        this.itemVersionDgDomain.update((BaseEo)itemVersionDgEo);
        List itemBundleRelationDgEos = this.itemBundleRelationDgDomain.queryBySkuIdAndVersion(itemVersionDgEo.getSkuId(), version);
        if (CollectionUtil.isNotEmpty((Collection)itemBundleRelationDgEos)) {
            for (ItemBundleRelationDgEo itemBundleRelationDgEo : itemBundleRelationDgEos) {
                itemBundleRelationDgEo.setVersion(dto.getVersion());
                this.itemBundleRelationDgDomain.update((BaseEo)itemBundleRelationDgEo);
            }
        }
        if (isPushErp) {
            ItemVersionDgDto itemVersionDgDto = new ItemVersionDgDto();
            itemVersionDgDto.setSkuId(itemVersionDgEo.getSkuId());
            itemVersionDgDto.setId(itemVersionDgEo.getId());
            this.applicationContext.publishEvent((Object)new ItemVersionMqEvent(Lists.newArrayList((Object[])new ItemVersionDgDto[]{itemVersionDgDto})));
        }
    }

    private ItemVersionDgEo checkId(Long id) {
        ItemVersionDgEo itemVersionDgEo = (ItemVersionDgEo)this.itemVersionDgDomain.selectById((Serializable)id);
        AssertUtils.notNull((Object)itemVersionDgEo, (String)"\u6e05\u4f20\u6b63\u786e\u7684id");
        return itemVersionDgEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteItemVersion(Long id) {
        ItemVersionDgEo itemVersionDgEo = this.checkId(id);
        ItemSkuDgEo itemSkuDgEo = (ItemSkuDgEo)this.itemSkuDgDomain.selectById((Serializable)itemVersionDgEo.getSkuId());
        AssertUtils.notNull((Object)itemSkuDgEo, (String)"sku\u4fe1\u606f\u4e0d\u5b58\u5728!");
        ItemDgEo itemDgEo = (ItemDgEo)this.itemDgDomain.selectByPrimaryKey(itemSkuDgEo.getItemId());
        AssertUtils.notNull((Object)itemDgEo, (String)"spu\u4fe1\u606f\u4e0d\u5b58\u5728!");
        if (ItemDgItemAttributeEnum.ITEM_ATTRIBUTE_PRODUCT.getType().equals(itemDgEo.getItemAttribute())) {
            AssertUtils.isFalse((!ItemVersionOaAuditStatusEnum.FAIL_STATUS.getType().equals(itemVersionDgEo.getOaAuditStatus()) ? 1 : 0) != 0, (String)"\u5ba1\u6838\u4e0d\u901a\u8fc7\u624d\u80fd\u5220\u9664");
        }
        this.itemVersionDgDomain.delete((BaseEo)itemVersionDgEo);
        List itemBundleRelationDgEos = this.itemBundleRelationDgDomain.queryBySkuIdAndVersion(itemVersionDgEo.getSkuId(), itemVersionDgEo.getVersion());
        if (CollectionUtil.isNotEmpty((Collection)itemBundleRelationDgEos)) {
            Set itemBundleIds = itemBundleRelationDgEos.stream().map(BaseEo::getId).collect(Collectors.toSet());
            this.itemBundleRelationDgDomain.logicDeleteByIds((List)Lists.newArrayList(itemBundleIds));
        }
    }
}

