/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.customer.impl;

import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dao.das.customer.IDgCustomerAreaDas;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerAreaDomain;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsCustomerAreaDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsCustomerAreaInfoDto;
import com.yunxi.dg.base.center.report.dto.customer.request.DgCustomerShopAreaReqDto;
import com.yunxi.dg.base.center.report.dto.customer.response.DgCustomerShopAreaRespDto;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerAreaEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

@Service
public class DgCustomerAreaDomainImpl
extends BaseDomainImpl<DgCustomerAreaEo>
implements IDgCustomerAreaDomain {
    @Resource
    private IDgCustomerAreaDas iDgCustomerAreaDas;

    public ICommonDas<DgCustomerAreaEo> commonDas() {
        return this.iDgCustomerAreaDas;
    }

    @Override
    public List<DgCustomerShopAreaRespDto> queryAreaByShop(DgCustomerShopAreaReqDto reqDto) {
        return this.iDgCustomerAreaDas.queryAreaByShop(reqDto);
    }

    @Override
    public PageInfo<DgCustomerShopAreaRespDto> queryAreaPageByShop(DgCustomerShopAreaReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        return new PageInfo(this.iDgCustomerAreaDas.queryAreaByShop(reqDto));
    }

    @Override
    public List<CsCustomerAreaDto> getChildByIndexPaths(Set<String> indexPaths) {
        if (CollectionUtils.isEmpty(indexPaths)) {
            return Lists.newArrayList();
        }
        return this.iDgCustomerAreaDas.getChildByIndexPaths(indexPaths);
    }

    @Override
    public List<DgCustomerAreaEo> listChildAreaByCodes(List<String> codes, List<DgCustomerAreaEo> dgCustomerAreaEos) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<DgCustomerAreaEo>();
        }
        List areaEos = this.iDgCustomerAreaDas.listAreaByParentCodes(codes);
        if (CollectionUtils.isEmpty((Collection)areaEos)) {
            return new ArrayList<DgCustomerAreaEo>();
        }
        dgCustomerAreaEos.addAll(areaEos);
        return this.listChildAreaByCodes(areaEos.stream().map(DgCustomerAreaEo::getCode).collect(Collectors.toList()), dgCustomerAreaEos);
    }

    @Override
    public Map<Long, CsCustomerAreaInfoDto> getAreaInfoMap(List<Long> areaIds) {
        if (areaIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List areaList = this.selectByIds(areaIds);
        areaIds = areaList.stream().flatMap(k -> Arrays.stream(k.getIndexPath().split(",")).map(Long::parseLong)).distinct().collect(Collectors.toList());
        areaList = this.selectByIds(areaIds);
        Map<Long, DgCustomerAreaEo> areaMap = areaList.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
        return areaIds.stream().distinct().map(areId -> {
            DgCustomerAreaEo lastArea = (DgCustomerAreaEo)areaMap.get(areId);
            if (lastArea == null) {
                return null;
            }
            CsCustomerAreaInfoDto info = new CsCustomerAreaInfoDto();
            info.setAreaId(areId);
            List<Long> joinAreaIds = Arrays.stream(lastArea.getIndexPath().split(",")).map(Long::parseLong).collect(Collectors.toList());
            joinAreaIds.forEach(areaId -> {
                DgCustomerAreaEo area = (DgCustomerAreaEo)areaMap.get(areaId);
                if (area == null) {
                    return;
                }
                if (area.getCategory().equals(1)) {
                    info.setRegionCode(area.getCode());
                    info.setRegionName(area.getName());
                } else if (area.getCategory().equals(2)) {
                    info.setProvinceCode(area.getCode());
                    info.setProvinceName(area.getName());
                } else if (area.getCategory().equals(3)) {
                    info.setCityCode(area.getCode());
                    info.setCityName(area.getName());
                }
            });
            return info;
        }).filter(Objects::nonNull).collect(Collectors.toMap(CsCustomerAreaInfoDto::getAreaId, v -> v));
    }
}

