/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.enterprice.impl;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.enterprice.EnterpriceConstants;
import com.yunxi.dg.base.center.report.convert.entity.EnterpriceCrossOrderLineConverter;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderDomain;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderLineDomain;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossOrderDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossOrderLineDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossOrderLinePageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossOrderUpdateDto;
import com.yunxi.dg.base.center.report.enums.CompanyTradeTypeEnum;
import com.yunxi.dg.base.center.report.enums.EnterpriceCrossOrderSyncErpStatusEnum;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossOrderEo;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossOrderLineEo;
import com.yunxi.dg.base.center.report.service.enterprice.IEnterpriceCrossOrderLineService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.RoundingMode;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class EnterpriceCrossOrderLineServiceImpl
extends BaseServiceImpl<EnterpriceCrossOrderLineDto, EnterpriceCrossOrderLineEo, IEnterpriceCrossOrderLineDomain>
implements IEnterpriceCrossOrderLineService {
    @Resource
    private IEnterpriceCrossOrderDomain orderDomain;

    public EnterpriceCrossOrderLineServiceImpl(IEnterpriceCrossOrderLineDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<EnterpriceCrossOrderLineDto, EnterpriceCrossOrderLineEo> converter() {
        return EnterpriceCrossOrderLineConverter.INSTANCE;
    }

    @Override
    public PageInfo<EnterpriceCrossOrderLineDto> queryPage(EnterpriceCrossOrderLinePageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(((IEnterpriceCrossOrderLineDomain)this.domain).queryPage(dto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrder(EnterpriceCrossOrderUpdateDto dto) {
        EnterpriceCrossOrderLineEo orderLineEo;
        EnterpriceCrossOrderEo orderEo1;
        EnterpriceCrossOrderEo orderEoQuery = new EnterpriceCrossOrderEo();
        orderEoQuery.setId(dto.getOrderId());
        EnterpriceCrossOrderEo orderEo = (EnterpriceCrossOrderEo)this.orderDomain.selectOne((BaseEo)orderEoQuery);
        AssertUtils.notNull((Object)orderEo, (String)"\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
        AssertUtils.isTrue((orderEo.getType().equals(CompanyTradeTypeEnum.SALE_ORDER.getType()) || orderEo.getType().equals(CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType()) ? 1 : 0) != 0, (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u5141\u8bb8\u7f16\u8f91");
        AssertUtils.isTrue((boolean)orderEo.getSyncStatus().equals(EnterpriceCrossOrderSyncErpStatusEnum.SYNC_FAIL.getType()), (String)"\u4fee\u6539\u5931\u8d25\uff0c\u4ea4\u6613\u5355\u5df2\u540c\u6b65");
        this.orderDomain.updateOrder(dto, orderEo);
        if (orderEo.getType().equals(CompanyTradeTypeEnum.SALE_ORDER.getType())) {
            ((IEnterpriceCrossOrderLineDomain)this.domain).updateOrderLine(dto.getOrderId(), dto.getId(), dto.getPrice());
        }
        if ((orderEo1 = this.orderDomain.selectRelevanceSaleOrderOrPurchaseOrder(orderEo.getId())) == null) {
            return;
        }
        EnterpriceCrossOrderUpdateDto dto1 = (EnterpriceCrossOrderUpdateDto)BeanUtil.copyProperties((Object)dto, EnterpriceCrossOrderUpdateDto.class, (String[])new String[0]);
        this.orderDomain.updateOrder(dto1, orderEo1);
        if (orderEo1.getType().equals(CompanyTradeTypeEnum.PURCHASE_ORDER.getType()) && (orderLineEo = ((IEnterpriceCrossOrderLineDomain)this.domain).selectRelevanceSaleOrderLineOrPurchaseOrderLine(dto.getId())) != null) {
            ((IEnterpriceCrossOrderLineDomain)this.domain).updateOrderLine(orderLineEo.getOrderId(), orderLineEo.getId(), dto.getPrice().divide(EnterpriceConstants.ENTERPRICE_PRICE_FIXED_RATIO, 6, RoundingMode.HALF_UP));
        }
    }

    @Override
    public EnterpriceCrossOrderLineDto selectOrderLine(Long id) {
        EnterpriceCrossOrderLineDto orderLineDto = ((IEnterpriceCrossOrderLineDomain)this.domain).selectOrderLine(id);
        AssertUtils.notNull((Object)orderLineDto, (String)"\u67e5\u65e0\u5546\u54c1\u884c");
        Long saleOrderByPurchaseOrderId = this.orderDomain.getSaleOrderByPurchaseOrderId(orderLineDto.getOrderId());
        if (saleOrderByPurchaseOrderId == null) {
            return orderLineDto;
        }
        EnterpriceCrossOrderDto orderDto = this.orderDomain.selectOrder(saleOrderByPurchaseOrderId);
        if (orderDto == null) {
            return orderLineDto;
        }
        orderLineDto.setRelevanceDocumentNo(orderDto.getDocumentNo());
        if (orderDto.getSupplierId() != null) {
            orderLineDto.setSupplierId(orderDto.getSupplierId());
            orderLineDto.setSupplierCode(orderDto.getSupplierCode());
            orderLineDto.setSupplierName(orderDto.getSupplierName());
            orderLineDto.setPurchaseEnterpriseId(orderDto.getPurchaseEnterpriseId());
            orderLineDto.setPurchaseEnterpriseCode(orderDto.getPurchaseEnterpriseCode());
            orderLineDto.setPurchaseEnterpriseName(orderDto.getPurchaseEnterpriseName());
        }
        if (orderDto.getSaleEnterpriseId() != null) {
            orderLineDto.setSaleEnterpriseId(orderDto.getSaleEnterpriseId());
            orderLineDto.setSaleEnterpriseCode(orderDto.getSaleEnterpriseCode());
            orderLineDto.setSaleEnterpriseName(orderDto.getSaleEnterpriseName());
            orderLineDto.setCustomerId(orderDto.getCustomerId());
            orderLineDto.setCustomerCode(orderDto.getCustomerCode());
            orderLineDto.setCustomerName(orderDto.getCustomerName());
        }
        return orderLineDto;
    }
}

