/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.enterprice.impl.handler;

import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderDomain;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderLineDomain;
import com.yunxi.dg.base.center.report.dto.companytrade.EnterpriseDto;
import com.yunxi.dg.base.center.report.dto.companytrade.EnterpriseModifyTransferOrderNoEventDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossReceiveDeliveryResultDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossReceiveDeliveryResultReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossTradeRelationRespDto;
import com.yunxi.dg.base.center.report.enums.BusinessTypeEnum;
import com.yunxi.dg.base.center.report.enums.CompanyTradeTypeEnum;
import com.yunxi.dg.base.center.report.enums.DisplayBusinessTypeEnum;
import com.yunxi.dg.base.center.report.enums.ReceiveDeliveryResultOrderTypeEnum;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossOrderEo;
import com.yunxi.dg.base.center.report.service.enterprice.IEnterpriceCrossTradeRelationService;
import com.yunxi.dg.base.center.report.service.enterprice.impl.handler.EnterpriceCrossAbstractSceneServiceImpl;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class EnterpriceCrossInterOrgTransferServiceImpl
extends EnterpriceCrossAbstractSceneServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(EnterpriceCrossInterOrgTransferServiceImpl.class);
    @Resource
    private IEnterpriceCrossOrderDomain orderDomain;
    @Resource
    private IEnterpriceCrossOrderLineDomain orderLineDomain;
    @Resource
    private IEnterpriceCrossTradeRelationService tradeRelationService;
    @Resource
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public Boolean checkEnterpriceOrderAndHandleBusinessType(EnterpriceCrossReceiveDeliveryResultReqDto context) {
        boolean interOrganizationTransactionOrderFlag = StringUtils.equals((CharSequence)context.getResultDto().getBusinessType(), (CharSequence)BusinessTypeEnum.INTER_ORGANIZATION_TRANSACTION_ORDER.getType());
        if (interOrganizationTransactionOrderFlag) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public List<Long> createOrder(EnterpriceCrossReceiveDeliveryResultReqDto context) {
        CompanyTradeTypeEnum orderTypeEnum = this.checkInterOrgTransationOrderCompanyTradeType(context.getResultDto().getDisplayBusinessType(), context.getResultDto().getOrderType());
        EnterpriceCrossReceiveDeliveryResultDto resultDto = context.getResultDto();
        AssertUtils.notNull((Object)orderTypeEnum, (String)("\u3010\u516c\u53f8\u95f4\u4ea4\u6613\u3011\u8de8\u7ec4\u7ec7\u8c03\u62e8\uff0c\u5224\u65ad\u516c\u53f8\u95f4\u4ea4\u6613\u7c7b\u578b\u5931\u8d25\uff0c\u5355\u53f7\uff1a" + resultDto.getDocumentNo()));
        EnterpriceCrossOrderEo orderEo = this.createEo(resultDto.getBusinessType(), resultDto.getDisplayBusinessType(), resultDto.getId(), orderTypeEnum.getType());
        this.setOrgInfo(orderEo, resultDto);
        this.orderDomain.insert((BaseEo)orderEo);
        this.createOrderLine(orderEo, context);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new EnterpriseModifyTransferOrderNoEventDto((Object)context));
        return Collections.singletonList(orderEo.getId());
    }

    private void createOrderLine(EnterpriceCrossOrderEo orderEo, EnterpriceCrossReceiveDeliveryResultReqDto context) {
        Boolean deductResult;
        if (orderEo.getType().equals(CompanyTradeTypeEnum.PURCHASE_ORDER.getType()) || orderEo.getType().equals(CompanyTradeTypeEnum.SALE_ORDER.getType())) {
            deductResult = this.orderLineDomain.createOrderLine(context.getResultDto(), context.getResultDetailDtoList(), orderEo);
            this.deductFailSetSyncException(deductResult, orderEo);
        }
        if (orderEo.getType().equals(CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType())) {
            deductResult = this.orderLineDomain.purchaseOrderReturnDeductAndCreateOrderLine(context.getResultDetailDtoList(), orderEo);
            this.deductFailSetSyncException(deductResult, orderEo);
        }
        if (orderEo.getType().equals(CompanyTradeTypeEnum.AFTERSALE_ORDER.getType())) {
            deductResult = this.orderLineDomain.saleOrderReturnDeductAndCreateOrderLine(context.getResultDetailDtoList(), orderEo);
            this.deductFailSetSyncException(deductResult, orderEo);
        }
    }

    private void setOrgInfo(EnterpriceCrossOrderEo orderEo, EnterpriceCrossReceiveDeliveryResultDto resultDto) {
        EnterpriseDto enterpriseDto;
        EnterpriseDto deliveryEnterpriseDto = this.orderDomain.getLogicWarehouseEnterprise(resultDto.getDeliveryLogicWarehouseCode());
        EnterpriseDto receiveEnterpriseDto = this.orderDomain.getLogicWarehouseEnterprise(resultDto.getReceiveLogicWarehouseCode());
        EnterpriceCrossTradeRelationRespDto tradeRelationRespDto = null;
        if (deliveryEnterpriseDto != null && receiveEnterpriseDto != null) {
            tradeRelationRespDto = resultDto.getDisplayBusinessType().equals(DisplayBusinessTypeEnum.COMPANY_TRANSACTION.getType()) ? this.tradeRelationService.getByPurchaseEnterpriseCodeAndEnterpriseCode(receiveEnterpriseDto.getEnterpriseCode(), deliveryEnterpriseDto.getEnterpriseCode()) : this.tradeRelationService.getByPurchaseEnterpriseCodeAndEnterpriseCode(deliveryEnterpriseDto.getEnterpriseCode(), receiveEnterpriseDto.getEnterpriseCode());
        }
        if (orderEo.getType().equals(CompanyTradeTypeEnum.PURCHASE_ORDER.getType()) || orderEo.getType().equals(CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType())) {
            enterpriseDto = orderEo.getType().equals(CompanyTradeTypeEnum.PURCHASE_ORDER.getType()) ? receiveEnterpriseDto : deliveryEnterpriseDto;
            this.setPurchase(orderEo, enterpriseDto);
            this.setSupplier(orderEo, tradeRelationRespDto);
        }
        if (orderEo.getType().equals(CompanyTradeTypeEnum.SALE_ORDER.getType()) || orderEo.getType().equals(CompanyTradeTypeEnum.AFTERSALE_ORDER.getType())) {
            enterpriseDto = orderEo.getType().equals(CompanyTradeTypeEnum.SALE_ORDER.getType()) ? receiveEnterpriseDto : deliveryEnterpriseDto;
            this.setSaleEnterprice(orderEo, enterpriseDto);
            this.setCustomer(orderEo, tradeRelationRespDto);
        }
    }

    private void setCustomer(EnterpriceCrossOrderEo orderEo, EnterpriceCrossTradeRelationRespDto tradeRelationRespDto) {
        if (tradeRelationRespDto == null) {
            this.setExceptionToSyncException(orderEo, "\u5339\u914d\u4ea4\u6613\u5173\u7cfb\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
            return;
        }
        orderEo.setCustomerId(tradeRelationRespDto.getCustomerId());
        orderEo.setCustomerCode(tradeRelationRespDto.getCustomerCode());
    }

    private void setSaleEnterprice(EnterpriceCrossOrderEo orderEo, EnterpriseDto saleEnterpriseDto) {
        if (saleEnterpriseDto == null) {
            this.setExceptionToSyncException(orderEo, "\u83b7\u53d6\u9500\u552e\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
            return;
        }
        orderEo.setSaleEnterpriseId(saleEnterpriseDto.getEnterpriseId());
        orderEo.setSaleEnterpriseCode(saleEnterpriseDto.getEnterpriseCode());
        orderEo.setCalculateCompanyCode(saleEnterpriseDto.getEnterpriseCode());
    }

    private void setSupplier(EnterpriceCrossOrderEo orderEo, EnterpriceCrossTradeRelationRespDto tradeRelationRespDto) {
        if (tradeRelationRespDto == null) {
            this.setExceptionToSyncException(orderEo, "\u5339\u914d\u4ea4\u6613\u5173\u7cfb\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
            return;
        }
        orderEo.setSupplierId(tradeRelationRespDto.getSupplierId());
        orderEo.setSupplierCode(tradeRelationRespDto.getSupplierCode());
    }

    private void setPurchase(EnterpriceCrossOrderEo orderEo, EnterpriseDto enterpriseDto) {
        if (enterpriseDto == null) {
            this.setExceptionToSyncException(orderEo, "\u83b7\u53d6\u91c7\u8d2d\u65b9\u4fe1\u606f\u5931\u8d25");
            return;
        }
        orderEo.setPurchaseEnterpriseId(enterpriseDto.getEnterpriseId());
        orderEo.setPurchaseEnterpriseCode(enterpriseDto.getEnterpriseCode());
        orderEo.setCalculateCompanyCode(orderEo.getPurchaseEnterpriseCode());
    }

    private CompanyTradeTypeEnum checkInterOrgTransationOrderCompanyTradeType(String displayBusinessType, String orderType) {
        boolean deliveredFlag = orderType.equals(ReceiveDeliveryResultOrderTypeEnum.DELIVERY.getType());
        if (deliveredFlag) {
            boolean isCompanyTransactionFlag = displayBusinessType.equals(DisplayBusinessTypeEnum.COMPANY_TRANSACTION.getType());
            return isCompanyTransactionFlag ? CompanyTradeTypeEnum.SALE_ORDER : CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER;
        }
        boolean receivedFlag = orderType.equals(ReceiveDeliveryResultOrderTypeEnum.RECEIVE.getType());
        if (receivedFlag) {
            boolean isCompanyTransactionFlag = displayBusinessType.equals(DisplayBusinessTypeEnum.COMPANY_TRANSACTION.getType());
            return isCompanyTransactionFlag ? CompanyTradeTypeEnum.PURCHASE_ORDER : CompanyTradeTypeEnum.AFTERSALE_ORDER;
        }
        return null;
    }
}

