/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.convert.entity.AccountFlowConverter;
import com.yunxi.dg.base.center.report.domain.entity.IAccountFlowDomain;
import com.yunxi.dg.base.center.report.domain.entity.IFlowTypeDomain;
import com.yunxi.dg.base.center.report.dto.entity.AccountFlowDto;
import com.yunxi.dg.base.center.report.dto.entity.AccountFlowPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.FlowTypeDto;
import com.yunxi.dg.base.center.report.eo.account.AccountFlowEo;
import com.yunxi.dg.base.center.report.eo.account.FlowTypeEo;
import com.yunxi.dg.base.center.report.service.entity.IAccountFlowService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Service;

@Service
public class AccountFlowServiceImpl
extends BaseServiceImpl<AccountFlowDto, AccountFlowEo, IAccountFlowDomain>
implements IAccountFlowService {
    @Resource
    private ICacheService cacheService;
    @Resource
    private IFlowTypeDomain flowTypeDomain;

    public AccountFlowServiceImpl(IAccountFlowDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<AccountFlowDto, AccountFlowEo> converter() {
        return AccountFlowConverter.INSTANCE;
    }

    @Override
    public PageInfo<AccountFlowDto> page(AccountFlowPageReqDto reqDto) {
        Object[] args;
        PageInfo pageInfo = new PageInfo();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqDto.getBusinessOrderNo()}) && CollectionUtils.isEmpty((Collection)reqDto.getBusinessOrderNos()) && (args = reqDto.getBusinessOrderNo().split("[,\uff0c]")).length > 1) {
            reqDto.setBusinessOrderNos((List)Lists.newArrayList((Object[])args));
            reqDto.setBusinessOrderNo(null);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqDto.getChangeType()})) {
            Map<String, List<FlowTypeDto>> map = this.queryFlowTypeList().stream().collect(Collectors.groupingBy(FlowTypeDto::getType));
            reqDto.setChangeTypeList(map.get(reqDto.getChangeType()).get(0).getOldTypes());
            reqDto.setChangeType(null);
        }
        PageInfo eoPageInfo = ((IAccountFlowDomain)this.domain).page(reqDto);
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)eoPageInfo, (String[])new String[]{"navigatepageNums", "list"});
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            List accountFlowDtos;
            ArrayList dtos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)dtos, (Collection)eoPageInfo.getList(), AccountFlowDto.class);
            Map<Object, Object> orderMap = Maps.newHashMap();
            List saleOrderNos = dtos.stream().map(AccountFlowDto::getOrderNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(saleOrderNos) && CollectionUtils.isNotEmpty((Collection)(accountFlowDtos = ((IAccountFlowDomain)this.domain).queryFinanceAuditTimeBySaleOrderNos(saleOrderNos)))) {
                orderMap = accountFlowDtos.stream().collect(Collectors.toMap(AccountFlowDto::getOrderNo, Function.identity(), (a, b) -> a));
            }
            JSONObject ftMap = this.queryFlowTypeMap();
            for (AccountFlowDto dto : dtos) {
                AccountFlowDto dgEsPerformOrderRespDto;
                dto.setChangeTypeName(ftMap.getString(dto.getChangeType()));
                if (!StringUtils.isNotBlank((CharSequence)dto.getOrderNo()) || (dgEsPerformOrderRespDto = (AccountFlowDto)orderMap.get(dto.getOrderNo())) == null) continue;
                dto.setFinanceAuditTime(dgEsPerformOrderRespDto.getFinanceAuditTime());
            }
            pageInfo.setList((List)dtos);
        }
        return pageInfo;
    }

    private JSONObject queryFlowTypeMap() {
        String key = "flowTypeMap";
        String cacheValue = (String)this.cacheService.getCache("global", key, String.class);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cacheValue})) {
            return JSON.parseObject((String)cacheValue);
        }
        FlowTypeEo typeEo = new FlowTypeEo();
        typeEo.setStatus("enable");
        List fts = this.flowTypeDomain.selectList((BaseEo)typeEo);
        JSONObject result = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)fts)) {
            for (FlowTypeEo eo : fts) {
                result.put(eo.getType(), (Object)eo.getNewName());
            }
            this.cacheService.setCache("global", key, (Object)result.toJSONString());
        }
        return result;
    }

    private List<FlowTypeDto> queryFlowTypeList() {
        String key = "flowTypeList";
        String cacheValue = (String)this.cacheService.getCache("global", key, String.class);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cacheValue})) {
            return JSON.parseArray((String)cacheValue, FlowTypeDto.class);
        }
        FlowTypeEo typeEo = new FlowTypeEo();
        typeEo.setStatus("enable");
        List fts = this.flowTypeDomain.selectList((BaseEo)typeEo);
        ArrayList dtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)fts)) {
            HashMap result = Maps.newHashMap();
            for (FlowTypeEo ft : fts) {
                if (!result.containsKey(ft.getNewType())) {
                    FlowTypeDto dto = new FlowTypeDto();
                    dto.setType(ft.getNewType());
                    dto.setName(ft.getNewName());
                    dto.setOldTypes((List)Lists.newArrayList((Object[])new String[]{ft.getType()}));
                    result.put(dto.getType(), dto);
                    dtos.add(dto);
                    continue;
                }
                ((FlowTypeDto)result.get(ft.getNewType())).getOldTypes().add(ft.getType());
            }
            this.cacheService.setCache("global", key, (Object)JSON.toJSONString((Object)dtos));
        }
        return dtos;
    }
}

