/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.report.domain.entity.IDgAfterSaleOrderDz1Domain;
import com.yunxi.dg.base.center.report.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderInfoDz1Domain;
import com.yunxi.dg.base.center.report.domain.trade.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.report.dto.dz1.req.DgAfterSaleOrderDz1ReqDto;
import com.yunxi.dg.base.center.report.dto.dz1.req.DgAfterSaleOrderItemDz1RespDto;
import com.yunxi.dg.base.center.report.dto.dz1.req.DgOrderDz1PageReqDto;
import com.yunxi.dg.base.center.report.dto.dz1.resp.DgAfterSaleOrderDz1RespDto;
import com.yunxi.dg.base.center.report.dto.dz1.resp.DgPerformOrderInfoDz1Dto;
import com.yunxi.dg.base.center.report.dto.dz1.resp.DgPerformOrderItemDz1RespDto;
import com.yunxi.dg.base.center.report.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.report.eo.trade.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.report.service.entity.IDgSaleOrderSearchService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgSaleOrderSearchServiceImpl
implements IDgSaleOrderSearchService {
    private static final Logger log = LoggerFactory.getLogger(DgSaleOrderSearchServiceImpl.class);
    @Resource
    private IDgPerformOrderInfoDz1Domain domain;
    @Resource
    private IDgPerformOrderItemDomain performOrderItemDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain orderLineAmountDomain;
    @Resource
    private IDgAfterSaleOrderDz1Domain afterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderItemDomain afterSaleOrderItemDomain;

    @Override
    public PageInfo<DgPerformOrderInfoDz1Dto> queryOrderInfoByPage(DgOrderDz1PageReqDto reqDto) {
        log.info("queryByPageDz1Param\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.paramCheck(reqDto);
        PageInfo orderInfoPage = this.domain.queryOrderInfoByPage(reqDto);
        List orderInfoList = orderInfoPage.getList();
        if (CollUtil.isEmpty((Collection)orderInfoList)) {
            return orderInfoPage;
        }
        this.setItemInfo(orderInfoList);
        return orderInfoPage;
    }

    private void paramCheck(DgOrderDz1PageReqDto reqDto) {
        AssertUtils.isFalse((reqDto.getPageSize() > 100 ? 1 : 0) != 0, (String)"\u6bcf\u9875\u884c\u6570\u6700\u5927100");
    }

    private void setItemInfo(List<DgPerformOrderInfoDz1Dto> orderInfoList) {
        List orderIdList = orderInfoList.stream().map(DgPerformOrderInfoDz1Dto::getId).collect(Collectors.toList());
        List itemDetailList = this.performOrderItemDomain.queryPerformItemDetailByOrderId(orderIdList);
        if (CollUtil.isEmpty((Collection)itemDetailList)) {
            log.info("\u5355\u636e\u5173\u8054\u5546\u54c1\u884c\u4e0d\u5b58\u5728");
            return;
        }
        Map<Long, List<DgPerformOrderItemDz1RespDto>> itemMap = itemDetailList.stream().map(item -> {
            DgPerformOrderItemDz1RespDto itemDzDto = new DgPerformOrderItemDz1RespDto();
            BeanUtil.copyProperties((Object)item, (Object)itemDzDto, (String[])new String[0]);
            return itemDzDto;
        }).collect(Collectors.groupingBy(DgPerformOrderItemDz1RespDto::getOrderId));
        List orderLineAmountEos = this.orderLineAmountDomain.selectByOrderIds(orderIdList);
        if (CollUtil.isEmpty((Collection)orderLineAmountEos)) {
            log.info("\u5355\u636e\u5173\u8054\u5546\u54c1\u884c\u91d1\u989d\u4e0d\u5b58\u5728");
            return;
        }
        Map<Long, List<DgPerformOrderLineAmountEo>> sfAmountMap = orderLineAmountEos.stream().filter(line -> DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode().equals(line.getAccountType())).collect(Collectors.groupingBy(DgPerformOrderLineAmountEo::getOrderId));
        for (DgPerformOrderInfoDz1Dto orderInfo : orderInfoList) {
            Long orderId = orderInfo.getId();
            List<DgPerformOrderItemDz1RespDto> itemDzs = itemMap.get(orderId);
            if (CollUtil.isEmpty(itemDzs)) {
                log.info("\u9500\u552e\u8ba2\u5355\uff1a{} \u5546\u54c1\u884c\u4e3a\u7a7a", (Object)orderInfo.getSaleOrderNo());
                continue;
            }
            List<DgPerformOrderLineAmountEo> lineAmountEos = sfAmountMap.get(orderId);
            if (CollUtil.isEmpty(lineAmountEos)) {
                log.info("\u9500\u552e\u8ba2\u5355\uff1a{} \u5546\u54c1\u884c\u91d1\u989d\u4e3a\u7a7a", (Object)orderInfo.getSaleOrderNo());
                continue;
            }
            Map<Long, BigDecimal> amountEoMap = lineAmountEos.stream().collect(Collectors.toMap(DgPerformOrderLineAmountEo::getOrderLineId, DgPerformOrderLineAmountEo::getAmount, (v1, v2) -> v2));
            for (DgPerformOrderItemDz1RespDto item2 : itemDzs) {
                Long itemId = item2.getId();
                item2.setPayAmount(Convert.toBigDecimal((Object)amountEoMap.get(itemId), (BigDecimal)BigDecimal.ZERO));
            }
            orderInfo.setItemList(itemDzs);
        }
    }

    @Override
    public PageInfo<DgAfterSaleOrderDz1RespDto> queryReturnByPage(DgAfterSaleOrderDz1ReqDto reqDto) {
        log.info("\u9000\u8d27\u5355\u5217\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.paramCheck(reqDto);
        PageInfo pageInfo = this.afterSaleOrderDomain.queryReturnByPage(reqDto);
        List pageInfoList = pageInfo.getList();
        if (CollUtil.isEmpty((Collection)pageInfoList)) {
            return pageInfo;
        }
        this.setAfterItemInfo(pageInfoList);
        return pageInfo;
    }

    private void paramCheck(DgAfterSaleOrderDz1ReqDto reqDto) {
        AssertUtils.isFalse((reqDto.getPageSize() > 100 ? 1 : 0) != 0, (String)"\u6bcf\u9875\u884c\u6570\u6700\u5927100");
    }

    private void setAfterItemInfo(List<DgAfterSaleOrderDz1RespDto> pageInfoList) {
        List ids = pageInfoList.stream().map(DgAfterSaleOrderDz1RespDto::getId).collect(Collectors.toList());
        List itemEoList = this.afterSaleOrderItemDomain.selectByAfterOrderIds(ids);
        if (CollUtil.isEmpty((Collection)itemEoList)) {
            log.info("\u552e\u540e\u5173\u8054\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        Map<Long, List<DgAfterSaleOrderItemEo>> itemMap = itemEoList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemEo::getAfterSaleOrderId));
        for (DgAfterSaleOrderDz1RespDto afterSaleOrder : pageInfoList) {
            Long id = afterSaleOrder.getId();
            List<DgAfterSaleOrderItemEo> orderItemEos = itemMap.get(id);
            if (CollUtil.isEmpty(orderItemEos)) {
                log.info("\u552e\u540e\u5355\uff1a{} {} \u5546\u54c1\u884c\u4e3a\u7a7a", (Object)afterSaleOrder.getAfterSaleOrderNo(), (Object)afterSaleOrder.getPlatformRefundOrderSn());
                continue;
            }
            List itemDtoList = orderItemEos.stream().map(line -> {
                DgAfterSaleOrderItemDz1RespDto itemDto = new DgAfterSaleOrderItemDz1RespDto();
                BeanUtil.copyProperties((Object)line, (Object)itemDto, (String[])new String[0]);
                return itemDto;
            }).collect(Collectors.toList());
            afterSaleOrder.setItems(itemDtoList);
        }
    }
}

