/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.CostStatisticalTypeEnum;
import com.yunxi.dg.base.center.report.convert.entity.ShopSkuCostDetailConverter;
import com.yunxi.dg.base.center.report.dao.das.IOrderSkuCostDetailDas;
import com.yunxi.dg.base.center.report.dao.das.IShopSkuCostDetailDas;
import com.yunxi.dg.base.center.report.domain.entity.IShopSkuCostDetailDomain;
import com.yunxi.dg.base.center.report.domain.item.IDirDgDomain;
import com.yunxi.dg.base.center.report.dto.entity.ShopSkuCostDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.ShopSkuCostDetailPageReqDto;
import com.yunxi.dg.base.center.report.eo.OrderSkuCostDetailEo;
import com.yunxi.dg.base.center.report.eo.ShopSkuCostDetailEo;
import com.yunxi.dg.base.center.report.service.entity.IShopSkuCostDetailService;
import com.yunxi.dg.base.center.report.utils.MathUtils;
import com.yunxi.dg.base.center.report.utils.PageQueryUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ShopSkuCostDetailServiceImpl
extends BaseServiceImpl<ShopSkuCostDetailDto, ShopSkuCostDetailEo, IShopSkuCostDetailDomain>
implements IShopSkuCostDetailService {
    private static final Logger log = LoggerFactory.getLogger(ShopSkuCostDetailServiceImpl.class);
    @Resource
    private IOrderSkuCostDetailDas orderSkuCostDetailDas;
    @Resource
    private IShopSkuCostDetailDas shopSkuCostDetailDas;
    @Resource
    private IDirDgDomain dirDgDomain;

    public ShopSkuCostDetailServiceImpl(IShopSkuCostDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ShopSkuCostDetailDto, ShopSkuCostDetailEo> converter() {
        return ShopSkuCostDetailConverter.INSTANCE;
    }

    @Override
    public void syncWithDates(List<LocalDate> dates) {
        dates = dates.stream().distinct().sorted().collect(Collectors.toList());
        dates.forEach(date -> {
            try {
                this.syncWithDate((LocalDate)date);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65 {} \u7684\u5e97\u94faSKU\u8d39\u7528\u5206\u644a\u660e\u7ec6\u5931\u8d25", date, (Object)e);
            }
        });
        this.syncAfterAllDateOnly(dates);
    }

    @Override
    public void syncAfterAllDateOnly(List<LocalDate> dates) {
        String reportName = "\u5e97\u94faSKU\u8d39\u7528\u5206\u644a\u660e\u7ec6";
        CostStatisticalTypeEnum.MONTH.doSync(reportName, dates, this::syncWithRange);
        CostStatisticalTypeEnum.QUARTER.doSync(reportName, dates, this::syncWithRange);
        CostStatisticalTypeEnum.YEAR.doSync(reportName, dates, this::syncWithRange);
    }

    private void syncWithRange(CostStatisticalTypeEnum type, Integer currentDate, Integer startDate, Integer endDate) {
        List<ShopSkuCostDetailEo> list = PageQueryUtils.queryAll(1000, () -> this.shopSkuCostDetailDas.queryByStatisticalDate(startDate, endDate, type.getPrev().getCode()));
        Map<String, List<ShopSkuCostDetailEo>> group = this.groupShopSkuCostDetails(list);
        ArrayList<ShopSkuCostDetailEo> details = new ArrayList<ShopSkuCostDetailEo>();
        group.forEach((key, values) -> {
            BigDecimal paidAmount = BigDecimal.ZERO;
            BigDecimal refundAmount = BigDecimal.ZERO;
            BigDecimal saleAmount = BigDecimal.ZERO;
            BigDecimal budgetCostAmount = BigDecimal.ZERO;
            BigDecimal actualCostAmount = BigDecimal.ZERO;
            BigDecimal taxCostAmount = BigDecimal.ZERO;
            int paidNum = 0;
            int refundNum = 0;
            for (ShopSkuCostDetailEo value : values) {
                paidAmount = paidAmount.add(Optional.ofNullable(value.getPaidAmount()).orElse(BigDecimal.ZERO));
                refundAmount = refundAmount.add(Optional.ofNullable(value.getRefundAmount()).orElse(BigDecimal.ZERO));
                saleAmount = saleAmount.add(Optional.ofNullable(value.getSaleAmount()).orElse(BigDecimal.ZERO));
                budgetCostAmount = budgetCostAmount.add(Optional.ofNullable(value.getBudgetCostAmount()).orElse(BigDecimal.ZERO));
                actualCostAmount = actualCostAmount.add(Optional.ofNullable(value.getActualCostAmount()).orElse(BigDecimal.ZERO));
                taxCostAmount = taxCostAmount.add(Optional.ofNullable(value.getTaxCostAmount()).orElse(BigDecimal.ZERO));
                paidNum += Optional.ofNullable(value.getPaidNum()).orElse(0).intValue();
                refundNum += Optional.ofNullable(value.getRefundNum()).orElse(0).intValue();
            }
            ShopSkuCostDetailEo o = (ShopSkuCostDetailEo)values.get(0);
            ShopSkuCostDetailEo eo = new ShopSkuCostDetailEo();
            eo.setType(type.getCode()).setStatisticalDate(currentDate).setShopId(o.getShopId()).setShopCode(o.getShopCode()).setShopName(o.getShopName()).setShopWebsiteId(o.getShopWebsiteId()).setShopWebsiteCode(o.getShopWebsiteCode()).setShopWebsiteName(o.getShopWebsiteName()).setDirId(o.getDirId()).setDirCode(o.getDirCode()).setDirName(o.getDirName()).setItemId(o.getItemId()).setItemCode(o.getItemCode()).setItemName(o.getItemName()).setSkuId(o.getSkuId()).setSkuCode(o.getSkuCode()).setSkuName(o.getSkuName()).setPaidNum(Integer.valueOf(paidNum)).setPaidAmount(paidAmount).setRefundNum(Integer.valueOf(refundNum)).setRefundAmount(refundAmount).setSaleNum(Integer.valueOf(eo.getPaidNum() - eo.getRefundNum())).setSaleAmount(saleAmount).setRefundRate(MathUtils.rate(eo.getRefundAmount(), saleAmount)).setBudgetCostAmount(budgetCostAmount).setBudgetCostRate(MathUtils.rate(budgetCostAmount, saleAmount)).setActualCostAmount(actualCostAmount).setActualCostRate(MathUtils.rate(actualCostAmount, saleAmount)).setTaxCostAmount(taxCostAmount).setGrossProfitAmount(saleAmount.subtract(taxCostAmount)).setGrossProfitRate(MathUtils.rate(eo.getGrossProfitAmount(), saleAmount)).setProfitAmount(eo.getGrossProfitAmount().subtract(actualCostAmount)).setProfitRate(MathUtils.rate(eo.getProfitAmount(), saleAmount)).setBudgetActualDiffAmount(eo.getBudgetCostAmount().subtract(eo.getActualCostAmount())).setBudgetActualDiffRate(Optional.ofNullable(eo.getBudgetCostRate()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(eo.getActualCostRate()).orElse(BigDecimal.ZERO)));
            details.add(eo);
        });
        details.sort(Comparator.comparing(ShopSkuCostDetailEo::getStatisticalDate));
        this.shopSkuCostDetailDas.physicalDeleteByDate(currentDate, type.getCode());
        this.shopSkuCostDetailDas.insertBatch(details);
    }

    private void syncWithDate(LocalDate date) {
        LocalDateTime startTime = date.atStartOfDay();
        LocalDateTime endTime = date.atTime(23, 59, 59);
        List<OrderSkuCostDetailEo> list = PageQueryUtils.queryAll(1000, () -> this.orderSkuCostDetailDas.queryByBizTime(startTime, endTime));
        this.syncDateOnly(date, list);
    }

    @Override
    public void syncDateOnly(LocalDate date, List<OrderSkuCostDetailEo> list) {
        log.info("\u540c\u6b65\u5e97\u94faSKU\u8d39\u7528\u5206\u644a\u660e\u7ec6\u5f00\u59cb: date={}", (Object)date);
        Map<String, List<OrderSkuCostDetailEo>> group = this.groupOrderSkuCostDetails(list);
        ArrayList<ShopSkuCostDetailEo> details = new ArrayList<ShopSkuCostDetailEo>();
        Integer statisticalDate = Integer.parseInt(date.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        group.forEach((key, values) -> {
            BigDecimal paidAmount = BigDecimal.ZERO;
            BigDecimal refundAmount = BigDecimal.ZERO;
            BigDecimal budgetCostAmount = BigDecimal.ZERO;
            BigDecimal actualCostAmount = BigDecimal.ZERO;
            BigDecimal taxCostAmount = BigDecimal.ZERO;
            HashSet<String> paidOrders = new HashSet<String>();
            HashSet<String> refundOrders = new HashSet<String>();
            HashSet<String> uniqueIds = new HashSet<String>();
            for (OrderSkuCostDetailEo value : values) {
                String uniqueId = String.format("%s_%s_%s", value.getSourceId(), value.getSourceType(), value.getSkuCode());
                if (!uniqueIds.contains(uniqueId)) {
                    uniqueIds.add(uniqueId);
                    if (value.isSaleOrder()) {
                        paidAmount = paidAmount.add(Optional.ofNullable(value.getSkuRealPayAmount()).orElse(BigDecimal.ZERO));
                        taxCostAmount = taxCostAmount.add(Optional.ofNullable(value.getSkuTaxCostAmount()).orElse(BigDecimal.ZERO));
                    } else {
                        refundAmount = refundAmount.add(Optional.ofNullable(value.getSkuRefundAmount()).orElse(BigDecimal.ZERO));
                    }
                }
                budgetCostAmount = budgetCostAmount.add(Optional.ofNullable(value.getBudgetCostAmount()).orElse(BigDecimal.ZERO));
                actualCostAmount = actualCostAmount.add(Optional.ofNullable(value.getActualCostAmount()).orElse(BigDecimal.ZERO));
                if (value.isSaleOrder()) {
                    paidOrders.add(value.getPlatformOrderNo());
                    continue;
                }
                refundOrders.add(value.getPlatformRefundOrderSn());
            }
            BigDecimal saleAmount = paidAmount.subtract(refundAmount);
            OrderSkuCostDetailEo o = (OrderSkuCostDetailEo)values.get(0);
            ShopSkuCostDetailEo eo = new ShopSkuCostDetailEo();
            eo.setType("date").setStatisticalDate(statisticalDate).setShopId(o.getShopId()).setShopCode(o.getShopCode()).setShopName(o.getShopName()).setShopWebsiteId(o.getShopWebsiteId()).setShopWebsiteCode(o.getShopWebsiteCode()).setShopWebsiteName(o.getShopWebsiteName()).setDirId(o.getDirId()).setDirCode(o.getDirCode()).setDirName(o.getDirName()).setItemId(o.getItemId()).setItemCode(o.getItemCode()).setItemName(o.getItemName()).setSkuId(o.getSkuId()).setSkuCode(o.getSkuCode()).setSkuName(o.getSkuName()).setPaidNum(Integer.valueOf(paidOrders.size())).setPaidAmount(paidAmount).setRefundNum(Integer.valueOf(refundOrders.size())).setRefundAmount(refundAmount).setSaleNum(Integer.valueOf(eo.getPaidNum() - eo.getRefundNum())).setSaleAmount(saleAmount).setRefundRate(MathUtils.rate(eo.getRefundAmount(), saleAmount)).setBudgetCostAmount(budgetCostAmount).setBudgetCostRate(MathUtils.rate(budgetCostAmount, saleAmount)).setActualCostAmount(actualCostAmount).setActualCostRate(MathUtils.rate(actualCostAmount, saleAmount)).setTaxCostAmount(taxCostAmount).setGrossProfitAmount(saleAmount.subtract(taxCostAmount)).setGrossProfitRate(MathUtils.rate(eo.getGrossProfitAmount(), saleAmount)).setProfitAmount(eo.getGrossProfitAmount().subtract(actualCostAmount)).setProfitRate(MathUtils.rate(eo.getProfitAmount(), saleAmount)).setBudgetActualDiffAmount(eo.getBudgetCostAmount().subtract(eo.getActualCostAmount())).setBudgetActualDiffRate(Optional.ofNullable(eo.getBudgetCostRate()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(eo.getActualCostRate()).orElse(BigDecimal.ZERO)));
            details.add(eo);
        });
        details.sort(Comparator.comparing(ShopSkuCostDetailEo::getStatisticalDate));
        this.shopSkuCostDetailDas.physicalDeleteByDate(statisticalDate, "date");
        this.shopSkuCostDetailDas.insertBatch(details);
        log.info("\u540c\u6b65\u5e97\u94faSKU\u8d39\u7528\u5206\u644a\u660e\u7ec6\u5b8c\u6210: date={}", (Object)date);
    }

    private Map<String, List<OrderSkuCostDetailEo>> groupOrderSkuCostDetails(List<OrderSkuCostDetailEo> list) {
        return list.stream().collect(Collectors.groupingBy(k -> Optional.ofNullable(k.getShopCode()).orElse("").trim() + "_" + Optional.ofNullable(k.getShopWebsiteCode()).orElse("").trim() + "_" + Optional.ofNullable(k.getDirCode()).orElse("").trim() + "_" + Optional.ofNullable(k.getSkuCode()).orElse("").trim()));
    }

    private Map<String, List<ShopSkuCostDetailEo>> groupShopSkuCostDetails(List<ShopSkuCostDetailEo> list) {
        return list.stream().collect(Collectors.groupingBy(k -> Optional.ofNullable(k.getShopCode()).orElse("").trim() + "_" + Optional.ofNullable(k.getShopWebsiteCode()).orElse("").trim() + "_" + Optional.ofNullable(k.getDirCode()).orElse("").trim() + "_" + Optional.ofNullable(k.getSkuCode()).orElse("").trim()));
    }

    @Override
    public PageInfo<ShopSkuCostDetailDto> page(ShopSkuCostDetailPageReqDto dto) {
        dto.processParams();
        if (dto.getDirIds() != null && !dto.getDirIds().isEmpty()) {
            List dirIds = this.dirDgDomain.getDescendantIds(dto.getDirIds());
            dto.setDirIds(dirIds);
        }
        PageInfo page = PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> this.shopSkuCostDetailDas.queryList(dto));
        this.dirDgDomain.setFullDirName(page.getList(), ShopSkuCostDetailDto::getDirId, ShopSkuCostDetailDto::setDirName);
        MathUtils.setScales(page.getList(), Lists.newArrayList((Object[])new Function[]{ShopSkuCostDetailDto::getPaidAmount, ShopSkuCostDetailDto::getRefundAmount, ShopSkuCostDetailDto::getSaleAmount, ShopSkuCostDetailDto::getActualCostAmount, ShopSkuCostDetailDto::getGrossProfitAmount, ShopSkuCostDetailDto::getProfitAmount, ShopSkuCostDetailDto::getBudgetActualDiffAmount}), Lists.newArrayList((Object[])new BiConsumer[]{ShopSkuCostDetailDto::setPaidAmount, ShopSkuCostDetailDto::setRefundAmount, ShopSkuCostDetailDto::setSaleAmount, ShopSkuCostDetailDto::setActualCostAmount, ShopSkuCostDetailDto::setGrossProfitAmount, ShopSkuCostDetailDto::setProfitAmount, ShopSkuCostDetailDto::setBudgetActualDiffAmount}), 2);
        return page;
    }
}

