/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.fetch.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.DateUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.api.U9InventoryApi;
import com.yunxi.dg.base.center.inventory.dto.request.U9OrderFlowReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.U9OrderFlowRespDto;
import com.yunxi.dg.base.center.pulldata.dto.entity.ThreeInventoryPostDetailDto;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchBo;
import com.yunxi.dg.base.center.pulldata.service.component.fetch.DataFetchStrategy;
import com.yunxi.dg.base.center.report.constants.reconciliation.InventoryReconciliationSourceEnum;
import com.yunxi.dg.base.center.report.dao.das.inventory.IDgDeliveryResultOrderDas;
import com.yunxi.dg.base.center.report.dao.das.inventory.IDgPlanOrderDas;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryResultOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryResultOrderPageReqDto;
import com.yunxi.dg.base.center.report.eo.inventory.DgDeliveryResultOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgPlanOrderEo;
import com.yunxi.dg.base.center.report.service.fetch.U9OrderTypeEnum;
import com.yunxi.dg.base.center.report.service.fetch.impl.AbstractDataFetchOverwriteStrategy;
import com.yunxi.dg.base.center.report.service.inventory.IDgDeliveryResultOrderService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class U9DataFetchStrategy
extends AbstractDataFetchOverwriteStrategy
implements DataFetchStrategy {
    private static final Logger log = LoggerFactory.getLogger(U9DataFetchStrategy.class);
    @Resource
    private IDgDeliveryResultOrderService dgDeliveryResultOrderService;
    @Resource
    private U9InventoryApi u9InventoryApi;
    @Resource
    private IDgPlanOrderDas dgPlanOrderDas;
    @Resource
    private IDgDeliveryResultOrderDas deliveryResultOrderDas;

    public String type() {
        return InventoryReconciliationSourceEnum.U9.getCode();
    }

    @Override
    public void doFetchAndSaveData(DataFetchBo dataFetchBo) {
        log.info("\u5f00\u59cb\u62c9\u53d6U9\u5355\u636e\u6d41\u6c34,dataFetchBo:{}", (Object)JSON.toJSONString((Object)dataFetchBo));
        String warehouseCode = dataFetchBo.getWarehouseCode();
        String reconciliationTime = null;
        reconciliationTime = dataFetchBo.getReconciliationDate() == null ? U9DataFetchStrategy.getDateString(-1) : DateUtil.getDateFormat((Date)dataFetchBo.getReconciliationDate(), (String)"yyyy-MM-dd");
        Date reconciliationTimeDate = DateUtil.parseDate((String)reconciliationTime, (String)"yyyy-MM-dd");
        this.doDelete(ThreeInventoryPostDetailDto.builder().reconciliationTime(reconciliationTimeDate).warehouseCode(warehouseCode).source(InventoryReconciliationSourceEnum.U9.getCode()).build());
        Date startTime = DateUtil.getDayBegin((Date)reconciliationTimeDate);
        Date endTime = DateUtil.getDayEnd((Date)reconciliationTimeDate);
        DgDeliveryResultOrderPageReqDto dgDeliveryResultOrderPageReqDto = new DgDeliveryResultOrderPageReqDto();
        dgDeliveryResultOrderPageReqDto.setStartBizDate(startTime);
        dgDeliveryResultOrderPageReqDto.setEndBizDate(endTime);
        dgDeliveryResultOrderPageReqDto.setOffsetTypeList((List)Lists.newArrayList((Object[])new String[]{"un_offset"}));
        List deliveryResultOrderDtos = (List)this.dgDeliveryResultOrderService.queryList(dgDeliveryResultOrderPageReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)deliveryResultOrderDtos)) {
            log.info("u9\u5355\u636e\u6d41\u6c34\u62c9\u53d6\uff0c\u7ed3\u679c\u5355\u67e5\u8be2\u4e3a\u7a7a\uff0cstartTime:{}\uff0cendTime:{}", (Object)DateUtil.getDateToString((Date)startTime), (Object)DateUtil.getDateToString((Date)endTime));
            return;
        }
        Map<String, List<DgDeliveryResultOrderDto>> deliveryByOrderTypeMap = deliveryResultOrderDtos.stream().collect(Collectors.groupingBy(DgDeliveryResultOrderDto::getBusinessType));
        deliveryByOrderTypeMap.forEach((businessType, deliveryList) -> {
            Map<String, List<DgDeliveryResultOrderDto>> orderTypeMap = deliveryList.stream().collect(Collectors.groupingBy(DgDeliveryResultOrderDto::getOrderType));
            orderTypeMap.forEach((orderType, deliverys) -> {
                try {
                    List<String> documentNos = U9OrderTypeEnum.PURCHASE_RECEIVE.getInventoryType().equals(businessType) || U9OrderTypeEnum.PURCHASE_RETURN.getInventoryType().equals(businessType) ? deliverys.stream().map(DgDeliveryResultOrderDto::getRelevanceNo).collect(Collectors.toList()) : deliverys.stream().map(DgDeliveryResultOrderDto::getDocumentNo).collect(Collectors.toList());
                    String u9Type = Objects.requireNonNull(U9OrderTypeEnum.getByInventoryTypeAndOrderType(businessType, orderType)).getCode();
                    if (u9Type.equals(U9OrderTypeEnum.TRANSFER_IN.getCode())) {
                        List<DgDeliveryResultOrderDto> onceTransfers = deliverys.stream().filter(resultOrderDto -> Objects.nonNull(resultOrderDto.getDeliveryPhysicsWarehouseCode()) && Objects.nonNull(resultOrderDto.getReceivePhysicsWarehouseCode()) && resultOrderDto.getDeliveryPhysicsWarehouseCode().equals(resultOrderDto.getReceivePhysicsWarehouseCode()) || "TRANSFER_ACCOUNT".equals(resultOrderDto.getDisplayBusinessType()) || "O_TO_O_TRANSFER".equals(resultOrderDto.getDisplayBusinessType()) || "REVERSE_O_TO_O_TRANSFER".equals(resultOrderDto.getDisplayBusinessType())).collect(Collectors.toList());
                        List<String> onceTransferNos = onceTransfers.stream().map(DgDeliveryResultOrderDto::getDocumentNo).collect(Collectors.toList());
                        log.info("\u3010\u62c9\u53d6U9\u5355\u636e\u6d41\u6c34\u3011----\u4e00\u6b65\u5f0f\u8c03\u62e8\u5355\u5165\u5e93\u7c7b\u578b\u7ed3\u679c\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString(onceTransferNos));
                        documentNos.removeAll(onceTransferNos);
                        this.pullU9OrderFlow(U9OrderTypeEnum.ONE_STEP_TRANSFER.getCode(), onceTransferNos, onceTransfers, startTime, 2);
                    }
                    if (u9Type.equals(U9OrderTypeEnum.STANDARD_SHIP.getCode())) {
                        List<DgDeliveryResultOrderDto> spanOrgOnces = deliverys.stream().filter(resultOrderDto -> StringUtils.isNotEmpty((CharSequence)resultOrderDto.getU9No()) && resultOrderDto.getU9No().contains(",")).collect(Collectors.toList());
                        List<String> spanOrgOncesNos = spanOrgOnces.stream().map(DgDeliveryResultOrderDto::getDocumentNo).collect(Collectors.toList());
                        log.info("\u3010\u62c9\u53d6U9\u5355\u636e\u6d41\u6c34\u3011----\u8de8\u7ec4\u7ec7\u4e00\u6b65\u5f0f\u8c03\u62e8\u5355\u7c7b\u578b\u7ed3\u679c\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString(spanOrgOncesNos));
                        this.pullU9OrderFlow(U9OrderTypeEnum.ONE_STEP_TRANSFER.getCode(), spanOrgOncesNos, spanOrgOnces, startTime, 1);
                    }
                    if (u9Type.equals(U9OrderTypeEnum.RETURN_PROCESS.getCode())) {
                        List relevanceNos = deliverys.stream().map(DgDeliveryResultOrderDto::getRelevanceNo).collect(Collectors.toList());
                        List dgPlanOrderEos = ((ExtQueryChainWrapper)this.dgPlanOrderDas.filter().in((Object)"order_no", relevanceNos)).list();
                        List orderNos = dgPlanOrderEos.stream().filter(dgPlanOrderEo -> StringUtils.isNotEmpty((CharSequence)dgPlanOrderEo.getRefundType()) && "RESALE".equals(dgPlanOrderEo.getRefundType())).map(DgPlanOrderEo::getOrderNo).collect(Collectors.toList());
                        List<DgDeliveryResultOrderDto> resaleOrders = deliverys.stream().filter(resultOrderDto -> orderNos.contains(resultOrderDto.getRelevanceNo())).collect(Collectors.toList());
                        List<String> resaleDocumentNos = resaleOrders.stream().map(DgDeliveryResultOrderDto::getDocumentNo).collect(Collectors.toList());
                        log.info("\u3010\u62c9\u53d6U9\u5355\u636e\u6d41\u6c34\u3011----\u8fd4\u9500\u9000\u8d27\u5355\u53f7\uff1a{},\u5339\u914d\u5b8c\u540e\u7684\u7ed3\u679c\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString(orderNos), (Object)JSON.toJSONString(resaleDocumentNos));
                        documentNos.removeAll(resaleDocumentNos);
                        this.pullU9OrderFlow(U9OrderTypeEnum.PURCHASE_RECEIVE.getCode(), resaleDocumentNos, resaleOrders, startTime, 0);
                    }
                    this.pullU9OrderFlow(u9Type, documentNos, (List<DgDeliveryResultOrderDto>)deliverys, startTime, 0);
                }
                catch (Exception e) {
                    log.info("\u62c9\u53d6u9\u5355\u636e\u6d41\u6c34\u5931\u8d25,businessType:{},orderType:{}", new Object[]{businessType, orderType, e});
                }
            });
        });
    }

    private void pullU9OrderFlow(String u9Type, List<String> documentNos, List<DgDeliveryResultOrderDto> deliverys, Date reconciliationTime, Integer type) {
        U9OrderFlowReqDto u9OrderFlowReqDto = new U9OrderFlowReqDto();
        u9OrderFlowReqDto.setBusinessType(u9Type);
        List partition = Lists.partition(documentNos, (int)1000);
        ArrayList u9OrderFlowRespDtos = new ArrayList();
        partition.forEach(documentNoList -> {
            u9OrderFlowReqDto.setBusinessNums(documentNoList);
            List u9OrderFlowRespDtosList = (List)this.u9InventoryApi.queryU9OrderFlowByEai(u9OrderFlowReqDto).getData();
            if (CollectionUtils.isNotEmpty((Collection)u9OrderFlowRespDtosList)) {
                u9OrderFlowRespDtos.addAll(u9OrderFlowRespDtosList);
            }
        });
        Map<String, String> deliverMap = deliverys.stream().collect(Collectors.toMap(DgDeliveryResultOrderDto::getRelevanceNo, DgDeliveryResultOrderDto::getDocumentNo, (a, b) -> b));
        List<ThreeInventoryPostDetailDto> threeInventoryPostDetailDtos = this.convertToDto(reconciliationTime, u9OrderFlowRespDtos.stream().filter(u9OrderFlowRespDto -> Objects.nonNull(u9OrderFlowRespDto.getU9DocNo())).collect(Collectors.toList()), deliverMap, type);
        this.doSave(threeInventoryPostDetailDtos);
    }

    private List<ThreeInventoryPostDetailDto> convertToDto(Date reconciliationTime, List<U9OrderFlowRespDto> u9OrderFlowRespDtos, Map<String, String> deliverMap, Integer type) {
        ArrayList<ThreeInventoryPostDetailDto> threeInventoryPostDetailDtos = new ArrayList<ThreeInventoryPostDetailDto>();
        u9OrderFlowRespDtos.forEach(u9OrderFlowRespDto -> u9OrderFlowRespDto.getLines().forEach(line -> {
            try {
                ThreeInventoryPostDetailDto threeInventoryPostDetailDto = new ThreeInventoryPostDetailDto();
                threeInventoryPostDetailDto.setOsOrderType(u9OrderFlowRespDto.getBusinessType());
                threeInventoryPostDetailDto.setOsBizType(u9OrderFlowRespDto.getBusinessType());
                threeInventoryPostDetailDto.setOsBizTypeStr(Objects.requireNonNull(U9OrderTypeEnum.getByCode(u9OrderFlowRespDto.getBusinessType())).getDesc());
                threeInventoryPostDetailDto.setOsBizNo(u9OrderFlowRespDto.getU9DocNo());
                threeInventoryPostDetailDto.setInventoryProperty("qualified");
                threeInventoryPostDetailDto.setSource(this.type());
                threeInventoryPostDetailDto.setSkuCode(line.getItemCode());
                threeInventoryPostDetailDto.setQuantity(new BigDecimal(line.getQty()));
                if (u9OrderFlowRespDto.getBusinessType().equals(U9OrderTypeEnum.PURCHASE_RECEIVE.getCode()) || u9OrderFlowRespDto.getBusinessType().equals(U9OrderTypeEnum.PURCHASE_RETURN.getCode())) {
                    threeInventoryPostDetailDto.setOrderNo(deliverMap.containsKey(u9OrderFlowRespDto.getBusinessNum()) ? (String)deliverMap.get(u9OrderFlowRespDto.getBusinessNum()) : u9OrderFlowRespDto.getBusinessNum());
                } else {
                    threeInventoryPostDetailDto.setOrderNo(u9OrderFlowRespDto.getBusinessNum());
                }
                threeInventoryPostDetailDto.setReconciliationTime(reconciliationTime);
                threeInventoryPostDetailDto.setExtension(JSONObject.toJSONString((Object)line));
                switch (type) {
                    case 1: {
                        threeInventoryPostDetailDto.setWarehouseCode(u9OrderFlowRespDto.getOutWhCode());
                        threeInventoryPostDetailDto.setOrderType("delivery");
                        break;
                    }
                    case 2: {
                        threeInventoryPostDetailDto.setWarehouseCode(u9OrderFlowRespDto.getInWhCode());
                        threeInventoryPostDetailDto.setOrderType("receive");
                        ThreeInventoryPostDetailDto onceTransferDto = new ThreeInventoryPostDetailDto();
                        BeanUtils.copyProperties((Object)threeInventoryPostDetailDto, (Object)onceTransferDto);
                        onceTransferDto.setWarehouseCode(u9OrderFlowRespDto.getOutWhCode());
                        onceTransferDto.setOrderType("delivery");
                        String relevanceNo = deliverMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)).get(u9OrderFlowRespDto.getBusinessNum());
                        if (StringUtils.isEmpty((CharSequence)relevanceNo)) {
                            log.info("\u4e00\u6b65\u5f0f\u8c03\u62e8\uff0c\u6839\u636e\u5165\u5e93\u7ed3\u679c\u5355\u83b7\u53d6\u4e1a\u52a1\u5355\u53f7\u4e3a\u7a7adeliverMap\uff1a{}\uff0cBusinessNum\uff1a{}", (Object)JSON.toJSONString((Object)deliverMap), (Object)u9OrderFlowRespDto.getBusinessNum());
                            break;
                        }
                        List deliveryResultOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.deliveryResultOrderDas.filter().eq((Object)"relevance_no", (Object)relevanceNo)).eq((Object)"order_type", (Object)"delivery")).list();
                        if (CollectionUtils.isEmpty((Collection)deliveryResultOrderEos)) {
                            log.info("\u4e00\u6b65\u5f0f\u8c03\u62e8\uff0c\u6839\u636e\u4e1a\u52a1\u5355\u53f7\u67e5\u8be2\u51fa\u5e93\u7ed3\u679c\u5355\u4e3a\u7a7arelevanceNo:{}", (Object)relevanceNo);
                            break;
                        }
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                        if (!sdf.format(((DgDeliveryResultOrderEo)deliveryResultOrderEos.get(0)).getBizDate()).equals(sdf.format(reconciliationTime))) break;
                        onceTransferDto.setOrderNo(((DgDeliveryResultOrderEo)deliveryResultOrderEos.get(0)).getDocumentNo());
                        threeInventoryPostDetailDtos.add(onceTransferDto);
                        break;
                    }
                    default: {
                        if (threeInventoryPostDetailDto.getOrderNo().startsWith("DS")) {
                            threeInventoryPostDetailDto.setWarehouseCode(u9OrderFlowRespDto.getOutWhCode());
                            threeInventoryPostDetailDto.setOrderType("delivery");
                            break;
                        }
                        if (threeInventoryPostDetailDto.getOrderNo().startsWith("RS")) {
                            threeInventoryPostDetailDto.setWarehouseCode(u9OrderFlowRespDto.getInWhCode());
                            threeInventoryPostDetailDto.setOrderType("receive");
                            break;
                        }
                        log.info("\u6ca1\u5339\u914d\u4e0a\u51fa\u5165\u5e93\u5355\u5934");
                        threeInventoryPostDetailDto.setWarehouseCode(StringUtils.isEmpty((CharSequence)u9OrderFlowRespDto.getInWhCode()) ? u9OrderFlowRespDto.getOutWhCode() : u9OrderFlowRespDto.getInWhCode());
                        threeInventoryPostDetailDto.setOrderType(StringUtils.isEmpty((CharSequence)u9OrderFlowRespDto.getInWhCode()) ? "delivery" : "receive");
                    }
                }
                threeInventoryPostDetailDtos.add(threeInventoryPostDetailDto);
            }
            catch (Exception e) {
                log.info("u9\u5355\u636e\u8f6c\u6362\u5bf9\u8d26dto\u5931\u8d25\uff0cline:{}", (Object)JSON.toJSONString((Object)line), (Object)e);
            }
        }));
        return threeInventoryPostDetailDtos;
    }

    public static String getDateString(int day) {
        DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate yesterday = LocalDate.now().plusDays(day);
        return yesterday.format(DATE_FORMATTER);
    }
}

