/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.customer;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerAreaDomain;
import com.yunxi.dg.base.center.report.dto.customer.request.DgCustomerShopAreaReqDto;
import com.yunxi.dg.base.center.report.dto.customer.response.DgCustomerShopAreaRespDto;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerAreaEo;
import com.yunxi.dg.base.center.report.service.customer.IDgCustomerAreaService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DgCustomerAreaServiceImpl
implements IDgCustomerAreaService {
    @Resource
    private IDgCustomerAreaDomain dgCustomerAreaDomain;

    @Override
    public List<DgCustomerShopAreaRespDto> queryAreaListByShop(DgCustomerShopAreaReqDto reqDto) {
        List respDtoList = this.dgCustomerAreaDomain.queryAreaByShop(reqDto);
        if (CollectionUtils.isEmpty((Collection)respDtoList)) {
            return new ArrayList<DgCustomerShopAreaRespDto>();
        }
        List<String> areaCodeList = respDtoList.stream().map(DgCustomerShopAreaRespDto::getAreaCode).collect(Collectors.toList());
        ArrayList<DgCustomerShopAreaRespDto> provinceAreaList = new ArrayList<DgCustomerShopAreaRespDto>();
        this.queryParentProvinceAreaByCodes(areaCodeList, provinceAreaList);
        return provinceAreaList.stream().filter(o -> {
            boolean condition;
            boolean bl = condition = Objects.nonNull(o.getCategory()) && o.getCategory() == 2;
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getAreaIdList())) {
                boolean bl2 = condition = condition && reqDto.getAreaIdList().contains(o.getAreaId());
            }
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getAreaIdList())) {
                condition = condition && reqDto.getAreaCodeList().contains(o.getAreaCode());
            }
            return condition;
        }).collect(Collectors.toList());
    }

    private void queryParentProvinceAreaByCodes(List<String> areaCodeList, List<DgCustomerShopAreaRespDto> provinceAreaList) {
        List dgCustomerAreaEos = this.dgCustomerAreaDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCustomerAreaEo.class).in(DgCustomerAreaEo::getCode, areaCodeList));
        if (CollectionUtils.isEmpty((Collection)dgCustomerAreaEos)) {
            return;
        }
        provinceAreaList.addAll(dgCustomerAreaEos.stream().map(o -> {
            DgCustomerShopAreaRespDto areaRespDto = new DgCustomerShopAreaRespDto();
            areaRespDto.setId(o.getId());
            areaRespDto.setAreaId(o.getId());
            areaRespDto.setAreaCode(o.getCode());
            areaRespDto.setAreaName(o.getName());
            areaRespDto.setAreaParentCode(o.getParentCode());
            areaRespDto.setCategory(o.getCategory());
            areaRespDto.setErpCode(o.getErpCode());
            return areaRespDto;
        }).collect(Collectors.toList()));
        List<String> codeList = dgCustomerAreaEos.stream().map(DgCustomerAreaEo::getParentCode).filter(code -> StringUtils.isNotBlank((CharSequence)code) && !code.equals("0")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        this.queryParentProvinceAreaByCodes(codeList, provinceAreaList);
    }

    @Override
    public PageInfo<DgCustomerShopAreaRespDto> queryAreaPageByShop(DgCustomerShopAreaReqDto reqDto) {
        return new PageInfo(this.queryAreaListByShop(reqDto));
    }
}

