/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.customer.tob;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.report.dao.vo.DgItemSkuRespVo;
import com.yunxi.dg.base.center.report.domain.customer.IDgCSRCustomerSkuPolicyDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsCompanyInfoDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsCustomerBuyScopePolicyDomian;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsOrgCustomerRelationDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsRRelationEnterpriseDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsRRelationShopDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerAreaDomain;
import com.yunxi.dg.base.center.report.domain.customer.IDgCustomerDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDgShopDomain;
import com.yunxi.dg.base.center.report.domain.item.IDirDgDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemSkuDgDomain;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsCustomerAreaDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationExtDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrgCustomerRelationPageReqDto;
import com.yunxi.dg.base.center.report.dto.customer.request.BuyScopeDto;
import com.yunxi.dg.base.center.report.dto.customer.request.CustomerPolicyDto;
import com.yunxi.dg.base.center.report.dto.customer.request.DgCustomerBuyScopeCustomerQueryVo;
import com.yunxi.dg.base.center.report.dto.customer.request.DgCustomerBuyScopeItemQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.request.DgCustomerBuyScopeItemQueryVo;
import com.yunxi.dg.base.center.report.dto.customer.request.DgCustomerBuyScopePolicyConditionDto;
import com.yunxi.dg.base.center.report.dto.customer.request.DgEsCustomerBuyScopeItemQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.request.DgTobCustomerBuyScopeItemQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.request.DgTobCustomerBuyScopeItemQueryExtDto;
import com.yunxi.dg.base.center.report.dto.customer.request.ItemBuyScope;
import com.yunxi.dg.base.center.report.dto.customer.request.ItemBuyScopeDto;
import com.yunxi.dg.base.center.report.dto.customer.request.SpecifyItem;
import com.yunxi.dg.base.center.report.dto.customer.response.CustomerRelationByEnterpriseRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.DgCsCustomerBuyScopePolicyRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.DgCustomerBuyScopeCustomerRespDto;
import com.yunxi.dg.base.center.report.dto.customer.response.DgCustomerBuyScopeItemRespDto;
import com.yunxi.dg.base.center.report.dto.item.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.report.dto.item.ItemSkuDgDto;
import com.yunxi.dg.base.center.report.dto.item.ShopItemDto;
import com.yunxi.dg.base.center.report.dto.item.ShopItemEsRespDto;
import com.yunxi.dg.base.center.report.dto.item.ShopItemPageSearchReqDto;
import com.yunxi.dg.base.center.report.dto.item.ShopSkuIdSearchReqDto;
import com.yunxi.dg.base.center.report.enums.CustomerBuyScopeTypeEnum;
import com.yunxi.dg.base.center.report.enums.CustomerTypeEnum;
import com.yunxi.dg.base.center.report.eo.DgShopEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCSRCustomerSkuPolicyEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsCompanyInfoEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsCustomerBuyScopePolicyEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsRRelationEnterpriseEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCsRRelationShopEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerAreaEo;
import com.yunxi.dg.base.center.report.eo.customer.DgCustomerEo;
import com.yunxi.dg.base.center.report.eo.item.DirDgEo;
import com.yunxi.dg.base.center.report.service.customer.tob.IDgCustomerBuyScopeItemService;
import com.yunxi.dg.base.center.report.service.item.DgShopItemService;
import com.yunxi.dg.base.center.report.utils.GuavaCacheUtil;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgCustomerBuyScopeItemServiceImpl
implements IDgCustomerBuyScopeItemService {
    private static final Logger log = LoggerFactory.getLogger(DgCustomerBuyScopeItemServiceImpl.class);
    @Resource
    private IDgCsCustomerBuyScopePolicyDomian iDgCsCustomerBuyScopePolicyDomian;
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;
    @Resource
    private IDirDgDomain iDirDgDomain;
    @Resource
    private IDgCsCompanyInfoDomain iDgCsCompanyInfoDomain;
    @Resource
    private IDgCsOrgCustomerRelationDomain iDgCsOrgCustomerRelationDomain;
    @Resource
    private IDgShopDomain iDgShopDomain;
    @Resource
    private IDgCSRCustomerSkuPolicyDomain iDgCSRCustomerSkuPolicyDomain;
    @Resource
    private IDgCustomerAreaDomain iDgCustomerAreaDomain;
    @Resource
    private DgShopItemService shopItemService;
    @Resource
    private IDgCsRRelationEnterpriseDomain iDgCsRRelationEnterpriseDomain;
    @Resource
    private IDgCsRRelationShopDomain iDgCsRRelationShopDomain;
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;

    @Override
    public PageInfo<DgCustomerBuyScopeItemRespDto> queryBuyScopeItemPage(DgCustomerBuyScopeItemQueryDto queryDto) {
        Object obj = this.queryBuyScopeItem(queryDto, true);
        return Objects.isNull(obj) ? new PageInfo() : (PageInfo)obj;
    }

    @Override
    public PageInfo<DgCustomerBuyScopeItemRespDto> queryTobBuyScopeItemPage(DgTobCustomerBuyScopeItemQueryDto queryDto) {
        queryDto.setTob(true);
        return this.queryBuyScopeItemPage((DgCustomerBuyScopeItemQueryDto)queryDto);
    }

    @Override
    public DgCsCustomerBuyScopePolicyRespDto queryBuyScopeItemDetailsById(Long id) {
        DgCsCustomerBuyScopePolicyRespDto scopePolicyRespDto = (DgCsCustomerBuyScopePolicyRespDto)BeanUtil.toBean((Object)this.iDgCsCustomerBuyScopePolicyDomian.selectByPrimaryKey(id), DgCsCustomerBuyScopePolicyRespDto.class);
        if (Objects.nonNull(scopePolicyRespDto)) {
            DgShopEo dgShopEo = (DgShopEo)this.iDgShopDomain.selectByPrimaryKey(scopePolicyRespDto.getShopId());
            scopePolicyRespDto.setShopName(dgShopEo.getName());
        }
        return scopePolicyRespDto;
    }

    @Override
    public DgCsCustomerBuyScopePolicyRespDto queryTobBuyScopeItemDetailsById(Long id) {
        return this.queryBuyScopeItemDetailsById(id);
    }

    @Override
    public List<DgCustomerBuyScopeItemRespDto> queryTobBuyScopeItemList(DgTobCustomerBuyScopeItemQueryDto queryDto) {
        queryDto.setTob(true);
        Object obj = this.queryBuyScopeItem((DgCustomerBuyScopeItemQueryDto)queryDto, false);
        return Objects.isNull(obj) ? new ArrayList() : (List)obj;
    }

    @Override
    public List<DgCustomerBuyScopeItemRespDto> queryBuyScopeItemList(DgCustomerBuyScopeItemQueryDto queryDto) {
        Object obj = this.queryBuyScopeItem(queryDto, false);
        return Objects.isNull(obj) ? new ArrayList() : (List)obj;
    }

    @Override
    public PageInfo<ShopItemEsRespDto> queryTobEsBuyScopeItemPage(DgEsCustomerBuyScopeItemQueryDto queryDto) {
        queryDto.setTob(true);
        log.info("queryTobEsBuyScopeItemPage\u8acb\u6c42\u5165\u53c2====\u300b{}", (Object)JSON.toJSONString((Object)queryDto));
        ArrayList<DgCsCustomerBuyScopePolicyEo> isMatchPolicyList = new ArrayList<DgCsCustomerBuyScopePolicyEo>();
        HashMap<Long, Map<Long, DgCSRCustomerSkuPolicyEo>> skuAndPolicyMap = new HashMap<Long, Map<Long, DgCSRCustomerSkuPolicyEo>>();
        ArrayList<ShopItemDto> shopItemAll = new ArrayList<ShopItemDto>();
        DgCustomerBuyScopeItemQueryVo queryVo = this.buildCustomerBuyScopeItemQueryVo(skuAndPolicyMap, isMatchPolicyList, shopItemAll, (DgCustomerBuyScopeItemQueryDto)queryDto);
        if (queryVo == null || !this.buildPolicyQueryItemSkuEs(queryDto, queryVo)) {
            return new PageInfo();
        }
        log.info("queryVo===>{}", (Object)JSON.toJSONString((Object)queryVo.getShopSkuIdMap()));
        PageInfo<ShopItemEsRespDto> esPageInfo = this.shopItemService.queryPage(this.buildShopItemPageSearchReqDto(queryDto, queryVo));
        this.handlerEsFilterBuyScopeItem(queryVo, esPageInfo.getList(), queryDto.getShelfStatus());
        return esPageInfo;
    }

    @Override
    public PageInfo<DgCustomerBuyScopeItemRespDto> queryTobBuyScopeItemPageByCustomer(DgTobCustomerBuyScopeItemQueryExtDto queryDto) {
        Integer queryLevel = queryDto.getQueryLevel();
        this.verifyQueryParams(queryDto);
        if (Objects.equals(queryLevel, 2)) {
            DgCustomerBuyScopeItemQueryVo queryVo = new DgCustomerBuyScopeItemQueryVo();
            DgCustomerBuyScopeItemQueryVo buyScopeItemQueryVo = new DgCustomerBuyScopeItemQueryVo();
            Long customerId = queryDto.getCustomerId();
            DgCustomerEo dgCustomerEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(customerId);
            AssertUtils.notNull((Object)dgCustomerEo, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
            queryVo.setCustomerName(dgCustomerEo.getName());
            queryVo.setErpCode(dgCustomerEo.getErpCode());
            queryVo.setExternalCode(dgCustomerEo.getExternalCode());
            queryVo.setCustomerId(dgCustomerEo.getId());
            DgCsCompanyInfoEo dgCsCompanyInfoEo = (DgCsCompanyInfoEo)this.iDgCsCompanyInfoDomain.selectByPrimaryKey(dgCustomerEo.getCompanyId());
            AssertUtils.notNull((Object)dgCsCompanyInfoEo, (String)"\u5ba2\u6237\u516c\u53f8\u4e0d\u5b58\u5728");
            queryVo.setCompanyName(dgCsCompanyInfoEo.getCompanyName());
            Long shopId = queryDto.getShopId();
            List<DgCsCustomerBuyScopePolicyEo> policyEos = this.getDgCsCustomerBuyScopePolicyEos(queryDto);
            if (CollectionUtil.isEmpty(policyEos)) {
                return new PageInfo();
            }
            DgShopEo dgShopEo = (DgShopEo)this.iDgShopDomain.selectByPrimaryKey(shopId);
            List<DgCsCustomerBuyScopePolicyEo> scopePolicyEos = this.getLatestScopePolicyByCustomer(dgCustomerEo, policyEos, shopId);
            if (CollectionUtils.isEmpty(scopePolicyEos)) {
                return new PageInfo();
            }
            List<Long> disableSkuIdList = this.getDisableSkuIdList(customerId, scopePolicyEos);
            boolean isNullPage = this.buildItemQueryVo(queryDto, queryVo, buyScopeItemQueryVo, scopePolicyEos, disableSkuIdList);
            if (isNullPage) {
                return new PageInfo();
            }
            queryVo.setStatus(queryDto.getStatus());
            PageInfo itemPage = this.iDgCsCustomerBuyScopePolicyDomian.queryBuyScopeItemPage(queryVo);
            if (CollectionUtils.isEmpty((Collection)itemPage.getList())) {
                return new PageInfo();
            }
            List buyScopeSkuIdList = ((List)Optional.ofNullable(this.iDgCsCustomerBuyScopePolicyDomian.queryBuyScopeItemList(buyScopeItemQueryVo)).orElse(new ArrayList())).stream().map(DgCustomerBuyScopeItemRespDto::getSkuId).collect(Collectors.toList());
            Map<Long, DirDgEo> dirDgEoMap = this.getAllDir(itemPage.getList());
            for (DgCustomerBuyScopeItemRespDto itemRespDto : itemPage.getList()) {
                this.setItemDirName(itemRespDto, dirDgEoMap);
                itemRespDto.setOrganizationId(dgShopEo.getOrganizationId());
                itemRespDto.setOrganizationCode(dgShopEo.getOrganizationCode());
                itemRespDto.setOrganizationName(dgShopEo.getOrganizationName());
                itemRespDto.setExternalCode(dgCustomerEo.getExternalCode());
                Long skuId = itemRespDto.getSkuId();
                if (disableSkuIdList.contains(skuId)) {
                    itemRespDto.setStatus(Integer.valueOf(1));
                } else {
                    itemRespDto.setStatus(Integer.valueOf(0));
                }
                if (buyScopeSkuIdList.contains(skuId)) {
                    itemRespDto.setIsBuyScope(Integer.valueOf(1));
                    continue;
                }
                itemRespDto.setIsBuyScope(Integer.valueOf(0));
            }
            return itemPage;
        }
        return new PageInfo();
    }

    private List<Long> getDisableSkuIdList(Long customerId, List<DgCsCustomerBuyScopePolicyEo> scopePolicyEo) {
        List ids = scopePolicyEo.stream().map(BaseEo::getId).collect(Collectors.toList());
        return ((List)Optional.ofNullable(this.iDgCSRCustomerSkuPolicyDomain.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCSRCustomerSkuPolicyEo.class).eq(DgCSRCustomerSkuPolicyEo::getStatus, (Object)1)).eq(Objects.nonNull(customerId), DgCSRCustomerSkuPolicyEo::getCustomerId, (Object)customerId)).in(DgCSRCustomerSkuPolicyEo::getPolicyId, ids))).orElse(new ArrayList())).stream().map(DgCSRCustomerSkuPolicyEo::getSkuId).collect(Collectors.toList());
    }

    private boolean buildItemQueryVo(DgTobCustomerBuyScopeItemQueryExtDto queryDto, DgCustomerBuyScopeItemQueryVo queryVo, DgCustomerBuyScopeItemQueryVo buyScopeItemQueryVo, List<DgCsCustomerBuyScopePolicyEo> scopePolicyEos, List<Long> disableSkuIdList) {
        List skuIds;
        ItemQueryDgReqDto itemDgReqDto;
        Map<Long, DirDgEo> dgDirEoMap;
        HashSet<Long> skuIdList = new HashSet<Long>();
        HashSet spuIdList = new HashSet();
        HashSet<Long> dirIdList = new HashSet<Long>();
        HashSet brandList = new HashSet();
        HashSet excludeSkuIdList = new HashSet();
        HashSet excludeSpuIdList = new HashSet();
        HashSet excludeDirIdList = new HashSet();
        HashSet excludeBrandList = new HashSet();
        HashSet brandSet = new HashSet();
        HashSet dirSet = new HashSet();
        HashSet excludeSkuIdSet = new HashSet();
        HashSet skuIdSet = new HashSet();
        HashSet spuIdSet = new HashSet();
        Integer isBuyScope = queryDto.getIsBuyScope();
        if (Objects.nonNull(queryDto.getSkuId())) {
            skuIdList.add(queryDto.getSkuId());
        }
        boolean includeNotLimit = false;
        for (DgCsCustomerBuyScopePolicyEo scopePolicyEo : scopePolicyEos) {
            SpecifyItem specifyItem;
            ItemBuyScopeDto itemPolicyDto = (ItemBuyScopeDto)JSON.parseObject((String)scopePolicyEo.getItemPolicy(), ItemBuyScopeDto.class);
            ItemBuyScope itemBuyScope = itemPolicyDto.getBuy_scope();
            String itemBuyScopeType = itemPolicyDto.getItem_buy_scope_type();
            List brand = itemBuyScope.getBrand();
            List dir = itemBuyScope.getDir();
            List excludeSkuIds = itemBuyScope.getExclude_sku();
            SpecifyItem item = itemPolicyDto.getSpecify_item();
            if (includeNotLimit || itemBuyScopeType.equals("1")) {
                includeNotLimit = true;
                brandSet.clear();
                dirSet.clear();
                excludeSkuIdSet.clear();
                skuIdSet.clear();
                spuIdSet.clear();
            } else {
                if (CollectionUtils.isNotEmpty((Collection)brand)) {
                    brandSet.addAll(brand);
                }
                if (CollectionUtils.isNotEmpty((Collection)dir)) {
                    dirSet.addAll(dir);
                }
                if (CollectionUtils.isNotEmpty((Collection)excludeSkuIds)) {
                    excludeSkuIdSet.addAll(excludeSkuIds);
                }
                if (Objects.nonNull(item)) {
                    if (Objects.equals(item.getSpecify_type(), 2)) {
                        skuIdSet.addAll(item.getItem());
                    }
                    if (Objects.equals(item.getSpecify_type(), 1)) {
                        spuIdSet.addAll(item.getItem());
                    }
                }
            }
            if (Objects.equals(isBuyScope, 0)) {
                if (Objects.equals(itemBuyScopeType, "1")) continue;
                if (Objects.equals(itemBuyScopeType, "2")) {
                    if (CollectionUtil.isNotEmpty((Collection)brand)) {
                        excludeBrandList.addAll(brand);
                    }
                    if (CollectionUtil.isNotEmpty((Collection)dir)) {
                        excludeDirIdList.addAll(dir);
                    }
                    if (CollectionUtil.isNotEmpty((Collection)excludeSkuIds)) {
                        skuIdList.addAll(excludeSkuIds);
                    }
                } else if (Objects.equals(itemBuyScopeType, "3")) {
                    specifyItem = itemPolicyDto.getSpecify_item();
                    if (Objects.equals(specifyItem.getSpecify_type(), 2)) {
                        excludeSkuIdList.addAll(specifyItem.getItem());
                    }
                    if (Objects.equals(specifyItem.getSpecify_type(), 1)) {
                        excludeSpuIdList.addAll(specifyItem.getItem());
                    }
                }
            }
            if (!Objects.equals(isBuyScope, 1) || Objects.equals(itemBuyScopeType, "1")) continue;
            if (Objects.equals(itemBuyScopeType, "2")) {
                if (CollectionUtil.isNotEmpty((Collection)brand)) {
                    brandList.addAll(brand);
                }
                if (CollectionUtil.isNotEmpty((Collection)dir)) {
                    dirIdList.addAll(dir);
                }
                if (!CollectionUtil.isNotEmpty((Collection)excludeSkuIds)) continue;
                excludeSkuIdList.addAll(excludeSkuIds);
                continue;
            }
            if (!Objects.equals(itemBuyScopeType, "3")) continue;
            specifyItem = itemPolicyDto.getSpecify_item();
            if (Objects.equals(specifyItem.getSpecify_type(), 2)) {
                skuIdList.addAll(specifyItem.getItem());
            }
            if (!Objects.equals(specifyItem.getSpecify_type(), 1)) continue;
            spuIdList.addAll(specifyItem.getItem());
        }
        queryVo.setSkuIdList(new ArrayList(skuIdList));
        queryVo.setExcludeSkuIdList(new ArrayList(excludeSkuIdList));
        queryVo.setExcludeDirIdList(new ArrayList(excludeDirIdList));
        queryVo.setExcludeBrandList(new ArrayList(excludeBrandList));
        queryVo.setExcludeSpuIdList(new ArrayList(excludeSpuIdList));
        queryVo.setSkuIdList(new ArrayList(skuIdList));
        queryVo.setSpuIdList(new ArrayList(spuIdList));
        queryVo.setExcludeSkuIdList(new ArrayList(excludeSkuIdList));
        queryVo.setDirIdList(new ArrayList(dirIdList));
        queryVo.setBrandList(new ArrayList(brandList));
        buyScopeItemQueryVo.setBrandList(new ArrayList(brandSet));
        buyScopeItemQueryVo.setDirIdList(new ArrayList(dirSet));
        buyScopeItemQueryVo.setSpuIdList(new ArrayList(spuIdSet));
        buyScopeItemQueryVo.setSkuIdList(new ArrayList(skuIdSet));
        buyScopeItemQueryVo.setExcludeSkuIdList(new ArrayList(excludeSkuIdSet));
        buyScopeItemQueryVo.setShopIdList(Collections.singletonList(queryDto.getShopId()));
        if (CollectionUtil.isNotEmpty(disableSkuIdList)) {
            if (Objects.equals(queryDto.getStatus(), 1)) {
                queryVo.setSkuIdList(disableSkuIdList);
            }
            if (Objects.equals(queryDto.getStatus(), 0)) {
                if (CollectionUtil.isNotEmpty((Collection)queryVo.getExcludeSkuIdList())) {
                    queryVo.getExcludeSkuIdList().addAll(disableSkuIdList);
                } else {
                    queryVo.setExcludeSkuIdList(disableSkuIdList);
                }
            }
        } else if (Objects.equals(queryDto.getStatus(), 1)) {
            return true;
        }
        if (CollectionUtil.isNotEmpty(dgDirEoMap = this.mapParentByChildDriIds(queryDto.getDirIdList()))) {
            dirIdList.addAll(dgDirEoMap.keySet());
            queryVo.setDirIdList(new ArrayList(dirIdList));
        }
        queryVo.setShopIdList(Collections.singletonList(queryDto.getShopId()));
        queryVo.setSpuName(queryDto.getSpuName());
        queryVo.setSpuCode(queryDto.getSpuCode());
        queryVo.setSkuName(queryDto.getSkuName());
        queryVo.setSkuCode(queryDto.getSkuCode());
        queryVo.setOrganizationIds(queryDto.getOrganizationIds());
        queryVo.setPageNum(queryDto.getPageNum());
        queryVo.setPageSize(queryDto.getPageSize());
        if (CollectionUtil.isNotEmpty((Collection)queryVo.getBrandList()) && CollectionUtil.isNotEmpty((Collection)queryDto.getBrandList())) {
            queryVo.getBrandList().addAll(queryDto.getBrandList());
        } else {
            queryVo.setBrandList(queryDto.getBrandList());
        }
        if (CollectionUtil.isNotEmpty((Collection)queryVo.getDirIdList()) && CollectionUtil.isNotEmpty((Collection)queryDto.getDirIdList())) {
            queryVo.getDirIdList().addAll(queryDto.getDirIdList());
        } else {
            queryVo.setDirIdList(queryDto.getDirIdList());
        }
        queryVo.setItemType(queryDto.getItemType());
        if (CollectionUtils.isNotEmpty((Collection)queryVo.getSpuIdList())) {
            itemDgReqDto = new ItemQueryDgReqDto();
            itemDgReqDto.setItemIds(queryVo.getSpuIdList());
            skuIds = ((List)Optional.ofNullable(this.itemSkuDgDomain.queryItemSkuList(itemDgReqDto)).orElse(new ArrayList())).stream().map(DgItemSkuRespVo::getId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty((Collection)queryVo.getSkuIdList())) {
                queryVo.getSkuIdList().addAll(skuIds);
            } else {
                queryVo.setSkuIdList(skuIds);
            }
            queryVo.setSpuIdList(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)buyScopeItemQueryVo.getSpuIdList())) {
            itemDgReqDto = new ItemQueryDgReqDto();
            itemDgReqDto.setItemIds(buyScopeItemQueryVo.getSpuIdList());
            skuIds = ((List)Optional.ofNullable(this.itemSkuDgDomain.queryItemSkuList(itemDgReqDto)).orElse(new ArrayList())).stream().map(DgItemSkuRespVo::getId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty((Collection)buyScopeItemQueryVo.getSkuIdList())) {
                buyScopeItemQueryVo.getSkuIdList().addAll(skuIds);
            } else {
                buyScopeItemQueryVo.setSkuIdList(skuIds);
            }
            buyScopeItemQueryVo.setSpuIdList(null);
        }
        return false;
    }

    private List<DgCsCustomerBuyScopePolicyEo> getDgCsCustomerBuyScopePolicyEos(DgTobCustomerBuyScopeItemQueryExtDto queryDto) {
        List policyEos = this.iDgCsCustomerBuyScopePolicyDomian.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCsCustomerBuyScopePolicyEo.class).eq(DgCsCustomerBuyScopePolicyEo::getShopId, (Object)queryDto.getShopId())).eq(DgCsCustomerBuyScopePolicyEo::getStatus, (Object)5)).in(CollectionUtil.isNotEmpty((Collection)queryDto.getOrganizationIds()), DgCsCustomerBuyScopePolicyEo::getOrganizationId, (Collection)queryDto.getOrganizationIds())).orderByDesc(BaseEo::getUpdateTime));
        return policyEos;
    }

    private List<DgCsCustomerBuyScopePolicyEo> getLatestScopePolicyByCustomer(DgCustomerEo dgCustomerEo, List<DgCsCustomerBuyScopePolicyEo> policyEos, Long shopId) {
        ArrayList<DgCsCustomerBuyScopePolicyEo> scopePolicyEos = new ArrayList<DgCsCustomerBuyScopePolicyEo>();
        Long customerId = dgCustomerEo.getId();
        CsOrgCustomerRelationPageReqDto reqDto = new CsOrgCustomerRelationPageReqDto();
        reqDto.setCustomerId(customerId);
        reqDto.setStatus(Integer.valueOf(4));
        reqDto.setShopIdList(Collections.singletonList(shopId));
        List relationDtoList = this.iDgCsOrgCustomerRelationDomain.queryList(reqDto, Collections.singletonList(1));
        if (CollectionUtil.isEmpty((Collection)relationDtoList)) {
            return scopePolicyEos;
        }
        Long customerTypeId = ((CsOrgCustomerRelationDto)relationDtoList.get(0)).getCustomerTypeId();
        Long areaId = ((CsOrgCustomerRelationDto)relationDtoList.get(0)).getAreaId();
        Long customerGroupId = dgCustomerEo.getCustomerGroupId();
        Long levelId = ((CsOrgCustomerRelationDto)relationDtoList.get(0)).getLevelId();
        for (DgCsCustomerBuyScopePolicyEo policyEo : policyEos) {
            List specifyCustomer;
            CustomerPolicyDto customerPolicy = (CustomerPolicyDto)JSON.parseObject((String)policyEo.getCustomerPolicy(), CustomerPolicyDto.class);
            BuyScopeDto customerBuyScope = customerPolicy.getBuy_scope();
            String customerBuyScopeType = customerPolicy.getCustomer_buy_scope_type();
            if (Objects.equals(customerBuyScopeType, "1")) {
                scopePolicyEos.add(policyEo);
                continue;
            }
            if (Objects.equals(customerBuyScopeType, "2")) {
                if (CollectionUtil.isNotEmpty((Collection)customerBuyScope.getExclude_customer()) && customerBuyScope.getExclude_customer().contains(customerId)) continue;
                List customerGroup = customerBuyScope.getCustomer_group();
                if (CollectionUtil.isNotEmpty((Collection)customerGroup) && customerGroup.contains(customerGroupId)) {
                    scopePolicyEos.add(policyEo);
                    continue;
                }
                List customerType = customerBuyScope.getCustomer_type();
                if (CollectionUtil.isNotEmpty((Collection)customerType) && customerType.contains(customerTypeId)) {
                    scopePolicyEos.add(policyEo);
                    continue;
                }
                List area = customerBuyScope.getArea();
                if (CollectionUtil.isNotEmpty((Collection)area) && area.contains(areaId)) {
                    scopePolicyEos.add(policyEo);
                    continue;
                }
                List level = customerBuyScope.getLevel();
                if (!CollectionUtil.isNotEmpty((Collection)level) || !level.contains(levelId)) continue;
                scopePolicyEos.add(policyEo);
                continue;
            }
            if (!Objects.equals(customerBuyScopeType, "3") || !(specifyCustomer = customerPolicy.getSpecify_customer()).contains(customerId)) continue;
            scopePolicyEos.add(policyEo);
        }
        return scopePolicyEos;
    }

    @Override
    public PageInfo<DgCustomerBuyScopeCustomerRespDto> queryTobBuyScopeCustomerPageByItem(DgTobCustomerBuyScopeItemQueryExtDto queryDto) {
        Integer queryLevel = queryDto.getQueryLevel();
        this.verifyQueryParams(queryDto);
        if (Objects.equals(queryLevel, 4)) {
            Long shopId = queryDto.getShopId();
            Long skuId = queryDto.getSkuId();
            DgCustomerBuyScopeItemQueryVo queryVo = new DgCustomerBuyScopeItemQueryVo();
            queryVo.setSkuIdList(Collections.singletonList(skuId));
            queryVo.setShopIdList(Collections.singletonList(shopId));
            queryVo.setPageNum(Integer.valueOf(1));
            queryVo.setPageSize(Integer.valueOf(1));
            List itemList = this.iDgCsCustomerBuyScopePolicyDomian.queryBuyScopeItemList(queryVo);
            if (CollectionUtils.isEmpty((Collection)itemList)) {
                return new PageInfo();
            }
            DgShopEo dgShopEo = (DgShopEo)Optional.ofNullable(this.iDgShopDomain.selectByPrimaryKey(shopId)).orElse((BaseEo)new DgShopEo());
            DgCustomerBuyScopeItemRespDto itemRespDto = (DgCustomerBuyScopeItemRespDto)itemList.get(0);
            this.setItemDirName(itemRespDto);
            List<DgCsCustomerBuyScopePolicyEo> policyEos = this.getDgCsCustomerBuyScopePolicyEos(queryDto);
            if (CollectionUtil.isEmpty(policyEos)) {
                return new PageInfo();
            }
            List<DgCsCustomerBuyScopePolicyEo> scopePolicyEos = this.getLatestScopePolicyByItem(skuId, itemRespDto, policyEos);
            log.info("\u67e5\u8be2\u7b26\u5408\u7684\u5141\u8d2d\u653f\u7b56\uff1a{}", (Object)JSON.toJSONString(scopePolicyEos));
            if (CollectionUtils.isEmpty(scopePolicyEos)) {
                return new PageInfo();
            }
            DgCustomerBuyScopeCustomerQueryVo customerQueryVo = new DgCustomerBuyScopeCustomerQueryVo();
            DgCustomerBuyScopeCustomerQueryVo buyScopeQueryVo = new DgCustomerBuyScopeCustomerQueryVo();
            List<Long> disableCustomerIdList = this.getDisableCustomerIdList(scopePolicyEos, skuId);
            boolean isNullPage = this.buildCustomerQueryVo(customerQueryVo, buyScopeQueryVo, scopePolicyEos, queryDto, itemRespDto, disableCustomerIdList);
            if (isNullPage) {
                return new PageInfo();
            }
            List customerRespDtoList = this.iDgCsCustomerBuyScopePolicyDomian.queryBuyScopeCustomerList(buyScopeQueryVo);
            List customerIdList = ((List)Optional.ofNullable(customerRespDtoList).orElse(new ArrayList())).stream().map(DgCustomerBuyScopeCustomerRespDto::getCustomerId).collect(Collectors.toList());
            PageInfo pageInfo = this.iDgCsCustomerBuyScopePolicyDomian.queryBuyScopeCustomerPage(customerQueryVo);
            for (DgCustomerBuyScopeCustomerRespDto respDto : pageInfo.getList()) {
                respDto.setOrganizationId(dgShopEo.getOrganizationId());
                respDto.setOrganizationCode(dgShopEo.getOrganizationCode());
                respDto.setOrganizationName(dgShopEo.getOrganizationName());
                respDto.setShopName(itemRespDto.getShopName());
                respDto.setSpuId(itemRespDto.getItemId());
                respDto.setSpuCode(itemRespDto.getSpuCode());
                respDto.setSpuName(itemRespDto.getSpuName());
                respDto.setSkuId(itemRespDto.getSkuId());
                respDto.setSkuCode(itemRespDto.getSkuCode());
                respDto.setSkuName(itemRespDto.getSkuName());
                respDto.setSpecOne(itemRespDto.getSpecOne());
                respDto.setSpecTwo(itemRespDto.getSpecTwo());
                respDto.setDirId(itemRespDto.getDirId());
                respDto.setDirName(itemRespDto.getDirName());
                respDto.setBrandId(itemRespDto.getBrandId());
                respDto.setBrandName(itemRespDto.getBrandName());
                if (customerIdList.contains(respDto.getCustomerId())) {
                    respDto.setIsBuyScope(Integer.valueOf(1));
                } else {
                    respDto.setIsBuyScope(Integer.valueOf(0));
                }
                if (disableCustomerIdList.contains(respDto.getCustomerId())) {
                    respDto.setStatus(Integer.valueOf(1));
                    continue;
                }
                respDto.setStatus(Integer.valueOf(0));
            }
            return pageInfo;
        }
        return new PageInfo();
    }

    private List<Long> getDisableCustomerIdList(List<DgCsCustomerBuyScopePolicyEo> scopePolicyEos, Long skuId) {
        List ids = scopePolicyEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        return ((List)Optional.ofNullable(this.iDgCSRCustomerSkuPolicyDomain.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCSRCustomerSkuPolicyEo.class).eq(DgCSRCustomerSkuPolicyEo::getStatus, (Object)1)).eq(DgCSRCustomerSkuPolicyEo::getSkuId, (Object)skuId)).in(DgCSRCustomerSkuPolicyEo::getPolicyId, ids))).orElse(new ArrayList())).stream().map(DgCSRCustomerSkuPolicyEo::getCustomerId).collect(Collectors.toList());
    }

    private boolean buildCustomerQueryVo(DgCustomerBuyScopeCustomerQueryVo customerQueryVo, DgCustomerBuyScopeCustomerQueryVo buyScopeQueryVo, List<DgCsCustomerBuyScopePolicyEo> scopePolicyEos, DgTobCustomerBuyScopeItemQueryExtDto queryDto, DgCustomerBuyScopeItemRespDto itemRespDto, List<Long> disableCustomerIdList) {
        HashSet customerIdList = new HashSet();
        HashSet groupIdList = new HashSet();
        HashSet typeList = new HashSet();
        HashSet areaList = new HashSet();
        HashSet levelList = new HashSet();
        HashSet excludeCustomerIdList = new HashSet();
        HashSet excludeGroupIdList = new HashSet();
        HashSet excludeTypeList = new HashSet();
        HashSet excludeAreaList = new HashSet();
        HashSet excludeLevelList = new HashSet();
        HashSet excludeCustomer = new HashSet();
        HashSet customerGroup = new HashSet();
        HashSet customerType = new HashSet();
        HashSet area = new HashSet();
        HashSet level = new HashSet();
        HashSet specifyCustomer = new HashSet();
        int customerBuyScopeTypeCount = 0;
        boolean isAllScope = false;
        Integer isBuyScope = queryDto.getIsBuyScope();
        for (DgCsCustomerBuyScopePolicyEo scopePolicyEo : scopePolicyEos) {
            CustomerPolicyDto customerPolicyDto = (CustomerPolicyDto)JSON.parseObject((String)scopePolicyEo.getCustomerPolicy(), CustomerPolicyDto.class);
            String customerBuyScopeType = customerPolicyDto.getCustomer_buy_scope_type();
            BuyScopeDto buyScope = customerPolicyDto.getBuy_scope();
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getExclude_customer())) {
                excludeCustomer.addAll(buyScope.getExclude_customer());
            }
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getCustomer_group())) {
                customerGroup.addAll(buyScope.getCustomer_group());
            }
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getCustomer_type())) {
                customerType.addAll(buyScope.getCustomer_type());
            }
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getArea())) {
                area.addAll(buyScope.getArea());
            }
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getLevel())) {
                level.addAll(buyScope.getLevel());
            }
            if (CollectionUtil.isNotEmpty((Collection)customerPolicyDto.getSpecify_customer())) {
                specifyCustomer.addAll(customerPolicyDto.getSpecify_customer());
            }
            if (Objects.equals(isBuyScope, 1)) {
                if (Objects.equals(customerBuyScopeType, "1")) {
                    isAllScope = true;
                } else if (Objects.equals(customerBuyScopeType, "2")) {
                    if (CollectionUtil.isNotEmpty((Collection)buyScope.getExclude_customer())) {
                        excludeCustomerIdList.addAll(buyScope.getExclude_customer());
                    }
                    if (CollectionUtil.isNotEmpty((Collection)buyScope.getCustomer_group())) {
                        groupIdList.addAll(buyScope.getCustomer_group());
                    }
                    if (CollectionUtil.isNotEmpty((Collection)buyScope.getCustomer_type())) {
                        typeList.addAll(buyScope.getCustomer_type());
                    }
                    if (CollectionUtil.isNotEmpty((Collection)buyScope.getArea())) {
                        areaList.addAll(buyScope.getArea());
                    }
                    if (CollectionUtil.isNotEmpty((Collection)buyScope.getLevel())) {
                        levelList.addAll(buyScope.getLevel());
                    }
                } else if (Objects.equals(customerBuyScopeType, "3") && CollectionUtil.isNotEmpty((Collection)customerPolicyDto.getSpecify_customer())) {
                    customerIdList.addAll(customerPolicyDto.getSpecify_customer());
                }
            }
            if (!Objects.equals(isBuyScope, 0)) continue;
            if (Objects.equals(customerBuyScopeType, "1")) {
                ++customerBuyScopeTypeCount;
                continue;
            }
            if (Objects.equals(customerBuyScopeType, "2")) {
                if (CollectionUtil.isNotEmpty((Collection)buyScope.getExclude_customer())) {
                    customerIdList.addAll(buyScope.getExclude_customer());
                }
                if (CollectionUtil.isNotEmpty((Collection)buyScope.getCustomer_group())) {
                    excludeGroupIdList.addAll(buyScope.getCustomer_group());
                }
                if (CollectionUtil.isNotEmpty((Collection)buyScope.getCustomer_type())) {
                    excludeTypeList.addAll(buyScope.getCustomer_type());
                }
                if (CollectionUtil.isNotEmpty((Collection)buyScope.getArea())) {
                    excludeAreaList.addAll(buyScope.getArea());
                }
                if (!CollectionUtil.isNotEmpty((Collection)buyScope.getLevel())) continue;
                excludeLevelList.addAll(buyScope.getLevel());
                continue;
            }
            if (!Objects.equals(customerBuyScopeType, "3") || !CollectionUtil.isNotEmpty((Collection)customerPolicyDto.getSpecify_customer())) continue;
            excludeCustomerIdList.addAll(customerPolicyDto.getSpecify_customer());
        }
        if (Objects.equals(isBuyScope, 0) && customerBuyScopeTypeCount == scopePolicyEos.size()) {
            return true;
        }
        if (!isAllScope) {
            customerQueryVo.setCustomerIdList(new ArrayList(customerIdList));
            customerQueryVo.setGroupIdList(new ArrayList(groupIdList));
            customerQueryVo.setTypeList(new ArrayList(typeList));
            customerQueryVo.setAreaList(new ArrayList(areaList));
            customerQueryVo.setLevelList(new ArrayList(levelList));
        }
        customerQueryVo.setExcludeCustomerIdList(new ArrayList(excludeCustomerIdList));
        customerQueryVo.setExcludeGroupIdList(new ArrayList(excludeGroupIdList));
        customerQueryVo.setExcludeTypeList(new ArrayList(excludeTypeList));
        customerQueryVo.setExcludeAreaList(new ArrayList(excludeAreaList));
        customerQueryVo.setExcludeLevelList(new ArrayList(excludeLevelList));
        customerQueryVo.setPageNum(queryDto.getPageNum());
        customerQueryVo.setPageSize(queryDto.getPageSize());
        customerQueryVo.setBusinessTypeList(Collections.singletonList(1));
        customerQueryVo.setRelationStatusList(Collections.singletonList(4));
        customerQueryVo.setShopId(queryDto.getShopId());
        buyScopeQueryVo.setExcludeCustomerIdList(new ArrayList(excludeCustomer));
        buyScopeQueryVo.setGroupIdList(new ArrayList(customerGroup));
        buyScopeQueryVo.setTypeList(new ArrayList(customerType));
        buyScopeQueryVo.setAreaList(new ArrayList(area));
        buyScopeQueryVo.setLevelList(new ArrayList(level));
        buyScopeQueryVo.setCustomerIdList(new ArrayList(specifyCustomer));
        buyScopeQueryVo.setShopId(queryDto.getShopId());
        buyScopeQueryVo.setRelationStatusList(Collections.singletonList(4));
        if (CollectionUtils.isNotEmpty(disableCustomerIdList)) {
            if (Objects.equals(queryDto.getStatus(), 1)) {
                customerQueryVo.setCustomerIdList(disableCustomerIdList);
            }
            if (Objects.equals(queryDto.getStatus(), 0)) {
                if (CollectionUtil.isNotEmpty((Collection)customerQueryVo.getExcludeCustomerIdList())) {
                    customerQueryVo.getExcludeCustomerIdList().addAll(disableCustomerIdList);
                } else {
                    customerQueryVo.setExcludeCustomerIdList(disableCustomerIdList);
                }
            }
        } else if (Objects.equals(queryDto.getStatus(), 1)) {
            return true;
        }
        return false;
    }

    private List<DgCsCustomerBuyScopePolicyEo> getLatestScopePolicyByItem(Long skuId, DgCustomerBuyScopeItemRespDto itemRespDto, List<DgCsCustomerBuyScopePolicyEo> policyEos) {
        ArrayList<DgCsCustomerBuyScopePolicyEo> scopePolicyEos = new ArrayList<DgCsCustomerBuyScopePolicyEo>();
        for (DgCsCustomerBuyScopePolicyEo policyEo : policyEos) {
            List item;
            ItemBuyScopeDto itemPolicyDto = (ItemBuyScopeDto)JSON.parseObject((String)policyEo.getItemPolicy(), ItemBuyScopeDto.class);
            ItemBuyScope itemBuyScope = itemPolicyDto.getBuy_scope();
            String itemBuyScopeType = itemPolicyDto.getItem_buy_scope_type();
            if (Objects.equals(itemBuyScopeType, "1")) {
                scopePolicyEos.add(policyEo);
                continue;
            }
            if (Objects.equals(itemBuyScopeType, "2")) {
                List excludeSku = itemBuyScope.getExclude_sku();
                if (CollectionUtil.isNotEmpty((Collection)excludeSku) && excludeSku.contains(itemRespDto.getSkuId())) continue;
                List brand = itemBuyScope.getBrand();
                if (CollectionUtil.isNotEmpty((Collection)brand) && brand.contains(itemRespDto.getBrandId())) {
                    scopePolicyEos.add(policyEo);
                    continue;
                }
                List dir = itemBuyScope.getDir();
                if (CollectionUtil.isNotEmpty((Collection)dir)) {
                    scopePolicyEos.add(policyEo);
                    continue;
                }
            }
            if (!Objects.equals(itemBuyScopeType, "3")) continue;
            SpecifyItem specifyItem = itemPolicyDto.getSpecify_item();
            if (Objects.equals(specifyItem.getSpecify_type(), 1)) {
                List itemList = ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().in((Object)"item_id", (Collection)specifyItem.getItem())).list();
                List skuIdList = ((List)Optional.ofNullable(itemList).orElse(new ArrayList())).stream().map(BaseEo::getId).collect(Collectors.toList());
                if (!skuIdList.contains(skuId)) continue;
                scopePolicyEos.add(policyEo);
                continue;
            }
            if (!Objects.equals(specifyItem.getSpecify_type(), 2) || !(item = specifyItem.getItem()).contains(skuId)) continue;
            scopePolicyEos.add(policyEo);
        }
        return scopePolicyEos;
    }

    private void verifyQueryParams(DgTobCustomerBuyScopeItemQueryExtDto queryDto) {
        Integer queryLevel = queryDto.getQueryLevel();
        Integer isBuyScope = queryDto.getIsBuyScope();
        AssertUtils.notNull((Object)queryLevel, (String)"\u67e5\u8be2\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        if (Objects.equals(queryLevel, 1)) {
            AssertUtils.notNull((Object)queryDto.getCustomerId(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
            AssertUtils.isNull((Object)isBuyScope, (String)"\u6309\u5ba2\u6237\u67e5\u8be2\u4e0d\u5141\u8bb8\u6307\u5b9a\u662f\u5426\u5141\u8d2d", (Object[])new Object[0]);
        }
        if (Objects.equals(queryLevel, 2)) {
            AssertUtils.notNull((Object)queryDto.getCustomerId(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
            AssertUtils.notNull((Object)queryDto.getShopId(), (String)"\u8bf7\u9009\u62e9\u5e97\u94fa");
        }
        if (Objects.equals(queryLevel, 3)) {
            AssertUtils.notNull((Object)queryDto.getSkuId(), (String)"\u8bf7\u9009\u62e9\u5546\u54c1");
            AssertUtils.isNull((Object)isBuyScope, (String)"\u6309\u5546\u54c1\u67e5\u8be2\u4e0d\u5141\u8bb8\u6307\u5b9a\u662f\u5426\u5141\u8d2d", (Object[])new Object[0]);
        }
        if (Objects.equals(queryLevel, 4)) {
            AssertUtils.notNull((Object)queryDto.getSkuId(), (String)"\u8bf7\u9009\u62e9\u5546\u54c1");
            AssertUtils.notNull((Object)queryDto.getShopId(), (String)"\u8bf7\u9009\u62e9\u5e97\u94fa");
        }
    }

    private void handlerEsFilterBuyScopeItem(DgCustomerBuyScopeItemQueryVo queryVo, List<ShopItemEsRespDto> esRespDtos, Integer shelfStatus) {
        if (CollectionUtil.isEmpty(esRespDtos)) {
            return;
        }
        log.info("esRespDtos=>{}", (Object)JSON.toJSONString(esRespDtos));
        Map shopSkuIdMap = queryVo.getShopSkuIdMap();
        esRespDtos.forEach(e -> {
            Iterator iterator = e.getItemSkuList().iterator();
            List skuIds = (List)shopSkuIdMap.get(e.getItemShopDgDto().getShopId());
            while (iterator.hasNext()) {
                ItemSkuDgDto next = (ItemSkuDgDto)iterator.next();
                if (skuIds.contains(next.getId())) continue;
                log.info("\u4e0d\u5b58\u5728skuId=>{}", (Object)JSON.toJSONString((Object)next));
                iterator.remove();
            }
        });
    }

    private ShopItemPageSearchReqDto buildShopItemPageSearchReqDto(DgEsCustomerBuyScopeItemQueryDto queryDto, DgCustomerBuyScopeItemQueryVo queryVo) {
        ShopItemPageSearchReqDto shopItemPageSearchReqDto = (ShopItemPageSearchReqDto)BeanUtil.copyProperties((Object)queryDto, ShopItemPageSearchReqDto.class, (String[])new String[]{"shopSkuIdMapStr"});
        ArrayList<ShopSkuIdSearchReqDto> shopIdSkuIds = new ArrayList<ShopSkuIdSearchReqDto>();
        for (Map.Entry entry : queryVo.getShopSkuIdMap().entrySet()) {
            ShopSkuIdSearchReqDto reqDto = new ShopSkuIdSearchReqDto();
            reqDto.setSkuIds((List)entry.getValue());
            reqDto.setShopId((Long)entry.getKey());
            shopIdSkuIds.add(reqDto);
        }
        if (CollectionUtil.isNotEmpty((Collection)queryDto.getTagIdList())) {
            shopItemPageSearchReqDto.setTagIds(queryDto.getTagIdList());
        }
        shopItemPageSearchReqDto.setSpuShelfStatus(queryDto.getShelfStatus());
        shopItemPageSearchReqDto.setSkuShelfStatus(queryDto.getShelfStatus());
        shopItemPageSearchReqDto.setInBrandIds(queryDto.getInBrandIds());
        shopItemPageSearchReqDto.setInBackDirId(queryDto.getInBackDirId());
        shopItemPageSearchReqDto.setExcludeSkuList(queryDto.getExcludeSkuList());
        shopItemPageSearchReqDto.setShopIds(queryDto.getShopIds());
        shopItemPageSearchReqDto.setShopIdSkuIds(shopIdSkuIds);
        shopItemPageSearchReqDto.setSorts(queryDto.getSorts());
        shopItemPageSearchReqDto.setFirstMarketDateList(queryDto.getFirstMarketDateList());
        return shopItemPageSearchReqDto;
    }

    private List<DgCustomerBuyScopeItemRespDto> buildDgCustomerBuyScopeItemRespDto(PageInfo<ShopItemEsRespDto> esPageInfo, Long customerId) {
        if (CollectionUtil.isEmpty((Collection)esPageInfo.getList())) {
            log.info("\u4e0d\u5b58\u5728\u5141\u8d2d\u5546\u54c1\u7684\u6570\u636e");
            return Collections.emptyList();
        }
        ArrayList<DgCustomerBuyScopeItemRespDto> allScopeItem = new ArrayList<DgCustomerBuyScopeItemRespDto>();
        DgCustomerEo dgCustomerEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(customerId);
        DgCsCompanyInfoEo dgCsCompanyInfoEo = (DgCsCompanyInfoEo)this.iDgCsCompanyInfoDomain.selectByPrimaryKey(dgCustomerEo.getCompanyId());
        for (ShopItemEsRespDto shopItemEsRespDto : esPageInfo.getList()) {
            for (ItemSkuDgDto itemSkuDgDto : shopItemEsRespDto.getItemSkuList()) {
                DgCustomerBuyScopeItemRespDto dto = new DgCustomerBuyScopeItemRespDto();
                dto.setCustomerId(dgCustomerEo.getId());
                dto.setDirName(shopItemEsRespDto.getDirName());
                dto.setOrganizationId(dto.getOrganizationId());
                dto.setOrganizationName(dto.getOrganizationName());
                dto.setShopId(shopItemEsRespDto.getItemShopDgDto().getShopId());
                dto.setBrandId(shopItemEsRespDto.getBrandId());
                dto.setBrandName(shopItemEsRespDto.getBrand());
                dto.setDirId(shopItemEsRespDto.getDirId());
                dto.setCompanyName(dgCsCompanyInfoEo.getCompanyName());
                dto.setCustomerName(dgCustomerEo.getName());
                dto.setItemId(shopItemEsRespDto.getItemShopDgDto().getItemId());
                dto.setErpCode(dgCustomerEo.getErpCode());
                dto.setShopName(shopItemEsRespDto.getItemShopDgDto().getShopName());
                dto.setSkuCode(itemSkuDgDto.getCode());
                dto.setSpuCode(shopItemEsRespDto.getCode());
                dto.setSkuName(itemSkuDgDto.getDisplayName());
                dto.setSpuName(shopItemEsRespDto.getName());
                dto.setItemId(itemSkuDgDto.getItemId());
                dto.setSpecOne(itemSkuDgDto.getSpecOne());
                dto.setSpecTwo(itemSkuDgDto.getSpecTwo());
                dto.setType(shopItemEsRespDto.getType());
                allScopeItem.add(dto);
            }
        }
        return allScopeItem;
    }

    private boolean buildPolicyQueryItemSkuEs(DgEsCustomerBuyScopeItemQueryDto queryDto, DgCustomerBuyScopeItemQueryVo queryVo) {
        if (CollectionUtil.isNotEmpty((Collection)queryVo.getBrandList())) {
            if (CollectionUtil.isNotEmpty((Collection)queryDto.getInBrandIds())) {
                queryDto.getInBrandIds().retainAll(queryVo.getBrandList());
                if (CollectionUtil.isEmpty((Collection)queryDto.getInBrandIds())) {
                    return false;
                }
            } else {
                queryDto.setInBrandIds(queryVo.getBrandList());
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)queryVo.getDirIdList())) {
            if (CollectionUtil.isNotEmpty((Collection)queryDto.getInBackDirId())) {
                queryDto.getInBackDirId().retainAll(queryVo.getBrandList());
                if (CollectionUtil.isEmpty((Collection)queryDto.getInBackDirId())) {
                    return false;
                }
            } else {
                queryDto.setInBackDirId(queryVo.getDirIdList());
            }
        }
        return !CollectionUtil.isEmpty((Map)queryVo.getShopSkuIdMap());
    }

    private Object queryBuyScopeItem(DgCustomerBuyScopeItemQueryDto queryDto, boolean isPage) {
        ArrayList<DgCsCustomerBuyScopePolicyEo> isMatchPolicyList = new ArrayList<DgCsCustomerBuyScopePolicyEo>();
        HashMap<Long, Map<Long, DgCSRCustomerSkuPolicyEo>> skuAndPolicyMap = new HashMap<Long, Map<Long, DgCSRCustomerSkuPolicyEo>>();
        ArrayList<ShopItemDto> shopItemAll = new ArrayList<ShopItemDto>();
        DgCustomerBuyScopeItemQueryVo dgCustomerBuyScopeItemQueryVo = this.buildCustomerBuyScopeItemQueryVo(skuAndPolicyMap, isMatchPolicyList, shopItemAll, queryDto);
        if (CollectionUtil.isEmpty(isMatchPolicyList) || CollectionUtil.isEmpty(shopItemAll) || dgCustomerBuyScopeItemQueryVo == null) {
            return null;
        }
        if (isPage) {
            PageInfo pageInfo = this.iDgCsCustomerBuyScopePolicyDomian.queryBuyScopeItemPage(dgCustomerBuyScopeItemQueryVo);
            this.setOrganizationNameList(pageInfo.getList(), isMatchPolicyList, skuAndPolicyMap, queryDto.getCustomerId());
            return pageInfo;
        }
        List respDtoList = this.iDgCsCustomerBuyScopePolicyDomian.queryBuyScopeItemList(dgCustomerBuyScopeItemQueryVo);
        this.setOrganizationNameList(respDtoList, isMatchPolicyList, skuAndPolicyMap, queryDto.getCustomerId());
        return respDtoList;
    }

    private DgCustomerBuyScopeItemQueryVo buildCustomerBuyScopeItemQueryVo(Map<Long, Map<Long, DgCSRCustomerSkuPolicyEo>> skuAndPolicyMap, List<DgCsCustomerBuyScopePolicyEo> isMatchPolicyList, List<ShopItemDto> shopItemAll, DgCustomerBuyScopeItemQueryDto queryDto) {
        DgCustomerBuyScopeItemQueryVo dgCustomerBuyScopeItemQueryVo = this.buildDgCustomerBuyScopeItemQueryVo(queryDto, isMatchPolicyList, shopItemAll, skuAndPolicyMap);
        if (Objects.isNull(dgCustomerBuyScopeItemQueryVo)) {
            return dgCustomerBuyScopeItemQueryVo;
        }
        Map<Long, DirDgEo> dgDirEoMap = this.mapParentByChildDriIds(queryDto.getDirIdList());
        if (CollectionUtil.isNotEmpty(dgDirEoMap)) {
            dgCustomerBuyScopeItemQueryVo.setDirIdList((List)Lists.newArrayList(dgDirEoMap.keySet()));
        }
        if (CollectionUtil.isNotEmpty(isMatchPolicyList) && CollectionUtil.isNotEmpty(shopItemAll)) {
            dgCustomerBuyScopeItemQueryVo.setShopSkuIdMap(this.convertShopSkuMap(shopItemAll));
        }
        return dgCustomerBuyScopeItemQueryVo;
    }

    private DgCustomerBuyScopeItemQueryVo buildDgCustomerBuyScopeItemQueryVo(DgCustomerBuyScopeItemQueryDto queryDto, List<DgCsCustomerBuyScopePolicyEo> isMatchPolicyList, List<ShopItemDto> shopItemAll, Map<Long, Map<Long, DgCSRCustomerSkuPolicyEo>> skuAndPolicyMap) {
        HashMap<Long, CsOrgCustomerRelationDto> relationEoMap;
        AssertUtils.notNull((Object)queryDto.getCustomerId(), (String)"\u67e5\u8be2\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        DgCustomerBuyScopeItemQueryVo dgCustomerBuyScopeItemQueryVo = (DgCustomerBuyScopeItemQueryVo)BeanUtil.toBean((Object)queryDto, DgCustomerBuyScopeItemQueryVo.class);
        DgCustomerEo dgCustomerEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(queryDto.getCustomerId());
        AssertUtils.notNull((Object)dgCustomerEo, (String)"\u975e\u6cd5\u5ba2\u6237id");
        dgCustomerBuyScopeItemQueryVo.setExternalCode(dgCustomerEo.getExternalCode());
        List relationExtDtos = this.iDgCsOrgCustomerRelationDomain.queryOrgCustomerRelByCustomerId(dgCustomerEo.getId());
        if (CollectionUtils.isEmpty((Collection)relationExtDtos)) {
            log.info("\u5ba2\u6237\u4ea4\u6613\u5173\u7cfb\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        HashMap relationEoMaps = Maps.newHashMap();
        HashMap customerIdEnterpriseMap = Maps.newHashMap();
        HashMap relationIdShopMap = Maps.newHashMap();
        HashSet enterHashSet = Sets.newHashSet();
        HashSet shopHashSet = Sets.newHashSet();
        for (CsOrgCustomerRelationExtDto row : relationExtDtos) {
            relationEoMaps.putIfAbsent(row.getId(), row);
            customerIdEnterpriseMap.putIfAbsent(row.getCustomerId(), Lists.newArrayList());
            if (!enterHashSet.contains(row.getEnterpriseId())) {
                DgCsRRelationEnterpriseEo enterpriseEo = new DgCsRRelationEnterpriseEo();
                enterpriseEo.setEnterpriseId(row.getEnterpriseId());
                enterpriseEo.setEnterpriseCode(row.getEnterpriseCode());
                enterpriseEo.setOrganizationId(row.getEntOrganizationId());
                enterpriseEo.setCustomerId(row.getCustomerId());
                enterpriseEo.setRelationId(row.getId());
                ((List)customerIdEnterpriseMap.get(row.getCustomerId())).add(enterpriseEo);
                enterHashSet.add(row.getEnterpriseId());
            }
            relationIdShopMap.putIfAbsent(row.getId(), Lists.newArrayList());
            if (shopHashSet.contains(row.getShopId())) continue;
            DgCsRRelationShopEo shopEo = new DgCsRRelationShopEo();
            shopEo.setShopId(row.getShopId());
            shopEo.setCustomerTypeId(row.getCustomerTypeId());
            shopEo.setCustomerId(row.getCustomerId());
            shopEo.setRelationId(row.getId());
            ((List)relationIdShopMap.get(row.getId())).add(shopEo);
            shopHashSet.add(row.getShopId());
        }
        ArrayList relationEos = Lists.newArrayList(relationEoMaps.values());
        Boolean isBuy = this.handlerTerminalCustomerRelationInfo(dgCustomerEo, relationEos, relationEoMap = new HashMap<Long, CsOrgCustomerRelationDto>(), relationEoMaps);
        if (!isBuy.booleanValue() || CollectionUtil.isEmpty(relationEoMap)) {
            log.info("\u6ca1\u6709\u5141\u8d2d\u653f\u7b56\u7684\u6570\u636e");
            return null;
        }
        List<DgCsCustomerBuyScopePolicyEo> scopePolicyEos = this.buyScopePolicyEoList(dgCustomerBuyScopeItemQueryVo, relationEos);
        if (CollectionUtil.isEmpty(scopePolicyEos)) {
            return null;
        }
        Map<Long, Map<Long, DgCSRCustomerSkuPolicyEo>> newSkuAndPolicyMap = this.getPolicyAndSkuDisabledMap(queryDto);
        if (CollectionUtil.isNotEmpty(newSkuAndPolicyMap)) {
            skuAndPolicyMap.putAll(newSkuAndPolicyMap);
        }
        if (queryDto.getStatus() != null && queryDto.getStatus().equals(1) && CollectionUtil.isEmpty(skuAndPolicyMap)) {
            return null;
        }
        List<DgCsCustomerBuyScopePolicyEo> isNewMatchPolicyList = this.matchCustomerPolicyRule(dgCustomerBuyScopeItemQueryVo, scopePolicyEos, relationEos, shopItemAll, skuAndPolicyMap, customerIdEnterpriseMap, relationIdShopMap, dgCustomerEo);
        if (CollectionUtil.isNotEmpty(isNewMatchPolicyList)) {
            isMatchPolicyList.addAll(isNewMatchPolicyList);
        }
        return dgCustomerBuyScopeItemQueryVo;
    }

    private Boolean handlerTerminalCustomerRelationInfo(DgCustomerEo dgCustomerEo, List<CsOrgCustomerRelationDto> relationEos, Map<Long, CsOrgCustomerRelationDto> relationEoMap, Map<Long, CsOrgCustomerRelationDto> srcRelationEoMap) {
        relationEoMap.putAll(srcRelationEoMap);
        if (CustomerTypeEnum.TERMINAL.getType().equals(dgCustomerEo.getType())) {
            relationEoMap.putAll(srcRelationEoMap);
            List relation = this.iDgCsOrgCustomerRelationDomain.listCustomerRelationByCustomerId((List)Lists.newArrayList((Object[])new Long[]{dgCustomerEo.getId(), dgCustomerEo.getParentCustomerId()}));
            if (CollectionUtil.isEmpty((Collection)relation)) {
                log.info("\u5408\u9002\u653f\u7b56\uff0c\u8bf4\u660e\u6ca1\u6709\u5141\u8d2d\u653f\u7b56");
                return false;
            }
            Map<String, Map<Long, List<CustomerRelationByEnterpriseRespDto>>> groupMap = relation.stream().collect(Collectors.groupingBy(CustomerRelationByEnterpriseRespDto::getRectintKey, Collectors.groupingBy(CustomerRelationByEnterpriseRespDto::getCustomerId)));
            ArrayList relationIds = new ArrayList();
            for (Map.Entry<String, Map<Long, List<CustomerRelationByEnterpriseRespDto>>> entry : groupMap.entrySet()) {
                List<CustomerRelationByEnterpriseRespDto> enterpriseRespDtos;
                if (!CollectionUtil.isNotEmpty(entry.getValue()) || entry.getValue().size() <= 1 || !CollectionUtil.isNotEmpty(enterpriseRespDtos = entry.getValue().get(dgCustomerEo.getId()))) continue;
                relationIds.addAll(enterpriseRespDtos.stream().map(BaseDto::getId).collect(Collectors.toList()));
            }
            if (CollectionUtil.isEmpty((Collection)relation)) {
                log.info("\u5408\u9002\u653f\u7b56\uff0c\u8bf4\u660e\u6ca1\u6709\u5141\u8d2d\u653f\u7b56");
                return false;
            }
            relationEoMap.keySet().retainAll(relationIds);
            relationEos.clear();
            relationEos.addAll(relationEoMap.values());
        }
        return true;
    }

    private Map<Long, List<Long>> convertShopSkuMap(List<ShopItemDto> shopItemAll) {
        HashMap<Long, List<Long>> shopSkuMap = new HashMap<Long, List<Long>>();
        for (ShopItemDto shopItemDto : shopItemAll) {
            List mapOrDefault = shopSkuMap.getOrDefault(shopItemDto.getShopId(), new ArrayList());
            mapOrDefault.add(shopItemDto.getSkuId());
            shopSkuMap.put(shopItemDto.getShopId(), mapOrDefault);
        }
        return shopSkuMap;
    }

    private Map<Long, Map<Long, DgCSRCustomerSkuPolicyEo>> getPolicyAndSkuDisabledMap(DgCustomerBuyScopeItemQueryDto queryDto) {
        if (queryDto.getStatus() != null) {
            return this.getCustomerAndSkuDisabledMap(queryDto.getCustomerId(), 1);
        }
        return Collections.emptyMap();
    }

    private Map<Long, Map<Long, DgCSRCustomerSkuPolicyEo>> getCustomerAndSkuDisabledMap(Long customerId, Integer status) {
        List csrCustomerSkuPolicyEos = this.iDgCSRCustomerSkuPolicyDomain.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCSRCustomerSkuPolicyEo.class).eq(DgCSRCustomerSkuPolicyEo::getStatus, (Object)status)).eq(DgCSRCustomerSkuPolicyEo::getCustomerId, (Object)customerId));
        if (CollectionUtil.isNotEmpty((Collection)csrCustomerSkuPolicyEos)) {
            return csrCustomerSkuPolicyEos.stream().collect(Collectors.groupingBy(DgCSRCustomerSkuPolicyEo::getPolicyId, Collectors.toMap(DgCSRCustomerSkuPolicyEo::getSkuId, Function.identity())));
        }
        return Collections.emptyMap();
    }

    private Map<Long, DirDgEo> getAllDir(List<DgCustomerBuyScopeItemRespDto> itemList) {
        Set dirIds = itemList.stream().map(DgCustomerBuyScopeItemRespDto::getDirId).collect(Collectors.toSet());
        List dirDgEos = this.iDirDgDomain.selectByIds((List)Lists.newArrayList(dirIds));
        if (CollectionUtils.isNotEmpty((Collection)dirDgEos)) {
            HashSet allParentDirIds = Sets.newHashSet();
            for (DirDgEo eo : dirDgEos) {
                String[] paths = eo.getIndexPath().split(",");
                int i = 0;
                for (String tid : paths) {
                    if (i != paths.length - 1 && !Objects.equals(tid, "0")) {
                        allParentDirIds.add(Long.parseLong(tid));
                    }
                    ++i;
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)allParentDirIds)) {
                dirDgEos.addAll(this.iDirDgDomain.selectByIds((List)Lists.newArrayList((Iterable)allParentDirIds)));
            }
        }
        return dirDgEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (o1, o2) -> o1));
    }

    private void setOrganizationNameList(List<DgCustomerBuyScopeItemRespDto> itemList, List<DgCsCustomerBuyScopePolicyEo> isMatchPolicyList, Map<Long, Map<Long, DgCSRCustomerSkuPolicyEo>> skuAndPolicyMap, Long customerId) {
        if (CollectionUtil.isEmpty(itemList)) {
            return;
        }
        if (CollectionUtil.isEmpty(skuAndPolicyMap)) {
            skuAndPolicyMap = this.getCustomerAndSkuDisabledMap(customerId, 1);
        }
        Map shopMapPolicy = isMatchPolicyList.stream().sorted(Comparator.comparing(BaseEo::getUpdateTime, Comparator.reverseOrder())).collect(Collectors.groupingBy(DgCsCustomerBuyScopePolicyEo::getShopId, Collectors.toList()));
        Map<Long, DirDgEo> dirDgEoMap = this.getAllDir(itemList);
        block0: for (DgCustomerBuyScopeItemRespDto itemDto : itemList) {
            itemDto.setIsBuyScope(Integer.valueOf(1));
            this.setItemDirName(itemDto, dirDgEoMap);
            List policyEoList = shopMapPolicy.get(itemDto.getShopId());
            for (DgCsCustomerBuyScopePolicyEo policyEo : policyEoList) {
                ItemBuyScopeDto itemPolicy;
                if (!policyEo.getShopId().equals(itemDto.getShopId())) continue;
                Map<Long, DgCSRCustomerSkuPolicyEo> skuIdMap = skuAndPolicyMap.get(policyEo.getId());
                itemDto.setStatus(Integer.valueOf(0));
                itemDto.setPolicyId(policyEo.getId());
                if (CollectionUtil.isNotEmpty(skuIdMap)) {
                    DgCSRCustomerSkuPolicyEo skuPolicyEo = skuIdMap.get(itemDto.getSkuId());
                    itemDto.setStatus(Integer.valueOf(Objects.nonNull(skuPolicyEo) ? skuPolicyEo.getStatus() : 0));
                }
                if ((itemPolicy = (ItemBuyScopeDto)JSONUtil.toBean((String)policyEo.getItemPolicy(), ItemBuyScopeDto.class)).getItem_buy_scope_type().equals(CustomerBuyScopeTypeEnum.UN_LIMITED.getType())) {
                    itemDto.setPolicyId(policyEo.getId());
                    itemDto.setOrganizationName(policyEo.getOrganizationName());
                    itemDto.setShopId(policyEo.getShopId());
                    itemDto.setOrganizationId(policyEo.getOrganizationId());
                    itemDto.setOrganizationCode(policyEo.getOrganizationCode());
                    continue block0;
                }
                if (itemPolicy.getItem_buy_scope_type().equals(CustomerBuyScopeTypeEnum.BUY_SCOPE.getType())) {
                    Map<Long, DirDgEo> dirMap;
                    ItemBuyScope buyScope = itemPolicy.getBuy_scope();
                    boolean isContinue = CollectionUtil.isNotEmpty((Collection)buyScope.getItem_type()) && !buyScope.getItem_type().contains(itemDto.getType()) || CollectionUtil.isNotEmpty((Collection)buyScope.getBrand()) && !buyScope.getBrand().contains(itemDto.getBrandId()) || CollectionUtil.isNotEmpty((Collection)buyScope.getExclude_sku()) && buyScope.getExclude_sku().contains(itemDto.getSkuId());
                    if (isContinue || CollectionUtil.isNotEmpty((Collection)buyScope.getDir()) && !(dirMap = this.mapParentByChildDriIds(buyScope.getDir())).containsKey(itemDto.getDirId())) continue;
                    itemDto.setPolicyId(policyEo.getId());
                    itemDto.setOrganizationName(policyEo.getOrganizationName());
                    itemDto.setShopId(policyEo.getShopId());
                    itemDto.setOrganizationId(policyEo.getOrganizationId());
                    itemDto.setOrganizationCode(policyEo.getOrganizationCode());
                    continue block0;
                }
                if (!itemPolicy.getItem_buy_scope_type().equals(CustomerBuyScopeTypeEnum.SPECIFY.getType()) || itemPolicy.getSpecify_item() == null) continue;
                List item = itemPolicy.getSpecify_item().getItem();
                if ((!itemPolicy.getSpecify_item().getSpecify_type().equals(2) || !item.contains(itemDto.getSkuId())) && (!itemPolicy.getSpecify_item().getSpecify_type().equals(1) || !item.contains(itemDto.getItemId()))) continue;
                itemDto.setPolicyId(policyEo.getId());
                itemDto.setOrganizationName(policyEo.getOrganizationName());
                itemDto.setOrganizationId(policyEo.getOrganizationId());
                itemDto.setShopId(policyEo.getShopId());
                itemDto.setOrganizationCode(policyEo.getOrganizationCode());
                continue block0;
            }
        }
    }

    private List<DgCsCustomerBuyScopePolicyEo> buyScopePolicyEoList(DgCustomerBuyScopeItemQueryVo queryDto, List<CsOrgCustomerRelationDto> relationEos) {
        Set orgIds = relationEos.stream().map(CsOrgCustomerRelationDto::getOrganizationId).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty((Collection)queryDto.getOrganizationIds())) {
            queryDto.getOrganizationIds().retainAll(orgIds);
            if (CollectionUtil.isEmpty((Collection)queryDto.getOrganizationIds())) {
                return Collections.emptyList();
            }
            List newRelationEos = relationEos.stream().filter(e -> queryDto.getOrganizationIds().contains(e.getOrganizationId())).collect(Collectors.toList());
            relationEos.clear();
            relationEos.addAll(newRelationEos);
        } else {
            queryDto.setOrganizationIds((List)Lists.newArrayList(orgIds));
        }
        List<Long> shopIdList = this.listShopIdByShopName(queryDto.getShopName());
        return this.iDgCsCustomerBuyScopePolicyDomian.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgCsCustomerBuyScopePolicyEo.class).eq(queryDto.getShopId() != null, DgCsCustomerBuyScopePolicyEo::getShopId, (Object)queryDto.getShopId())).in(CollectionUtil.isNotEmpty((Collection)queryDto.getShopIdList()), DgCsCustomerBuyScopePolicyEo::getShopId, (Collection)queryDto.getShopIdList())).in(CollectionUtil.isNotEmpty((Collection)queryDto.getOrganizationIds()), DgCsCustomerBuyScopePolicyEo::getOrganizationId, (Collection)queryDto.getOrganizationIds())).eq(DgCsCustomerBuyScopePolicyEo::getStatus, (Object)5)).eq(BaseEo::getDr, (Object)CommonConstants.Dr.NO)).in(CollectionUtil.isNotEmpty(shopIdList), DgCsCustomerBuyScopePolicyEo::getShopId, shopIdList)).orderByDesc(BaseEo::getUpdateTime));
    }

    private List<Long> listShopIdByShopName(String shopName) {
        if (StrUtil.isBlank((CharSequence)shopName)) {
            return Collections.emptyList();
        }
        List shopEos = ((ExtQueryChainWrapper)this.iDgShopDomain.filter().like((Object)"name", (Object)shopName)).list();
        return ((List)Optional.ofNullable(shopEos).orElse(new ArrayList())).stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    private void setCustomerInfo(DgCustomerBuyScopeItemQueryVo queryDto, DgCustomerEo dgCustomerEo) {
        DgCsCompanyInfoEo dgCsCompanyInfoEo = (DgCsCompanyInfoEo)this.iDgCsCompanyInfoDomain.selectByPrimaryKey(dgCustomerEo.getCompanyId());
        queryDto.setCustomerName(dgCustomerEo.getName());
        queryDto.setErpCode(dgCustomerEo.getErpCode());
        queryDto.setCompanyName(dgCsCompanyInfoEo.getCompanyName());
    }

    private List<DgCsCustomerBuyScopePolicyEo> matchCustomerPolicyRule(DgCustomerBuyScopeItemQueryVo queryDto, List<DgCsCustomerBuyScopePolicyEo> policyEos, List<CsOrgCustomerRelationDto> relationEos, List<ShopItemDto> shopItemAll, Map<Long, Map<Long, DgCSRCustomerSkuPolicyEo>> skuAndPolicyMap, Map<Long, List<DgCsRRelationEnterpriseEo>> customerIdEnterpriseMap, Map<Long, List<DgCsRRelationShopEo>> relationIdShopMap, DgCustomerEo dgCustomerEo) {
        if (CollectionUtil.isEmpty(policyEos)) {
            return Collections.emptyList();
        }
        this.setCustomerInfo(queryDto, dgCustomerEo);
        Map<Long, DgShopEo> shopPolicyMap = this.getShopPolicyMap(queryDto.getOrganizationIds());
        if (CollectionUtil.isEmpty(shopPolicyMap)) {
            return Collections.emptyList();
        }
        return this.getMatchPolicyList(policyEos, shopPolicyMap, skuAndPolicyMap, customerIdEnterpriseMap, relationIdShopMap, relationEos, shopItemAll, (DgCustomerBuyScopeItemQueryDto)queryDto, dgCustomerEo);
    }

    private Map<Long, DgShopEo> getShopPolicyMap(List<Long> orgIds) {
        if (CollectionUtil.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        DgShopEo dgShopEo = new DgShopEo();
        dgShopEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"organization_id", orgIds)}));
        List dgShopEos = this.iDgShopDomain.selectList((BaseEo)dgShopEo);
        if (CollectionUtil.isEmpty((Collection)dgShopEos)) {
            return Collections.emptyMap();
        }
        return dgShopEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
    }

    private Map<Long, Map<Long, CsOrgCustomerRelationDto>> getRelationMap(List<CsOrgCustomerRelationDto> relationEos) {
        return relationEos.stream().collect(Collectors.groupingBy(CsOrgCustomerRelationDto::getOrganizationId, Collectors.toMap(CsOrgCustomerRelationDto::getId, Function.identity(), (v1, v2) -> v1)));
    }

    private List<DgCsCustomerBuyScopePolicyEo> getMatchPolicyList(List<DgCsCustomerBuyScopePolicyEo> policyEos, Map<Long, DgShopEo> shopPolicyMap, Map<Long, Map<Long, DgCSRCustomerSkuPolicyEo>> skuAndPolicyMap, Map<Long, List<DgCsRRelationEnterpriseEo>> customerIdEnterpriseMap, Map<Long, List<DgCsRRelationShopEo>> relationIdShopMap, List<CsOrgCustomerRelationDto> relationEos, List<ShopItemDto> shopItemAll, DgCustomerBuyScopeItemQueryDto queryDto, DgCustomerEo dgCustomerEo) {
        ArrayList<DgCsCustomerBuyScopePolicyEo> isMatchPolicyList = new ArrayList<DgCsCustomerBuyScopePolicyEo>();
        Map<Long, Map<Long, CsOrgCustomerRelationDto>> relationMap = this.getRelationMap(relationEos);
        List scopePolicyEos = policyEos.stream().sorted(Comparator.comparing(BaseEo::getCreateTime, Comparator.reverseOrder())).collect(Collectors.toList());
        HashMap<Long, List<Long>> shopDisabledPolicyIds = new HashMap<Long, List<Long>>();
        HashMap<Long, Set<Long>> activateShopIdSkuIdMap = new HashMap<Long, Set<Long>>();
        HashMap excludeSkuListMap = new HashMap();
        for (DgCsCustomerBuyScopePolicyEo policyEo : scopePolicyEos) {
            Map<Long, ShopItemDto> shopItemDtoMap;
            Map<Long, CsOrgCustomerRelationDto> orgCustomerRelationEoMap;
            if (shopPolicyMap.get(policyEo.getShopId()) == null || CollectionUtil.isEmpty(orgCustomerRelationEoMap = relationMap.get(policyEo.getOrganizationId()))) continue;
            ArrayList dgCsRRelationEnterpriseEos = new ArrayList();
            ArrayList<DgCsRRelationShopEo> relationShopEos = new ArrayList<DgCsRRelationShopEo>();
            orgCustomerRelationEoMap.values().forEach(r -> {
                List eos;
                List shopEos;
                List enterpriseEos = (List)customerIdEnterpriseMap.get(r.getCustomerId());
                if (CollectionUtil.isNotEmpty((Collection)enterpriseEos)) {
                    dgCsRRelationEnterpriseEos.addAll(enterpriseEos);
                }
                if (CollectionUtil.isNotEmpty((Collection)(shopEos = (List)relationIdShopMap.get(r.getId()))) && CollectionUtil.isNotEmpty(eos = shopEos.stream().filter(s -> s.getShopId().equals(policyEo.getShopId())).collect(Collectors.toList()))) {
                    relationShopEos.addAll(eos);
                }
            });
            if (queryDto.isTob()) {
                if (CollectionUtil.isEmpty(dgCsRRelationEnterpriseEos)) {
                    log.info("\u6ca1\u6709\u7b7e\u7ea6\u516c\u53f8");
                    log.info("\u516c\u53f8\u4fe1\u606f\uff1a{}\uff0c \u653f\u7b56\uff1a{}", (Object)JSON.toJSONString(relationIdShopMap), (Object)JSON.toJSONString((Object)policyEo));
                    continue;
                }
                if (CollectionUtil.isEmpty(relationShopEos)) {
                    log.info("\u6ca1\u6709\u7b7e\u7ea6\u5e97\u94fa");
                    log.info("\u5e97\u94fa\u4fe1\u606f\uff1a{}\uff0c \u653f\u7b56\uff1a{}", (Object)JSON.toJSONString(relationIdShopMap), (Object)JSON.toJSONString((Object)policyEo));
                    continue;
                }
            }
            List excludeSkuList = excludeSkuListMap.getOrDefault(policyEo.getShopId(), new ArrayList());
            DgCustomerBuyScopePolicyConditionDto condition = this.getMatchPolicyQueryItemCondition(isMatchPolicyList, relationShopEos, relationMap, policyEo, dgCustomerEo, queryDto.isTob());
            if (Objects.isNull(condition) || queryDto.isTob() && CollectionUtil.isEmpty(customerIdEnterpriseMap)) {
                log.info("\u6ca1\u6709\u7b26\u5408\u67e5\u8be2\u6761\u4ef6");
                continue;
            }
            if (queryDto.isTob()) {
                condition.setEnterpriseIdList(dgCsRRelationEnterpriseEos.stream().map(DgCsRRelationEnterpriseEo::getOrganizationId).collect(Collectors.toList()));
            }
            condition.setSkuCode(queryDto.getSkuCode());
            condition.setSpuCode(queryDto.getSpuCode());
            condition.setSkuName(queryDto.getSkuName());
            condition.setItemType(queryDto.getItemType());
            condition.setSkuCodes(queryDto.getSkuCodes());
            if (CollectionUtil.isNotEmpty((Collection)excludeSkuList)) {
                condition.getExcludeSkuList().addAll(excludeSkuList);
                excludeSkuList = condition.getExcludeSkuList();
            } else if (CollectionUtil.isNotEmpty((Collection)condition.getExcludeSkuList())) {
                excludeSkuList.addAll(condition.getExcludeSkuList());
            }
            if (CollectionUtil.isNotEmpty((Collection)queryDto.getBrandList())) {
                if (CollectionUtil.isNotEmpty((Collection)condition.getBrandList())) {
                    condition.getBrandList().retainAll(queryDto.getBrandList());
                } else {
                    condition.setBrandList(queryDto.getBrandList());
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)queryDto.getSkuIdList())) {
                if (CollectionUtil.isNotEmpty((Collection)condition.getSkuIdList())) {
                    condition.getSkuIdList().retainAll(queryDto.getSkuIdList());
                } else {
                    condition.setSkuIdList(queryDto.getSkuIdList());
                }
            }
            if (CollectionUtil.isEmpty(shopItemDtoMap = this.getShopItemSKuPolicyMap(condition))) continue;
            if (CollectionUtil.isNotEmpty((Collection)condition.getExcludeSkuList())) {
                excludeSkuList.addAll(condition.getExcludeSkuList());
            }
            this.handlerFilterDisabledSku(activateShopIdSkuIdMap, skuAndPolicyMap, shopItemDtoMap, shopDisabledPolicyIds, queryDto, policyEo);
            if (!CollectionUtil.isNotEmpty(shopItemDtoMap)) continue;
            shopItemAll.addAll(Lists.newArrayList(shopItemDtoMap.values()));
        }
        return isMatchPolicyList;
    }

    private void handlerFilterDisabledSku(Map<Long, Set<Long>> activateShopIdSkuIdMap, Map<Long, Map<Long, DgCSRCustomerSkuPolicyEo>> skuAndPolicyMap, Map<Long, ShopItemDto> shopItemDtoMap, Map<Long, List<Long>> shopDisabledPolicyIds, DgCustomerBuyScopeItemQueryDto queryDto, DgCsCustomerBuyScopePolicyEo policyEo) {
        if (queryDto.getStatus() != null && queryDto.getStatus().equals(1)) {
            Map mapDisabled = skuAndPolicyMap.getOrDefault(policyEo.getId(), new HashMap());
            Set skuSet = activateShopIdSkuIdMap.getOrDefault(policyEo.getShopId(), new HashSet());
            if (CollectionUtil.isEmpty((Map)mapDisabled)) {
                shopItemDtoMap.values().forEach(e -> skuSet.add(e.getSkuId()));
                activateShopIdSkuIdMap.put(policyEo.getShopId(), skuSet);
                shopItemDtoMap.clear();
                return;
            }
            Iterator<Long> iterator = shopItemDtoMap.keySet().iterator();
            while (iterator.hasNext()) {
                Long skuId = iterator.next();
                DgCSRCustomerSkuPolicyEo skuPolicyEo = (DgCSRCustomerSkuPolicyEo)mapDisabled.get(skuId);
                if (skuSet.contains(skuId)) {
                    iterator.remove();
                    continue;
                }
                if (!Objects.isNull(skuPolicyEo)) continue;
                skuSet.add(skuId);
                activateShopIdSkuIdMap.put(policyEo.getShopId(), skuSet);
                iterator.remove();
            }
        }
        if (queryDto.getStatus() != null && queryDto.getStatus().equals(0)) {
            List policyIds = shopDisabledPolicyIds.getOrDefault(policyEo.getShopId(), new ArrayList());
            policyIds.add(policyEo.getId());
            shopDisabledPolicyIds.put(policyEo.getShopId(), policyIds);
            policyIds.forEach(id -> {
                Map map = (Map)skuAndPolicyMap.get(id);
                if (CollectionUtil.isNotEmpty((Map)map)) {
                    shopItemDtoMap.keySet().removeAll(map.keySet());
                }
            });
        }
    }

    private void setItemDirName(DgCustomerBuyScopeItemRespDto itemDto, Map<Long, DirDgEo> dirDgEoMap) {
        DirDgEo dir = dirDgEoMap.get(itemDto.getDirId());
        if (dir != null) {
            String[] paths;
            for (String path : paths = dir.getIndexPath().split(",")) {
                DirDgEo pDir = dirDgEoMap.get(Long.parseLong(path));
                if (pDir == null) continue;
                if (StrUtil.isBlank((CharSequence)itemDto.getDirName())) {
                    itemDto.setDirName(String.format("%s", pDir.getName()));
                    continue;
                }
                itemDto.setDirName(String.format("%s/%s", itemDto.getDirName(), pDir.getName()));
            }
        }
    }

    private void setItemDirName(DgCustomerBuyScopeItemRespDto itemDto) {
        List<DirDgEo> parentByChildDriIds = this.getParentByChildDriId(itemDto.getDirId());
        if (CollectionUtil.isNotEmpty(parentByChildDriIds)) {
            for (DirDgEo eo : parentByChildDriIds) {
                if (StrUtil.isBlank((CharSequence)itemDto.getDirName())) {
                    itemDto.setDirName(String.format("%s", eo.getName()));
                    continue;
                }
                itemDto.setDirName(String.format("%s/%s", itemDto.getDirName(), eo.getName()));
            }
        }
    }

    private Map<Long, ShopItemDto> getShopItemSKuPolicyMap(DgCustomerBuyScopePolicyConditionDto condition) {
        List itemDtos = this.iDgShopDomain.listShopItemPolicyCondition(condition);
        if (CollectionUtil.isEmpty((Collection)itemDtos)) {
            return Collections.emptyMap();
        }
        return itemDtos.stream().peek(e -> e.setPolicyId(condition.getPolicyId())).collect(Collectors.toMap(ShopItemDto::getSkuId, Function.identity(), (v1, v2) -> v2));
    }

    private DgCustomerBuyScopePolicyConditionDto getMatchPolicyQueryItemCondition(List<DgCsCustomerBuyScopePolicyEo> isMatchPolicyList, List<DgCsRRelationShopEo> relationShopEos, Map<Long, Map<Long, CsOrgCustomerRelationDto>> relationMap, DgCsCustomerBuyScopePolicyEo policyEo, DgCustomerEo dgCustomerEo, boolean isTob) {
        DgCustomerBuyScopePolicyConditionDto queryItemCondition = null;
        CustomerPolicyDto customerPolicyDto = (CustomerPolicyDto)JSONUtil.toBean((String)policyEo.getCustomerPolicy(), CustomerPolicyDto.class);
        ItemBuyScopeDto itemPolicy = (ItemBuyScopeDto)JSONUtil.toBean((String)policyEo.getItemPolicy(), ItemBuyScopeDto.class);
        if (customerPolicyDto.getCustomer_buy_scope_type().equals(CustomerBuyScopeTypeEnum.UN_LIMITED.getType())) {
            queryItemCondition = this.getPolicyQueryItemCondition(itemPolicy, policyEo);
            isMatchPolicyList.add(policyEo);
        }
        if (customerPolicyDto.getCustomer_buy_scope_type().equals(CustomerBuyScopeTypeEnum.BUY_SCOPE.getType()) && this.matchBuyScopeCustomerPolicyRule(dgCustomerEo, customerPolicyDto, policyEo, relationMap, relationShopEos, isTob).booleanValue()) {
            queryItemCondition = this.getPolicyQueryItemCondition(itemPolicy, policyEo);
            isMatchPolicyList.add(policyEo);
        }
        if (customerPolicyDto.getCustomer_buy_scope_type().equals(CustomerBuyScopeTypeEnum.SPECIFY.getType()) && customerPolicyDto.getSpecify_customer().contains(dgCustomerEo.getId())) {
            queryItemCondition = this.getPolicyQueryItemCondition(itemPolicy, policyEo);
            isMatchPolicyList.add(policyEo);
        }
        return queryItemCondition;
    }

    private DgCustomerBuyScopePolicyConditionDto getPolicyQueryItemCondition(ItemBuyScopeDto itemPolicy, DgCsCustomerBuyScopePolicyEo policyEo) {
        SpecifyItem specifyItem;
        DgCustomerBuyScopePolicyConditionDto conditionDto = new DgCustomerBuyScopePolicyConditionDto();
        conditionDto.setShopId(policyEo.getShopId());
        conditionDto.setPolicyId(policyEo.getId());
        ItemBuyScope buyScope = itemPolicy.getBuy_scope();
        if (Objects.nonNull(itemPolicy.getBuy_scope())) {
            Map<Long, DirDgEo> map;
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getBrand())) {
                conditionDto.getBrandList().addAll(buyScope.getBrand());
            }
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getItem_type())) {
                conditionDto.getItemTypeList().addAll(buyScope.getItem_type());
            }
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getExclude_sku())) {
                conditionDto.getExcludeSkuList().addAll(buyScope.getExclude_sku());
            }
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getDir()) && CollectionUtil.isNotEmpty(map = this.mapParentByChildDriIds(buyScope.getDir()))) {
                conditionDto.getDirList().addAll(Lists.newArrayList(map.keySet()));
            }
        }
        if (Objects.nonNull(specifyItem = itemPolicy.getSpecify_item()) && specifyItem.getSpecify_type() != null) {
            if (specifyItem.getSpecify_type().equals(2) && CollectionUtil.isNotEmpty((Collection)specifyItem.getItem())) {
                conditionDto.getSkuIdList().addAll(specifyItem.getItem());
            }
            if (specifyItem.getSpecify_type().equals(1) && CollectionUtil.isNotEmpty((Collection)specifyItem.getItem())) {
                conditionDto.getItemIdList().addAll(specifyItem.getItem());
            }
        }
        return conditionDto;
    }

    private Map<Long, DirDgEo> mapParentByChildDriIds(List<Long> dirIds) {
        if (CollectionUtil.isEmpty(dirIds)) {
            return Collections.emptyMap();
        }
        List dirDgEos = this.iDirDgDomain.selectByIds(dirIds);
        if (CollectionUtils.isNotEmpty((Collection)dirDgEos)) {
            Set indexPaths = dirDgEos.stream().map(DirDgEo::getIndexPath).collect(Collectors.toSet());
            dirDgEos.addAll(this.iDirDgDomain.queryAllSub(indexPaths));
        }
        return ((List)Optional.ofNullable(dirDgEos).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
    }

    @Override
    public List<DirDgEo> getParentByChildDriId(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        List dirEos = (List)GuavaCacheUtil.getCache(String.format("dir:%s", id));
        if (CollectionUtil.isEmpty((Collection)dirEos)) {
            List dirs = this.iDirDgDomain.selectByIds((List)Lists.newArrayList((Object[])new Long[]{id}));
            if (CollectionUtils.isNotEmpty((Collection)dirs)) {
                DirDgEo dir = (DirDgEo)dirs.get(0);
                String[] paths = Optional.ofNullable(dir.getIndexPath()).orElse("0").split(",");
                ArrayList ids = Lists.newArrayList();
                int i = 0;
                for (String tid : paths) {
                    if (i != paths.length - 1 && Objects.equals(tid, "0")) {
                        ids.add(Long.parseLong(tid));
                    }
                    ++i;
                }
                dirEos = CollectionUtils.isNotEmpty((Collection)ids) ? this.iDirDgDomain.selectByIds((List)ids) : Lists.newArrayList();
                dirEos.add(dir);
            }
            GuavaCacheUtil.putCache(String.format("dir:%s", id), dirEos);
        }
        return dirEos;
    }

    private Boolean matchBuyScopeCustomerPolicyRule(DgCustomerEo dgCustomerEo, CustomerPolicyDto customerPolicyDto, DgCsCustomerBuyScopePolicyEo policyEo, Map<Long, Map<Long, CsOrgCustomerRelationDto>> relationMap, List<DgCsRRelationShopEo> relationShopEos, boolean isTob) {
        if (customerPolicyDto.getCustomer_buy_scope_type().equals(CustomerBuyScopeTypeEnum.BUY_SCOPE.getType())) {
            boolean match;
            BuyScopeDto buyScope = customerPolicyDto.getBuy_scope();
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getCustomer_group()) && !buyScope.getCustomer_group().contains(dgCustomerEo.getCustomerGroupId())) {
                return Boolean.FALSE;
            }
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getCustomer_type()) && (isTob ? !(match = relationShopEos.stream().anyMatch(e -> e.getCustomerId().equals(buyScope.getCustomer_type()))) : !buyScope.getCustomer_type().contains(dgCustomerEo.getCustomerTypeId()))) {
                return Boolean.FALSE;
            }
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getLevel()) && !buyScope.getLevel().contains(dgCustomerEo.getLevelId())) {
                return Boolean.FALSE;
            }
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getArea())) {
                Map<Long, CsOrgCustomerRelationDto> relationEoMap = relationMap.get(policyEo.getOrganizationId());
                if (CollectionUtil.isEmpty(relationEoMap)) {
                    return Boolean.FALSE;
                }
                Map<Long, CsCustomerAreaDto> areaPolicyMap = this.getChildByParentIdListMap(buyScope.getArea());
                Map<Long, CsCustomerAreaDto> areaOrgMap = this.getChildByParentIdListMap(relationEoMap.values().stream().map(CsOrgCustomerRelationDto::getAreaId).collect(Collectors.toList()));
                areaPolicyMap.keySet().retainAll(areaOrgMap.keySet());
                if (!CollectionUtil.isNotEmpty(areaPolicyMap)) {
                    return Boolean.FALSE;
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)buyScope.getExclude_customer()) && buyScope.getExclude_customer().contains(dgCustomerEo.getId())) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Map<Long, CsCustomerAreaDto> getChildByParentIdListMap(List<Long> pids) {
        HashMap<Long, CsCustomerAreaDto> childByParentIdMap = new HashMap<Long, CsCustomerAreaDto>();
        for (Long pid : pids) {
            Map<Long, CsCustomerAreaDto> map = this.getChildByParentIdMap(pid);
            if (!CollectionUtil.isNotEmpty(map)) continue;
            childByParentIdMap.putAll(map);
        }
        return childByParentIdMap;
    }

    private Map<Long, CsCustomerAreaDto> getChildByParentIdMap(Long pid) {
        if (Objects.isNull(pid)) {
            return Collections.emptyMap();
        }
        String keyId = String.format("area:%s", pid);
        Map cacheMap = (Map)GuavaCacheUtil.getCache(keyId);
        if (CollectionUtil.isNotEmpty((Map)cacheMap)) {
            return cacheMap;
        }
        DgCustomerAreaEo pAreaEo = (DgCustomerAreaEo)this.iDgCustomerAreaDomain.selectByPrimaryKey(pid);
        if (Objects.isNull(pAreaEo)) {
            return Collections.emptyMap();
        }
        List byParentId = this.iDgCustomerAreaDomain.getChildByIndexPaths((Set)Sets.newHashSet((Object[])new String[]{pAreaEo.getIndexPath()}));
        if (CollectionUtil.isNotEmpty((Collection)byParentId)) {
            Map<Long, CsCustomerAreaDto> areaDtoMap = byParentId.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
            areaDtoMap.put(pAreaEo.getId(), (CsCustomerAreaDto)BeanUtil.copyProperties((Object)pAreaEo, CsCustomerAreaDto.class, (String[])new String[0]));
            GuavaCacheUtil.putCache(keyId, areaDtoMap);
            return areaDtoMap;
        }
        return Collections.emptyMap();
    }
}

