/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.logistics.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.config.SearchConfigVo;
import com.yunxi.dg.base.center.report.constants.YesNoEnum;
import com.yunxi.dg.base.center.report.convert.entity.SendOrderDetailConverter;
import com.yunxi.dg.base.center.report.domain.entity.ISendOrderDetailDomain;
import com.yunxi.dg.base.center.report.dto.entity.SendOrderDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.SendOrderDetailPageReqDto;
import com.yunxi.dg.base.center.report.eo.SendOrderDetailEo;
import com.yunxi.dg.base.center.report.service.impl.inventory.es.BaseEsServiceInterface;
import com.yunxi.dg.base.center.report.service.logistics.ISendOrderDetailService;
import com.yunxi.dg.base.center.report.util.EsSearchUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SendOrderDetailServiceImpl
extends BaseServiceImpl<SendOrderDetailDto, SendOrderDetailEo, ISendOrderDetailDomain>
implements ISendOrderDetailService,
BaseEsServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(SendOrderDetailServiceImpl.class);
    String sendOrderTableName = "lg_send_order_detail";
    String sendOrderWaitTableName = "lg_send_order_detail_wait";
    private static final String[] ORDER_NOS = new String[]{"documentNo", "relevanceNo", "externalOrderNo"};
    @Value(value="${project.inventory.es.query:false}")
    private Boolean esQuery;
    @Autowired
    protected IOpenSearchService openSearchService;
    @Resource
    private SearchConfigVo searchConfigVo;

    public SendOrderDetailServiceImpl(ISendOrderDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<SendOrderDetailDto, SendOrderDetailEo> converter() {
        return SendOrderDetailConverter.INSTANCE;
    }

    @Override
    public RestResponse<List<SendOrderDetailDto>> queryList(SendOrderDetailPageReqDto reqDto) {
        return new RestResponse((Object)((ISendOrderDetailDomain)this.domain).queryList(reqDto));
    }

    @Override
    public PageInfo<SendOrderDetailDto> queryPage(SendOrderDetailPageReqDto reqDto) {
        PageInfo<SendOrderDetailDto> sendOrderDetailDtoPageInfo = new PageInfo<SendOrderDetailDto>();
        if (this.esQuery.booleanValue()) {
            if (YesNoEnum.YES.getCode().equals(reqDto.getTypeStatus())) {
                reqDto.setStatusList(Arrays.asList("wait_send"));
                reqDto.setNoticeStatusList(Arrays.asList("ono_wait_out"));
                sendOrderDetailDtoPageInfo = this.getSendOrderDetailWaitEsList(reqDto, this.sendOrderWaitTableName);
            } else {
                if (ObjectUtil.equals((Object)2, (Object)reqDto.getTypeStatus())) {
                    reqDto.setNoticeStatusList(Arrays.asList("ono_wait_out", "ono_portion_out"));
                    reqDto.setStatusList(Arrays.asList("send"));
                } else if (ObjectUtil.equals((Object)3, (Object)reqDto.getTypeStatus())) {
                    reqDto.setNoticeStatusList(Arrays.asList("ono_total_out", "ono_total_out", "oro_done_out"));
                    reqDto.setStatusList(Arrays.asList("send"));
                }
                sendOrderDetailDtoPageInfo = this.getSendOrderDetailWaitEsList(reqDto, this.sendOrderTableName);
            }
        } else {
            PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
            sendOrderDetailDtoPageInfo = new PageInfo(((ISendOrderDetailDomain)this.domain).queryList(reqDto));
        }
        return sendOrderDetailDtoPageInfo;
    }

    private PageInfo<SendOrderDetailDto> getSendOrderDetailWaitEsList(SendOrderDetailPageReqDto dto, String tableName) {
        String indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + tableName;
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            BigDecimal pageNum = new BigDecimal(dto.getPageNum());
            BigDecimal pageSize = new BigDecimal(dto.getPageSize());
            BigDecimal maxSize = new BigDecimal(10000);
            if (pageNum.multiply(pageSize).subtract(pageSize).compareTo(maxSize) > -1) {
                pageNum = maxSize.divide(pageSize, 0, 0);
            }
            queryVo.setPage(pageNum.intValue());
            queryVo.setPageSize(pageSize.intValue());
            SearchResultVo searchResultVo = this.searchData(indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new PageInfo();
            }
            pageInfo = this.searchResultPage(searchResultVo);
            List dgDeliveryNoticeOrderDtoList = searchResultVo.getDocValues(docValue -> {
                SendOrderDetailDto orderItemPageDto = (SendOrderDetailDto)BeanUtil.copyProperties((Object)docValue, SendOrderDetailDto.class, (String[])new String[0]);
                return orderItemPageDto;
            });
            pageInfo.setList(dgDeliveryNoticeOrderDtoList);
        }
        catch (Exception e) {
            log.error("ES\u67e5\u8be2\u5f02\u5e38:", (Throwable)e);
            throw new BizException("ES\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        return pageInfo;
    }

    private OSSearchVo initSearchVo(SendOrderDetailPageReqDto reqDto) throws Exception {
        FilterFieldVo filter;
        log.info("ES\u53d1\u8fd0\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        OSSearchVo queryVo = EsSearchUtils.newInstance().getNewSearchVo((Object)reqDto);
        if (CollectionUtils.isEmpty((Collection)reqDto.getCompoundOrderNoList())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.in((String)o, (List)reqDto.getCompoundOrderNoList(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompoundOrderNo())) {
            filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String o : ORDER_NOS) {
                filter.addSubFilterFieldVos(new FilterFieldVo[]{FilterFieldVo.equal((String)o, (String)reqDto.getCompoundOrderNo(), (LogicalSymbol)LogicalSymbol.OR)});
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        queryVo.addSort("id", SortOrder.DESC);
        log.info("ES\u53d1\u8fd0\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryVo));
        return queryVo;
    }

    @Override
    public IOpenSearchService getIOpenSearchService() {
        return this.openSearchService;
    }
}

