/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qimen.api.request.InventoryQueryRequest;
import com.qimen.api.response.InventoryQueryResponse;
import com.yunxi.dg.base.center.inventory.api.IQimenInventoryApi;
import com.yunxi.dg.base.center.inventory.api.U9InventoryApi;
import com.yunxi.dg.base.center.inventory.dto.request.U9InventorySnapshotReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.U9QueryCurrentInventoryReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.CsPhysicsWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.InventorySnapShotRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.ThirdWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.U9InventorySnapshotRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.U9QueryCurrentInventoryRespDto;
import com.yunxi.dg.base.center.pulldata.service.component.runner.BizRunnerAfterGetLockRunner;
import com.yunxi.dg.base.center.report.constants.ErpInventoryTypeEnum;
import com.yunxi.dg.base.center.report.constants.InventoryCompareTypeEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.BaseDispositionEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.CsLogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.DateTypeEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.FiltrationTypeEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.InventoryReconciliationSourceEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.ReconciliationResultEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.ReconiliationDifferenceResultEnum;
import com.yunxi.dg.base.center.report.domain.inventory.IDgLogicWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemExtDomain;
import com.yunxi.dg.base.center.report.domain.item.IItemSkuExtDomain;
import com.yunxi.dg.base.center.report.domain.reconciliation.IInventoryDiscrepancyDomain;
import com.yunxi.dg.base.center.report.domain.reconciliation.IReconciliationDispositionDomain;
import com.yunxi.dg.base.center.report.domain.reconciliation.IThreeInventoryDomain;
import com.yunxi.dg.base.center.report.dto.entity.KeepAccountMidwaySnapDto;
import com.yunxi.dg.base.center.report.dto.entity.KeepAccountMidwaySnapPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.LogicInventorySnapshotDto;
import com.yunxi.dg.base.center.report.dto.entity.LogicInventorySnapshotPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.ThirdWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryListReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicInventoryTotalPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.InventoryPreemptionDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.BaseDispositionRespDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.DgInventoryRespDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.DispositionDataDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.InventoryDataDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.InventoryDiscrepancyCollectDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.InventoryDiscrepancyDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.InventoryReqDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.ThreeInventoryDto;
import com.yunxi.dg.base.center.report.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.report.eo.inventory.InventoryPreemptionEo;
import com.yunxi.dg.base.center.report.eo.item.ItemExtEo;
import com.yunxi.dg.base.center.report.eo.item.ItemSkuExtEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.FiltrationDispositionEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.InventoryDiscrepancyCollectEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.InventoryDiscrepancyEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.ReconciliationDispositionEo;
import com.yunxi.dg.base.center.report.eo.reconciliation.ThreeInventoryEo;
import com.yunxi.dg.base.center.report.service.entity.IKeepAccountMidwaySnapService;
import com.yunxi.dg.base.center.report.service.inventory.IDgLogicInventoryService;
import com.yunxi.dg.base.center.report.service.inventory.IDgLogicInventoryTotalService;
import com.yunxi.dg.base.center.report.service.inventory.IDgLogicWarehouseService;
import com.yunxi.dg.base.center.report.service.inventory.IDgPhysicsWarehouseService;
import com.yunxi.dg.base.center.report.service.inventory.ILogicInventorySnapshotService;
import com.yunxi.dg.base.center.report.service.reconciliation.IBaseDispositionService;
import com.yunxi.dg.base.center.report.service.reconciliation.IFiltrationDispositionService;
import com.yunxi.dg.base.center.report.service.reconciliation.IInventoryCompareService;
import com.yunxi.dg.base.center.report.service.reconciliation.IInventoryDiscrepancyCollectService;
import com.yunxi.dg.base.center.report.service.reconciliation.IInventoryDiscrepancyService;
import com.yunxi.dg.base.center.report.service.reconciliation.IThreeInventoryService;
import com.yunxi.dg.base.center.report.service.utils.CollectionGroupUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InventoryCompareServiceImpl
implements IInventoryCompareService {
    private static final Logger log = LoggerFactory.getLogger(InventoryCompareServiceImpl.class);
    @Resource
    private IQimenInventoryApi qimenInventoryApi;
    @Resource
    private IDgLogicWarehouseService logicWarehouseService;
    @Resource
    private IDgLogicInventoryService dgLogicInventoryService;
    @Resource
    private IBaseDispositionService baseDispositionService;
    @Resource
    private IThreeInventoryService iThreeInventoryService;
    @Resource
    private IDgPhysicsWarehouseService physicsWarehouseService;
    @Resource
    private IFiltrationDispositionService filtrationDispositionService;
    @Resource
    private IInventoryDiscrepancyService inventoryDiscrepancyService;
    @Resource
    private IInventoryDiscrepancyCollectService inventoryDiscrepancyCollectService;
    @Resource
    private IItemSkuExtDomain itemSkuExtDomain;
    @Resource
    private IItemExtDomain itemExtDomain;
    @Resource
    private ILogicInventorySnapshotService snapshotService;
    @Resource
    private BizRunnerAfterGetLockRunner runner;
    @Resource
    private IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IThreeInventoryDomain threeInventoryDomain;
    @Resource
    private IInventoryDiscrepancyDomain inventoryDiscrepancyDomain;
    @Resource
    private ICommonsMqService mqService;
    @Resource
    private U9InventoryApi u9InventoryApi;
    @Resource
    private IDgLogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IReconciliationDispositionDomain reconciliationDispositionDomain;
    @Resource
    private IDgLogicInventoryTotalService dgLogicInventoryTotalService;
    @Resource
    private IKeepAccountMidwaySnapService keepAccountMidwaySnapService;

    @Override
    public RestResponse<List<InventoryDiscrepancyDto>> extract(InventoryReqDto reqDto) {
        Set<Object> rightMapKey;
        Set<Object> leftMapKey;
        Sets.SetView unionList;
        log.info("\u6267\u884c\u4e2d\u53f0\u548c\u4e09\u65b9\u5e93\u5b58\u5bf9\u8d26\u5dee\u5f02\u6d41\u6c34\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (StringUtils.isEmpty((String)reqDto.getBizDate()) || StringUtils.isEmpty((String)reqDto.getSource()) || StringUtils.isEmpty((String)reqDto.getDispositionNo())) {
            log.info("\u5bf9\u8d26\u65e5\u671f\u3001\u5bf9\u8d26\u65b9\u3001\u89c4\u5219\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            return new RestResponse();
        }
        BaseDispositionRespDto isBatchResp = this.baseDispositionService.selectDataByCode(BaseDispositionEnum.IS_BATCH.getCode());
        DispositionDataDto isBatchDto = (DispositionDataDto)JSONObject.parseObject((String)isBatchResp.getValue(), DispositionDataDto.class);
        BaseDispositionRespDto isStatusResp = this.baseDispositionService.selectDataByCode(BaseDispositionEnum.IS_STATUS.getCode());
        DispositionDataDto isStatusDto = (DispositionDataDto)JSONObject.parseObject((String)isStatusResp.getValue(), DispositionDataDto.class);
        BaseDispositionRespDto isCollectResp = this.baseDispositionService.selectDataByCode(BaseDispositionEnum.IS_COLLECT.getCode());
        DispositionDataDto isCollectDto = (DispositionDataDto)JSONObject.parseObject((String)isCollectResp.getValue(), DispositionDataDto.class);
        List<String> fieldsList = this.groupFieldsList(isBatchDto, isStatusDto, isCollectDto);
        List<FiltrationDispositionEo> filtrationDispositionEoList = this.filtrationWarehouseCode(reqDto);
        List<ThreeInventoryEo> omsInventoryList = this.iThreeInventoryService.selectThreeInventoryList(reqDto.getBizDate(), InventoryReconciliationSourceEnum.HYX.getCode());
        List<ThreeInventoryEo> threeInventoryList = this.iThreeInventoryService.selectThreeInventoryList(reqDto.getBizDate(), reqDto.getSource());
        List<ThreeInventoryEo> newOmsInventoryList = this.normalData(omsInventoryList, filtrationDispositionEoList, reqDto.getInventoryProperties());
        Map<Object, Object> omsInventoryMap = new HashMap();
        if (CollectionUtils.isNotEmpty(newOmsInventoryList)) {
            omsInventoryMap = CollectionGroupUtils.groupingByDynamicProperties(new ThreeInventoryEo(), newOmsInventoryList, fieldsList);
        }
        Map<Object, Object> threeInventoryMap = new HashMap();
        ArrayList<String> threeInventoryProperties = new ArrayList<String>();
        for (String inventoryProperty : reqDto.getInventoryProperties()) {
            threeInventoryProperties.add(inventoryProperty);
            if (!InventoryReconciliationSourceEnum.U9.getCode().equals(reqDto.getSource())) continue;
            threeInventoryProperties.addAll(ErpInventoryTypeEnum.getByInventoryProperties((String)inventoryProperty));
        }
        List<ThreeInventoryEo> newThreeInventoryList = this.normalData(threeInventoryList, filtrationDispositionEoList, threeInventoryProperties);
        if (CollectionUtils.isNotEmpty(newThreeInventoryList)) {
            threeInventoryMap = CollectionGroupUtils.groupingByDynamicProperties(new ThreeInventoryEo(), newThreeInventoryList, fieldsList);
        }
        ArrayList<InventoryDiscrepancyDto> inventoryDiscrepancyEoList = new ArrayList<InventoryDiscrepancyDto>();
        if (!(omsInventoryMap.isEmpty() && threeInventoryMap.isEmpty() || !CollectionUtils.isNotEmpty((Collection)(unionList = Sets.union(leftMapKey = omsInventoryMap.keySet(), rightMapKey = threeInventoryMap.keySet()))))) {
            for (String key : unionList) {
                InventoryDiscrepancyDto discrepancyEo;
                log.info("\u5bf9\u8d26key:{}", (Object)key);
                if (CollectionUtils.isNotEmpty((Collection)((Collection)omsInventoryMap.get(key))) && CollectionUtils.isEmpty((Collection)((Collection)threeInventoryMap.get(key)))) {
                    discrepancyEo = this.setDetailData(reqDto.getSource(), (List)omsInventoryMap.get(key), (List)threeInventoryMap.get(key), 0, DateTypeEnum.getByCode((String)reqDto.getDateType()));
                    inventoryDiscrepancyEoList.add(discrepancyEo);
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)((Collection)omsInventoryMap.get(key))) && CollectionUtils.isNotEmpty((Collection)((Collection)threeInventoryMap.get(key)))) {
                    discrepancyEo = this.setDetailData(reqDto.getSource(), (List)threeInventoryMap.get(key), (List)omsInventoryMap.get(key), 1, DateTypeEnum.getByCode((String)reqDto.getDateType()));
                    inventoryDiscrepancyEoList.add(discrepancyEo);
                    continue;
                }
                discrepancyEo = this.setDetailData(reqDto.getSource(), (List)omsInventoryMap.get(key), (List)threeInventoryMap.get(key), 0, DateTypeEnum.getByCode((String)reqDto.getDateType()));
                inventoryDiscrepancyEoList.add(discrepancyEo);
            }
        }
        ArrayList inventoryDiscrepancyCollectDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(inventoryDiscrepancyEoList)) {
            this.getKeepAccountMidwaySnapDtos2(inventoryDiscrepancyEoList);
            this.checkMatchResultSecond(inventoryDiscrepancyEoList);
            this.setLastDayOfTheMonth(reqDto, inventoryDiscrepancyEoList);
            this.inventoryDiscrepancyService.batchDeleteInventoryDiscrepancy(inventoryDiscrepancyEoList, reqDto.getBizDate());
            this.inventoryDiscrepancyService.insertBatch(inventoryDiscrepancyEoList);
            List<InventoryDiscrepancyCollectEo> collectEoList = this.inventoryDiscrepancyCollectService.selectDataListByConditions(reqDto.getBizDate());
            if (CollectionUtils.isNotEmpty(collectEoList)) {
                Map<String, List<InventoryDiscrepancyDto>> discrepancyMap = CollectionGroupUtils.groupingByDynamicProperties(new InventoryDiscrepancyDto(), inventoryDiscrepancyEoList, fieldsList);
                Map<String, List<InventoryDiscrepancyCollectEo>> collectMap = CollectionGroupUtils.groupingByDynamicProperties(new InventoryDiscrepancyCollectEo(), collectEoList, fieldsList);
                for (Map.Entry<String, List<InventoryDiscrepancyDto>> listEntry : discrepancyMap.entrySet()) {
                    String key = listEntry.getKey();
                    List<InventoryDiscrepancyDto> dtoList = listEntry.getValue();
                    if (null != collectMap.get(key)) {
                        List<InventoryDiscrepancyCollectEo> collectEoList1 = collectMap.get(key);
                        if (!CollectionUtils.isNotEmpty(collectEoList1)) continue;
                        InventoryDiscrepancyCollectDto discrepancyCollectDto = new InventoryDiscrepancyCollectDto();
                        BeanUtils.copyProperties((Object)collectEoList1.get(0), (Object)discrepancyCollectDto);
                        discrepancyCollectDto.setInventoryResult(JSONObject.toJSONString(this.setInventoryResult(dtoList.get(0), collectEoList1.get(0))));
                        discrepancyCollectDto.setDifferenceResult(JSONObject.toJSONString(this.setResultDifferenceResult(dtoList.get(0), collectEoList1.get(0))));
                        discrepancyCollectDto.setCheckResult(this.discrepancyResult(dtoList.get(0), collectEoList1.get(0)));
                        this.inventoryDiscrepancyCollectService.update((BaseDto)discrepancyCollectDto);
                        inventoryDiscrepancyCollectDtos.add(discrepancyCollectDto);
                        continue;
                    }
                    InventoryDiscrepancyCollectDto discrepancyCollectDto = new InventoryDiscrepancyCollectDto();
                    BeanUtils.copyProperties((Object)dtoList.get(0), (Object)discrepancyCollectDto);
                    discrepancyCollectDto.setId(null);
                    discrepancyCollectDto.setInventoryResult(JSONObject.toJSONString(this.setInventoryResult(dtoList.get(0), null)));
                    discrepancyCollectDto.setDifferenceResult(JSONObject.toJSONString(this.setResultDifferenceResult(dtoList.get(0), null)));
                    discrepancyCollectDto.setCheckResult(dtoList.get(0).getResult());
                    this.inventoryDiscrepancyCollectService.insert((BaseDto)discrepancyCollectDto);
                    inventoryDiscrepancyCollectDtos.add(discrepancyCollectDto);
                }
            } else {
                List<InventoryDiscrepancyCollectDto> discrepancyCollectDtos = this.setSaveData(inventoryDiscrepancyEoList);
                this.inventoryDiscrepancyCollectService.insertBatch(discrepancyCollectDtos);
                inventoryDiscrepancyCollectDtos.addAll(discrepancyCollectDtos);
            }
        }
        return new RestResponse(inventoryDiscrepancyEoList);
    }

    private void checkMatchResultSecond(List<InventoryDiscrepancyDto> inventoryDiscrepancyEoList) {
        for (InventoryDiscrepancyDto ld : inventoryDiscrepancyEoList) {
            String result = ld.getResult();
            BigDecimal midwayDifferenceNum = ld.getDifferenceNum().add(Optional.ofNullable(ld.getMidwayNum()).orElse(BigDecimal.ZERO));
            if (Objects.equals(result, ReconiliationDifferenceResultEnum.CONSISTENT.getCode().toString()) || Objects.equals(result, ReconiliationDifferenceResultEnum.INCONSISTENT.getCode().toString())) {
                ld.setResult(midwayDifferenceNum.compareTo(BigDecimal.ZERO) == 0 ? ReconiliationDifferenceResultEnum.CONSISTENT.getCode().toString() : ReconiliationDifferenceResultEnum.INCONSISTENT.getCode().toString());
            }
            if (Objects.equals(result, ld.getResult())) continue;
            log.info("\u5bf9\u8d26\u5dee\u5f02\u6d41\u6c34\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u66f4\u65b0\u6570\u636e {} {} {} {}", new Object[]{ld.getSkuCode(), ld.getLogicWarehouseCode(), result, ld.getResult()});
        }
    }

    private Map<String, List<KeepAccountMidwaySnapDto>> getKeepAccountMidwaySnapDtos(List<InventoryDiscrepancyDto> inventoryDiscrepancyEoList) {
        List logicWarehouseCodeList = inventoryDiscrepancyEoList.stream().map(InventoryDiscrepancyDto::getLogicWarehouseCode).collect(Collectors.toList());
        List skuCodeList = inventoryDiscrepancyEoList.stream().map(InventoryDiscrepancyDto::getSkuCode).collect(Collectors.toList());
        KeepAccountMidwaySnapPageReqDto keepAccountMidwaySnapPageReqDto = new KeepAccountMidwaySnapPageReqDto();
        keepAccountMidwaySnapPageReqDto.setLogicWarehouseCodeList(logicWarehouseCodeList);
        keepAccountMidwaySnapPageReqDto.setSkuCodeList(skuCodeList);
        log.info("\u62c9\u53d6\u8bb0\u8d26\u5728\u9014\u660e\u7ec6\u6570\u636e \u53c2\u6570 {}", (Object)JSONObject.toJSONString((Object)keepAccountMidwaySnapPageReqDto));
        List<KeepAccountMidwaySnapDto> keepAccountMidwaySnapDtoList = this.keepAccountMidwaySnapService.queryKeepAccountMidwaySnapList(keepAccountMidwaySnapPageReqDto);
        log.info("\u62c9\u53d6\u8bb0\u8d26\u5728\u9014\u660e\u7ec6\u6570\u636e \u7ed3\u679c {}", (Object)Optional.ofNullable(keepAccountMidwaySnapDtoList).map(List::size).orElse(0));
        Map keepAccountMidwaySnapMap = Optional.ofNullable(keepAccountMidwaySnapDtoList).map(ld -> ld.stream().collect(Collectors.groupingBy(o -> o.getSkuCode() + "_" + o.getLogicWarehouseCode()))).orElse(new HashMap());
        inventoryDiscrepancyEoList.forEach(ld -> {
            List matchList = (List)keepAccountMidwaySnapMap.get(ld.getSkuCode() + "_" + ld.getLogicWarehouseCode());
            if (CollectionUtils.isNotEmpty((Collection)matchList)) {
                log.info("\u5546\u54c1\u7f16\u7801 {} \u4ed3\u5e93\u7f16\u7801 {} \u5728\u9014\u8bb0\u5f55\u6570 {}", new Object[]{ld.getSkuCode(), ld.getLogicWarehouseCode(), matchList.size()});
                ld.setMidwayNum(matchList.stream().map(KeepAccountMidwaySnapDto::getMidwayNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            } else {
                ld.setMidwayNum(BigDecimal.ZERO);
            }
        });
        return keepAccountMidwaySnapMap;
    }

    private Map<String, List<KeepAccountMidwaySnapDto>> getKeepAccountMidwaySnapDtos2(List<InventoryDiscrepancyDto> inventoryDiscrepancyEoList) {
        List logicWarehouseCodeList = inventoryDiscrepancyEoList.stream().map(InventoryDiscrepancyDto::getLogicWarehouseCode).collect(Collectors.toList());
        List skuCodeList = inventoryDiscrepancyEoList.stream().map(InventoryDiscrepancyDto::getSkuCode).collect(Collectors.toList());
        KeepAccountMidwaySnapPageReqDto keepAccountMidwaySnapPageReqDto = new KeepAccountMidwaySnapPageReqDto();
        keepAccountMidwaySnapPageReqDto.setLogicWarehouseCodeList(logicWarehouseCodeList);
        keepAccountMidwaySnapPageReqDto.setSkuCodeList(skuCodeList);
        log.info("\u62c9\u53d6\u8bb0\u8d26\u5728\u9014\u5e93\u5b58\u6570\u636e \u53c2\u6570 {}", (Object)JSONObject.toJSONString((Object)keepAccountMidwaySnapPageReqDto));
        List<KeepAccountMidwaySnapDto> keepAccountMidwaySnapDtoList = this.keepAccountMidwaySnapService.queryList(keepAccountMidwaySnapPageReqDto);
        log.info("\u62c9\u53d6\u8bb0\u8d26\u5728\u9014\u5e93\u5b58\u6570\u636e \u7ed3\u679c {}", (Object)Optional.ofNullable(keepAccountMidwaySnapDtoList).map(List::size).orElse(0));
        Map keepAccountMidwaySnapMap = Optional.ofNullable(keepAccountMidwaySnapDtoList).map(ld -> ld.stream().collect(Collectors.groupingBy(o -> o.getSkuCode() + "_" + o.getLogicWarehouseCode()))).orElse(new HashMap());
        inventoryDiscrepancyEoList.forEach(ld -> {
            List matchList = (List)keepAccountMidwaySnapMap.get(ld.getSkuCode() + "_" + ld.getLogicWarehouseCode());
            if (CollectionUtils.isNotEmpty((Collection)matchList)) {
                log.info("\u5546\u54c1\u7f16\u7801 {} \u4ed3\u5e93\u7f16\u7801 {} \u5728\u9014\u8bb0\u5f55\u6570 {}", new Object[]{ld.getSkuCode(), ld.getLogicWarehouseCode(), matchList.size()});
                ld.setMidwayNum(matchList.stream().map(KeepAccountMidwaySnapDto::getMidwayNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            } else {
                ld.setMidwayNum(BigDecimal.ZERO);
            }
        });
        return keepAccountMidwaySnapMap;
    }

    private boolean batchUpdateLastDayOfTheMonth(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return true;
        }
        int size = ids.size();
        log.info("\u51c6\u5907\u6279\u91cf\u63d2\u5165{}\u8868\u6570\u636e\uff1a{}\u6761", (Object)this.inventoryDiscrepancyDomain.getClass().getSimpleName(), (Object)size);
        if (size == 0) {
            return true;
        }
        long bt = System.currentTimeMillis();
        int BATCH_SIZE = 1000;
        if (size > 1000) {
            int loop = size / 1000;
            int fromIndex = 0;
            int toIndex = 1000;
            for (int i = 0; i < loop; ++i) {
                log.debug("\u7b2c" + fromIndex + "~" + toIndex + "\u6761");
                List<Long> idsSplit = ids.subList(fromIndex, toIndex);
                this.doBatchUpdateLastDayOfTheMonth(idsSplit);
                fromIndex += 1000;
                toIndex += 1000;
            }
            if (fromIndex < size) {
                log.debug("\u7b2c" + fromIndex + "~" + size + "\u6761");
                this.doBatchUpdateLastDayOfTheMonth(ids.subList(fromIndex, size));
            }
        } else {
            this.doBatchUpdateLastDayOfTheMonth(ids);
        }
        long et = System.currentTimeMillis();
        log.info("{}\u8868{}\u6761\u6570\u636e\u63d2\u5165\u6210\u529f\uff0c\u8017\u65f6\uff1a{} ms", new Object[]{this.inventoryDiscrepancyDomain.getClass().getSimpleName(), size, et - bt});
        return true;
    }

    private void doBatchUpdateLastDayOfTheMonth(List<Long> ids) {
        InventoryDiscrepancyEo eo = new InventoryDiscrepancyEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", ids));
        eo.setLastDayOfTheMonth(Integer.valueOf(0));
        eo.setSqlFilters(sqlFilterList);
        this.inventoryDiscrepancyDomain.updateSelectiveSqlFilter((BaseEo)eo);
    }

    public static int getDifferMonth(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        int year = com.dtyunxi.util.DateUtil.getDifferYear((Date)date1, (Date)date2);
        int months = c2.get(2) - c1.get(2) + year * 12;
        return months;
    }

    private void setLastDayOfTheMonth(InventoryReqDto reqDto, List<InventoryDiscrepancyDto> inventoryDiscrepancyEoList) {
        List inventoryDiscrepancyEos;
        Date now = DateUtil.getDayBegin();
        Date bizDate = com.dtyunxi.util.DateUtil.parse((String)reqDto.getBizDate(), (String)"yyyy-MM-dd");
        log.info("today:{},bizDate:{}", (Object)now.toString(), (Object)bizDate.toString());
        if (!Objects.equals(DateTypeEnum.DAY.getCode(), reqDto.getDateType())) {
            return;
        }
        boolean differentMonth = InventoryCompareServiceImpl.getDifferMonth(bizDate, now) != 0;
        Date monthEnd = DateUtil.getMonthEnd((Date)bizDate);
        String monthEndStr = DateUtil.getDateFormat((Date)monthEnd, (String)"yyyy-MM-dd");
        log.info("\u4e1a\u52a1\u65f6\u95f4\u548c\u5f53\u524d\u65f6\u95f4\u662f\u5426\u4e0d\u5728\u540c\u4e00\u4e2a\u6708:{}", (Object)differentMonth);
        if (differentMonth && !Objects.equals(monthEndStr, bizDate)) {
            log.info("\u5f53\u524d\u548c\u4e1a\u52a1\u65f6\u95f4\u4e0d\u4e3a\u540c\u4e00\u4e2a\u6708\uff0c\u4e14\u4e1a\u52a1\u65f6\u95f4\u4e0d\u4e3a\u6708\u672b\u6700\u540e\u4e00\u5929\u4e0d\u66f4\u65b0\u6708\u5ea6\u5e93\u5b58\u5bf9\u8d26\u6807\u8bc6");
            return;
        }
        Date dayBefore = DateUtil.addDays((Date)bizDate, (int)-1);
        ArrayList<String> dateList = new ArrayList<String>(2);
        dateList.add(reqDto.getBizDate());
        if (InventoryCompareServiceImpl.getDifferMonth(dayBefore, bizDate) == 0) {
            String dayBeforeStr = DateUtil.getDateFormat((Date)dayBefore, (String)"yyyy-MM-dd");
            dateList.add(dayBeforeStr);
        }
        if (CollectionUtils.isNotEmpty((Collection)(inventoryDiscrepancyEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryDiscrepancyDomain.filter().in((Object)"biz_Date", dateList)).eq((Object)"last_day_of_the_month", (Object)1)).list()))) {
            List<Long> ids = inventoryDiscrepancyEos.stream().map(e -> e.getId()).collect(Collectors.toList());
            log.info("\u53d6\u6d88\u4e4b\u524d\u7684\u6807\u8bc6{}\u6761", (Object)ids.size());
            boolean flag = this.batchUpdateLastDayOfTheMonth(ids);
            log.info("\u53d6\u6d88\u4e4b\u524d\u7684\u6807\u8bc6\u7ed3\u679c\uff1a{}", (Object)flag);
            inventoryDiscrepancyEoList.forEach(e -> e.setLastDayOfTheMonth(Integer.valueOf(1)));
        }
        if (DateUtil.getMonthBegin().compareTo(now) == 0 && bizDate.compareTo(DateUtil.getMonthBegin()) == 0) {
            log.info("\u524d\u662f\u5f53\u6708\u7b2c\u4e00\u5929\u4e14\u4e1a\u52a1\u65e5\u671f\u4e5f\u662f\u5f53\u6708\u7b2c\u4e00\u5929\uff0c\u76f4\u63a5\u8bbe\u7f6e\u6807\u8bc6");
            inventoryDiscrepancyEoList.forEach(e -> e.setLastDayOfTheMonth(Integer.valueOf(1)));
        }
    }

    private List<FiltrationDispositionEo> filtrationWarehouseCode(InventoryReqDto reqDto) {
        List<FiltrationDispositionEo> filtrationDispositionEoList = this.filtrationDispositionService.selectFiltrationByCondition(reqDto.getDispositionNo(), FiltrationTypeEnum.LOGIC.getCode());
        DgLogicWarehousePageReqDto logicWarehousePageReqDto = new DgLogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseStatus(ValidFlagEnum.ENABLE.getCode());
        List logicWarehouseDtos = this.logicWarehouseDomain.queryList(logicWarehousePageReqDto);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)logicWarehouseDtos), (String)"\u903b\u8f91\u4ed3\u5e93\u90fd\u4e0d\u5b58\u5728");
        List filtrationWarehouseCodes = filtrationDispositionEoList.stream().map(e -> e.getEncodeNo()).distinct().collect(Collectors.toList());
        List<FiltrationDispositionEo> warehouseList = logicWarehouseDtos.stream().filter(e -> !filtrationWarehouseCodes.contains(e.getWarehouseCode())).map(e -> {
            FiltrationDispositionEo dispositionEo = new FiltrationDispositionEo();
            dispositionEo.setEncodeNo(e.getWarehouseCode());
            dispositionEo.setEncodeName(e.getWarehouseName());
            dispositionEo.setFiltrationType(FiltrationTypeEnum.LOGIC.getCode());
            return dispositionEo;
        }).collect(Collectors.toList());
        return warehouseList;
    }

    public void dealInventoryCompare(List<InventoryDiscrepancyDto> inventoryDiscrepancyEoList, String bizDate) {
        log.info("\u5220\u9664\u76f8\u540c\u65e5\u671f+\u76f8\u540c\u903b\u8f91\u4ed3+\u76f8\u540csku+\u76f8\u540c\u72b6\u6001\u6570\u636e:{}", (Object)bizDate);
        this.inventoryDiscrepancyService.batchDeleteInventoryDiscrepancy(inventoryDiscrepancyEoList, bizDate);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RestResponse<Void> saveThreeInventory(InventoryReqDto reqDto) {
        log.info("\u8c03\u7528\u63a5\u53e3\u62c9\u53d6\u4e09\u65b9\u5e93\u5b58\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)reqDto));
        LogicInventorySnapshotPageReqDto snapshotPageReqDto = new LogicInventorySnapshotPageReqDto();
        snapshotPageReqDto.setSnapshotDate(reqDto.getBizDate());
        List snapshotDtos = (List)RestResponseHelper.extractData(this.snapshotService.queryList(snapshotPageReqDto));
        ArrayList<DgInventoryRespDto> inventoryRespDtoList = new ArrayList();
        if (InventoryReconciliationSourceEnum.HYX.getCode().equals(reqDto.getSource())) {
            log.info("\u5f00\u59cb\u62c9\u53d6 \u7cfb\u7edf\u5e93\u5b58\u6570\u636e");
            DgLogicInventoryListReqDto listReqDto = new DgLogicInventoryListReqDto();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqDto.getItemCode())) {
                listReqDto.setSkuCode(reqDto.getItemCode());
            }
            try {
                if (!CollectionUtils.isNotEmpty((Collection)snapshotDtos)) return RestResponse.VOID;
                List warehouseCodes = snapshotDtos.stream().map(LogicInventorySnapshotDto::getWarehouseCode).distinct().collect(Collectors.toList());
                listReqDto.setWarehouseCodeList(warehouseCodes);
                log.info("\u5f00\u59cb\u62c9\u53d6 \u7cfb\u7edf\u5e93\u5b58\u6570\u636e oms = {}", (Object)JSONObject.toJSONString((Object)listReqDto));
                List dgLogicInventoryDtos = (List)RestResponseHelper.extractData(this.dgLogicInventoryService.queryList(listReqDto));
                if (!CollectionUtils.isNotEmpty((Collection)dgLogicInventoryDtos)) return RestResponse.VOID;
                inventoryRespDtoList = this.setOmsInventoryData(dgLogicInventoryDtos, reqDto);
                this.saveThreeInventoryData(inventoryRespDtoList, InventoryReconciliationSourceEnum.HYX.getCode());
                return RestResponse.VOID;
            }
            catch (Exception e) {
                log.error("\u62c9\u53d6 \u7cfb\u7edf\u5e93\u5b58\u6570\u636e oms\u5f02\u5e38\uff1a{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
            }
            return RestResponse.VOID;
        } else if (InventoryReconciliationSourceEnum.WMS.getCode().contains(reqDto.getSource())) {
            try {
                void var14_24;
                DgLogicInventoryListReqDto listReqDto = new DgLogicInventoryListReqDto();
                if (StringUtils.isNotEmpty((String)reqDto.getItemCode())) {
                    listReqDto.setSkuCode(reqDto.getItemCode());
                }
                if (CollectionUtils.isNotEmpty((Collection)reqDto.getItemCodeList())) {
                    listReqDto.setSkuCodeList(reqDto.getItemCodeList());
                }
                HashMap<String, ThirdWarehouseDto> thirdWarehouseMap = new HashMap<String, ThirdWarehouseDto>();
                if (!CollectionUtils.isNotEmpty((Collection)snapshotDtos)) return RestResponse.VOID;
                List warehouseCodes = snapshotDtos.stream().map(LogicInventorySnapshotDto::getWarehouseCode).distinct().collect(Collectors.toList());
                listReqDto.setWarehouseCodeList(warehouseCodes);
                List logicInventoryDtos = (List)RestResponseHelper.extractData(this.dgLogicInventoryService.queryList(listReqDto));
                if (!CollectionUtils.isNotEmpty((Collection)logicInventoryDtos)) return RestResponse.VOID;
                List logicWarehouseCodes = logicInventoryDtos.stream().map(DgLogicInventoryDto::getWarehouseCode).distinct().collect(Collectors.toList());
                DgLogicWarehousePageReqDto pageReqDto = new DgLogicWarehousePageReqDto();
                pageReqDto.setWarehouseCodes(logicWarehouseCodes);
                List logicWarehouseDtos = (List)RestResponseHelper.extractData(this.logicWarehouseService.queryList(pageReqDto));
                List<String> phyWarehouseCodes = logicWarehouseDtos.stream().map(DgLogicWarehouseDto::getPhysicsWarehouseCode).distinct().collect(Collectors.toList());
                Map logicWarehouseMap = logicWarehouseDtos.stream().collect(Collectors.toMap(DgLogicWarehouseDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
                HashMap hashMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty(phyWarehouseCodes)) {
                    List<DgPhysicsWarehouseDto> dgPhysicsWarehouseDtos = this.physicsWarehouseService.queryPhyWarehouse(phyWarehouseCodes);
                    Map map = dgPhysicsWarehouseDtos.stream().collect(Collectors.toMap(DgPhysicsWarehouseDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
                }
                Map<String, List<DgLogicInventoryDto>> logicInventoryDtosListMap = logicInventoryDtos.stream().collect(Collectors.groupingBy(DgLogicInventoryDto::getWarehouseCode));
                HashMap<String, ThirdWarehouseDto> finalThirdWarehouseMap = thirdWarehouseMap;
                void finalPhysicsWarehouseRespDtoMap = var14_24;
                for (Map.Entry<String, List<DgLogicInventoryDto>> entry : logicInventoryDtosListMap.entrySet()) {
                    List<DgLogicInventoryDto> logicInventoryDtoList = entry.getValue();
                    if (!logicWarehouseMap.containsKey(entry.getKey())) continue;
                    DgLogicWarehouseDto logicWarehouseDto = (DgLogicWarehouseDto)logicWarehouseMap.get(entry.getKey());
                    DgPhysicsWarehouseDto csPhysicsWarehouseRespDto = (DgPhysicsWarehouseDto)finalPhysicsWarehouseRespDtoMap.get(logicWarehouseDto.getPhysicsWarehouseCode());
                    reqDto.setWarehouseCode(csPhysicsWarehouseRespDto.getEntitySystemCode());
                    InventoryQueryRequest request = this.setWmsFlowReqData(reqDto, logicInventoryDtoList, finalThirdWarehouseMap, csPhysicsWarehouseRespDto);
                    if (null == request) continue;
                    log.info("\u62c9\u53d6wms\u6570\u636e\u8bf7\u6c42 = {}", (Object)JSONObject.toJSONString((Object)request));
                    try {
                        List items;
                        InventoryQueryResponse restResponse = (InventoryQueryResponse)RestResponseHelper.extractData((RestResponse)this.qimenInventoryApi.inventoryQuery(request));
                        log.info("\u62c9\u53d6wms\u6570\u636e\u8fd4\u56de = {}", (Object)JSONObject.toJSONString((Object)restResponse));
                        if (!"200".equals(restResponse.getCode()) || !CollectionUtils.isNotEmpty((Collection)(items = restResponse.getItems()))) continue;
                        List<DgInventoryRespDto> dgInventoryRespDtos = this.setWmsInventoryFlowData(items, reqDto, csPhysicsWarehouseRespDto, logicWarehouseDto);
                        this.saveThreeInventoryData(dgInventoryRespDtos, InventoryReconciliationSourceEnum.WMS.getCode());
                    }
                    catch (Exception e) {
                        log.error("\u62c9\u53d6WMS\u5e93\u5b58\u5931\u8d25\uff1a{},{}", (Object)logicWarehouseDto.getWarehouseCode(), (Object)Throwables.getStackTraceAsString((Throwable)e));
                    }
                }
                return RestResponse.VOID;
            }
            catch (Exception e) {
                log.error("\u62c9\u53d6wms\u6570\u636e\u5931\u8d25 error = {}", (Object)Throwables.getStackTraceAsString((Throwable)e));
                return RestResponse.VOID;
            }
        } else {
            if (!InventoryReconciliationSourceEnum.U9.getCode().equals(reqDto.getSource())) return RestResponse.VOID;
            log.info("\u5f00\u59cb\u62c9\u53d6 U9\u5e93\u5b58\u6570\u636e");
            if (!CollectionUtils.isNotEmpty((Collection)snapshotDtos)) return RestResponse.VOID;
            List warehouseCodes = snapshotDtos.stream().map(LogicInventorySnapshotDto::getWarehouseCode).distinct().collect(Collectors.toList());
            DgLogicWarehousePageReqDto dto = new DgLogicWarehousePageReqDto();
            dto.setWarehouseCodes(warehouseCodes);
            List logicWarehouseDtos = (List)RestResponseHelper.extractData(this.logicWarehouseService.queryList(dto));
            log.info("\u903b\u8f91\u4ed3\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)logicWarehouseDtos));
            if (!CollectionUtils.isNotEmpty((Collection)logicWarehouseDtos)) return RestResponse.VOID;
            CompletableFuture.runAsync(() -> this.getU9InventorySnapshotList(logicWarehouseDtos, reqDto));
        }
        return RestResponse.VOID;
    }

    private List<LogicInventorySnapshotDto> getLoginInventorySnapDtos(String bizDate) {
        LogicInventorySnapshotPageReqDto snapshotPageReqDto = new LogicInventorySnapshotPageReqDto();
        snapshotPageReqDto.setSnapshotDate(bizDate);
        List snapshotDtos = (List)RestResponseHelper.extractData(this.snapshotService.queryList(snapshotPageReqDto));
        if (CollectionUtils.isNotEmpty((Collection)snapshotDtos)) {
            List<String> warehouseCodes = snapshotDtos.stream().map(LogicInventorySnapshotDto::getWarehouseCode).distinct().collect(Collectors.toList());
            List<DgLogicWarehouseDto> logicWarehouseDtos = this.getDgLogicWarehouseDto(warehouseCodes);
            Map logicWarehouseDtoMap = logicWarehouseDtos.stream().collect(Collectors.toMap(DgLogicWarehouseDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            snapshotDtos.forEach(v -> {
                if (logicWarehouseDtoMap.containsKey(v.getWarehouseCode())) {
                    DgLogicWarehouseDto warehouseDto = (DgLogicWarehouseDto)logicWarehouseDtoMap.get(v.getWarehouseCode());
                    v.setPhysicsWarehouseCode(Objects.nonNull(warehouseDto) ? warehouseDto.getPhysicsWarehouseCode() : null);
                    v.setPhysicsWarehouseName(Objects.nonNull(warehouseDto) ? warehouseDto.getPhysicsWarehouseName() : null);
                }
            });
        }
        return snapshotDtos;
    }

    private List<DgLogicWarehouseDto> getDgLogicWarehouseDto(List<String> warehouseCodes) {
        DgLogicWarehousePageReqDto pageReqDto = new DgLogicWarehousePageReqDto();
        pageReqDto.setWarehouseCodes(warehouseCodes);
        List logicWarehouseDtos = (List)RestResponseHelper.extractData(this.logicWarehouseService.queryList(pageReqDto));
        return logicWarehouseDtos;
    }

    private List<DgPhysicsWarehouseDto> getDgPhysicsWarehouseDtos(List<String> phyWarehouseCodes) {
        List<DgPhysicsWarehouseDto> dgPhysicsWarehouseDtos = this.physicsWarehouseService.queryPhyWarehouse(phyWarehouseCodes);
        return dgPhysicsWarehouseDtos;
    }

    @Override
    public void lockAndSaveThreeInventory(InventoryReqDto reqDto) {
        String cacheKey = "lockAndSaveThreeInventory_%s";
        this.runner.run(String.format(cacheKey, reqDto.getSource() + reqDto.getBizDate()), () -> this.fetchCount(reqDto.getSource(), reqDto.getBizDate()) > 0, s -> this.saveThreeInventoryNew(reqDto));
    }

    @Override
    public void reCreate(String reconciliationTime, String source, String dateType) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("reconciliationTime", reconciliationTime);
        map.put("source", source);
        map.put("dateType", dateType);
        String data = JSON.toJSONString(map);
        log.info("[\u5e93\u5b58\u5bf9\u8d26]\u53d1\u9001mq data\uff1a{}", (Object)data);
        this.mqService.sendSingleMessage("INVENTORY_DISCREPANCY_TAG", (Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveThreeInventoryAndExtract(Long dispositionId, String reconciliationDate) {
        ReconciliationDispositionEo dispositionEo = (ReconciliationDispositionEo)this.reconciliationDispositionDomain.selectByPrimaryKey(dispositionId);
        if (dispositionEo == null) {
            throw new BizException("[\u4e09\u65b9\u5e93\u5b58\u5bf9\u8d26\u6d41\u6c34]\uff0c\u89c4\u5219\u4e3a\u7a7a");
        }
        String dayCacheKey = String.format("saveThreeInventoryAndExtract_%s_%s", dispositionEo.getReconciliationObject(), reconciliationDate);
        log.info("dayCacheKey:{}", (Object)dayCacheKey);
        boolean dayFlag = this.cacheService.setIfAbsent(dayCacheKey, "1", 3600);
        if (!dayFlag) {
            throw new BizException("\u7cfb\u7edf\u7e41\u5fd9\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        try {
            long time = System.currentTimeMillis();
            InventoryReqDto omsReqDto = new InventoryReqDto();
            omsReqDto.setSource(InventoryReconciliationSourceEnum.HYX.getCode());
            omsReqDto.setBizDate(reconciliationDate);
            log.info("[\u62c9\u53d6\u7cfb\u7edf\u5e93\u5b58\u6d41\u6c34] InventoryReqDto = {}", (Object)JSONObject.toJSONString((Object)omsReqDto));
            this.saveThreeInventoryNew(omsReqDto);
            log.info("[\u62c9\u53d6\u7cfb\u7edf\u5e93\u5b58\u6d41\u6c34\u8017\u65f6]:{} ms", (Object)(System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
            String source = dispositionEo.getReconciliationObject();
            InventoryReqDto reqDto = new InventoryReqDto();
            reqDto.setSource(source);
            reqDto.setBizDate(reconciliationDate);
            log.info("[\u62c9\u53d6\u4e09\u65b9\u5e93\u5b58\u6d41\u6c34] InventoryReqDto = {}", (Object)JSONObject.toJSONString((Object)reqDto));
            this.saveThreeInventoryNew(reqDto);
            log.info("[\u62c9\u53d6\u4e09\u65b9\u5e93\u5b58\u6d41\u6c34\u8017\u65f6]:{} ms", (Object)(System.currentTimeMillis() - time));
            InventoryReqDto extractReqDto = new InventoryReqDto();
            extractReqDto.setSource(source);
            extractReqDto.setDispositionNo(dispositionEo.getDispositionNo());
            extractReqDto.setBizDate(reconciliationDate);
            extractReqDto.setInventoryProperties(Arrays.stream(dispositionEo.getReconciliationInventoryProperty().split("\u3001")).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
            extractReqDto.setDateType(DateTypeEnum.DAY.getCode());
            this.extract(extractReqDto);
            log.info("[\u4e09\u65b9\u5e93\u5b58\u5bf9\u8d26\u8017\u65f6]:{} ms", (Object)(System.currentTimeMillis() - time));
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u5e93\u5b58\u6d41\u6c34\u5bf9\u8d26error->{},{}", (Object)JSON.toJSONString((Object)e), (Object)e);
        }
        finally {
            this.cacheService.delCache(dayCacheKey);
        }
    }

    @Override
    public RestResponse<List<InventoryDiscrepancyDto>> saveCurrentThreeInventoryAndExtract(List<Long> ids) {
        List inventoryDiscrepancyEos = ((ExtQueryChainWrapper)this.inventoryDiscrepancyDomain.filter().in((Object)"id", ids)).list();
        if (CollectionUtils.isEmpty((Collection)inventoryDiscrepancyEos)) {
            throw new BizException("\u67e5\u8be2\u5e93\u5b58\u65e5\u5bf9\u8d26\u5dee\u5f02\u8bb0\u5f55\u4e3a\u7a7a");
        }
        RestResponse response = new RestResponse((Object)Lists.newArrayList());
        Map<String, List<InventoryDiscrepancyEo>> inventoryDiscrepancyMap = inventoryDiscrepancyEos.stream().collect(Collectors.groupingBy(InventoryDiscrepancyEo::getSource));
        inventoryDiscrepancyMap.forEach((source, list) -> {
            ReconciliationDispositionEo dispositionEo = (ReconciliationDispositionEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reconciliationDispositionDomain.filter().eq((Object)"reconciliation_object", source)).last(" limit 1")).one();
            if (dispositionEo == null) {
                throw new BizException("[\u62c9\u53d6\u5e76\u4e0e\u4e09\u65b9\u5dee\u5f02\u5904\u7406]\uff0c\u89c4\u5219\u4e3a\u7a7a");
            }
            long time = System.currentTimeMillis();
            String bizDate = DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            Map<String, List<InventoryDiscrepancyEo>> orgCodeMap = list.stream().collect(Collectors.groupingBy(inventoryDiscrepancyEo -> inventoryDiscrepancyEo.getOrganizationCode() + "-" + inventoryDiscrepancyEo.getLogicWarehouseCode()));
            orgCodeMap.forEach((k, v) -> {
                String[] split = k.split("-");
                String organizationCode = split[0];
                String warehouseCode = split[1];
                List<String> skuCodes = v.stream().map(InventoryDiscrepancyEo::getSkuCode).collect(Collectors.toList());
                log.info("[\u62c9\u53d6\u7cfb\u7edf\u5b9e\u65f6\u5e93\u5b58\u6d41\u6c34] skuCodes = {}\uff0corganizationCode:{},warehouseCode:{}", new Object[]{JSONObject.toJSONString(skuCodes), organizationCode, warehouseCode});
                this.saveCurrentSystemInventoryNew(skuCodes, bizDate, warehouseCode);
                log.info("[\u62c9\u53d6\u7cfb\u7edf\u5b9e\u65f6\u5e93\u5b58\u6d41\u6c34\u8017\u65f6]:{} ms", (Object)(System.currentTimeMillis() - time));
                log.info("[\u62c9\u53d6\u4e09\u65b9\u5b9e\u65f6\u5e93\u5b58\u6d41\u6c34] skuCodes = {}\uff0corganizationCode:{},warehouseCode:{}", new Object[]{JSONObject.toJSONString(skuCodes), organizationCode, warehouseCode});
                this.saveCurrentThreeInventoryNew((List<InventoryDiscrepancyEo>)v, bizDate, organizationCode, warehouseCode);
                log.info("[\u62c9\u53d6\u4e09\u65b9\u5b9e\u65f6\u5e93\u5b58\u6d41\u6c34\u8017\u65f6]:{} ms", (Object)(System.currentTimeMillis() - time));
            });
            InventoryReqDto extractReqDto = new InventoryReqDto();
            extractReqDto.setSource(source);
            extractReqDto.setDispositionNo(dispositionEo.getDispositionNo());
            extractReqDto.setBizDate(bizDate);
            extractReqDto.setDateType(DateTypeEnum.CURRENT.getCode());
            extractReqDto.setInventoryProperties(Arrays.stream(dispositionEo.getReconciliationInventoryProperty().split("\u3001")).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
            RestResponse<List<InventoryDiscrepancyDto>> extract = this.extract(extractReqDto);
            log.info("[\u4e09\u65b9\u5b9e\u65f6\u5e93\u5b58\u5bf9\u8d26\u8017\u65f6]:{} ms", (Object)(System.currentTimeMillis() - time));
            List currentInventoryDiscrepancyDtos = (List)extract.getData();
            this.setInventoryDiscrepancyDayNum(currentInventoryDiscrepancyDtos, inventoryDiscrepancyEos);
            ((List)response.getData()).addAll(currentInventoryDiscrepancyDtos);
        });
        this.setMidwayNum(inventoryDiscrepancyEos, (RestResponse<List<InventoryDiscrepancyDto>>)response);
        return response;
    }

    private void setMidwayNum(List<InventoryDiscrepancyEo> inventoryDiscrepancyEos, RestResponse<List<InventoryDiscrepancyDto>> response) {
        List logicWarehouseCodeList = inventoryDiscrepancyEos.stream().map(InventoryDiscrepancyEo::getLogicWarehouseCode).collect(Collectors.toList());
        List skuCodeList = inventoryDiscrepancyEos.stream().map(InventoryDiscrepancyEo::getSkuCode).collect(Collectors.toList());
        KeepAccountMidwaySnapPageReqDto keepAccountMidwaySnapPageReqDto = new KeepAccountMidwaySnapPageReqDto();
        keepAccountMidwaySnapPageReqDto.setLogicWarehouseCodeList(logicWarehouseCodeList);
        keepAccountMidwaySnapPageReqDto.setSkuCodeList(skuCodeList);
        List<KeepAccountMidwaySnapDto> keepAccountMidwaySnapDtoList = this.keepAccountMidwaySnapService.queryKeepAccountMidwaySnapList(keepAccountMidwaySnapPageReqDto);
        if (CollectionUtils.isNotEmpty(keepAccountMidwaySnapDtoList)) {
            Map keepAccountEnRouteInventoryDetailMap = keepAccountMidwaySnapDtoList.stream().collect(Collectors.toMap(p -> this.getWarehouseCodeKey(p.getLogicWarehouseCode(), p.getSkuCode()), Function.identity()));
            for (InventoryDiscrepancyDto inventoryDiscrepancyDto : (List)response.getData()) {
                KeepAccountMidwaySnapDto keepAccountMidwaySnapDto = (KeepAccountMidwaySnapDto)keepAccountEnRouteInventoryDetailMap.get(this.getWarehouseCodeKey(inventoryDiscrepancyDto.getLogicWarehouseCode(), inventoryDiscrepancyDto.getSkuCode()));
                if (keepAccountMidwaySnapDto != null) {
                    inventoryDiscrepancyDto.setMidwayNum(keepAccountMidwaySnapDto.getMidwayNum());
                    inventoryDiscrepancyDto.setDifferenceMidwayNum(inventoryDiscrepancyDto.getDifferenceNum().add(keepAccountMidwaySnapDto.getMidwayNum()));
                    if (BigDecimal.ZERO.compareTo(inventoryDiscrepancyDto.getDifferenceMidwayNum()) == 0) {
                        inventoryDiscrepancyDto.setResult("0");
                        continue;
                    }
                    inventoryDiscrepancyDto.setResult("1");
                    continue;
                }
                inventoryDiscrepancyDto.setMidwayNum(BigDecimal.ZERO);
                inventoryDiscrepancyDto.setDifferenceMidwayNum(inventoryDiscrepancyDto.getDifferenceNum());
            }
        }
    }

    private String getWarehouseCodeKey(String logicWarehouseCode, String skuCode) {
        return logicWarehouseCode + "_" + skuCode;
    }

    private void setInventoryDiscrepancyDayNum(List<InventoryDiscrepancyDto> currentInventorys, List<InventoryDiscrepancyEo> dayInventorys) {
        List<InventoryDiscrepancyEo> dayDiscrepancys = dayInventorys.stream().filter(dayInventory -> dayInventory.getResult().equals("1")).collect(Collectors.toList());
        Map currentMap = currentInventorys.stream().filter(dto -> dto.getResult().equals("0")).collect(Collectors.toMap(dto -> dto.getSkuCode() + dto.getLogicWarehouseCode(), Function.identity(), (a, b) -> b));
        dayDiscrepancys.forEach(day -> {
            InventoryDiscrepancyDto currentDiscrepancy = (InventoryDiscrepancyDto)currentMap.get(day.getSkuCode() + day.getLogicWarehouseCode());
            if (Objects.isNull(currentDiscrepancy)) {
                log.info("\u65e5\u5bf9\u8d26\u5339\u914d\u53ca\u65f6\u5e93\u5b58\u4e3a\u7a7a\uff0cskuCode:{},logicWarehouseCode:{}", (Object)day.getSkuCode(), (Object)day.getLogicWarehouseCode());
                return;
            }
            InventoryDiscrepancyEo updateEo = new InventoryDiscrepancyEo();
            updateEo.setId(day.getId());
            updateEo.setProcessedDifferenceTime(new Date());
            updateEo.setProcessedDifferenceNum(day.getDifferenceNum().negate());
            updateEo.setResult("0");
            this.inventoryDiscrepancyDomain.updateSelective((BaseEo)updateEo);
        });
    }

    @Override
    public void handleDiscrepancyDayNum(List<Long> ids) {
        List inventoryDiscrepancyEos = ((ExtQueryChainWrapper)this.inventoryDiscrepancyDomain.filter().in((Object)"id", ids)).list();
        if (CollectionUtils.isEmpty((Collection)inventoryDiscrepancyEos)) {
            throw new BizException("\u67e5\u8be2\u5e93\u5b58\u65e5\u5bf9\u8d26\u5dee\u5f02\u8bb0\u5f55\u4e3a\u7a7a");
        }
        inventoryDiscrepancyEos.forEach(day -> {
            InventoryDiscrepancyEo updateEo = new InventoryDiscrepancyEo();
            updateEo.setId(day.getId());
            updateEo.setProcessedDifferenceTime(new Date());
            updateEo.setProcessedDifferenceNum(day.getDifferenceNum().negate());
            updateEo.setResult("0");
            this.inventoryDiscrepancyDomain.updateSelective((BaseEo)updateEo);
        });
    }

    private void saveCurrentThreeInventoryNew(List<InventoryDiscrepancyEo> inventoryDiscrepancyEos, String bizDate, String organizationCode, String warehouseCode) {
        log.info("\u62c9\u53d6\u7b2c\u4e09\u65b9\u5b9e\u65f6\u5e93\u5b58\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString(inventoryDiscrepancyEos));
        try {
            U9QueryCurrentInventoryReqDto u9QueryCurrentInventoryReqDto = new U9QueryCurrentInventoryReqDto();
            u9QueryCurrentInventoryReqDto.setOrgCode(organizationCode);
            u9QueryCurrentInventoryReqDto.setWarehouseCode(warehouseCode);
            Map<String, InventoryDiscrepancyEo> inventoryDiscrepancyEoMap = inventoryDiscrepancyEos.stream().collect(Collectors.toMap(InventoryDiscrepancyEo::getSkuCode, Function.identity(), (a, b) -> b));
            u9QueryCurrentInventoryReqDto.setItemCodes((List)Lists.newArrayList(inventoryDiscrepancyEoMap.keySet()));
            log.info("\u5f00\u59cb\u62c9\u53d6 U9\u5b9e\u65f6\u5e93\u5b58\u6570\u636e\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)u9QueryCurrentInventoryReqDto));
            U9QueryCurrentInventoryRespDto u9QueryCurrentInventoryRespDto = (U9QueryCurrentInventoryRespDto)this.u9InventoryApi.queryU9CurrentInventory(u9QueryCurrentInventoryReqDto).getData();
            log.info("\u62c9\u53d6U9\u5b9e\u65f6\u5e93\u5b58\u6570\u636e\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)u9QueryCurrentInventoryRespDto));
            if (Objects.isNull(u9QueryCurrentInventoryRespDto) || CollectionUtils.isEmpty((Collection)u9QueryCurrentInventoryRespDto.getLines())) {
                log.info("\u62c9\u53d6u9\u5b9e\u65f6\u5e93\u5b58\u5feb\u7167\u4e3a\u7a7a,warehouseCode:{},organizationCode\uff1a{},inventoryDiscrepancyEoMap:{}", new Object[]{warehouseCode, organizationCode, JSON.toJSONString(inventoryDiscrepancyEoMap)});
            }
            List<DgInventoryRespDto> dgInventoryRespDtos = this.setU9CurrentInventoryFlowData(u9QueryCurrentInventoryRespDto, inventoryDiscrepancyEoMap, bizDate);
            this.saveThreeInventoryData(dgInventoryRespDtos, InventoryReconciliationSourceEnum.U9.getCode());
        }
        catch (Exception e) {
            log.info("\u62c9\u53d6\u7b2c\u4e09\u65b9\u5b9e\u65f6\u5e93\u5b58\u8bb0\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private List<DgInventoryRespDto> setU9CurrentInventoryFlowData(U9QueryCurrentInventoryRespDto u9QueryCurrentInventoryRespDto, Map<String, InventoryDiscrepancyEo> inventoryDiscrepancyEoMap, String bizDate) {
        ArrayList<DgInventoryRespDto> respDtoList = new ArrayList<DgInventoryRespDto>();
        List lines = u9QueryCurrentInventoryRespDto.getLines();
        lines.forEach(currentInventoryItem -> {
            InventoryDiscrepancyEo inventoryDiscrepancyEo = (InventoryDiscrepancyEo)inventoryDiscrepancyEoMap.get(currentInventoryItem.getItemCode());
            if (Objects.isNull(inventoryDiscrepancyEo)) {
                log.info("skuCode\u4e0d\u5b58\u5728\uff0cskuCode:{}", (Object)currentInventoryItem.getItemCode());
                return;
            }
            DgInventoryRespDto dgInventoryRespDto = new DgInventoryRespDto();
            BeanUtils.copyProperties((Object)inventoryDiscrepancyEo, (Object)dgInventoryRespDto);
            dgInventoryRespDto.setInventoryNum(currentInventoryItem.getQty());
            dgInventoryRespDto.setBizDate(bizDate);
            respDtoList.add(dgInventoryRespDto);
        });
        return respDtoList;
    }

    private void saveCurrentSystemInventoryNew(List<String> skuCodes, String bizDate, String warehouseCode) {
        log.info("\u62c9\u53d6\u7cfb\u7edf\u5b9e\u65f6\u5e93\u5b58\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString(skuCodes));
        try {
            DgLogicInventoryTotalPageReqDto dgLogicInventoryTotalPageReqDto = new DgLogicInventoryTotalPageReqDto();
            dgLogicInventoryTotalPageReqDto.setSkuCodeList(skuCodes);
            dgLogicInventoryTotalPageReqDto.setLogicWarehouseCode(warehouseCode);
            List logicInventoryTotalDtos = (List)this.dgLogicInventoryTotalService.queryList(dgLogicInventoryTotalPageReqDto).getData();
            if (CollectionUtils.isEmpty((Collection)logicInventoryTotalDtos)) {
                throw new BizException("\u67e5\u8be2\u903b\u8f91\u4ed3\u5b9e\u65f6\u5e93\u5b58\u4e3a\u7a7a");
            }
            ArrayList inventoryRespDtos = Lists.newArrayList();
            logicInventoryTotalDtos.forEach(dgLogicInventoryTotalDto -> {
                DgInventoryRespDto dgInventoryRespDto = new DgInventoryRespDto();
                dgInventoryRespDto.setInventoryNum(dgLogicInventoryTotalDto.getBalance().toString());
                dgInventoryRespDto.setOrganizationName(dgLogicInventoryTotalDto.getOrganizationName());
                dgInventoryRespDto.setOrganizationCode(dgLogicInventoryTotalDto.getOrganizationCode());
                dgInventoryRespDto.setBizDate(bizDate);
                dgInventoryRespDto.setPhysicsWarehouseCode(dgLogicInventoryTotalDto.getPhysicsWarehouseCode());
                dgInventoryRespDto.setPhysicsWarehouseName(dgLogicInventoryTotalDto.getPhysicsWarehouseName());
                dgInventoryRespDto.setLogicWarehouseCode(dgLogicInventoryTotalDto.getWarehouseCode());
                dgInventoryRespDto.setLogicWarehouseName(dgLogicInventoryTotalDto.getWarehouseName());
                dgInventoryRespDto.setSkuCode(dgLogicInventoryTotalDto.getSkuCode());
                dgInventoryRespDto.setSkuName(dgLogicInventoryTotalDto.getSkuName());
                dgInventoryRespDto.setStatus(dgLogicInventoryTotalDto.getInventoryProperty());
                inventoryRespDtos.add(dgInventoryRespDto);
            });
            this.saveThreeInventoryData(inventoryRespDtos, InventoryReconciliationSourceEnum.HYX.getCode());
        }
        catch (Exception e) {
            log.info("\u62c9\u53d6\u7cfb\u7edf\u5b9e\u65f6\u5e93\u5b58\u8bb0\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private Integer fetchCount(String source, String bizDate) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.threeInventoryDomain.filter().eq((Object)"biz_date", (Object)bizDate)).eq((Object)"source", (Object)source)).count();
    }

    @Override
    public RestResponse<Void> saveThreeInventoryNew(InventoryReqDto reqDto) {
        log.info("\u8c03\u7528\u63a5\u53e3\u62c9\u53d6\u4e09\u65b9\u5e93\u5b58\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)reqDto));
        List<LogicInventorySnapshotDto> snapshotDtos = this.getLoginInventorySnapDtos(reqDto.getBizDate());
        if (CollectionUtils.isEmpty(snapshotDtos)) {
            log.info("\u903b\u8f91\u4ed3\u5e93\u5b58\u5feb\u7167\u6570\u636e\u4e0d\u5b58\u5728:{}", (Object)reqDto.getBizDate());
            return RestResponse.VOID;
        }
        Map<String, List<LogicInventorySnapshotDto>> logicInventorySnapListMap = snapshotDtos.stream().collect(Collectors.groupingBy(LogicInventorySnapshotDto::getWarehouseCode));
        List<String> warehouseCodes = snapshotDtos.stream().map(LogicInventorySnapshotDto::getWarehouseCode).distinct().collect(Collectors.toList());
        List<DgLogicWarehouseDto> logicWarehouseDtos = this.getDgLogicWarehouseDto(warehouseCodes);
        if (CollectionUtils.isEmpty(logicWarehouseDtos)) {
            log.info("\u903b\u8f91\u4ed3\u5e93\u6570\u636e\u4e0d\u5b58\u5728:{}", (Object)reqDto.getBizDate());
            return RestResponse.VOID;
        }
        Map<Object, Object> logicWarehouseMap = Maps.newHashMap();
        Map<Object, Object> physicsWarehouseRespDtoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(logicWarehouseDtos)) {
            logicWarehouseMap = logicWarehouseDtos.stream().collect(Collectors.toMap(DgLogicWarehouseDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            List<String> phyWarehouseCodes = logicWarehouseDtos.stream().map(DgLogicWarehouseDto::getPhysicsWarehouseCode).distinct().collect(Collectors.toList());
            List<DgPhysicsWarehouseDto> dgPhysicsWarehouseDtos = this.getDgPhysicsWarehouseDtos(phyWarehouseCodes);
            physicsWarehouseRespDtoMap = dgPhysicsWarehouseDtos.stream().collect(Collectors.toMap(DgPhysicsWarehouseDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList<DgInventoryRespDto> inventoryRespDtoList = new ArrayList();
        if (InventoryReconciliationSourceEnum.HYX.getCode().equals(reqDto.getSource())) {
            log.info("\u5f00\u59cb\u62c9\u53d6 \u7cfb\u7edf\u5e93\u5b58\u6570\u636e");
            BaseDispositionRespDto isBatchResp = this.baseDispositionService.selectDataByCode(BaseDispositionEnum.IS_BATCH.getCode());
            DispositionDataDto isBatchDto = (DispositionDataDto)JSONObject.parseObject((String)isBatchResp.getValue(), DispositionDataDto.class);
            List preemptionDtos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryPreemptionDomain.filter().eq((Object)"valid", (Object)ValidFlagEnum.ENABLE.getCode())).in((Object)"source_type", (Collection)Lists.newArrayList((Object[])new String[]{"out_allot_preempt", "out_allot"}))).list();
            Map<Object, Object> preemptionMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)preemptionDtos)) {
                preemptionMap = preemptionDtos.stream().collect(Collectors.groupingBy(e -> e.getWarehouseCode()));
            }
            try {
                for (Map.Entry<String, List<LogicInventorySnapshotDto>> entry : logicInventorySnapListMap.entrySet()) {
                    List<LogicInventorySnapshotDto> v = entry.getValue();
                    DgLogicWarehouseDto logicWarehouseDto = (DgLogicWarehouseDto)logicWarehouseMap.get(entry.getKey());
                    DgPhysicsWarehouseDto csPhysicsWarehouseRespDto = (DgPhysicsWarehouseDto)physicsWarehouseRespDtoMap.get(logicWarehouseDto.getPhysicsWarehouseCode());
                    List inventoryPreemptionDtos = (List)preemptionMap.get(entry.getKey());
                    inventoryRespDtoList = this.setOmsLogicInventoryData(v, reqDto, logicWarehouseDto, csPhysicsWarehouseRespDto, isBatchDto, inventoryPreemptionDtos);
                    this.saveThreeInventoryData(inventoryRespDtoList, InventoryReconciliationSourceEnum.HYX.getCode());
                }
            }
            catch (Exception e2) {
                log.error("\u62c9\u53d6 \u7cfb\u7edf\u5e93\u5b58\u6570\u636e oms\u5f02\u5e38\uff1a{}", (Object)Throwables.getStackTraceAsString((Throwable)e2));
            }
        } else if (InventoryReconciliationSourceEnum.U9.getCode().equals(reqDto.getSource())) {
            log.info("\u5f00\u59cb\u62c9\u53d6 U9\u5e93\u5b58\u6570\u636e");
            for (Map.Entry<String, List<LogicInventorySnapshotDto>> entry : logicInventorySnapListMap.entrySet()) {
                DgLogicWarehouseDto logicWarehouseDto = (DgLogicWarehouseDto)logicWarehouseMap.get(entry.getKey());
                DgPhysicsWarehouseDto csPhysicsWarehouseRespDto = (DgPhysicsWarehouseDto)physicsWarehouseRespDtoMap.get(logicWarehouseDto.getPhysicsWarehouseCode());
                this.getU9InventorySnapshotListByLogicWarehouse(logicWarehouseDto, csPhysicsWarehouseRespDto, reqDto);
            }
        }
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveThreeInventoryData(List<DgInventoryRespDto> inventoryRespDtoList, String source) {
        ArrayList<ThreeInventoryDto> inventoryDtoList = new ArrayList<ThreeInventoryDto>();
        if (CollectionUtils.isNotEmpty(inventoryRespDtoList)) {
            inventoryRespDtoList.forEach(v -> {
                ThreeInventoryDto inventoryDto = new ThreeInventoryDto();
                BeanUtils.copyProperties((Object)v, (Object)inventoryDto);
                inventoryDto.setInventoryNum(new BigDecimal(v.getInventoryNum()));
                inventoryDto.setTransferPreemptNum(Objects.nonNull(v.getTransferPreemptNum()) ? new BigDecimal(v.getTransferPreemptNum()) : null);
                inventoryDto.setId(null);
                if (InventoryReconciliationSourceEnum.HYX.getCode().equals(source)) {
                    inventoryDto.setSource(InventoryReconciliationSourceEnum.HYX.getCode());
                } else if (InventoryReconciliationSourceEnum.WMS.getCode().contains(source)) {
                    inventoryDto.setSource(InventoryReconciliationSourceEnum.WMS.getCode());
                } else if (InventoryReconciliationSourceEnum.U9.getCode().equals(source)) {
                    inventoryDto.setSource(InventoryReconciliationSourceEnum.U9.getCode());
                }
                inventoryDto.setBatchNo(v.getBatchNo());
                inventoryDto.setExternalType(v.getType());
                inventoryDto.setType(Optional.ofNullable(InventoryCompareTypeEnum.getCode((String)inventoryDto.getExternalType())).orElse(InventoryCompareTypeEnum.BALANCE.getCode()));
                inventoryDtoList.add(inventoryDto);
            });
        }
        if (CollectionUtils.isNotEmpty(inventoryDtoList)) {
            this.iThreeInventoryService.batchDeleteThreeInventory(inventoryDtoList, source);
            this.iThreeInventoryService.saveThreeInventory(inventoryDtoList);
        }
    }

    public void getU9InventorySnapshotListByLogicWarehouse(DgLogicWarehouseDto logicWarehouseDto, DgPhysicsWarehouseDto csPhysicsWarehouseRespDto, InventoryReqDto reqDto) {
        ThreeInventoryDto dto = new ThreeInventoryDto();
        dto.setBizDate(reqDto.getBizDate());
        dto.setPhysicsWarehouseCode(logicWarehouseDto.getPhysicsWarehouseCode());
        dto.setLogicWarehouseCode(logicWarehouseDto.getWarehouseCode());
        dto.setSource(InventoryReconciliationSourceEnum.U9.getCode());
        this.iThreeInventoryService.deleteThreeInventory(dto);
        U9InventorySnapshotReqDto u9InventorySnapshotReqDto = new U9InventorySnapshotReqDto();
        u9InventorySnapshotReqDto.setSnapshotDate(reqDto.getBizDate());
        u9InventorySnapshotReqDto.setLogicWarehouseCode(logicWarehouseDto.getWarehouseCode());
        try {
            log.info("\u5f00\u59cb\u62c9\u53d6 U9\u5e93\u5b58\u6570\u636e\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)u9InventorySnapshotReqDto));
            List u9InventorySnapshotRespDtos = (List)this.u9InventoryApi.queryU9InventorySnapshot(u9InventorySnapshotReqDto).getData();
            log.info("\u62c9\u53d6U9\u5e93\u5b58\u6570\u636e\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)u9InventorySnapshotRespDtos));
            if (CollectionUtils.isEmpty((Collection)u9InventorySnapshotRespDtos)) {
                log.info("\u62c9\u53d6u9\u5e93\u5b58\u5feb\u7167\u4e3a\u7a7a,warehouseCode:{},snapshotDate:{}", (Object)logicWarehouseDto.getWarehouseCode(), (Object)reqDto.getBizDate());
                return;
            }
            List<DgInventoryRespDto> dgInventoryRespDtos = this.setU9InventoryFlowData(u9InventorySnapshotRespDtos, logicWarehouseDto, reqDto);
            this.saveThreeInventoryData(dgInventoryRespDtos, InventoryReconciliationSourceEnum.U9.getCode());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6U9\u5e93\u5b58\u5feb\u7167\u5217\u8868\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private List<DgInventoryRespDto> getU9InventorySnapshotList(List<DgLogicWarehouseDto> logicWarehouseDtos, InventoryReqDto reqDto) {
        LinkedList inventoryRespDtoList = Lists.newLinkedList();
        logicWarehouseDtos.forEach(v -> {
            ThreeInventoryDto dto = new ThreeInventoryDto();
            dto.setBizDate(reqDto.getBizDate());
            dto.setPhysicsWarehouseCode(v.getPhysicsWarehouseCode());
            dto.setLogicWarehouseCode(v.getWarehouseCode());
            dto.setSource(InventoryReconciliationSourceEnum.U9.getCode());
            this.iThreeInventoryService.deleteThreeInventory(dto);
            U9InventorySnapshotReqDto u9InventorySnapshotReqDto = new U9InventorySnapshotReqDto();
            u9InventorySnapshotReqDto.setSnapshotDate(reqDto.getBizDate());
            u9InventorySnapshotReqDto.setLogicWarehouseCode(v.getWarehouseCode());
            try {
                log.info("\u5f00\u59cb\u62c9\u53d6 U9\u5e93\u5b58\u6570\u636e\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)u9InventorySnapshotReqDto));
                List u9InventorySnapshotRespDtos = (List)this.u9InventoryApi.queryU9InventorySnapshot(u9InventorySnapshotReqDto).getData();
                log.info("\u62c9\u53d6U9\u5e93\u5b58\u6570\u636e\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)u9InventorySnapshotRespDtos));
                if (CollectionUtils.isEmpty((Collection)u9InventorySnapshotRespDtos)) {
                    log.info("\u62c9\u53d6u9\u5e93\u5b58\u5feb\u7167\u4e3a\u7a7a,warehouseCode:{},snapshotDate:{}", (Object)v.getWarehouseCode(), (Object)reqDto.getBizDate());
                    return;
                }
                List<DgInventoryRespDto> dgInventoryRespDtos = this.setU9InventoryFlowData(u9InventorySnapshotRespDtos, (DgLogicWarehouseDto)v, reqDto);
                this.saveThreeInventoryData(dgInventoryRespDtos, InventoryReconciliationSourceEnum.U9.getCode());
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6U9\u5e93\u5b58\u5feb\u7167\u5217\u8868\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
            }
        });
        return inventoryRespDtoList;
    }

    private List<DgInventoryRespDto> setU9InventoryFlowData(List<U9InventorySnapshotRespDto> u9InventorySnapshotRespDtos, DgLogicWarehouseDto logicWarehouseDto, InventoryReqDto reqDto) {
        ArrayList<DgInventoryRespDto> respDtoList = new ArrayList<DgInventoryRespDto>();
        if (CollectionUtils.isNotEmpty(u9InventorySnapshotRespDtos)) {
            List<String> skuCodes = u9InventorySnapshotRespDtos.stream().map(U9InventorySnapshotRespDto::getItemCode).distinct().collect(Collectors.toList());
            List<ItemSkuExtEo> itemSkuDgEoList = this.getItemSkuDgEo(skuCodes);
            Map<Object, Object> itemSkuDgEoMap = Maps.newHashMap();
            Map<Object, Object> itemDgEoMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(itemSkuDgEoList)) {
                List<Long> itemIds = itemSkuDgEoList.stream().map(ItemSkuExtEo::getItemId).distinct().collect(Collectors.toList());
                itemSkuDgEoMap = itemSkuDgEoList.stream().collect(Collectors.toMap(ItemSkuExtEo::getCode, Function.identity(), (k1, k2) -> k1));
                List<ItemExtEo> itemDgEos = this.getItemDgEo(itemIds);
                itemDgEoMap = itemDgEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
            }
            for (U9InventorySnapshotRespDto shotRespDto : u9InventorySnapshotRespDtos) {
                DgInventoryRespDto respDto = new DgInventoryRespDto();
                respDto.setBizDate(reqDto.getBizDate());
                respDto.setPhysicsWarehouseCode(logicWarehouseDto.getPhysicsWarehouseCode());
                respDto.setPhysicsWarehouseName(logicWarehouseDto.getPhysicsWarehouseName());
                respDto.setLogicWarehouseCode(logicWarehouseDto.getWarehouseCode());
                respDto.setLogicWarehouseName(logicWarehouseDto.getWarehouseName());
                respDto.setOrganizationCode(logicWarehouseDto.getOrganizationCode());
                respDto.setOrganizationName(logicWarehouseDto.getOrganizationName());
                respDto.setSkuCode(shotRespDto.getItemCode());
                respDto.setSkuName(shotRespDto.getItemName());
                respDto.setStatus("qualified");
                if (itemSkuDgEoMap.containsKey(shotRespDto.getItemCode())) {
                    ItemSkuExtEo ItemSkuExtEo2 = (ItemSkuExtEo)itemSkuDgEoMap.get(shotRespDto.getItemCode());
                    respDto.setSkuName(Objects.nonNull(ItemSkuExtEo2) ? ItemSkuExtEo2.getName() : null);
                    respDto.setUnit(Objects.nonNull(ItemSkuExtEo2) ? ItemSkuExtEo2.getUnit() : null);
                    if (Objects.nonNull(ItemSkuExtEo2) && itemDgEoMap.containsKey(ItemSkuExtEo2.getItemId())) {
                        ItemExtEo ItemExtEo2 = (ItemExtEo)itemDgEoMap.get(ItemSkuExtEo2.getItemId());
                        respDto.setSpuCode(Objects.nonNull(ItemExtEo2) ? ItemExtEo2.getCode() : null);
                        respDto.setSpuName(Objects.nonNull(ItemExtEo2) ? ItemExtEo2.getName() : null);
                    }
                }
                respDto.setInventoryNum(null != shotRespDto.getStoreQty() ? Convert.toStr((Object)shotRespDto.getStoreQty()) : null);
                respDtoList.add(respDto);
            }
        }
        return respDtoList;
    }

    private InventoryQueryRequest setWmsFlowReqData(InventoryReqDto reqDto, List<DgLogicInventoryDto> logicInventoryEoList, Map<String, ThirdWarehouseDto> thirdWarehouseMap, DgPhysicsWarehouseDto csPhysicsWarehouseRespDto) {
        if (StringUtils.isEmpty((String)reqDto.getWarehouseCode())) {
            return null;
        }
        InventoryQueryRequest request = new InventoryQueryRequest();
        ArrayList<InventoryQueryRequest.Criteria> criteriaList = new ArrayList<InventoryQueryRequest.Criteria>();
        if (CollectionUtils.isNotEmpty(logicInventoryEoList)) {
            for (DgLogicInventoryDto logicInventoryEo : logicInventoryEoList) {
                InventoryQueryRequest.Criteria criteria = new InventoryQueryRequest.Criteria();
                if (null != thirdWarehouseMap.get(reqDto.getWarehouseCode())) {
                    criteria.setOwnerCode(thirdWarehouseMap.get(reqDto.getWarehouseCode()).getOwnerCode());
                }
                criteria.setItemCode(logicInventoryEo.getSkuCode());
                if (null != csPhysicsWarehouseRespDto) {
                    criteria.setWarehouseCode(csPhysicsWarehouseRespDto.getThirdCode());
                }
                criteriaList.add(criteria);
            }
        }
        if (null != thirdWarehouseMap.get(reqDto.getWarehouseCode())) {
            request.setCustomerId(thirdWarehouseMap.get(reqDto.getWarehouseCode()).getCustomerId());
        }
        request.setCriteriaList(criteriaList);
        return request;
    }

    private InventoryQueryRequest setWmsFlowReqDataNew(InventoryReqDto reqDto, List<LogicInventorySnapshotDto> logicInventoryEoList, Map<String, ThirdWarehouseDto> thirdWarehouseMap, DgPhysicsWarehouseDto csPhysicsWarehouseRespDto) {
        if (StringUtils.isEmpty((String)reqDto.getWarehouseCode())) {
            return null;
        }
        InventoryQueryRequest request = new InventoryQueryRequest();
        ArrayList criteriaList = new ArrayList();
        List<String> skuCodes = logicInventoryEoList.stream().map(LogicInventorySnapshotDto::getSkuCode).distinct().collect(Collectors.toList());
        skuCodes.forEach(v -> {
            InventoryQueryRequest.Criteria criteria = new InventoryQueryRequest.Criteria();
            if (null != thirdWarehouseMap.get(reqDto.getWarehouseCode())) {
                criteria.setOwnerCode(((ThirdWarehouseDto)thirdWarehouseMap.get(reqDto.getWarehouseCode())).getOwnerCode());
            }
            criteria.setItemCode(v);
            if (null != csPhysicsWarehouseRespDto) {
                criteria.setWarehouseCode(csPhysicsWarehouseRespDto.getThirdCode());
            }
            criteriaList.add(criteria);
        });
        if (null != thirdWarehouseMap.get(reqDto.getWarehouseCode())) {
            request.setCustomerId(thirdWarehouseMap.get(reqDto.getWarehouseCode()).getCustomerId());
        }
        request.setCriteriaList(criteriaList);
        return request;
    }

    private List<DgInventoryRespDto> setWmsInventoryFlowData(List<InventoryQueryResponse.Item> itemList, InventoryReqDto reqDto, DgPhysicsWarehouseDto physicsWarehouseRespDto, DgLogicWarehouseDto logicWarehouseDto) {
        ArrayList<DgInventoryRespDto> respDtoList = new ArrayList<DgInventoryRespDto>();
        if (CollectionUtils.isNotEmpty(itemList)) {
            List<String> skuCodes = itemList.stream().map(InventoryQueryResponse.Item::getItemCode).distinct().collect(Collectors.toList());
            List<ItemSkuExtEo> itemSkuDgEoList = this.getItemSkuDgEo(skuCodes);
            Map<Object, Object> itemSkuDgEoMap = Maps.newHashMap();
            Map<Object, Object> itemDgEoMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(itemSkuDgEoList)) {
                List<Long> itemIds = itemSkuDgEoList.stream().map(ItemSkuExtEo::getItemId).distinct().collect(Collectors.toList());
                itemSkuDgEoMap = itemSkuDgEoList.stream().collect(Collectors.toMap(ItemSkuExtEo::getCode, Function.identity(), (k1, k2) -> k1));
                List<ItemExtEo> itemDgEos = this.getItemDgEo(itemIds);
                itemDgEoMap = itemDgEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
            }
            for (InventoryQueryResponse.Item item : itemList) {
                CsLogicWarehouseQualityEnum logicWarehouseQualityEnum;
                if (!CsLogicWarehouseQualityEnum.QUALIFIED.getWmsCode().equals(item.getInventoryType()) && !CsLogicWarehouseQualityEnum.UN_QUALIFIED.getWmsCode().equals(item.getInventoryType()) && !CsLogicWarehouseQualityEnum.WAIT_INSPECTION.getWmsCode().equals(item.getInventoryType()) && !CsLogicWarehouseQualityEnum.FREEZE.getWmsCode().equals(item.getInventoryType())) continue;
                DgInventoryRespDto respDto = new DgInventoryRespDto();
                respDto.setBizDate(reqDto.getBizDate());
                if (null != physicsWarehouseRespDto) {
                    respDto.setPhysicsWarehouseCode(physicsWarehouseRespDto.getWarehouseCode());
                    respDto.setPhysicsWarehouseName(physicsWarehouseRespDto.getWarehouseName());
                }
                if (null != logicWarehouseDto) {
                    respDto.setLogicWarehouseCode(logicWarehouseDto.getWarehouseCode());
                    respDto.setLogicWarehouseName(logicWarehouseDto.getWarehouseName());
                    respDto.setOrganizationCode(logicWarehouseDto.getOrganizationCode());
                    respDto.setOrganizationName(logicWarehouseDto.getOrganizationName());
                }
                respDto.setSkuCode(item.getItemCode());
                if (itemSkuDgEoMap.containsKey(item.getItemCode())) {
                    ItemSkuExtEo ItemSkuExtEo2 = (ItemSkuExtEo)itemSkuDgEoMap.get(item.getItemCode());
                    respDto.setSkuName(Objects.nonNull(ItemSkuExtEo2) ? ItemSkuExtEo2.getName() : null);
                    respDto.setUnit(Objects.nonNull(ItemSkuExtEo2) ? ItemSkuExtEo2.getUnit() : null);
                    if (Objects.nonNull(ItemSkuExtEo2) && itemDgEoMap.containsKey(ItemSkuExtEo2.getItemId())) {
                        ItemExtEo ItemExtEo2 = (ItemExtEo)itemDgEoMap.get(ItemSkuExtEo2.getItemId());
                        respDto.setSpuCode(Objects.nonNull(ItemExtEo2) ? ItemExtEo2.getCode() : null);
                        respDto.setSpuName(Objects.nonNull(ItemExtEo2) ? ItemExtEo2.getName() : null);
                    }
                }
                respDto.setStatus(null != (logicWarehouseQualityEnum = CsLogicWarehouseQualityEnum.getByWmsCode((String)item.getInventoryType())) ? logicWarehouseQualityEnum.getCode() : "");
                respDto.setBatchNo(item.getBatchCode());
                respDto.setInventoryNum(null != item.getQuantity() ? item.getQuantity().toString() : "");
                respDtoList.add(respDto);
            }
        }
        return respDtoList;
    }

    private List<ThreeInventoryEo> normalData(List<ThreeInventoryEo> omsInventoryList, List<FiltrationDispositionEo> filtrationDispositionEoList, List<String> inventoryProperties) {
        if (CollectionUtils.isEmpty(omsInventoryList)) {
            return null;
        }
        if (CollectionUtils.isEmpty(filtrationDispositionEoList)) {
            return omsInventoryList;
        }
        List<ThreeInventoryEo> newOmsInventoryList = omsInventoryList.stream().filter(inventory -> filtrationDispositionEoList.stream().map(FiltrationDispositionEo::getEncodeNo).collect(Collectors.joining()).contains(inventory.getLogicWarehouseCode())).filter(status -> inventoryProperties.contains(status.getStatus())).collect(Collectors.toList());
        return newOmsInventoryList;
    }

    private List<String> groupFieldsList(DispositionDataDto isBatchDto, DispositionDataDto isStatusDto, DispositionDataDto isCollectDto) {
        ArrayList<String> fieldsList = new ArrayList<String>();
        fieldsList.add("bizDate");
        fieldsList.add("organizationCode");
        fieldsList.add("physicsWarehouseCode");
        fieldsList.add("skuCode");
        if (null != isBatchDto && isBatchDto.getStatus().booleanValue()) {
            fieldsList.add("batchNo");
        }
        if (null != isStatusDto && isStatusDto.getStatus().booleanValue()) {
            fieldsList.add("status");
        }
        if (null != isCollectDto && !isCollectDto.getStatus().booleanValue()) {
            fieldsList.add("logicWarehouseCode");
        }
        return fieldsList;
    }

    private InventoryDiscrepancyDto setDetailData(String source, List<ThreeInventoryEo> inventoryEoList, List<ThreeInventoryEo> targetInventoryEoList, Integer tag, DateTypeEnum dateTypeEnum) {
        BigDecimal inventoryNum = BigDecimal.ZERO;
        ThreeInventoryEo inventoryEo = new ThreeInventoryEo();
        if (CollectionUtils.isNotEmpty(inventoryEoList)) {
            inventoryNum = inventoryEoList.stream().filter(i -> null != i.getInventoryNum()).map(ThreeInventoryEo::getInventoryNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            inventoryEo = inventoryEoList.get(0);
        }
        BigDecimal threeInventoryNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(targetInventoryEoList)) {
            threeInventoryNum = targetInventoryEoList.stream().filter(i -> null != i.getInventoryNum()).map(ThreeInventoryEo::getInventoryNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (null != inventoryEo && null != inventoryEo.getId()) {
                inventoryEo = targetInventoryEoList.get(0);
            }
        }
        InventoryDiscrepancyDto discrepancyEo = new InventoryDiscrepancyDto();
        if (null != inventoryEo && null != inventoryEo.getId()) {
            BeanUtils.copyProperties((Object)inventoryEo, (Object)discrepancyEo);
        }
        discrepancyEo.setId(null);
        List logicWarehouseCodeList = inventoryEoList.stream().filter(l -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)l.getLogicWarehouseCode())).map(ThreeInventoryEo::getLogicWarehouseCode).collect(Collectors.toList());
        List logicWarehouseNameList = inventoryEoList.stream().filter(l -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)l.getLogicWarehouseName())).map(ThreeInventoryEo::getLogicWarehouseName).collect(Collectors.toList());
        discrepancyEo.setSource(source);
        discrepancyEo.setLogicWarehouseCode(String.join((CharSequence)",", new HashSet(logicWarehouseCodeList)));
        discrepancyEo.setLogicWarehouseName(String.join((CharSequence)",", new HashSet(logicWarehouseNameList)));
        if (null != tag && 1 == tag) {
            discrepancyEo.setInventoryNum(threeInventoryNum);
            discrepancyEo.setThreeInventoryNum(inventoryNum);
            threeInventoryNum = discrepancyEo.getThreeInventoryNum();
            inventoryNum = discrepancyEo.getInventoryNum();
        } else {
            discrepancyEo.setInventoryNum(inventoryNum);
            discrepancyEo.setThreeInventoryNum(threeInventoryNum);
        }
        discrepancyEo.setDifferenceNum(inventoryNum.subtract(threeInventoryNum));
        log.info("source:{} logicWarehouseCode:{} skuCode:{} status:{} batchNo:{} \u5bf9\u8d26\u7ed3\u679c differenceNum = {}", new Object[]{source, discrepancyEo.getLogicWarehouseCode(), discrepancyEo.getSkuCode(), discrepancyEo.getStatus(), discrepancyEo.getBatchNo(), discrepancyEo.getDifferenceNum()});
        String result = "";
        if (inventoryNum.compareTo(threeInventoryNum) == 0) {
            result = ReconiliationDifferenceResultEnum.CONSISTENT.getCode().toString();
        } else if (inventoryNum.compareTo(threeInventoryNum) != 0) {
            result = ReconiliationDifferenceResultEnum.INCONSISTENT.getCode().toString();
        }
        String differenceReason = null;
        if (CollectionUtils.isEmpty(inventoryEoList) || CollectionUtils.isEmpty(targetInventoryEoList)) {
            if (null != tag && 1 == tag) {
                if (CollectionUtils.isEmpty(inventoryEoList) && CollectionUtils.isNotEmpty(targetInventoryEoList)) {
                    differenceReason = Objects.requireNonNull(ReconiliationDifferenceResultEnum.getCodeByDesc((String)(source + ReconciliationResultEnum.DATA_NULL.getDesc()))).toString();
                } else if (CollectionUtils.isNotEmpty(inventoryEoList) && CollectionUtils.isEmpty(targetInventoryEoList)) {
                    differenceReason = Objects.requireNonNull(ReconiliationDifferenceResultEnum.getCodeByDesc((String)(InventoryReconciliationSourceEnum.HYX.getCode() + ReconciliationResultEnum.DATA_NULL.getDesc()))).toString();
                }
            } else if (CollectionUtils.isEmpty(inventoryEoList) && CollectionUtils.isNotEmpty(targetInventoryEoList)) {
                differenceReason = Objects.requireNonNull(ReconiliationDifferenceResultEnum.getCodeByDesc((String)(InventoryReconciliationSourceEnum.HYX.getCode() + ReconciliationResultEnum.DATA_NULL.getDesc()))).toString();
            } else if (CollectionUtils.isNotEmpty(inventoryEoList) && CollectionUtils.isEmpty(targetInventoryEoList)) {
                differenceReason = Objects.requireNonNull(ReconiliationDifferenceResultEnum.getCodeByDesc((String)(source + ReconciliationResultEnum.DATA_NULL.getDesc()))).toString();
            }
        }
        if (ReconiliationDifferenceResultEnum.INCONSISTENT.getCode().toString().equals(result) && StringUtils.isEmpty(differenceReason)) {
            differenceReason = ReconiliationDifferenceResultEnum.INVENTORY_INCONSISTENCY.getCode().toString();
        }
        discrepancyEo.setResult(result);
        discrepancyEo.setDifferenceReason(differenceReason);
        discrepancyEo.setDateType(dateTypeEnum.getCode());
        return discrepancyEo;
    }

    private List<InventoryDiscrepancyCollectDto> setSaveData(List<InventoryDiscrepancyDto> inventoryDiscrepancyEoList) {
        ArrayList<InventoryDiscrepancyCollectDto> collectDtoList = new ArrayList<InventoryDiscrepancyCollectDto>();
        if (CollectionUtils.isNotEmpty(inventoryDiscrepancyEoList)) {
            for (InventoryDiscrepancyDto discrepancyDto : inventoryDiscrepancyEoList) {
                InventoryDiscrepancyCollectDto discrepancyCollectDto = new InventoryDiscrepancyCollectDto();
                BeanUtils.copyProperties((Object)discrepancyDto, (Object)discrepancyCollectDto);
                discrepancyCollectDto.setId(null);
                discrepancyCollectDto.setInventoryResult(JSONObject.toJSONString(this.setInventoryResult(discrepancyDto, null)));
                discrepancyCollectDto.setDifferenceResult(JSONObject.toJSONString(this.setResultDifferenceResult(discrepancyDto, null)));
                discrepancyCollectDto.setCheckResult(discrepancyDto.getResult());
                discrepancyCollectDto.setCreateTime(new Date());
                discrepancyCollectDto.setUpdateTime(new Date());
                discrepancyCollectDto.setDr(Integer.valueOf(0));
                collectDtoList.add(discrepancyCollectDto);
            }
        }
        return collectDtoList;
    }

    private List<InventoryDataDto> setInventoryResult(InventoryDiscrepancyDto discrepancyDto, InventoryDiscrepancyCollectEo collectEo) {
        List<InventoryDataDto> inventoryDataDtoList = new ArrayList();
        if (null != collectEo && null != collectEo.getId()) {
            inventoryDataDtoList = JSONArray.parseArray((String)collectEo.getInventoryResult(), InventoryDataDto.class);
        } else {
            InventoryDataDto inventoryDataDto = new InventoryDataDto();
            inventoryDataDto.setCode(InventoryReconciliationSourceEnum.HYX.getCode());
            inventoryDataDto.setValue(null != discrepancyDto.getInventoryNum() ? discrepancyDto.getInventoryNum().toString() : "");
            inventoryDataDtoList.add(inventoryDataDto);
        }
        InventoryDataDto threeInventoryDataDto = new InventoryDataDto();
        threeInventoryDataDto.setCode(discrepancyDto.getSource());
        threeInventoryDataDto.setValue(null != discrepancyDto.getThreeInventoryNum() ? discrepancyDto.getThreeInventoryNum().toString() : "");
        inventoryDataDtoList.add(threeInventoryDataDto);
        return inventoryDataDtoList;
    }

    private List<InventoryDataDto> setResultDifferenceResult(InventoryDiscrepancyDto discrepancyDto, InventoryDiscrepancyCollectEo collectEo) {
        List<InventoryDataDto> inventoryDataDtoList = new ArrayList();
        if (null != collectEo && null != collectEo.getId()) {
            inventoryDataDtoList = JSONArray.parseArray((String)collectEo.getDifferenceResult(), InventoryDataDto.class);
        }
        InventoryDataDto inventoryDataDto = new InventoryDataDto();
        inventoryDataDto.setCode(discrepancyDto.getSource());
        inventoryDataDto.setValue(null != discrepancyDto.getDifferenceNum() ? discrepancyDto.getDifferenceNum().toString() : "");
        inventoryDataDtoList.add(inventoryDataDto);
        return inventoryDataDtoList;
    }

    private String discrepancyResult(InventoryDiscrepancyDto discrepancyDto, InventoryDiscrepancyCollectEo collectEo) {
        List inventoryDataDtoList = new ArrayList();
        if (null != collectEo && null != collectEo.getId()) {
            inventoryDataDtoList = JSONArray.parseArray((String)collectEo.getDifferenceResult(), InventoryDataDto.class);
        }
        String result = "";
        if (CollectionUtils.isNotEmpty(inventoryDataDtoList)) {
            if (ReconiliationDifferenceResultEnum.CONSISTENT.getCode().toString().equals(discrepancyDto.getResult())) {
                result = new BigDecimal(((InventoryDataDto)inventoryDataDtoList.get(0)).getValue()).compareTo(discrepancyDto.getDifferenceNum()) == 0 ? ReconiliationDifferenceResultEnum.CONSISTENT.getCode().toString() : ReconiliationDifferenceResultEnum.INCONSISTENT.getCode().toString();
            } else if (ReconiliationDifferenceResultEnum.INCONSISTENT.getCode().toString().equals(discrepancyDto.getResult())) {
                result = discrepancyDto.getResult();
            } else {
                String string = result = null != collectEo && StringUtils.isNotEmpty((String)collectEo.getCheckResult()) ? collectEo.getCheckResult() + "," + discrepancyDto.getResult() : discrepancyDto.getResult();
            }
        }
        if ("VMI1".equals(collectEo.getPhysicsWarehouseCode()) && (StringUtils.isEmpty((String)discrepancyDto.getBizDate()) || InventoryReconciliationSourceEnum.HYX.getCode().equals(discrepancyDto.getSource())) && CollectionUtils.isNotEmpty(inventoryDataDtoList)) {
            if (StringUtils.isEmpty((String)discrepancyDto.getBizDate())) {
                result = ReconiliationDifferenceResultEnum.CONSISTENT.getCode().toString();
            } else if (InventoryReconciliationSourceEnum.HYX.getCode().equals(discrepancyDto.getSource()) && "VMI1".equals(collectEo.getPhysicsWarehouseCode()) && "VMI1".equals(discrepancyDto.getPhysicsWarehouseCode())) {
                result = new BigDecimal(((InventoryDataDto)inventoryDataDtoList.get(0)).getValue()).compareTo(discrepancyDto.getDifferenceNum()) == 0 ? ReconiliationDifferenceResultEnum.CONSISTENT.getCode().toString() : ReconiliationDifferenceResultEnum.INCONSISTENT.getCode().toString();
            }
        }
        return result;
    }

    private List<DgInventoryRespDto> setOmsLogicInventoryData(List<LogicInventorySnapshotDto> inventoryDtoList, InventoryReqDto reqDto, DgLogicWarehouseDto logicWarehouseDto, DgPhysicsWarehouseDto csPhysicsWarehouseRespDto, DispositionDataDto isBatchDto, List<InventoryPreemptionEo> inventoryPreemptionDtos) {
        List<DgInventoryRespDto> respDtoList;
        HashMap<String, InventoryPreemptionDto> transferPreemptionMap = new HashMap<String, InventoryPreemptionDto>();
        if (null != isBatchDto && isBatchDto.getStatus().booleanValue()) {
            respDtoList = this.doSetOmsLogicInventoryData(inventoryDtoList, reqDto, logicWarehouseDto, csPhysicsWarehouseRespDto, transferPreemptionMap);
        } else {
            HashMap balanceMap = new HashMap();
            inventoryDtoList.forEach(e -> {
                String key = e.getWarehouseCode() + e.getSkuCode() + e.getInventoryProperty();
                LogicInventorySnapshotDto dto = (LogicInventorySnapshotDto)balanceMap.get(key);
                if (Objects.isNull(dto)) {
                    dto = new LogicInventorySnapshotDto();
                    CubeBeanUtils.copyProperties((Object)dto, (Object)e, (String[])new String[0]);
                    dto.setBatch(null);
                    dto.setBalance(BigDecimalUtils.check((BigDecimal)dto.getBalance()));
                } else {
                    dto.setBalance(BigDecimalUtils.add((BigDecimal)dto.getBalance(), (BigDecimal)e.getBalance()));
                }
                balanceMap.put(key, dto);
            });
            Optional.ofNullable(inventoryPreemptionDtos).ifPresent(p -> p.forEach(e -> {
                String key = e.getWarehouseCode() + e.getSkuCode() + e.getInventoryProperty();
                BigDecimal actualPreemptNum = BigDecimalUtils.subtract((BigDecimal)e.getPreemptNum(), (BigDecimal)e.getReleaseNum());
                InventoryPreemptionDto dto = (InventoryPreemptionDto)transferPreemptionMap.get(key);
                if (Objects.isNull(dto)) {
                    dto = new InventoryPreemptionDto();
                    CubeBeanUtils.copyProperties((Object)dto, (Object)e, (String[])new String[0]);
                    dto.setPreemptNum(actualPreemptNum);
                } else {
                    dto.setPreemptNum(BigDecimalUtils.add((BigDecimal)dto.getPreemptNum(), (BigDecimal)actualPreemptNum));
                }
                transferPreemptionMap.put(key, dto);
            }));
            respDtoList = this.doSetOmsLogicInventoryData(Lists.newArrayList(balanceMap.values()), reqDto, logicWarehouseDto, csPhysicsWarehouseRespDto, transferPreemptionMap);
        }
        return respDtoList;
    }

    private List<DgInventoryRespDto> doSetOmsLogicInventoryData(List<LogicInventorySnapshotDto> inventoryDtoList, InventoryReqDto reqDto, DgLogicWarehouseDto logicWarehouseDto, DgPhysicsWarehouseDto csPhysicsWarehouseRespDto, Map<String, InventoryPreemptionDto> transferPreemptionMap) {
        ArrayList<DgInventoryRespDto> respDtoList = new ArrayList<DgInventoryRespDto>();
        inventoryDtoList.forEach(inventoryDto -> {
            DgInventoryRespDto respDto = new DgInventoryRespDto();
            respDto.setBizDate(reqDto.getBizDate());
            if (Objects.nonNull(csPhysicsWarehouseRespDto)) {
                respDto.setPhysicsWarehouseCode(csPhysicsWarehouseRespDto.getWarehouseCode());
                respDto.setPhysicsWarehouseName(csPhysicsWarehouseRespDto.getWarehouseName());
            }
            if (Objects.nonNull(logicWarehouseDto)) {
                respDto.setLogicWarehouseCode(logicWarehouseDto.getWarehouseCode());
                respDto.setLogicWarehouseName(logicWarehouseDto.getWarehouseName());
            }
            respDto.setOrganizationCode(inventoryDto.getOrganizationCode());
            respDto.setOrganizationName(inventoryDto.getOrganizationName());
            respDto.setSkuCode(inventoryDto.getSkuCode());
            respDto.setSkuName(inventoryDto.getSkuName());
            respDto.setSpuCode(inventoryDto.getSpuCode());
            respDto.setSpuName(inventoryDto.getSpuName());
            respDto.setStatus(inventoryDto.getInventoryProperty());
            respDto.setBatchNo(inventoryDto.getBatch());
            respDto.setInventoryNum(null != inventoryDto.getBalance() ? inventoryDto.getBalance().stripTrailingZeros().toString() : null);
            String key = inventoryDto.getWarehouseCode() + inventoryDto.getSkuCode() + inventoryDto.getInventoryProperty();
            InventoryPreemptionDto preemptionDto = (InventoryPreemptionDto)transferPreemptionMap.get(key);
            if (Objects.nonNull(preemptionDto)) {
                respDto.setTransferPreemptNum(preemptionDto.getPreemptNum().stripTrailingZeros().toString());
            }
            respDto.setUnit(inventoryDto.getUnit());
            respDtoList.add(respDto);
        });
        return respDtoList;
    }

    private List<DgInventoryRespDto> setOmsInventoryData(List<DgLogicInventoryDto> inventoryDtoList, InventoryReqDto reqDto) {
        ArrayList<DgInventoryRespDto> respDtoList = new ArrayList<DgInventoryRespDto>();
        if (CollectionUtils.isNotEmpty(inventoryDtoList)) {
            for (DgLogicInventoryDto inventoryDto : inventoryDtoList) {
                DgInventoryRespDto respDto = new DgInventoryRespDto();
                if (StringUtils.isNotEmpty((String)reqDto.getBizDate())) {
                    respDto.setBizDate(reqDto.getBizDate());
                }
                respDto.setPhysicsWarehouseCode(inventoryDto.getPhysicsWarehouseCode());
                respDto.setPhysicsWarehouseName(inventoryDto.getPhysicsWarehouseName());
                respDto.setOrganizationCode(inventoryDto.getOrganizationCode());
                respDto.setOrganizationName(inventoryDto.getOrganizationName());
                respDto.setLogicWarehouseCode(inventoryDto.getWarehouseCode());
                respDto.setLogicWarehouseName(inventoryDto.getWarehouseName());
                respDto.setSkuCode(inventoryDto.getSkuCode());
                respDto.setSkuName(inventoryDto.getSkuName());
                respDto.setSkuAbbreviation(inventoryDto.getSkuDisplayName());
                respDto.setSpuCode(inventoryDto.getSpuCode());
                respDto.setSpuName(inventoryDto.getSpuName());
                respDto.setStatus(inventoryDto.getInventoryProperty());
                respDto.setBatchNo(inventoryDto.getBatch());
                respDto.setInventoryNum(null != inventoryDto.getBalance() ? inventoryDto.getBalance().stripTrailingZeros().toString() : null);
                respDto.setUnit(inventoryDto.getUnit());
                respDtoList.add(respDto);
            }
        }
        return respDtoList;
    }

    private List<DgInventoryRespDto> setWmsInventoryData(List<InventoryQueryResponse.Item> itemList, InventoryReqDto reqDto, Map<String, CsPhysicsWarehouseRespDto> physicsWarehouseMap) {
        ArrayList<DgInventoryRespDto> respDtoList = new ArrayList<DgInventoryRespDto>();
        if (CollectionUtils.isNotEmpty(itemList)) {
            for (InventoryQueryResponse.Item item : itemList) {
                if (!CsLogicWarehouseQualityEnum.QUALIFIED.getWmsCode().equals(item.getInventoryType()) && !CsLogicWarehouseQualityEnum.UN_QUALIFIED.getWmsCode().equals(item.getInventoryType()) && !CsLogicWarehouseQualityEnum.WAIT_INSPECTION.getWmsCode().equals(item.getInventoryType()) && !CsLogicWarehouseQualityEnum.FREEZE.getWmsCode().equals(item.getInventoryType())) continue;
                DgInventoryRespDto respDto = new DgInventoryRespDto();
                respDto.setBizDate(reqDto.getBizDate());
                if (null != physicsWarehouseMap.get(reqDto.getWarehouseCode())) {
                    CsPhysicsWarehouseRespDto warehouseRespDto = physicsWarehouseMap.get(reqDto.getWarehouseCode());
                    respDto.setPhysicsWarehouseCode(warehouseRespDto.getWarehouseCode());
                    respDto.setPhysicsWarehouseName(warehouseRespDto.getWarehouseName());
                }
                respDto.setSkuCode(item.getItemCode());
                respDto.setSpuCode(item.getItemCode());
                respDto.setOrganizationCode("100");
                CsLogicWarehouseQualityEnum logicWarehouseQualityEnum = CsLogicWarehouseQualityEnum.getByWmsCode((String)item.getInventoryType());
                respDto.setStatus(null != logicWarehouseQualityEnum ? logicWarehouseQualityEnum.getCode() : "");
                respDto.setBatchNo(item.getBatchCode());
                respDto.setInventoryNum(null != item.getQuantity() ? item.getQuantity().toString() : "");
                respDtoList.add(respDto);
            }
        }
        return respDtoList;
    }

    private List<DgInventoryRespDto> setU9InventoryData(List<InventorySnapShotRespDto> snapShotRespDtoList, Map<String, DgLogicWarehouseDto> logicWarehouseDtoMap, InventoryReqDto reqDto) {
        ArrayList<DgInventoryRespDto> respDtoList = new ArrayList<DgInventoryRespDto>();
        if (CollectionUtils.isNotEmpty(snapShotRespDtoList)) {
            for (InventorySnapShotRespDto shotRespDto : snapShotRespDtoList) {
                if (!"KCZT01_SYS".equals(shotRespDto.getType()) && !"KCZT05_SYS".equals(shotRespDto.getType()) && !"KCZT002".equals(shotRespDto.getType())) continue;
                DgInventoryRespDto respDto = new DgInventoryRespDto();
                respDto.setBizDate(reqDto.getBizDate());
                respDto.setType(shotRespDto.getType());
                respDto.setOrganizationCode(shotRespDto.getOrganizationCode());
                respDto.setOrganizationName(shotRespDto.getOrganizationName());
                respDto.setLogicWarehouseCode(shotRespDto.getLogicWarehouseCode());
                if (StringUtils.isNotEmpty((String)shotRespDto.getLogicWarehouseCode()) && null != logicWarehouseDtoMap.get(shotRespDto.getLogicWarehouseCode())) {
                    DgLogicWarehouseDto logicWarehouseDto = logicWarehouseDtoMap.get(shotRespDto.getLogicWarehouseCode());
                    respDto.setPhysicsWarehouseCode(logicWarehouseDto.getPhysicsWarehouseCode());
                    respDto.setPhysicsWarehouseName(logicWarehouseDto.getPhysicsWarehouseName());
                    respDto.setLogicWarehouseName(logicWarehouseDto.getWarehouseName());
                }
                respDto.setSkuCode(shotRespDto.getSkuCode());
                respDto.setSkuName(shotRespDto.getSkuName());
                respDto.setSpuCode(shotRespDto.getSkuCode());
                respDto.setSpuName(shotRespDto.getSkuName());
                respDto.setStatus(CsLogicWarehouseQualityEnum.QUALIFIED.getCode());
                respDto.setInventoryNum(null != shotRespDto.getThreeInventoryNum() ? Convert.toStr((Object)shotRespDto.getThreeInventoryNum()) : null);
                respDto.setUnit(shotRespDto.getUnit());
                respDtoList.add(respDto);
            }
        }
        return respDtoList;
    }

    private InventoryQueryRequest setWmsReqData(InventoryReqDto reqDto, List<DgLogicInventoryDto> logicInventoryEoList, Map<String, ThirdWarehouseRespDto> thirdWarehouseMap, Map<String, CsPhysicsWarehouseRespDto> physicsWarehouseMap) {
        if (StringUtils.isEmpty((String)reqDto.getWarehouseCode())) {
            return null;
        }
        InventoryQueryRequest request = new InventoryQueryRequest();
        ArrayList<InventoryQueryRequest.Criteria> criteriaList = new ArrayList<InventoryQueryRequest.Criteria>();
        if (CollectionUtils.isNotEmpty(logicInventoryEoList)) {
            for (DgLogicInventoryDto logicInventoryEo : logicInventoryEoList) {
                InventoryQueryRequest.Criteria criteria = new InventoryQueryRequest.Criteria();
                if (null != thirdWarehouseMap.get(reqDto.getWarehouseCode())) {
                    criteria.setOwnerCode(thirdWarehouseMap.get(reqDto.getWarehouseCode()).getCustomerId());
                }
                criteria.setItemCode(logicInventoryEo.getSkuCode());
                if (null != physicsWarehouseMap.get(reqDto.getWarehouseCode())) {
                    criteria.setWarehouseCode(physicsWarehouseMap.get(reqDto.getWarehouseCode()).getThirdCode());
                }
                criteriaList.add(criteria);
            }
        }
        if (null != thirdWarehouseMap.get(reqDto.getWarehouseCode())) {
            request.setCustomerId(thirdWarehouseMap.get(reqDto.getWarehouseCode()).getCustomerId());
        }
        request.setCriteriaList(criteriaList);
        return request;
    }

    private List<ItemSkuExtEo> getItemSkuDgEo(List<String> skuCodes) {
        ArrayList itemSkuDgEos = Lists.newArrayList();
        try {
            List itemSkuDgEoList;
            int length;
            int i = 0;
            for (length = skuCodes.size(); length > 500; length -= 500) {
                itemSkuDgEoList = ((ExtQueryChainWrapper)this.itemSkuExtDomain.filter().in((Object)"code", skuCodes.subList(i, i + 500))).list();
                itemSkuDgEos.addAll(itemSkuDgEoList);
                i += 500;
            }
            if (length > 0) {
                itemSkuDgEoList = ((ExtQueryChainWrapper)this.itemSkuExtDomain.filter().in((Object)"code", skuCodes.subList(i, i + length))).list();
                itemSkuDgEos.addAll(itemSkuDgEoList);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5546\u54c1\u5931\u8d25:{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        return itemSkuDgEos;
    }

    private List<ItemExtEo> getItemDgEo(List<Long> itemIds) {
        ArrayList itemDgEos = Lists.newArrayList();
        try {
            List itemDgEoList;
            int length;
            int i = 0;
            for (length = itemIds.size(); length > 500; length -= 500) {
                itemDgEoList = ((ExtQueryChainWrapper)this.itemExtDomain.filter().in((Object)"id", itemIds.subList(i, i + 500))).list();
                itemDgEos.addAll(itemDgEoList);
                i += 500;
            }
            if (length > 0) {
                itemDgEoList = ((ExtQueryChainWrapper)this.itemExtDomain.filter().in((Object)"id", itemIds.subList(i, i + length))).list();
                itemDgEos.addAll(itemDgEoList);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5546\u54c1\u5931\u8d25:{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        return itemDgEos;
    }
}

