/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.pulldata.domain.entity.IReconciliationDifferenceDomain;
import com.yunxi.dg.base.center.pulldata.eo.ReconciliationDifferenceEo;
import com.yunxi.dg.base.center.report.constants.ErpInventoryTypeEnum;
import com.yunxi.dg.base.center.report.domain.reconciliation.IReconciliationDifferenceLogDomain;
import com.yunxi.dg.base.center.report.dto.reconciliation.ReconciliationDifferenceDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.ReconciliationDifferencePageReqDto;
import com.yunxi.dg.base.center.report.eo.reconciliation.ReconciliationDifferenceLogEo;
import com.yunxi.dg.base.center.report.service.reconciliation.IReconciliationDifferenceExtService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;

@Service
public class ReconciliationDifferenceExtServiceImpl
implements IReconciliationDifferenceExtService {
    @Resource
    private IReconciliationDifferenceDomain domain;
    @Resource
    private IReconciliationDifferenceLogDomain reconciliationDifferenceLogDomain;
    @Resource
    private IContext context;

    @Override
    public RestResponse<PageInfo<ReconciliationDifferenceDto>> queryPage(ReconciliationDifferencePageReqDto dto) {
        ExtQueryChainWrapper differenceEoLambdaQueryWrapper = (ExtQueryChainWrapper)this.domain.filter().orderByDesc((Object)"create_time");
        if (ObjectUtils.isNotEmpty((Object)dto.getSource())) {
            differenceEoLambdaQueryWrapper.eq((Object)"source", (Object)dto.getSource());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getDocumentNoList())) {
            differenceEoLambdaQueryWrapper.and(wrapper -> ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.in((Object)"relevance_biz_no", (Collection)dto.getDocumentNoList())).or()).in((Object)"os_order_no", (Collection)dto.getDocumentNoList())).or()).in((Object)"result_order_no", (Collection)dto.getDocumentNoList()));
        }
        if (StringUtils.isNotEmpty((String)dto.getReconciliationTimeStart())) {
            differenceEoLambdaQueryWrapper.ge((Object)"reconciliation_time", (Object)dto.getReconciliationTimeStart());
        }
        if (StringUtils.isNotEmpty((String)dto.getReconciliationTimeEnd())) {
            differenceEoLambdaQueryWrapper.le((Object)"reconciliation_time", (Object)dto.getReconciliationTimeEnd());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getLogicWarehouseCodes())) {
            differenceEoLambdaQueryWrapper.in((Object)"logic_warehouse_code", (Collection)dto.getLogicWarehouseCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getPhysicalWarehouseCodes())) {
            differenceEoLambdaQueryWrapper.in((Object)"physical_warehouse_code", (Collection)dto.getPhysicalWarehouseCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getSkuCodes())) {
            differenceEoLambdaQueryWrapper.in((Object)"sku_code", (Collection)dto.getSkuCodes());
        }
        if (StringUtils.isNotEmpty((String)dto.getSkuAbbr())) {
            differenceEoLambdaQueryWrapper.like((Object)"sku_abbr", (Object)dto.getSkuAbbr());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getSpuCodes())) {
            differenceEoLambdaQueryWrapper.in((Object)"spu_code", (Collection)dto.getSpuCodes());
        }
        if (StringUtils.isNotEmpty((String)dto.getResultOrderNo())) {
            differenceEoLambdaQueryWrapper.eq((Object)"result_order_no", (Object)dto.getResultOrderNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getBizTypes())) {
            differenceEoLambdaQueryWrapper.in((Object)"biz_type", (Collection)dto.getBizTypes());
        }
        if (StringUtils.isNotEmpty((String)dto.getRelevanceBizNo())) {
            differenceEoLambdaQueryWrapper.eq((Object)"relevance_biz_no", (Object)dto.getRelevanceBizNo());
        }
        if (StringUtils.isNotEmpty((String)dto.getRelevanceBizType())) {
            differenceEoLambdaQueryWrapper.eq((Object)"relevance_biz_type", (Object)dto.getRelevanceBizType());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getZtStatusList())) {
            differenceEoLambdaQueryWrapper.in((Object)"zt_status", (Collection)dto.getZtStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getZtBatchs())) {
            differenceEoLambdaQueryWrapper.in((Object)"zt_batch", (Collection)dto.getZtBatchs());
        }
        if (StringUtils.isNotEmpty((String)dto.getZtBatch())) {
            differenceEoLambdaQueryWrapper.like((Object)"zt_batch", (Object)dto.getZtBatch());
        }
        if (StringUtils.isNotEmpty((String)dto.getBookingNo())) {
            differenceEoLambdaQueryWrapper.eq((Object)"booking_no", (Object)dto.getBookingNo());
        }
        if (StringUtils.isNotEmpty((String)dto.getBookingType())) {
            differenceEoLambdaQueryWrapper.eq((Object)"booking_type", (Object)dto.getBookingType());
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getOsOrderNo())) {
            differenceEoLambdaQueryWrapper.in((Object)"os_order_no", new Object[]{dto.getOsOrderNo()});
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getOsOrderType())) {
            differenceEoLambdaQueryWrapper.in((Object)"os_order_type", new Object[]{dto.getOsOrderType()});
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getOsWarehouseCode())) {
            differenceEoLambdaQueryWrapper.in((Object)"os_warehouse_code", new Object[]{dto.getOsWarehouseCode()});
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getOsStatusList())) {
            differenceEoLambdaQueryWrapper.in((Object)"os_status", (Collection)dto.getOsStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getBookingTypes())) {
            differenceEoLambdaQueryWrapper.in((Object)"booking_type", (Collection)dto.getBookingTypes());
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getOsBatch())) {
            differenceEoLambdaQueryWrapper.in((Object)"os_batch", new Object[]{dto.getOsBatch()});
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getResults())) {
            differenceEoLambdaQueryWrapper.in((Object)"result", (Collection)dto.getResults());
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getDifferenceReason())) {
            differenceEoLambdaQueryWrapper.eq((Object)"difference_reason", (Object)dto.getDifferenceReason());
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getMarkStatusList())) {
            differenceEoLambdaQueryWrapper.in((Object)"mark_status", (Collection)dto.getMarkStatusList());
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getMarkStatus())) {
            differenceEoLambdaQueryWrapper.eq((Object)"mark_status", (Object)dto.getMarkStatus());
        }
        if (StringUtils.isNotEmpty((String)dto.getMarkRemark())) {
            differenceEoLambdaQueryWrapper.eq((Object)"mark_remark", (Object)dto.getMarkRemark());
        }
        if (StringUtils.isNotEmpty((String)dto.getUpdatePerson())) {
            differenceEoLambdaQueryWrapper.eq((Object)"updatePerson", (Object)dto.getUpdatePerson());
        }
        if (StringUtils.isNotEmpty((String)dto.getUpdateTimeStart())) {
            differenceEoLambdaQueryWrapper.gt((Object)"update_time", (Object)dto.getUpdateTimeStart());
        }
        if (StringUtils.isNotEmpty((String)dto.getUpdateTimeEnd())) {
            differenceEoLambdaQueryWrapper.lt((Object)"update_time", (Object)dto.getUpdateTimeEnd());
        }
        if (StringUtils.isNotEmpty((String)dto.getRemark())) {
            differenceEoLambdaQueryWrapper.like((Object)"remark", (Object)dto.getRemark());
        }
        differenceEoLambdaQueryWrapper.eq((Object)"dr", (Object)0);
        PageInfo pageInfo = differenceEoLambdaQueryWrapper.page(dto.getPageNum(), dto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<ReconciliationDifferenceDto> dtoList = new ArrayList<ReconciliationDifferenceDto>();
        ReconciliationDifferenceDto differenceDto = null;
        for (ReconciliationDifferenceEo reconciliationDifferenceEo : pageInfo.getList()) {
            differenceDto = new ReconciliationDifferenceDto();
            CubeBeanUtils.copyProperties((Object)differenceDto, (Object)reconciliationDifferenceEo, (String[])new String[0]);
            differenceDto.setResult(reconciliationDifferenceEo.getResult());
            differenceDto.setDifferenceReason(reconciliationDifferenceEo.getDifferenceReason());
            differenceDto.setOsStatus(ErpInventoryTypeEnum.getDesc((String)reconciliationDifferenceEo.getOsStatus()));
            dtoList.add(differenceDto);
        }
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public RestResponse<Integer> updateMarkStatus(ReconciliationDifferenceDto dto) {
        List ids = dto.getIds();
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)ids), (String)"\u6807\u8bb0id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)dto.getMarkStatus()), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        List eos = dto.getIds().stream().map(e -> {
            ReconciliationDifferenceEo reconciliationDifferenceEo = new ReconciliationDifferenceEo();
            reconciliationDifferenceEo.setMarkStatus(String.valueOf(dto.getMarkStatus()));
            reconciliationDifferenceEo.setResult("2");
            reconciliationDifferenceEo.setMarkRemark(dto.getMarkRemark());
            reconciliationDifferenceEo.setId(e);
            reconciliationDifferenceEo.setProcessPerson(this.context.userName());
            reconciliationDifferenceEo.setProcessTime(new Date());
            return reconciliationDifferenceEo;
        }).collect(Collectors.toList());
        int count = this.domain.getMapper().updateBatchByIds(eos);
        this.addReconciliationDifferenceLog(dto);
        return new RestResponse((Object)count);
    }

    private void addReconciliationDifferenceLog(ReconciliationDifferenceDto dto) {
        ArrayList reconciliationDifferenceLogEos = Lists.newArrayList();
        List ids = dto.getIds();
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        for (Long id : ids) {
            ReconciliationDifferenceLogEo reconciliationDifferenceLogEo = new ReconciliationDifferenceLogEo();
            reconciliationDifferenceLogEo.setReconciliationDifferenceId(id);
            reconciliationDifferenceLogEo.setRemark(dto.getMarkRemark());
            reconciliationDifferenceLogEo.setType(dto.getMarkStatus());
            reconciliationDifferenceLogEos.add(reconciliationDifferenceLogEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)reconciliationDifferenceLogEos)) {
            this.reconciliationDifferenceLogDomain.insertBatch((List)reconciliationDifferenceLogEos);
        }
    }
}

