/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.reconciliation.ThreeInventoryConverter;
import com.yunxi.dg.base.center.report.domain.reconciliation.IThreeInventoryDomain;
import com.yunxi.dg.base.center.report.dto.reconciliation.ThreeInventoryDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.ThreeInventoryReqDto;
import com.yunxi.dg.base.center.report.eo.reconciliation.ThreeInventoryEo;
import com.yunxi.dg.base.center.report.service.reconciliation.IThreeInventoryService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ThreeInventoryServiceImpl
extends BaseServiceImpl<ThreeInventoryDto, ThreeInventoryEo, IThreeInventoryDomain>
implements IThreeInventoryService {
    private static final Logger log = LoggerFactory.getLogger(ThreeInventoryServiceImpl.class);

    public ThreeInventoryServiceImpl(IThreeInventoryDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ThreeInventoryDto, ThreeInventoryEo> converter() {
        return ThreeInventoryConverter.INSTANCE;
    }

    @Override
    public RestResponse<Void> saveThreeInventory(List<ThreeInventoryDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return RestResponse.VOID;
        }
        List inventoryEoList = this.converter().toEoList(dtoList);
        ((IThreeInventoryDomain)this.domain).insertBatch(inventoryEoList);
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteThreeInventory(ThreeInventoryDto dto) {
        ThreeInventoryEo threeInventoryEo = new ThreeInventoryEo();
        CubeBeanUtils.copyProperties((Object)threeInventoryEo, (Object)dto, (String[])new String[0]);
        ((IThreeInventoryDomain)this.domain).delete((BaseEo)threeInventoryEo);
    }

    @Override
    public List<ThreeInventoryEo> selectThreeInventoryList(ThreeInventoryReqDto threeInventoryReqDto) {
        if (StringUtils.isEmpty((CharSequence)threeInventoryReqDto.getBizDate()) || StringUtils.isEmpty((CharSequence)threeInventoryReqDto.getSource())) {
            return new ArrayList<ThreeInventoryEo>();
        }
        ThreeInventoryEo inventoryEo = new ThreeInventoryEo();
        inventoryEo.setBizDate(threeInventoryReqDto.getBizDate());
        inventoryEo.setSource(threeInventoryReqDto.getSource());
        return ((IThreeInventoryDomain)this.domain).selectList((BaseEo)inventoryEo, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
    }

    @Override
    public List<ThreeInventoryEo> selectThreeInventoryList(String bizDate, String source) {
        if (StringUtils.isEmpty((CharSequence)bizDate) || StringUtils.isEmpty((CharSequence)source)) {
            return new ArrayList<ThreeInventoryEo>();
        }
        ThreeInventoryEo inventoryEo = new ThreeInventoryEo();
        inventoryEo.setBizDate(bizDate);
        inventoryEo.setSource(source);
        return ((IThreeInventoryDomain)this.domain).selectList((BaseEo)inventoryEo, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDeleteThreeInventory(List<ThreeInventoryDto> inventoryDtoList, String source) {
        log.info("\u62c9\u53d6\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u5904\u7406\uff1a{}", (Object)source);
        ExtQueryChainWrapper sqlFilters = ((IThreeInventoryDomain)this.domain).filter();
        String bizDate = inventoryDtoList.get(0).getBizDate();
        sqlFilters.eq((Object)"biz_date", (Object)bizDate);
        sqlFilters.eq((Object)"source", (Object)source);
        sqlFilters.in((Object)"logic_warehouse_code", (Collection)inventoryDtoList.stream().map(ThreeInventoryDto::getLogicWarehouseCode).distinct().collect(Collectors.toList()));
        Integer pageNum = 1;
        Integer pageSize = 1000;
        PageInfo pageInfo = sqlFilters.page(pageNum, pageSize);
        log.info("\u67e5\u8be2\u4e09\u65b9\u5e93\u5b58\u8bb0\u5f55\u8868\u5b9e\u4f53\u5bf9\u8c61pageNum={},\u8fd4\u56depages={}", (Object)pageNum, Objects.nonNull(pageInfo) ? Integer.valueOf(pageInfo.getPages()) : null);
        if (Objects.nonNull(pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            List ids = pageInfo.getList().stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            ThreeInventoryEo inventoryEo = new ThreeInventoryEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", ids));
            inventoryEo.setDr(1);
            inventoryEo.setSqlFilters(sqlFilterList);
            ((IThreeInventoryDomain)this.domain).updateSelectiveSqlFilter((BaseEo)inventoryEo);
        }
        for (int i = pageInfo.getPages() - 1; i >= 0; --i) {
            PageInfo eoPageInfo = sqlFilters.page(Integer.valueOf(i), pageSize);
            log.info("\u67e5\u8be2\u4e09\u65b9\u5e93\u5b58\u8bb0\u5f55\u8868\u5b9e\u4f53\u5bf9\u8c61pageNum={},\u8fd4\u56depages={}", (Object)pageNum, Objects.nonNull(eoPageInfo) ? Integer.valueOf(eoPageInfo.getPages()) : null);
            if (!Objects.nonNull(eoPageInfo) || !CollectionUtil.isNotEmpty((Collection)eoPageInfo.getList())) continue;
            List ids = eoPageInfo.getList().stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            ThreeInventoryEo inventoryEo = new ThreeInventoryEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", ids));
            inventoryEo.setDr(1);
            inventoryEo.setSqlFilters(sqlFilterList);
            ((IThreeInventoryDomain)this.domain).updateSelectiveSqlFilter((BaseEo)inventoryEo);
        }
    }
}

