/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.yunxi.dg.base.center.trade.dao.das.IOrderLineReleationItemLineDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLineReleationItemLineDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.enums.ItemLineCancelStatusEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.OrderLineReleationItemLineEo;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderLineReleationItemLineDomainImpl
extends BaseDomainImpl<OrderLineReleationItemLineEo>
implements IOrderLineReleationItemLineDomain {
    private static final Logger log = LoggerFactory.getLogger(OrderLineReleationItemLineDomainImpl.class);
    @Resource
    private IOrderLineReleationItemLineDas das;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;

    public ICommonDas<OrderLineReleationItemLineEo> commonDas() {
        return this.das;
    }

    @Override
    public List<OrderLineReleationItemLineEo> queryByOrderLineIds(List<Long> orderLineIds) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(OrderLineReleationItemLineEo::getOrderLineId, orderLineIds);
        return this.das.getMapper().selectList((Wrapper)queryOrderItemWrapper);
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryItemLineEoBySaleOrderId(Long saleOrderId) {
        AssertUtils.isFalse(saleOrderId == null, "\u53c2\u6570\u9500\u552e\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        List<DgPerformOrderLineDto> orderLineDtos = this.dgPerformOrderLineDomain.queryByOrderId(saleOrderId);
        AssertUtils.isFalse(CollectionUtils.isEmpty(orderLineDtos), "\u672a\u627e\u5230\u8ba2\u5355\u7684\u76f8\u5173\u8ba2\u5355\u884c\u4fe1\u606f");
        List orderLineIds = orderLineDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
        List releationItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"order_line_id", orderLineIds)).eq((Object)"dr", (Object)0)).list();
        AssertUtils.isFalse(CollectionUtils.isEmpty((Collection)releationItemLineEos), "\u672a\u627e\u5230\u8ba2\u5355\u884c\u4e0e\u5546\u54c1\u884c\u5173\u8054\u5173\u7cfb");
        List orderItemLineIds = releationItemLineEos.stream().map(OrderLineReleationItemLineEo::getOrderItemLineId).collect(Collectors.toList());
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().in((Object)"id", orderItemLineIds)).eq((Object)"dr", (Object)0)).list();
        AssertUtils.isFalse(CollectionUtils.isEmpty((Collection)orderItemLineEos), "\u672a\u627e\u5230\u8ba2\u5355\u5546\u54c1\u884c\u4fe1\u606f");
        return orderItemLineEos;
    }

    @Override
    public List<DgPerformOrderItemLineDto> queryItemLineDtoBySaleOrderId(Long saleOrderId) {
        AssertUtils.isFalse(saleOrderId == null, "\u53c2\u6570\u9500\u552e\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        List<DgPerformOrderLineDto> orderLineDtos = this.dgPerformOrderLineDomain.queryByOrderId(saleOrderId);
        AssertUtils.isFalse(CollectionUtils.isEmpty(orderLineDtos), "\u672a\u627e\u5230\u9500\u552e\u8ba2\u5355\u7684\u76f8\u5173\u8ba2\u5355\u884c\u4fe1\u606f");
        List orderLineIds = orderLineDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
        List releationItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"order_line_id", orderLineIds)).eq((Object)"dr", (Object)0)).list();
        AssertUtils.isFalse(CollectionUtils.isEmpty((Collection)releationItemLineEos), "\u672a\u627e\u5230\u9500\u552e\u8ba2\u5355\u884c\u4e0e\u5546\u54c1\u884c\u5173\u8054\u5173\u7cfb");
        List orderItemLineIds = releationItemLineEos.stream().map(OrderLineReleationItemLineEo::getOrderItemLineId).collect(Collectors.toList());
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().in((Object)"id", orderItemLineIds)).eq((Object)"sh_flag", (Object)YesOrNoEnum.NO.getType())).eq((Object)"dr", (Object)0)).list();
        AssertUtils.isFalse(CollectionUtils.isEmpty((Collection)orderItemLineEos), "\u672a\u627e\u5230\u9500\u552e\u8ba2\u5355\u5546\u54c1\u884c\u4fe1\u606f");
        ArrayList orderItemLineDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderItemLineDtos, (Collection)orderItemLineEos, DgPerformOrderItemLineDto.class);
        Map releationItemLineEoMap = releationItemLineEos.stream().collect(Collectors.toMap(OrderLineReleationItemLineEo::getOrderItemLineId, Function.identity()));
        for (DgPerformOrderItemLineDto orderItemLineDto : orderItemLineDtos) {
            orderItemLineDto.setOrderLineId(((OrderLineReleationItemLineEo)releationItemLineEoMap.get(orderItemLineDto.getId())).getOrderLineId());
        }
        return orderItemLineDtos;
    }

    @Override
    public List<DgPerformOrderItemLineDto> queryItemLineDtosByOrderLineIds(List<Long> orderLineIds) {
        AssertUtils.isFalse(CollectionUtils.isEmpty(orderLineIds), "\u53c2\u6570\u9500\u552e\u8ba2\u5355\u884cID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List releationItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"order_line_id", orderLineIds)).eq((Object)"dr", (Object)0)).list();
        AssertUtils.isFalse(CollectionUtils.isEmpty((Collection)releationItemLineEos), "\u672a\u627e\u5230\u9500\u552e\u8ba2\u5355\u884c\u4e0e\u5546\u54c1\u884c\u5173\u8054\u5173\u7cfb");
        List orderItemLineIds = releationItemLineEos.stream().map(OrderLineReleationItemLineEo::getOrderItemLineId).collect(Collectors.toList());
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().in((Object)"id", orderItemLineIds)).eq((Object)"sh_flag", (Object)0)).eq((Object)"dr", (Object)0)).list();
        AssertUtils.isFalse(CollectionUtils.isEmpty((Collection)orderItemLineEos), "\u672a\u627e\u5230\u9500\u552e\u8ba2\u5355\u5546\u54c1\u884c\u4fe1\u606f");
        ArrayList orderItemLineDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderItemLineDtos, (Collection)orderItemLineEos, DgPerformOrderItemLineDto.class);
        Map releationItemLineEoMap = releationItemLineEos.stream().collect(Collectors.toMap(OrderLineReleationItemLineEo::getOrderItemLineId, Function.identity()));
        for (DgPerformOrderItemLineDto orderItemLineDto : orderItemLineDtos) {
            orderItemLineDto.setOrderLineId(((OrderLineReleationItemLineEo)releationItemLineEoMap.get(orderItemLineDto.getId())).getOrderLineId());
        }
        return orderItemLineDtos;
    }

    @Override
    public List<DgPerformOrderItemLineDto> queryWaitDeliveryItemLineDtosByOrderLineIds(List<Long> orderLineIds) {
        AssertUtils.isFalse(CollectionUtils.isEmpty(orderLineIds), "\u53c2\u6570\u9500\u552e\u8ba2\u5355\u884cID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List releationItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"order_line_id", orderLineIds)).eq((Object)"dr", (Object)0)).list();
        AssertUtils.isFalse(CollectionUtils.isEmpty((Collection)releationItemLineEos), "\u672a\u627e\u5230\u9500\u552e\u8ba2\u5355\u884c\u4e0e\u5546\u54c1\u884c\u5173\u8054\u5173\u7cfb");
        List orderItemLineIds = releationItemLineEos.stream().map(OrderLineReleationItemLineEo::getOrderItemLineId).collect(Collectors.toList());
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().in((Object)"id", orderItemLineIds)).eq((Object)"sh_flag", (Object)0)).eq((Object)"delivery_status", (Object)ItemLineDeliveryStatusEnum.NO.getType())).eq((Object)"cancel_status", (Object)ItemLineCancelStatusEnum.NO.getType())).eq((Object)"dr", (Object)0)).list();
        if (CollectionUtils.isEmpty((Collection)orderItemLineEos)) {
            return new ArrayList<DgPerformOrderItemLineDto>();
        }
        ArrayList orderItemLineDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderItemLineDtos, (Collection)orderItemLineEos, DgPerformOrderItemLineDto.class);
        Map releationItemLineEoMap = releationItemLineEos.stream().collect(Collectors.toMap(OrderLineReleationItemLineEo::getOrderItemLineId, Function.identity()));
        for (DgPerformOrderItemLineDto orderItemLineDto : orderItemLineDtos) {
            orderItemLineDto.setOrderLineId(((OrderLineReleationItemLineEo)releationItemLineEoMap.get(orderItemLineDto.getId())).getOrderLineId());
        }
        return orderItemLineDtos;
    }

    @Override
    public List<DgPerformOrderItemLineDto> queryDeliveryItemLineDtosByOrderLineIds(List<Long> orderLineIds) {
        AssertUtils.isFalse(CollectionUtils.isEmpty(orderLineIds), "\u53c2\u6570\u9500\u552e\u8ba2\u5355\u884cID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List releationItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"order_line_id", orderLineIds)).eq((Object)"dr", (Object)0)).list();
        AssertUtils.isFalse(CollectionUtils.isEmpty((Collection)releationItemLineEos), "\u672a\u627e\u5230\u9500\u552e\u8ba2\u5355\u884c\u4e0e\u5546\u54c1\u884c\u5173\u8054\u5173\u7cfb");
        List orderItemLineIds = releationItemLineEos.stream().map(OrderLineReleationItemLineEo::getOrderItemLineId).collect(Collectors.toList());
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().in((Object)"id", orderItemLineIds)).eq((Object)"sh_flag", (Object)0)).eq((Object)"delivery_status", (Object)ItemLineDeliveryStatusEnum.YES.getType())).eq((Object)"cancel_status", (Object)ItemLineCancelStatusEnum.NO.getType())).eq((Object)"dr", (Object)0)).list();
        if (CollectionUtils.isEmpty((Collection)orderItemLineEos)) {
            return new ArrayList<DgPerformOrderItemLineDto>();
        }
        ArrayList orderItemLineDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderItemLineDtos, (Collection)orderItemLineEos, DgPerformOrderItemLineDto.class);
        Map releationItemLineEoMap = releationItemLineEos.stream().collect(Collectors.toMap(OrderLineReleationItemLineEo::getOrderItemLineId, Function.identity()));
        for (DgPerformOrderItemLineDto orderItemLineDto : orderItemLineDtos) {
            orderItemLineDto.setOrderLineId(((OrderLineReleationItemLineEo)releationItemLineEoMap.get(orderItemLineDto.getId())).getOrderLineId());
        }
        return orderItemLineDtos;
    }

    @Override
    public List<Long> queryOrderLineIdByItemLineIds(List<Long> afsOrderItemLineIds) {
        AssertUtils.isFalse(CollectionUtils.isEmpty(afsOrderItemLineIds), "\u53c2\u6570\u5546\u54c1\u884cID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List orderLineReleationItemLineEos = ((ExtQueryChainWrapper)this.das.filter().in((Object)"order_line_id", afsOrderItemLineIds)).list();
        AssertUtils.isFalse(CollectionUtils.isEmpty((Collection)orderLineReleationItemLineEos), "\u672a\u6839\u636e\u5546\u54c1\u884cID\u96c6\u5408\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u884cID\u96c6\u5408");
        return orderLineReleationItemLineEos.stream().map(OrderLineReleationItemLineEo::getOrderLineId).distinct().collect(Collectors.toList());
    }
}

