/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.IdGenrator;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgAfterSaleOrderDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgAfterSaleQuotaDetailDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgAfterSaleQuotaDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgAfterSaleRuleDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgOrderBusinessTypeDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgOrderChannelDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgOrderLabelDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgOrderTagDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgOrderTypeDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgSaleOrderDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgStrategyAutoCheckRuleDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.QualityControlDomainImpl;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgNoGreateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgNoGreateUtil.class);
    private static final int EXPIRE_TIME = 90000;
    public static final String DATA_TIME_FORMAT = "yyyyMMddHHmmss";
    public static final String DATA_FORMAT = "yyyyMMdd";
    @Resource
    protected ICacheService cacheService;
    @Resource
    protected Map<String, IResetRedisNoIndexCommon> resetRedisNoIndexCommonMap;
    private static final String AFTER_SALE_ORDER_PREFIX = "AF";
    private static final String PLATFORM_AFTER_SALE_ORDER_PREFIX = "PTTD";

    private static String getOrderIdPrefix(LocalDateTime now, String format) {
        return now.format(DateTimeFormatter.ofPattern(format));
    }

    private long generate(Class<?> noServiceClazz, String key) {
        Long incrNo = this.cacheService.incr(key, 90000L);
        if (incrNo == 1L) {
            incrNo = this.resetLastNo(noServiceClazz, key);
        }
        return incrNo;
    }

    private Long resetLastNo(Class<?> noServiceClazz, String key) {
        String beanServiceName = StringUtils.prefixToLower((String)noServiceClazz.getSimpleName(), (int)1);
        IResetRedisNoIndexCommon resetRedisNoIndexCommon = this.resetRedisNoIndexCommonMap.get(beanServiceName);
        AssertUtils.notNull((Object)resetRedisNoIndexCommon, (String)"%s\u6ca1\u6709\u5b9e\u73b0IResetRedisNoIndexCommon\u63a5\u53e3", (Object[])new Object[]{beanServiceName});
        String latestNo = resetRedisNoIndexCommon.getLatestNo();
        Long nextNo = 1L;
        if (latestNo.contains(key)) {
            long latestNoL = Long.parseLong(latestNo.substring(key.length()));
            nextNo = latestNoL + 1L;
            LOGGER.info("\u91cd\u7f6eredis\u5355\u53f7 key\uff1a{}, no:{}", (Object)key, (Object)nextNo);
            this.cacheService.setCache(key, (Object)nextNo, 90000);
        }
        return nextNo;
    }

    public String generateOrderNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, DATA_FORMAT);
        String prefix = "DD";
        String prefixOrderNo = prefix + orderIdPrefix;
        return prefixOrderNo + String.format("%1$07d", this.generate(DgSaleOrderDomainImpl.class, prefixOrderNo));
    }

    public String generateChannelNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, "yyMMdd");
        String prefix = "OC";
        String prefixRuleCode = prefix + orderIdPrefix;
        return prefixRuleCode + String.format("%1$02d", this.generate(DgOrderChannelDomainImpl.class, prefixRuleCode));
    }

    public String generateOrderTypeNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, "yyMMdd");
        String prefix = "OT";
        String prefixRuleCode = prefix + orderIdPrefix;
        return prefixRuleCode + String.format("%1$02d", this.generate(DgOrderTypeDomainImpl.class, prefixRuleCode));
    }

    public String generateBusinessTypeNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, "yyMMdd");
        String prefix = "BT";
        String prefixRuleCode = prefix + orderIdPrefix;
        return prefixRuleCode + String.format("%1$02d", this.generate(DgOrderBusinessTypeDomainImpl.class, prefixRuleCode));
    }

    public String generateTagNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, DATA_FORMAT);
        String prefix = "TAG";
        String prefixRuleCode = prefix + orderIdPrefix;
        return prefixRuleCode + String.format("%1$04d", this.generate(DgOrderTagDomainImpl.class, prefixRuleCode));
    }

    public String generateAfterSaleOrderNo() {
        LocalDateTime now = LocalDateTime.now();
        String prefixAfterSaleOrderNo = AFTER_SALE_ORDER_PREFIX + DgNoGreateUtil.getOrderIdPrefix(now, DATA_FORMAT);
        return prefixAfterSaleOrderNo + String.format("%1$06d", this.generate(DgAfterSaleOrderDomainImpl.class, prefixAfterSaleOrderNo));
    }

    public String generatePlatformAfterSaleOrderNo() {
        LocalDateTime now = LocalDateTime.now();
        String prefixAfterSaleOrderNo = PLATFORM_AFTER_SALE_ORDER_PREFIX + DgNoGreateUtil.getOrderIdPrefix(now, DATA_FORMAT);
        return prefixAfterSaleOrderNo + String.format("%1$06d", this.generate(DgAfterSaleOrderDomainImpl.class, prefixAfterSaleOrderNo));
    }

    public String generateDefaultPlatformNo() {
        return String.format("PN%s", IdGenrator.getDistributedId());
    }

    public String generateRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, DATA_TIME_FORMAT);
        String prefix = "DR";
        String prefixRuleCode = prefix + orderIdPrefix;
        return prefixRuleCode + String.format("%1$03d", this.generate(DgStrategyAutoCheckRuleDomainImpl.class, prefixRuleCode));
    }

    public String generateLabelNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, DATA_TIME_FORMAT);
        String prefix = "BS";
        String prefixRuleCode = prefix + orderIdPrefix;
        return prefixRuleCode + String.format("%1$03d", this.generate(DgOrderLabelDomainImpl.class, prefixRuleCode));
    }

    public String generateQcNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, DATA_TIME_FORMAT);
        String prefix = "QC";
        String prefixRuleCode = prefix + orderIdPrefix;
        return prefixRuleCode + String.format("%1$03d", this.generate(QualityControlDomainImpl.class, prefixRuleCode));
    }

    public String generateQuotaNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, DATA_FORMAT);
        String prefix = "THED";
        String prefixRuleCode = prefix + orderIdPrefix;
        return prefixRuleCode + String.format("%1$03d", this.generate(DgAfterSaleQuotaDomainImpl.class, prefixRuleCode));
    }

    public String generateAfterSaleRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, DATA_TIME_FORMAT);
        String prefix = "AFR";
        String prefixRuleCode = prefix + orderIdPrefix;
        return prefixRuleCode + String.format("%1$03d", this.generate(DgAfterSaleOrderDomainImpl.class, prefixRuleCode));
    }

    public String generateAfterSaleRuleItem() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, DATA_FORMAT);
        String prefix = "THGZ";
        String prefixRuleCode = prefix + orderIdPrefix;
        return prefixRuleCode + String.format("%1$03d", this.generate(DgAfterSaleRuleDomainImpl.class, prefixRuleCode));
    }

    public String generateAfterSaleRuleQuota() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, DATA_FORMAT);
        String prefix = "THEDGZ";
        String prefixRuleCode = prefix + orderIdPrefix;
        return prefixRuleCode + String.format("%1$03d", this.generate(DgAfterSaleRuleDomainImpl.class, prefixRuleCode));
    }

    public String generateQuotaDetailNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgNoGreateUtil.getOrderIdPrefix(now, DATA_FORMAT);
        String prefix = "BGLS";
        String prefixRuleCode = prefix + orderIdPrefix;
        return prefixRuleCode + String.format("%1$03d", this.generate(DgAfterSaleQuotaDetailDomainImpl.class, prefixRuleCode));
    }
}

