/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.AttachementReqDto;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.trade.dao.das.IAttachementDas;
import com.yunxi.dg.base.center.trade.domain.entity.IAttachementDomain;
import com.yunxi.dg.base.center.trade.eo.AttachementEo;
import com.yunxi.dg.base.center.trade.utils.AssertUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AttachementDomainImpl
extends BaseDomainImpl<AttachementEo>
implements IAttachementDomain {
    @Resource
    private IAttachementDas das;

    public ICommonDas<AttachementEo> commonDas() {
        return this.das;
    }

    @Override
    public void saveReturnAttachment(String afterOrderNo, List<AttachementEo> attachementEos) {
        AssertUtil.isTrue(StringUtils.isBlank((CharSequence)afterOrderNo), "-1", "\u4fdd\u5b58\u9000\u8d27\u5355\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c\u9000\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty(attachementEos)) {
            List eoList = attachementEos.stream().map(m -> {
                AttachementEo eo = new AttachementEo();
                eo.setBizNo(afterOrderNo);
                eo.setBizType(OptBizTypeEnum.RETURN.getType());
                eo.setPath(m.getPath());
                eo.setName(m.getName());
                return eo;
            }).collect(Collectors.toList());
            this.das.insertBatch(eoList);
        }
    }

    @Override
    public void logicDeleteAndSaveReturnAttachment(String afterOrderNo, List<AttachementEo> attachementEos, String bizType) {
        AssertUtil.isTrue(StringUtils.isBlank((CharSequence)afterOrderNo), "-1", "\u4fdd\u5b58\u9000\u8d27\u5355\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c\u9000\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AttachementEo queryEo = new AttachementEo();
        queryEo.setBizNo(afterOrderNo);
        queryEo.setBizType(bizType);
        List oldAttachementEos = this.das.selectList((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(1024));
        if (CollectionUtils.isNotEmpty((Collection)oldAttachementEos)) {
            oldAttachementEos.forEach(att -> this.das.deleteById(att.getId()));
        }
        if (CollectionUtils.isNotEmpty(attachementEos)) {
            HashSet fileNameSet = Sets.newHashSet();
            AssertUtils.isTrue((boolean)attachementEos.stream().allMatch(attachment -> fileNameSet.add(attachment.getName())), (String)"\u540c\u540d\u6587\u4ef6\u4e0d\u5141\u8bb8\u4e0a\u4f20");
            List eoList = attachementEos.stream().map(m -> {
                AttachementEo eo = new AttachementEo();
                eo.setBizNo(afterOrderNo);
                eo.setBizType(bizType);
                eo.setPath(m.getPath());
                eo.setName(m.getName());
                return eo;
            }).collect(Collectors.toList());
            this.das.insertBatch(eoList);
        }
    }

    @Override
    public void saveReceivingReportAttachment(String afterOrderNo, List<AttachementReqDto> attachementEos) {
        AssertUtil.isTrue(StringUtils.isBlank((CharSequence)afterOrderNo), "-1", "\u4fdd\u5b58\u9a8c\u6536\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u9000\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty(attachementEos)) {
            List eoList = attachementEos.stream().map(m -> {
                AttachementEo eo = new AttachementEo();
                eo.setBizNo(afterOrderNo);
                eo.setBizType(OptBizTypeEnum.RETURN_RECEIVING_REPORT.getType());
                eo.setPath(m.getPath());
                eo.setName(m.getName());
                return eo;
            }).collect(Collectors.toList());
            this.das.insertBatch(eoList);
        }
    }

    @Override
    public void logicDeleteAndSaveReceivingReportAttachment(String afterOrderNo, List<AttachementReqDto> attachementEos) {
        AssertUtil.isTrue(StringUtils.isBlank((CharSequence)afterOrderNo), "-1", "\u4fdd\u5b58\u9a8c\u6536\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u9000\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AttachementEo queryEo = new AttachementEo();
        queryEo.setBizNo(afterOrderNo);
        queryEo.setBizType(OptBizTypeEnum.RETURN_RECEIVING_REPORT.getType());
        List attachementEoList = this.das.selectList((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(1024));
        if (CollectionUtils.isNotEmpty((Collection)attachementEoList)) {
            attachementEoList.forEach(e -> this.das.logicDelete((BaseEo)e));
        }
        if (CollectionUtils.isNotEmpty(attachementEos)) {
            List eoList = attachementEos.stream().map(m -> {
                AttachementEo eo = new AttachementEo();
                eo.setBizNo(afterOrderNo);
                eo.setBizType(OptBizTypeEnum.RETURN_RECEIVING_REPORT.getType());
                eo.setPath(m.getPath());
                eo.setName(m.getName());
                return eo;
            }).collect(Collectors.toList());
            this.das.insertBatch(eoList);
        }
    }

    @Override
    public List<AttachementEo> queryEosByAfsOrderNo(String afterSaleOrderNo) {
        AssertUtil.isTrue(StringUtils.isBlank((CharSequence)afterSaleOrderNo), "\u67e5\u8be2\u53c2\u6570afterSaleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)this.das.filter().eq((Object)"biz_no", (Object)afterSaleOrderNo)).list();
    }

    @Override
    public List<AttachementEo> queryEosByAfsOrderNoAndTypes(String afterSaleOrderNo, ArrayList<String> types) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)afterSaleOrderNo), (String)"\u67e5\u8be2\u53c2\u6570\u552e\u540e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty(types), (String)"\u67e5\u8be2\u53c2\u6570\u7c7b\u578b\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"biz_no", (Object)afterSaleOrderNo)).in((Object)"biz_type", types)).list();
    }
}

