/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderLineDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderLinePayDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLineReleationItemLineDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLinePageReqDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.vo.BeforeOrderItemNumVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderLineDomainImpl
extends BaseDomainImpl<DgPerformOrderLineEo>
implements IDgPerformOrderLineDomain {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderLineDomainImpl.class);
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IOrderLineReleationItemLineDomain orderLineReleationItemLineDomain;
    @Resource
    private IDgPerformOrderLineDas das;
    @Resource
    private IDgPerformOrderLinePayDas performOrderLinePayDas;

    public ICommonDas<DgPerformOrderLineEo> commonDas() {
        return this.das;
    }

    @Override
    public void deleteByOrderId(Long orderId) {
        this.das.deleteByOrderId(orderId);
    }

    @Override
    public List<BeforeOrderItemNumVo> queryRelBeforeItemNum(String beforeOrderNo) {
        return this.das.queryRelBeforeItemNum(beforeOrderNo);
    }

    @Override
    public List<DgPerformOrderLineDto> queryByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderLineEo::getOrderId, (Object)orderId);
        return this.selectList((Wrapper<DgPerformOrderLineEo>)queryItemWrapper);
    }

    @Override
    public DgPerformOrderLineEo queryById(Long id) {
        return (DgPerformOrderLineEo)this.selectByIds(Lists.newArrayList((Object[])new Long[]{id})).get(0);
    }

    @Override
    public List<DgPerformOrderLineEo> queryByIds(List<Long> ids) {
        return this.selectByIds(ids);
    }

    @Override
    public List<DgPerformOrderLineDto> queryByOrderIds(List<Long> orderIds) {
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderLineEo::getOrderId, orderIds);
        return this.selectList((Wrapper<DgPerformOrderLineEo>)queryItemWrapper);
    }

    @Override
    public List<DgPerformOrderLineEo> queryEosByOrderIds(List<Long> orderIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderIds)) {
            return new ArrayList<DgPerformOrderLineEo>();
        }
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderLineEo::getOrderId, orderIds);
        return this.das.getMapper().selectList((Wrapper)queryItemWrapper);
    }

    @Override
    public List<DgPerformOrderLineDto> queryDtosByOrderIds(List<Long> orderIds) {
        AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(orderIds), (String)"\u67e5\u8be2\u53c2\u6570orderIds\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList dtoList = Lists.newArrayList();
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderLineEo::getOrderId, orderIds);
        List dgPerformOrderLineEos = this.das.getMapper().selectList((Wrapper)queryItemWrapper);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dgPerformOrderLineEos)) {
            CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)dgPerformOrderLineEos, DgPerformOrderLineDto.class);
        }
        return dtoList;
    }

    @Override
    public List<DgPerformOrderLineDto> queryByEo(DgPerformOrderLineEo queryEo) {
        AssertUtils.notNull((Object)queryEo, (String)"queryEo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)queryEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        return this.selectList((Wrapper<DgPerformOrderLineEo>)queryWrapper);
    }

    @Override
    public List<DgPerformOrderLineEo> queryOrderLinesBySkuCodes(Long orderId, List<String> skuCodeList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderLineEo::getOrderId, (Object)orderId)).in(DgPerformOrderLineEo::getSkuCode, skuCodeList);
        return this.das.getMapper().selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<DgPerformOrderLineDto> queryOrderLineDtoBySkuCodes(Long orderId, List<String> skuCodeList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderLineEo::getOrderId, (Object)orderId)).in(DgPerformOrderLineEo::getSkuCode, skuCodeList);
        return this.selectList((Wrapper<DgPerformOrderLineEo>)queryWrapper);
    }

    @Override
    public List<DgPerformOrderLineEo> queryByOrderIdAndIdList(Long saleOrderId, List<Long> orderLineIdList) {
        AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(orderLineIdList), (String)"\u67e5\u8be2\u53c2\u6570ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((saleOrderId == null ? 1 : 0) != 0, (String)"\u67e5\u8be2\u53c2\u6570\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"order_id", (Object)saleOrderId)).eq((Object)"dr", (Object)0)).in((Object)"id", orderLineIdList)).list();
    }

    @Override
    public List<DgPerformOrderLineDto> queryDtosByOrderIdAndIdList(Long saleOrderId, List<Long> orderLineIdList) {
        AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(orderLineIdList), (String)"\u67e5\u8be2\u53c2\u6570ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((saleOrderId == null ? 1 : 0) != 0, (String)"\u67e5\u8be2\u53c2\u6570\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        List performOrderLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"order_id", (Object)saleOrderId)).eq((Object)"dr", (Object)0)).in((Object)"id", orderLineIdList)).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)performOrderLineEos)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)performOrderLineEos, DgPerformOrderLineDto.class);
        return list;
    }

    @Override
    public List<DgPerformOrderLineEo> queryEosByPlatformOrderItemNos(List<String> platformItemNoList) {
        AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(platformItemNoList), (String)"\u53c2\u6570\u5e73\u53f0\u5546\u54c1\u884c\u552f\u4e00\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"dr", (Object)0)).in((Object)"platform_order_item_no", platformItemNoList)).list();
    }

    @Override
    public List<DgPerformOrderLineEo> queryEosByPlatformOrderItemNosAndOrderId(List<String> platformItemNoList, Long orderId) {
        AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(platformItemNoList), (String)"\u53c2\u6570platformItemNoList\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((orderId == null ? 1 : 0) != 0, (String)"\u53c2\u6570orderId\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"dr", (Object)0)).in((Object)"platform_order_item_no", platformItemNoList)).eq((Object)"order_id", (Object)orderId)).list();
    }

    @Override
    public List<DgPerformOrderLineEo> queryEosByOrderId(Long orderId) {
        AssertUtils.isFalse((orderId == null ? 1 : 0) != 0, (String)"\u53c2\u6570\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"order_id", (Object)orderId)).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public List<DgPerformOrderLineEo> queryByOrderIdAndPlatformOrderItemNos(Long saleOrderId, List<String> platformOrderItemNos) {
        AssertUtils.isFalse((saleOrderId == null ? 1 : 0) != 0, (String)"\u53c2\u6570\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty(platformOrderItemNos), (String)"\u53c2\u6570\u5e73\u53f0\u5546\u54c1\u552f\u4e00\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"order_id", (Object)saleOrderId)).in((Object)"platform_order_item_no", platformOrderItemNos)).list();
    }

    @Override
    public void updateOrderLinePayRecord(Long id) {
        this.das.updateOrderLinePayRecord(id);
    }

    @Override
    public List<DgPerformOrderLineDto> queryList(DgPerformOrderLinePageReqDto dto) {
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryItemWrapper.setEntity(BeanUtil.copyProperties((Object)dto, DgPerformOrderLineEo.class, (String[])new String[0]))).eq(BaseEo::getDr, (Object)0)).in(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dto.getOrderIds()), DgPerformOrderLineEo::getOrderId, (Collection)dto.getOrderIds());
        List<DgPerformOrderLineDto> saleOrderItemRespDtos = this.selectList((Wrapper<DgPerformOrderLineEo>)queryItemWrapper);
        return saleOrderItemRespDtos;
    }

    @Override
    public List<DgPerformOrderLineEo> queryEosByPlatformOrderNo(String platformOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u53c2\u6570platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).list();
    }

    @Override
    public List<DgPerformOrderLineDto> queryOrderLineByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderLineEo::getOrderId, (Object)orderId);
        List<DgPerformOrderLineDto> saleOrderItemRespDtos = this.selectList((Wrapper<DgPerformOrderLineEo>)queryItemWrapper);
        return saleOrderItemRespDtos;
    }

    private List<DgPerformOrderLineDto> selectList(Wrapper<DgPerformOrderLineEo> queryWrapper) {
        List performOrderLineEos = this.das.getMapper().selectList(queryWrapper);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)performOrderLineEos)) {
            return null;
        }
        ArrayList<DgPerformOrderLineDto> performOrderLineDtos = new ArrayList<DgPerformOrderLineDto>();
        CubeBeanUtils.copyCollection(performOrderLineDtos, (Collection)performOrderLineEos, DgPerformOrderLineDto.class);
        return performOrderLineDtos;
    }
}

