/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.OrderAddressDto;
import com.yunxi.dg.base.center.trade.dto.entity.OrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.TradeItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.OrderAddressEo;
import com.yunxi.dg.base.center.trade.eo.OrderEo;
import com.yunxi.dg.base.center.trade.eo.TradeItemEo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class F2BDtoConvertUtil {
    public static void dgOrderDtoToOrderDto(DgPerformOrderReqDto source, OrderDto target) {
        DgPerformOrderPaymentDto performOrderPaymentDto;
        if (Objects.isNull(source)) {
            source = new DgPerformOrderReqDto();
        }
        if (Objects.isNull(target)) {
            target = new OrderDto();
        }
        CubeBeanUtils.copyProperties((Object)target, (Object)source, (String[])new String[0]);
        target.setOrderNo(source.getSaleOrderNo());
        target.setThirdOrderNo(source.getPlatformOrderNo());
        target.setThirdParentOrderNo(source.getPlatformParentOrderNo());
        target.setOnlineType(source.getIsOnline());
        target.setDeviceType(source.getOrderSourceSystemCode());
        target.setOrderTradeStatus(source.getOrderStatus());
        target.setTotalAmount(source.getOrderTotalAmount());
        target.setAllAmount(source.getGoodsTotalAmount());
        Integer goodsTotalNum = Objects.isNull(source.getGoodsTotalNum()) ? 0 : source.getGoodsTotalNum().intValue();
        target.setTotalItemNum(goodsTotalNum);
        target.setBuyerRemark(source.getRemark());
        target.setPlaceTime(source.getSaleCreateTime());
        target.setCancelDesc(source.getCancelReason());
        target.setReceiveTime(source.getConfirmReceiveTime());
        DgPerformOrderSnapshotDto performOrderSnapshotDto = source.getPerformOrderSnapshotDto();
        if (Objects.nonNull(performOrderSnapshotDto)) {
            CubeBeanUtils.copyProperties((Object)target, (Object)performOrderSnapshotDto, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
            target.setShopId(String.valueOf(performOrderSnapshotDto.getShopId()));
        }
        if (Objects.nonNull(performOrderPaymentDto = source.getPerformOrderPaymentDto())) {
            CubeBeanUtils.copyProperties((Object)target, (Object)performOrderPaymentDto, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        }
        DgPerformOrderExtensionDto performOrderExtensionDto = source.getPerformOrderExtensionDto();
        if (Objects.nonNull(performOrderPaymentDto)) {
            CubeBeanUtils.copyProperties((Object)target, (Object)performOrderExtensionDto, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        }
    }

    public static void dgOrderRespDtoToOrderEo(DgPerformOrderRespDto source, OrderEo target) {
        DgPerformOrderPaymentDto performOrderPaymentDto;
        if (Objects.isNull(source)) {
            source = new DgPerformOrderRespDto();
        }
        if (Objects.isNull(target)) {
            target = new OrderEo();
        }
        CubeBeanUtils.copyProperties((Object)target, (Object)source, (String[])new String[0]);
        target.setOrderNo(source.getSaleOrderNo());
        target.setThirdOrderNo(source.getPlatformOrderNo());
        target.setThirdParentOrderNo(source.getPlatformParentOrderNo());
        target.setOnlineType(source.getIsOnline());
        target.setDeviceType(source.getOrderSourceSystemCode());
        target.setOrderTradeStatus(source.getOrderStatus());
        target.setTotalAmount(source.getOrderTotalAmount());
        target.setAllAmount(source.getGoodsTotalAmount());
        Integer goodsTotalNum = Objects.isNull(source.getGoodsTotalNum()) ? 0 : source.getGoodsTotalNum().intValue();
        target.setTotalItemNum(goodsTotalNum);
        target.setBuyerRemark(source.getRemark());
        target.setPlaceTime(source.getSaleCreateTime());
        target.setCancelDesc(source.getCancelReason());
        target.setReceiveTime(source.getConfirmReceiveTime());
        DgPerformOrderSnapshotDto performOrderSnapshotDto = source.getPerformOrderSnapshotDto();
        if (Objects.nonNull(performOrderSnapshotDto)) {
            CubeBeanUtils.copyProperties((Object)target, (Object)performOrderSnapshotDto, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
            target.setCustomerId(String.valueOf(performOrderSnapshotDto.getCustomerId()));
            target.setShopId(String.valueOf(performOrderSnapshotDto.getShopId()));
        }
        if (Objects.nonNull(performOrderPaymentDto = source.getPerformOrderPaymentDto())) {
            CubeBeanUtils.copyProperties((Object)target, (Object)performOrderPaymentDto, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        }
        DgPerformOrderExtensionDto performOrderExtensionDto = source.getPerformOrderExtensionDto();
        if (Objects.nonNull(performOrderPaymentDto)) {
            CubeBeanUtils.copyProperties((Object)target, (Object)performOrderExtensionDto, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        }
    }

    public static void orderDtoToDgOrderDto(DgPerformOrderReqDto target, OrderDto source) {
        if (Objects.isNull(target)) {
            target = new DgPerformOrderReqDto();
        }
        if (Objects.isNull(source)) {
            source = new OrderDto();
        }
        CubeBeanUtils.copyProperties((Object)target, (Object)source, (String[])new String[0]);
        target.setSaleOrderNo(source.getOrderNo());
        target.setPlatformOrderNo(source.getThirdOrderNo());
        target.setPlatformParentOrderNo(source.getThirdParentOrderNo());
        target.setIsOnline(source.getOnlineType());
        target.setOrderSourceSystemCode(source.getDeviceType());
        target.setOrderStatus(source.getOrderTradeStatus());
        target.setOrderTotalAmount(source.getTotalAmount());
        target.setGoodsTotalAmount(source.getAllAmount());
        BigDecimal totalItemNum = Objects.isNull(source.getTotalItemNum()) ? BigDecimal.ZERO : new BigDecimal(source.getTotalItemNum());
        target.setGoodsTotalNum(totalItemNum);
        target.setRemark(source.getBuyerRemark());
        target.setSaleCreateTime(source.getPlaceTime());
        target.setCancelReason(source.getCancelDesc());
        target.setConfirmReceiveTime(source.getReceiveTime());
        DgPerformOrderSnapshotDto performOrderSnapshotDto = new DgPerformOrderSnapshotDto();
        CubeBeanUtils.copyProperties((Object)performOrderSnapshotDto, (Object)source, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        performOrderSnapshotDto.setOrderId(source.getId());
        performOrderSnapshotDto.setCustomerId(Long.valueOf(source.getCustomerId()));
        performOrderSnapshotDto.setShopId(Long.valueOf(source.getShopId()));
        target.setPerformOrderSnapshotDto(performOrderSnapshotDto);
        DgPerformOrderPaymentDto performOrderPaymentDto = new DgPerformOrderPaymentDto();
        CubeBeanUtils.copyProperties((Object)performOrderPaymentDto, (Object)source, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        performOrderPaymentDto.setOrderId(source.getId());
        target.setPerformOrderPaymentDto(performOrderPaymentDto);
        DgPerformOrderExtensionDto performOrderExtensionDto = new DgPerformOrderExtensionDto();
        CubeBeanUtils.copyProperties((Object)performOrderExtensionDto, (Object)source, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        performOrderExtensionDto.setOrderId(source.getId());
        target.setPerformOrderExtensionDto(performOrderExtensionDto);
    }

    public static void orderEoToDgOrderDto(DgPerformOrderReqDto target, OrderEo source) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            return;
        }
        CubeBeanUtils.copyProperties((Object)target, (Object)source, (String[])new String[0]);
        target.setOrderSource(DgSaleOrderSourceEnum.REPLACE_CUSTOMER.getType());
        target.setSaleOrderNo(source.getOrderNo());
        target.setPlatformOrderNo(source.getThirdOrderNo());
        target.setPlatformParentOrderNo(source.getThirdParentOrderNo());
        target.setIsOnline(source.getOnlineType());
        target.setOrderSourceSystemCode(source.getDeviceType());
        target.setOrderStatus(source.getOrderTradeStatus());
        target.setOrderTotalAmount(source.getTotalAmount());
        target.setGoodsTotalAmount(source.getAllAmount());
        target.setOrigAmount(source.getPayOrigTotalAmount());
        target.setRemark(source.getBuyerRemark());
        target.setSaleCreateTime(source.getPlaceTime());
        target.setCancelReason(source.getCancelDesc());
        target.setConfirmReceiveTime(source.getReceiveTime());
        DgPerformOrderSnapshotDto performOrderSnapshotDto = new DgPerformOrderSnapshotDto();
        CubeBeanUtils.copyProperties((Object)performOrderSnapshotDto, (Object)source, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        performOrderSnapshotDto.setOrderId(source.getId());
        performOrderSnapshotDto.setCustomerId(Long.valueOf(source.getCustomerId()));
        performOrderSnapshotDto.setShopId(Long.valueOf(source.getShopId()));
        target.setPerformOrderSnapshotDto(performOrderSnapshotDto);
        DgPerformOrderPaymentDto performOrderPaymentDto = new DgPerformOrderPaymentDto();
        CubeBeanUtils.copyProperties((Object)performOrderPaymentDto, (Object)source, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        performOrderPaymentDto.setOrderId(source.getId());
        performOrderPaymentDto.setPayStatus(Integer.valueOf(0));
        performOrderPaymentDto.setRemainingPayAmount(source.getPayAmount());
        target.setPerformOrderPaymentDto(performOrderPaymentDto);
        DgPerformOrderExtensionDto performOrderExtensionDto = new DgPerformOrderExtensionDto();
        CubeBeanUtils.copyProperties((Object)performOrderExtensionDto, (Object)source, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        performOrderExtensionDto.setOrderId(source.getId());
        target.setPerformOrderExtensionDto(performOrderExtensionDto);
    }

    public static void orderEoToDgOrderRespDto(DgPerformOrderRespDto target, OrderEo source) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            return;
        }
        CubeBeanUtils.copyProperties((Object)target, (Object)source, (String[])new String[0]);
        target.setSaleOrderNo(source.getOrderNo());
        target.setPlatformOrderNo(source.getThirdOrderNo());
        target.setPlatformParentOrderNo(source.getThirdParentOrderNo());
        target.setIsOnline(source.getOnlineType());
        target.setOrderSourceSystemCode(source.getDeviceType());
        target.setOrderStatus(source.getOrderTradeStatus());
        target.setOrderTotalAmount(source.getTotalAmount());
        target.setGoodsTotalAmount(source.getAllAmount());
        BigDecimal totalItemNum = Objects.isNull(source.getTotalItemNum()) ? BigDecimal.ZERO : new BigDecimal(source.getTotalItemNum());
        target.setGoodsTotalNum(totalItemNum);
        target.setRemark(source.getBuyerRemark());
        target.setSaleCreateTime(source.getPlaceTime());
        target.setCancelReason(source.getCancelDesc());
        target.setConfirmReceiveTime(source.getReceiveTime());
        DgPerformOrderSnapshotDto performOrderSnapshotDto = new DgPerformOrderSnapshotDto();
        CubeBeanUtils.copyProperties((Object)performOrderSnapshotDto, (Object)source, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        performOrderSnapshotDto.setOrderId(source.getId());
        performOrderSnapshotDto.setCustomerId(Long.valueOf(source.getCustomerId()));
        performOrderSnapshotDto.setShopId(Long.valueOf(source.getShopId()));
        target.setPerformOrderSnapshotDto(performOrderSnapshotDto);
        DgPerformOrderPaymentDto performOrderPaymentDto = new DgPerformOrderPaymentDto();
        CubeBeanUtils.copyProperties((Object)performOrderPaymentDto, (Object)source, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        performOrderPaymentDto.setOrderId(source.getId());
        target.setPerformOrderPaymentDto(performOrderPaymentDto);
        DgPerformOrderExtensionDto performOrderExtensionDto = new DgPerformOrderExtensionDto();
        CubeBeanUtils.copyProperties((Object)performOrderExtensionDto, (Object)source, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        performOrderExtensionDto.setOrderId(source.getId());
        target.setPerformOrderExtensionDto(performOrderExtensionDto);
    }

    public static void dgAddrDtoToOrderDto(DgPerformOrderAddrDto source, OrderAddressDto target) {
        if (Objects.isNull(source)) {
            source = new DgPerformOrderAddrDto();
        }
        if (Objects.isNull(target)) {
            target = new OrderAddressDto();
        }
        target.setId(source.getId());
        target.setOrderNo(source.getOrderNo());
        target.setDeliveryName(source.getReceiveName());
        target.setDeliveryMobile(source.getReceivePhone());
        target.setDeliveryPhone(source.getReceivePhone());
        target.setProvinceName(source.getProvince());
        target.setProvinceCode(source.getProvinceCode());
        target.setCityName(source.getCity());
        target.setCityCode(source.getCityCode());
        target.setAreaName(source.getCounty());
        target.setAreaCode(source.getCountyCode());
        target.setStreetName(source.getStreet());
        target.setDetailed(source.getReceiveAddress());
        target.setPostcode(source.getPostcode());
    }

    public static void dgAddrDtoToAddrEo(DgPerformOrderAddrDto source, OrderAddressEo target) {
        if (Objects.isNull(source)) {
            source = new DgPerformOrderAddrDto();
        }
        if (Objects.isNull(target)) {
            target = new OrderAddressEo();
        }
        target.setId(source.getId());
        target.setOrderNo(source.getOrderNo());
        target.setDeliveryName(source.getReceiveName());
        target.setDeliveryMobile(source.getReceivePhone());
        target.setDeliveryPhone(source.getReceivePhone());
        target.setProvinceName(source.getProvince());
        target.setProvinceCode(source.getProvinceCode());
        target.setCityName(source.getCity());
        target.setCityCode(source.getCityCode());
        target.setAreaName(source.getCounty());
        target.setAreaCode(source.getCountyCode());
        target.setStreetName(source.getStreet());
        target.setDetailed(source.getReceiveAddress());
        target.setPostcode(source.getPostcode());
    }

    public static void orderDtoTodgAddrDto(DgPerformOrderAddrDto target, OrderAddressDto source) {
        if (Objects.isNull(target)) {
            target = new DgPerformOrderAddrDto();
        }
        if (Objects.isNull(source)) {
            source = new OrderAddressDto();
        }
        target.setId(source.getId());
        target.setOrderNo(source.getOrderNo());
        target.setReceiveName(source.getDeliveryPhone());
        target.setReceivePhone(source.getDeliveryPhone());
        target.setProvince(source.getProvinceName());
        target.setProvinceCode(source.getProvinceCode());
        target.setCity(source.getCityName());
        target.setCityCode(source.getCityCode());
        target.setCounty(source.getAreaName());
        target.setCountyCode(source.getAreaCode());
        target.setStreet(source.getStreetName());
        target.setReceiveAddress(source.getAddress());
        target.setPostcode(source.getPostcode());
    }

    public static void orderEoTodgAddrDto(DgPerformOrderAddrDto target, OrderAddressEo source) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            return;
        }
        target.setId(source.getId());
        target.setAddressId(source.getAddressId());
        target.setOrderNo(source.getOrderNo());
        target.setReceiveName(source.getDeliveryName());
        target.setReceivePhone(source.getDeliveryPhone());
        target.setProvince(source.getProvinceName());
        target.setProvinceCode(source.getProvinceCode());
        target.setCity(source.getCityName());
        target.setCityCode(source.getCityCode());
        target.setCounty(source.getAreaName());
        target.setCountyCode(source.getAreaCode());
        target.setStreet(source.getStreetName());
        target.setReceiveAddress(source.getAddress());
        target.setPostcode(source.getPostcode());
    }

    public static void dgItemDtoToTradeItemDto(DgPerformOrderItemDto source, TradeItemDto target) {
        if (Objects.isNull(source)) {
            source = new DgPerformOrderItemDto();
        }
        if (Objects.isNull(target)) {
            target = new TradeItemDto();
        }
        CubeBeanUtils.copyProperties((Object)target, (Object)source, (String[])new String[0]);
        Integer type = StringUtils.isEmpty((CharSequence)source.getType()) ? 0 : Integer.valueOf(source.getType());
        target.setItemType(type);
        Integer itemAttr = StringUtils.isEmpty((CharSequence)source.getItemAttr()) ? 0 : Integer.valueOf(source.getItemAttr());
        target.setBusType(itemAttr);
        String itemId = Objects.isNull(source.getItemId()) ? "" : source.getItemId().toString();
        target.setItemSerial(itemId);
        String skuId = Objects.isNull(source.getSkuId()) ? "" : source.getSkuId().toString();
        target.setSkuSerial(skuId);
        target.setItemPrice(source.getPrice());
        target.setPayTotalAmount(source.getPayAmount());
        target.setDiscountTotalAmount(source.getDiscountAmount());
        target.setUnit(source.getItemUnit());
        target.setItemNum(Integer.valueOf(source.getItemNum().intValue()));
    }

    public static void dgItemEoToTradeItemDto(DgPerformOrderItemDto source, TradeItemDto target) {
        if (Objects.isNull(source) || Objects.isNull(target)) {
            return;
        }
        CubeBeanUtils.copyProperties((Object)target, (Object)source, (String[])new String[0]);
        Integer type = StringUtils.isEmpty((CharSequence)source.getType()) ? 0 : Integer.valueOf(source.getType());
        target.setItemType(type);
        Integer itemAttr = StringUtils.isEmpty((CharSequence)source.getItemAttr()) ? 0 : Integer.valueOf(source.getItemAttr());
        target.setBusType(itemAttr);
        String itemId = Objects.isNull(source.getItemId()) ? "" : source.getItemId().toString();
        target.setItemSerial(itemId);
        String skuId = Objects.isNull(source.getSkuId()) ? "" : source.getSkuId().toString();
        target.setSkuSerial(skuId);
        target.setItemPrice(source.getPrice());
        target.setPayTotalAmount(source.getPayAmount());
        target.setDiscountTotalAmount(source.getDiscountAmount());
        target.setUnit(source.getItemUnit());
        target.setItemNum(Integer.valueOf(source.getItemNum().intValue()));
    }

    public static void dgItemRespToTradeItemEo(DgPerformOrderItemRespDto source, TradeItemEo target) {
        if (Objects.isNull(source) || Objects.isNull(target)) {
            return;
        }
        CubeBeanUtils.copyProperties((Object)target, (Object)source, (String[])new String[0]);
        Integer type = StringUtils.isEmpty((CharSequence)source.getType()) ? 0 : Integer.valueOf(source.getType());
        target.setItemType(type);
        Integer itemAttr = StringUtils.isEmpty((CharSequence)source.getItemAttr()) ? 0 : Integer.valueOf(source.getItemAttr());
        target.setBusType(itemAttr);
        String itemId = Objects.isNull(source.getItemId()) ? "" : source.getItemId().toString();
        target.setItemSerial(itemId);
        String skuId = Objects.isNull(source.getSkuId()) ? "" : source.getSkuId().toString();
        target.setSkuSerial(skuId);
        target.setItemPrice(source.getPrice());
        target.setPayTotalAmount(source.getPayAmount());
        target.setDiscountTotalAmount(source.getDiscountAmount());
        target.setUnit(source.getItemUnit());
        target.setItemNum(Integer.valueOf(source.getItemNum().intValue()));
        if (Objects.nonNull(source.getPerformOrderItemExtensionDto())) {
            target.setThirdSkuSerial(source.getPerformOrderItemExtensionDto().getThirdSkuSerial());
        }
    }

    public static void tradeItemDtoToDgItemDto(DgPerformOrderItemDto target, TradeItemDto source) {
        if (Objects.isNull(source)) {
            source = new TradeItemDto();
        }
        if (Objects.isNull(target)) {
            target = new DgPerformOrderItemDto();
        }
        CubeBeanUtils.copyProperties((Object)target, (Object)source, (String[])new String[0]);
        String itemType = Objects.isNull(source.getItemType()) ? "" : String.valueOf(source.getItemType());
        target.setType(itemType);
        String itemAttr = Objects.isNull(source.getBusType()) ? "" : String.valueOf(source.getBusType());
        target.setItemAttr(itemAttr);
        Long itemId = Objects.isNull(source.getItemSerial()) ? null : Long.valueOf(source.getItemSerial());
        target.setItemId(itemId);
        Long skuId = Objects.isNull(source.getSkuSerial()) ? null : Long.valueOf(source.getSkuSerial());
        target.setSkuId(skuId);
        target.setPrice(source.getItemPrice());
        target.setPayAmount(source.getPayTotalAmount());
        target.setDiscountAmount(source.getDiscountTotalAmount());
        target.setItemUnit(source.getUnit());
    }

    public static void tradeItemEoToDgItemDto(DgPerformOrderItemReqDto target, TradeItemEo source) {
        HashMap extensionMap;
        Long skuId;
        if (Objects.isNull(source) || Objects.isNull(target)) {
            return;
        }
        CubeBeanUtils.copyProperties((Object)target, (Object)source, (String[])new String[0]);
        target.setItemCostPayDtos(source.getItemCostPayDtos());
        String itemType = Objects.isNull(source.getItemType()) ? "" : String.valueOf(source.getItemType());
        target.setType(itemType);
        String itemAttr = Objects.isNull(source.getBusType()) ? "" : String.valueOf(source.getBusType());
        target.setItemAttr(itemAttr);
        Long itemId = Objects.isNull(source.getItemSerial()) ? null : Long.valueOf(source.getItemSerial());
        target.setItemId(itemId);
        Long l = skuId = Objects.isNull(source.getSkuSerial()) ? null : Long.valueOf(source.getSkuSerial());
        if (StringUtils.isNotBlank((CharSequence)source.getExtension()) && (extensionMap = (HashMap)JSONObject.parseObject((String)source.getExtension(), HashMap.class)).containsKey("imgPath")) {
            target.setImgUrl(extensionMap.get("imgPath").toString());
        }
        target.setSkuId(skuId);
        target.setPrice(source.getItemPrice());
        target.setPayAmount(source.getPayTotalAmount());
        target.setItemOrigAmount(source.getPayOrigTotalAmount());
        target.setDiscountAmount(source.getDiscountTotalAmount());
        target.setItemUnit(source.getUnit());
        target.setSortNo(Long.valueOf(source.getSortNo().intValue()));
        target.setItemNum(new BigDecimal(source.getItemNum()));
        target.setOrderItemUnit(source.getOrderItemUnit());
        target.setOrderItemUnitName(source.getOrderItemUnitName());
    }

    public static DgPerformOrderItemReqDto tradeRespDto2DgItemDto(TradeItemRespDto tradeItemRespDto) {
        if (tradeItemRespDto == null) {
            return null;
        }
        DgPerformOrderItemReqDto performOrderItemReqDto = new DgPerformOrderItemReqDto();
        CubeBeanUtils.copyProperties((Object)performOrderItemReqDto, (Object)tradeItemRespDto, (String[])new String[0]);
        Long itemId = Objects.isNull(tradeItemRespDto.getItemSerial()) ? null : Long.valueOf(tradeItemRespDto.getItemSerial());
        performOrderItemReqDto.setItemId(itemId);
        Long skuId = Objects.isNull(tradeItemRespDto.getSkuSerial()) ? null : Long.valueOf(tradeItemRespDto.getSkuSerial());
        performOrderItemReqDto.setSkuId(skuId);
        performOrderItemReqDto.setPrice(tradeItemRespDto.getItemPrice());
        performOrderItemReqDto.setPayAmount(tradeItemRespDto.getPayTotalAmount());
        performOrderItemReqDto.setDiscountAmount(tradeItemRespDto.getDiscountTotalAmount());
        performOrderItemReqDto.setItemOrigAmount(tradeItemRespDto.getPayOrigTotalAmount());
        performOrderItemReqDto.setItemUnit(tradeItemRespDto.getUnit());
        performOrderItemReqDto.setItemNum(new BigDecimal(tradeItemRespDto.getItemNum()));
        performOrderItemReqDto.setSortNo(Long.valueOf(tradeItemRespDto.getSortNo().intValue()));
        return performOrderItemReqDto;
    }
}

