/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordDelReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordPageReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordReqExtDto;
import com.yunxi.dg.base.center.report.dto.tag.TagRecordLinkReqDto;
import com.yunxi.dg.base.center.report.proxy.tag.IReBizTagRecordApiProxy;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderTagRecordDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderTagRecordRespDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgOrderTagRecordDomainImpl
implements IDgOrderTagRecordDomain {
    private static final Logger log = LoggerFactory.getLogger(DgOrderTagRecordDomainImpl.class);
    private final String recordSourceModel = "ORDER_SALES";
    private final String recordLinkOptType = "MANUAL";
    @Resource
    private IReBizTagRecordApiProxy reBizTagRecordApiProxy;

    @Override
    public void addOrderTagRecord(DgOrderTagRecordReqDto addReqDto) {
        ReBizTagRecordReqDto reqDto = new ReBizTagRecordReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)addReqDto, (String[])new String[0]);
        TagRecordLinkReqDto orderTagRecordEo = new TagRecordLinkReqDto();
        orderTagRecordEo.setRecordLinkId(addReqDto.getOrderId());
        reqDto.setRecordLinkList((List)Lists.newArrayList((Object[])new TagRecordLinkReqDto[]{orderTagRecordEo}));
        reqDto.setRecordLinkOptType("MANUAL");
        reqDto.setRecordSourceModel("ORDER_SALES");
        log.info("[\u8ba2\u5355\u6807\u7b7e]\u6dfb\u52a0\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
        RestResponseHelper.checkOrThrow((RestResponse)this.reBizTagRecordApiProxy.batchInsert((List)Lists.newArrayList((Object[])new ReBizTagRecordReqDto[]{reqDto})));
    }

    @Override
    public void removeOrderTagRecordById(Long id, Long orderId) {
        ReBizTagRecordDelReqDto reqDto = new ReBizTagRecordDelReqDto();
        reqDto.setIdList((List)Lists.newArrayList((Object[])new Long[]{id}));
        reqDto.setRecordLinkIdList((List)Lists.newArrayList((Object[])new Long[]{orderId}));
        log.info("[\u8ba2\u5355\u6807\u7b7e]\u79fb\u9664\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
        RestResponseHelper.checkOrThrow((RestResponse)this.reBizTagRecordApiProxy.logicDel(reqDto));
    }

    @Override
    public void replaceOrderTagRecord(List<DgOrderTagRecordReqDto> tagList) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(tagList), (String)"\u6807\u7b7e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List tagCodes = tagList.stream().map(DgOrderTagRecordReqDto::getTagCode).distinct().collect(Collectors.toList());
        List reqExtDtos = tagList.stream().map(DgOrderTagRecordReqDto::getOrderId).distinct().map(orderId -> {
            ReBizTagRecordReqExtDto reqExtDto = new ReBizTagRecordReqExtDto();
            reqExtDto.setRecordLinkId(orderId);
            reqExtDto.setRecordLinkOptType("MANUAL");
            reqExtDto.setRecordSourceModel("ORDER_SALES");
            reqExtDto.setRecordLinkId(orderId);
            reqExtDto.setTagCodeList(tagCodes);
            return reqExtDto;
        }).collect(Collectors.toList());
        log.info("[\u8ba2\u5355\u6807\u7b7e]\u6279\u91cf\u66ff\u6362\u4e1a\u52a1\u6807\u7b7e\u8bb0\u5f55,\u53c2\u6570:{}", (Object)JSON.toJSONString(reqExtDtos));
        RestResponseHelper.checkOrThrow((RestResponse)this.reBizTagRecordApiProxy.businessLabelCoverage(reqExtDtos));
    }

    @Override
    public void batchInsert(List<String> tagCodes, List<Long> recordLinkIds) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(tagCodes), (String)"\u6807\u7b7e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(recordLinkIds), (String)"\u6807\u7b7e\u5173\u8054\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List recordLinkList = recordLinkIds.stream().distinct().map(orderId -> {
            TagRecordLinkReqDto reqDto = new TagRecordLinkReqDto();
            reqDto.setRecordLinkId(orderId);
            return reqDto;
        }).collect(Collectors.toList());
        List reBizTagRecordReqDtos = tagCodes.stream().map(tagCode -> {
            ReBizTagRecordReqDto reqDto = new ReBizTagRecordReqDto();
            reqDto.setTagCode(tagCode);
            reqDto.setRecordLinkOptType("MANUAL");
            reqDto.setRecordSourceModel("ORDER_SALES");
            reqDto.setRecordLinkList(recordLinkList);
            return reqDto;
        }).collect(Collectors.toList());
        RestResponseHelper.checkOrThrow((RestResponse)this.reBizTagRecordApiProxy.batchInsert(reBizTagRecordReqDtos));
    }

    @Override
    public List<DgOrderTagRecordRespDto> queryByParam(DgOrderTagRecordReqDto orderTagRecordReqDto) {
        AssertUtils.notNull((Object)orderTagRecordReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ReBizTagRecordPageReqDto reqDto = new ReBizTagRecordPageReqDto();
        if (Objects.nonNull(orderTagRecordReqDto.getTagCode())) {
            reqDto.setTagCode(orderTagRecordReqDto.getTagCode());
        }
        if (Objects.nonNull(orderTagRecordReqDto.getOrderId())) {
            reqDto.setRecordLinkId(orderTagRecordReqDto.getOrderId());
        }
        reqDto.setTagStatus(Integer.valueOf(1));
        List reBizTagRecordRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.reBizTagRecordApiProxy.findAll(reqDto));
        if (CollectionUtils.isEmpty((Collection)reBizTagRecordRespDtos)) {
            return null;
        }
        return reBizTagRecordRespDtos.stream().map(dto -> {
            DgOrderTagRecordRespDto orderTagRecordRespDto = new DgOrderTagRecordRespDto();
            orderTagRecordRespDto.setId(dto.getId());
            orderTagRecordRespDto.setTagCode(dto.getTagCode());
            orderTagRecordRespDto.setOrderId(dto.getRecordLinkId());
            orderTagRecordRespDto.setTagExtend(dto.getTagExtend());
            return orderTagRecordRespDto;
        }).collect(Collectors.toList());
    }

    @Override
    public List<DgOrderTagRecordRespDto> queryTagById(Long id) {
        DgOrderTagRecordReqDto tagRecordReqDto = new DgOrderTagRecordReqDto();
        tagRecordReqDto.setOrderId(id);
        return this.queryByParam(tagRecordReqDto);
    }
}

